from UmBoostLib import tarList, targetList, iSessList, SessList, iConnList, connList

import settings, simplejson
logging = settings.get_logger()

class IscsiIniTargetsSessions:
    
    def __init__(self, sid, ip, ostype, req_type):
         self.sid = sid
         self.ip = ip
         self.ostype = ostype
         self.req_type = req_type
    
    def get_data(self):
        data = {}
        target_html = self.get_targets()
        if target_html == -2 or target_html == -1 or target_html == 67:
            return target_html
        
        session_html = self.get_session(25)
        if session_html == -2 or session_html == -1:
            return session_html
        
        data = {}
        data['target_html'] = target_html
        data['session_html'] = session_html
        return simplejson.dumps(data)
    
    def get_targets(self):
        logging.info('iSCSI Target Properties Sessions Get Targets List: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.boosttarlistobj = tarList()
        self.boosttargetlistobj = targetList()
        status = self.boosttargetlistobj.getiSCSITargetInformation( self.boosttarlistobj, self.sid, self.ip )
        logging.info('iSCSI Target Properties Sessions Get Targets List status: %s'%status)

        if status == 0:
            return self.generate_tagetlist_html()
        elif status == -2 or status == 67:
            return status
        else:
            return -1
        
    def generate_tagetlist_html(self):
        ip_id = self.ip.replace('.','_')
        
        if self.req_type == 'desktop':
            unique_parent_id = '#iscsi_target_content__incend__%s .iscsi_target_session_details_tab'%ip_id
        else:
            unique_parent_id = '#i_sd__%s__incend'%ip_id
        
        select_head_html = '<select class="targets_list" onchange = "i_ts_show_sessions($(this), \'%s\')" >\
                            <option value="null">Select One..</option>'%unique_parent_id
        select_html = '%s%s</select>'
        option_html = '<option value="%s" title = "%s" >%s</option>'
        html_list = target_list = []
        for i in range(0,len(self.boosttarlistobj)):
            html_list.append(option_html%( self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName.replace(' ','').replace('.','_') , self.boosttargetlistobj.get(self.boosttarlistobj,i).CurrentState, self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName ))
            target_list.append(self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName)
        
        html = ''.join(html_list)
        select_html = select_html%(select_head_html, html)
        return select_html
    
    def get_session(self, stack):
       self.boostISListobj = iSessList()
       self.boostSListobj = SessList()
       
       logging.info('iSCSI Initiator Sessions Details - Get Session ids : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, ostype : %s\
                   '%( self.sid, self.ip, stack, self.ostype ))
       status = self.boostISListobj.getSessionList( self.boostSListobj, self.sid, self.ip, stack, int(self.ostype) )
       logging.info('iSCSI Initiator Sessions Details - Get Session status: %s'%( status ))
       
       if status == 0: 
           return self.generate_session_html()
       elif status == -2:
           return status
       else:
           return -1
       
    def generate_session_html(self):
        ip_id = self.ip.replace('.','_')
        
        if self.req_type == 'desktop':
            unique_parent_id = '#iscsi_target_content__incend__%s .iscsi_target_session_details_tab'%ip_id
        else:
            unique_parent_id = '#i_sd__%s__incend'%ip_id
        
        sessions_html = []
        for i in range(0, len(self.boostSListobj)):
            sess_tar_name = self.boostISListobj.get(self.boostSListobj,i).TargetName.replace(' ','').replace('.','_')
            sessions_html.append('<li class="%s as_hide" onclick="i_ts_get_connections($(this),\'%s\', \'%s\')" >%s\
                            <input type="hidden" value="%s" class="sess_id" />\
                            <input type="hidden" value="%s" class="init_name" />\
                            <input type="hidden" value="%s" class="tarname" /></li>'%(
                            sess_tar_name,
                            unique_parent_id,
                            self.ip,
                            self.boostISListobj.get(self.boostSListobj,i).SessionID,
                            self.boostISListobj.get(self.boostSListobj,i).SessionID,
                            self.boostISListobj.get(self.boostSListobj,i).InitiatorName,
                            self.boostISListobj.get(self.boostSListobj,i).TargetName
                            ))
        return ''.join(sessions_html)

    def get_connections(self, data):
       self.boostICListobj = iConnList()
       self.boostCListobj = connList()
       
       logging.info('iSCSI Initiator  Sessions Details - Get connections : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, SessionId : %s,\
                    iniName : %s, tarName : %s, ostype : %s\
                   '%( self.sid, self.ip, data['stack'], data['sessid'], data['init_name'], data['tarname'], self.ostype ))
       status = self.boostICListobj.getConnectionList( self.boostCListobj, self.sid, self.ip, int(data['stack']), data['sessid'], data['init_name'], data['tarname'], int(self.ostype)  )
       logging.info('iSCSI Initiator  Sessions Details - Get connections status: %s'%( status ))
       
       if status == 0: 
           return self.generate_connection_html()
       elif status == -2:
           return status
       else:
           return -1
       
    def generate_connection_html(self):
        ip_id = self.ip.replace('.','_')
        
        if self.req_type == 'desktop':
            unique_parent_id = '#iscsi_target_content__incend__%s .iscsi_target_session_details_tab'%ip_id
        else:
            unique_parent_id = '#i_sd__%s__incend'%ip_id
        
        connections_html = ['<li onclick="i_ts_show_details($(this), \'%s\')" >Initiator: %s:%s -> Target: %s:%s ; CID: %s\
                            <input type="hidden" value="%s" class="offload" />\
                            <input type="hidden" value="%s" class="hd" />\
                            <input type="hidden" value="%s" class="dd" />\
                            </li>'%( 
                            unique_parent_id,
                            self.boostICListobj.get(self.boostCListobj,i).InitiatorAddress,
                            self.boostICListobj.get(self.boostCListobj,i).InitiatorPort,
                            self.boostICListobj.get(self.boostCListobj,i).TargetAddress,
                            self.boostICListobj.get(self.boostCListobj,i).Targetport,
                            self.boostICListobj.get(self.boostCListobj,i).CID,
                            self.boostICListobj.get(self.boostCListobj,i).offloadStr,
                            self.boostICListobj.get(self.boostCListobj,i).headerDigest,
                            self.boostICListobj.get(self.boostCListobj,i).dataDigest )
                            for i in range(0, len(self.boostCListobj))]
        return ''.join(connections_html)