from UmBoostLib import vsList, VswitchList, PortGroupList, epgList, EsxVswitch, IntfList, InterfaceList

import logging
import settings, utils
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class Hypervisor:
    
    def __init__(self, sid, ip):
        self.sid    =   sid
        self.ip     =   ip
    
    def get_switch_tree(self, data):
        logging.info('Hypervisor - Virtual Network Topology getVswitchList : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.vsList_obj = vsList()
        self.VswitchList_obj = VswitchList()
        status = self.VswitchList_obj.getVswitchList( self.vsList_obj, self.sid, self.ip )
        #status = 0
        logging.info('Hypervisor - Virtual Network Topology getVswitchList status : %s'%( status ))
        
        if status == 0:
            return  self.build_switch_tree()
        elif status == -2:
            return -2
            
    def build_switch_tree(self):
        
        switch_html = []
        self.plus_img = '<img src="/images/black/tree_plus.png">'
        self.minus_img = '<img src="/images/black/tree_minus.png">'
        self.unique_parent_id = '#hypervisor_content__incend__%s .virtual_network_topology_tab'%self.ip.replace('.','_')
        for i in range(0,len(self.vsList_obj)):
            switch_name = self.VswitchList_obj.get(self.vsList_obj,i).vSwitchName
            switch_html.append('<li class="vm_tree_li">')
            switch_html.append('<a href="javascript:void(0);" onclick="" class="tree_action">%s</a>'%self.plus_img)
            switch_html.append('<a href="javascript:void(0);" class="vnt_switch_m" onclick="vnt_toggle_detail(\'%s\', $(this))"><img class="icon" src="images/black/switch2.png" />%s'
                               %(self.unique_parent_id, switch_name))
            switch_html.append('<input type="hidden" value="%s" class="switch_name" />'%switch_name)
            switch_html.append('<input type="hidden" value="%s" class="mtu" />'%self.VswitchList_obj.get(self.vsList_obj,i).Mtu)
            switch_html.append('</a>')
            if self.VswitchList_obj.get(self.vsList_obj,i).UpLinks != '':
                logging.info('Uplinks of %s returned by Boost:- %s'%(switch_name, self.VswitchList_obj.get(self.vsList_obj,i).UpLinks))
                switch_html.append(self.get_vmnic_html(self.VswitchList_obj.get(self.vsList_obj,i).UpLinks))
            #PG Group
            groups_html = self.get_portal_groups_html(switch_name)
            if groups_html == -2:
                return groups_html
            elif groups_html == 1:
                continue
            switch_html.append(groups_html)
            switch_html.append('</li>')
        
        return ''.join(switch_html)
            
    def get_portal_groups_html(self, switch_name):
        logging.info('Hypervisor - Virtual Network Topology getPortGroupList : Sid : %s, Ip : %s, switch : %s'%( self.sid, self.ip, switch_name ))
        self.PortGroupList_obj = PortGroupList()
        self.pList_obj = epgList()
        status = self.PortGroupList_obj.getPortGroupList( self.pList_obj, self.sid, self.ip, switch_name )
        #status = 0
        logging.info('Hypervisor - Virtual Network Topology getPortGroupList status : %s'%( status ))
        
        html = ''
        if status == 0:
            for i in range(0, len(self.pList_obj)):
                pgname = self.PortGroupList_obj.get(self.pList_obj,i).PGName
                uplinks = self.PortGroupList_obj.get(self.pList_obj,i).UpLinks
                logging.info('Uplinks of PG: %s of Vswitch : %s - returned by Boost:- %s'%(pgname, switch_name, uplinks))
                html += '<ul class="as_hide"><li>'
                if uplinks.strip() != '':
                    html += '<a href="javascript:void(0);" class="tree_action vnt_pg_m">%s</a>'%self.plus_img
                html += '<a class="vnt_pg_m" href="javascript:void(0);" onclick="vnt_toggle_detail(\'%s\', $(this))" >\
                         <img class="icon" src="images/black/v_network.png" />%s'%(self.unique_parent_id, pgname)
                html += '<input type="hidden" value="%s" class="pg_name" />'%pgname
                
                if uplinks.strip() != '':
                    html += '<input type="hidden" value="%s" class="uplinks" />'%uplinks
                html += '<input type="hidden" value="%s" class="vlanid" />'%self.PortGroupList_obj.get(self.pList_obj,i).VlanId
                html += '</a>'
                #Start vmincs for this pg
                if uplinks.strip() != '': 
                    uplinks = uplinks.split(',')
                    for i in uplinks:
                        html += '<ul class="as_hide"><li>'
                        html += '<a href="javascript:void(0);" class="vnt_vmnic_m pg_vmnic" onclick="vnt_toggle_detail(\'%s\', $(this))" >\
                                <input type="hidden" class="pgname" value="%s" />\
                                <input type="hidden" class="vswitchname" value="%s" />\
                                <img class="icon" src="images/black/pg_col.png"><span class="vmnic_name">%s</span></a>'%( self.unique_parent_id, pgname, switch_name, i)
                        html += '</li></ul>'
                #End pg ul
                html += '</li></ul>'
            
            return html
        elif status == -2:
            return status
        else:
            return 1
        
    def get_vmnic_html(self, vmnics):
        vmnics = vmnics.split(',')
        vmnics_html = ''
        for i in vmnics:
            vmnics_html += '<ul class="as_hide vmmnics_ul"><li><a onclick = "vnt_toggle_detail(\'%s\', $(this))" href="javascript:void(0);" class="vnt_vmnic_m" >\
                            <img src="images/black/pg_col.png" class="icon"><span class="vmnic_name">%s</span></a></li></ul>'%(self.unique_parent_id, i)
        return vmnics_html
            
    def get_switch_names(self):
        logging.info('Hypervisor - Virtual Network Topology getVswitchList : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        vsList_obj = vsList()
        VswitchList_obj = VswitchList()
        status = VswitchList_obj.getVswitchList( vsList_obj, self.sid, self.ip )
        logging.info('Hypervisor - Virtual Network Topology getVswitchList status : %s'%( status ))
        
        if status == 0:
            switch_list = [ VswitchList_obj.get(vsList_obj,i).vSwitchName for i in range(0, len(vsList_obj)) ]
            return ','.join(switch_list)
        elif status == -2:
            return -2
        else:
            return -1
        
    def get_pg_names(self):
        logging.info('Hypervisor - Virtual Network Topology getVswitchList : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        vsList_obj = vsList()
        VswitchList_obj = VswitchList()
        status = VswitchList_obj.getVswitchList( vsList_obj, self.sid, self.ip )
        logging.info('Hypervisor - Virtual Network Topology getVswitchList status : %s'%( status ))
        
        if status == 0:
            pgname_list = []
            for i in range(0, len(vsList_obj)):
                switch_name = VswitchList_obj.get(vsList_obj,i).vSwitchName
                logging.info('Hypervisor - Virtual Network Topology getPortGroupList : Sid : %s, Ip : %s, switch : %s'%( self.sid, self.ip, switch_name ))
                PortGroupList_obj = PortGroupList()
                pList_obj = epgList()
                status = PortGroupList_obj.getPortGroupList( pList_obj, self.sid, self.ip, switch_name )
                #status = 0
                logging.info('Hypervisor - Virtual Network Topology getPortGroupList status : %s'%( status ))

                if status == 0:
                    temp_pgname_list = [ PortGroupList_obj.get(pList_obj,i).PGName for i in range(0, len(pList_obj)) ]
                    pgname = ','.join(temp_pgname_list)
                    pgname_list.append(pgname)
                elif status == -2:
                    return -2
                else:
                    continue
            return ','.join(pgname_list)
        elif status == -2:
            return -2
        else:
            return -1
        
    def create_virtual_network(self, data):
             
        logging.info('Hypervisor - AddDelVSConf : Sid : %s, Ip : %s, reqType : %s, VSwitchName : %s, PGName : %s, vmnic : %s'
                     %( self.sid, self.ip, data['reqType'], data['VSwitchName'], data['PGName'], data['vmnic'] ))
        VswitchList_obj = EsxVswitch()
        status = VswitchList_obj.AddDelVSConf( self.sid, self.ip, int(data['reqType']), data['VSwitchName'], data['PGName'], data['vmnic'] )
        #status = 0
        logging.info('Hypervisor - AddDelVSConf status : %s'%( status ))  
        
        if status == 0 or status == -2:
            return status
        else:
            return -1
        
    def get_vswifname(self):
        
        logging.info('Hypervisor - Get all interface name:  waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        boostIntfListObj = IntfList()
        boostInterfaceList = InterfaceList()
        inf_status = boostInterfaceList.getNetworkInformation(boostIntfListObj,self.sid, self.ip)
        logging.info('Hypervisor - Get all interface name - status: %s'%inf_status)
        
        if inf_status == 0:
            friendly_name_list = [ boostInterfaceList.get(boostIntfListObj, i).FriendlyName for i in range(0,len(boostIntfListObj)) ]
            last_vswif_id = friendly_name_list[len(friendly_name_list)-1].replace('vswif','')
            last_vswif_id = int(last_vswif_id)+1
            return 'vswif%s'%last_vswif_id

        elif inf_status == -2:
            return -2
        else:
            return -1
        
    
    def create_vwsif(self, data):
        
        if data['action'] == 'create_vwsif':
            if data['ipType'] == '1':
                logging.info('Validate IP : %s, Validate : 1 '%data['action_ip'])
                ip_validate = utils.validate_ip(data['action_ip'], 1)
                logging.info('IP Validate status %s'%ip_validate)
                if ip_validate == -1:
                    return  'Invalid IP'
            
                logging.info('Validate mask : %s, Validate : 2'%data['mask'])
                mask_validate = utils.validate_ip(data['mask'], 2)
                logging.info('mask Validate status %s'%mask_validate)
                if mask_validate == -1:
                    return  'Invalid Mask'
             
        logging.info('Hypervisor - Create vswif : Sid : %s, Ip : %s, ipType : %s, VSwifName : %s, PGName : %s, ip : %s, mask : %s, ipversion : ipv4'
                     %( self.sid, self.ip, data['ipType'], data['VSwifName'], data['PGName'], data['action_ip'], data['mask'] ))
        VswitchList_obj = EsxVswitch()
        status = VswitchList_obj.AddVswif( self.sid, self.ip, int(data['ipType']), data['VSwifName'], data['PGName'], data['action_ip'], data['mask'], 'ipv4' )
        #status = 0
        logging.info('Hypervisor - Create vswif status : %s'%( status ))  
        
        if status == 0 or status == -2:
            return status
        else:
            return -1
        
    def get_interface_list(self):
        self.boostInterfaceList = InterfaceList()
        self.boostNWInterfaceObj = IntfList()
        logging.info('Hypervisor - VNT - Summary - Get Interface list: waiting for response from UMboost sid : %s , UmServerIP : %s'%(self.sid, self.ip))
        status = self.boostInterfaceList.getNetworkInformation(self.boostNWInterfaceObj, self.sid, self.ip)
        logging.info('Hypervisor - VNT - Summary - Get Interface list: %s'%(status))
        
        if status == 0:
            return self.generate_interface_html()
        elif status == -2:
           return -2
        else:
           return -1
        
    def get_interface_obj(self):
        for i in range(0,len(self.boostNWInterfaceObj)):
            yield self.boostInterfaceList.get(self.boostNWInterfaceObj,i) 

    def generate_interface_html(self):
        html = []
        for i in self.get_interface_obj():
            if i.FriendlyName.find('vswif') == -1:
                html.append(self.eth_list_html(i))
        whole_html = ''.join(html)
        return whole_html

    def eth_list_html(self,obj):
        
        status_class = 'green_f'
        class_name = 'eth'

        if obj.Status:
            status = 'Enabled '
            name = 'enabled'
        else:
            status = 'Disabled '
            status_class = 'red_f'
            class_name = 'eth_bk'
            name = 'disabled'
        
        if obj.LinkState:
            link = 'Link Present'
        else:
            link = 'No Link'
            status_class = 'red_f'
            class_name = 'eth_bk'
            
        desc_title =  obj.Description
        
        if len(obj.Description) > 35:
            desc = "%s..."%obj.Description[:35]
        else:
            desc = obj.Description
        
        friendly_name_class_name = obj.FriendlyName.replace('.','_')    
        html = '<li class="%s %s" name="%s" onclick="vnt_toggle_class($(this))" >%s\
                <input type="hidden" class="svs" value="%s [ %s ]" />\
                <input type="hidden" class="desc" value="%s" />\
                <input type="hidden" class="desc_title" value="%s" />\
                <input type="hidden" class="status" value="%s__%s**%s" />\
                <input type="hidden" class="mtu" value="%s" />\
                <input type="hidden" class="vlan" value="%s" />\
                <input type="hidden" class="name" value="%s" />\
                </li>'%(class_name,friendly_name_class_name,name,obj.FriendlyName,obj.FriendlyName,obj.MacString,desc,desc_title,status_class,\
                        status,link,obj.mtu,obj.vlanId, obj.FriendlyName)
                
        return html
    
    def set_vlanid(self, data):
             
        logging.info('Hypervisor - Set vlanid : Sid : %s, Ip : %s, VSwitchName : %s, PGName : %s, vlanid : %s'
                     %( self.sid, self.ip, data['vswitchname'], data['PGName'], data['vlanid'] ))
        VswitchList_obj = EsxVswitch()
        status = VswitchList_obj.ModifyVlan( self.sid, self.ip, data['vswitchname'], data['PGName'], data['vlanid'] )
        #status = 0
        logging.info('Hypervisor - Set vlanid status : %s'%( status ))  
        
        if status == 0 or status == -2:
            return status
        else:
            return -1