from UmBoostLib import foiscsi_ini_boost, foiscsi_boost_params
from Constants import FOISCSI_CONSTANTS
import settings, utils, simplejson
logging = settings.get_logger()

class FoiscsiInitiatorProps:
    
    def __init__(self, **kwargs):
        self.sid = kwargs['sid']
        self.ip = kwargs['ip']
        self.req_type = kwargs['req_type']

    def get_properties(self):
        
        logging.info('Foiscsi get properties - waiting for response from UMboost sid : %s , IP : %s, cmd : params op=show'%(self.sid,self.ip))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "params op=show")
        logging.info('Foiscsi get properties status : %s'%(status))
        
        return_data = {}
        if status == 0:
            logging.info('Foiscsi get properties Params')
            self.params = foiscsi_boost_params()
            status = self.mainObj.foiscsi_get_params(self.params)
            logging.info('Foiscsi get properties Params status : %s'%(status))
            if status == 0:
                return_data['status'] = 0
                return_data['html'] = self.generate_props_html()
                return simplejson.dumps(return_data)
            elif status == -2:
                return_data['status'] = -2
                return simplejson.dumps(return_data)
            elif FOISCSI_CONSTANTS.has_key(status):
                return_data['status'] = 6
                return_data['msg'] = FOISCSI_CONSTANTS[status]
                return simplejson.dumps(return_data)
            else:
                return_data['status'] = -1
                return simplejson.dumps(return_data)
        elif status == -2:
            return_data['status'] = -2
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
                return_data['status'] = 6
                return_data['msg'] = FOISCSI_CONSTANTS[status]
                return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
        
    def generate_props_html(self):
        
        head_html = '<ul class="horizontal head_ul">\
                     <li class="desc"><h2>Description</h2></li>\
                     <li class="value"><h2 class="bg_none" >Value</h2></li>\
                     </ul>'
        html_list = []
        html_list.append( utils.get_boolean_editor( 'DataSequenceInOrder', 'DataSequenceInOrder', self.params.DataSequenceInOrder) )
        html_list.append( utils.get_boolean_editor( 'DataPDUInOrder', 'DataPDUInOrder', self.params.DataPDUInOrder) )
        html_list.append( utils.get_boolean_editor( 'ImmediateData', 'ImmediateData', self.params.ImmediateData) )
        html_list.append( utils.get_boolean_editor( 'InitialR2T', 'InitialR2T', self.params.InitialR2T) )
        html_list.append( utils.get_number_editor('ErrorRecoveryLevel', 'ErrorRecoveryLevel', '0#2', 1, self.params.ErrorRecoveryLevel) )
        
        html_list.append( utils.get_text_editor( 'MaxConnections', 'MaxConnections', self.params.MaxConnections) )
        
        html_list.append( utils.get_number_editor('DefaultTime2Wait', 'DefaultTime2Wait', '1#100', 1, self.params.DefaultTime2Wait) )
        html_list.append( utils.get_number_editor('DefaultTime2Retain', 'DefaultTime2Retain', '1#100', 1, self.params.DefaultTime2Retain) )
        html_list.append( utils.get_number_editor('MaxBurstLength', 'MaxBurstLength', '1#16777215', 1, self.params.MaxBurstLength) )
        html_list.append( utils.get_number_editor('FirstBurstLength', 'FirstBurstLength', '1#16777215', 1, self.params.FirstBurstLength) )
        html_list.append( utils.get_custom_choice_editor( propdesc = 'HeaderDigest', propname = 'HeaderDigest', value = self.params.HeaderDigest, choices = 'None#None,CRC32C#CRC32C,None#CRC32C') )
        html_list.append( utils.get_custom_choice_editor( propdesc = 'DataDigest', propname = 'DataDigest', value = self.params.DataDigest, choices = 'None#None,CRC32C#CRC32C,None#CRC32C') )
        html_list.append( utils.get_number_editor('MaxRecvDataSegmentLength', 'MaxRecvDataSegmentLength', '1#16777215', 1, self.params.MaxRecvDataSegmentLength) )
        html_list.append( utils.get_number_editor('PingTimeout', 'PingTimeout', '1#600', 1, self.params.PingTimeout) )
        html_list.append( utils.get_custom_choice_editor( propdesc = 'AuthPolicy', propname = 'AuthPolicy', value = self.params.AuthPolicy, choices = 'Oneway#Mutual') )
        html_list.append( utils.get_custom_choice_editor( propdesc = 'AuthMethod', propname = 'AuthMethod', value = self.params.AuthMethod, choices = 'None#CHAP') )
        html_list.append( utils.get_text_editor( 'UserName', 'UserName', self.params.UserName) )
        html_list.append( utils.get_text_editor( 'Password', 'Password', self.params.Password) )
        html_list.append( utils.get_text_editor( 'UserNameIN', 'UserNameIN', self.params.UserNameIN) )
        html = ''.join(html_list)
        return head_html + html
    
    def set_properties(self, kwargs):
        
        self.mainObj = foiscsi_ini_boost()
        
        if int(kwargs['properties_count']) > 1:
            for i in range(int(kwargs['properties_count'])):
                logging.info('Foiscsi set properties - propname :%s , value : %s :'%( kwargs['propname'][i], kwargs['value'][i] ))
                status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "params op=assign key=%s val=%s"%( kwargs['propname'][i], kwargs['value'][i] ))
                logging.info('Foiscsi set Propname : %s property Status : %s'%(kwargs['propname'][i], status))
        else:
            logging.info('Foiscsi set properties - propname :%s , value : %s :'%( kwargs['propname'], kwargs['value'] ))
            status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "params op=assign key=%s val=%s"%( kwargs['propname'], kwargs['value'] ))
            logging.info('Foiscsi set Propname : %s property Status : %s'%(kwargs['propname'], status))
        
        status = 0
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1