from UmBoostLib import foiscsi_ini_boost, foiscsi_boost_iface, foiscsi_boost_ifcfg
from Constants import FOISCSI_CONSTANTS
import settings, utils, simplejson
logging = settings.get_logger()

class FoiscsiInitiatorPorts:
    
    def __init__(self, **kwargs):
        self.sid = kwargs['sid']
        self.ip = kwargs['ip']
        self.req_type = kwargs['req_type']

    def get_initial_data(self, data):
        
        return_data = {}
        logging.info('Foiscsi Ports issue interface cmd - waiting for response from UMboost sid : %s , IP : %s, devno : %s, ifid=%s'%(self.sid, self.ip, data['devno'], data['ifid']))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "interface devno=%s op=show ifid=%s"%( data['devno'], data['ifid'] ))
        logging.info('Foiscsi Ports issue interface cmd status : %s'%(status))
        
        if status == 0:
            logging.info('Foiscsi get Ports Params')
            self.ifaceObj = foiscsi_boost_iface()
            status = self.mainObj.foiscsi_get_iface(self.ifaceObj)
            logging.info('Foiscsi get Ports Params status : %s'%(status))
            
            if status == 0:
                return_data['status'] = '0'
                return_data['mtu'] =  self.ifaceObj.mtu
                return_data['vlanid'] =  self.ifaceObj.vlanid
                return simplejson.dumps(return_data)
            elif status == -2:
                return_data['status'] = '-2'
                return simplejson.dumps(return_data)
            elif FOISCSI_CONSTANTS.has_key(status):
                return_data['status'] = 6
                return_data['msg'] = FOISCSI_CONSTANTS[status]
                return simplejson.dumps(return_data)
            else:
                return_data['status'] = '-1'
                return simplejson.dumps(return_data)
        elif status == -2:
            return_data['status'] = '-2'
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = '-1'
            return simplejson.dumps(return_data)
        
    def get_ifconfig_values(self, data):
    
        return_data = {}
        logging.info('Foiscsi Ports issue ifconfig - waiting for response from UMboost sid : %s , IP : %s, devno : %s, ifid=%s, ntype : %s'%(self.sid, self.ip, data['devno'], data['ifid'], data['ntype']))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "ifconfig devno=%s op=show ifid=%s ntype=%s"%( data['devno'], data['ifid'], data['ntype'] ))
        logging.info('Foiscsi Ports issue ifconfig status : %s'%(status))
        
        if status == 0:
            logging.info('Foiscsi get Ports ifconfig Params')
            self.ifcfgObj = foiscsi_boost_ifcfg()
            status = self.mainObj.foiscsi_get_ifcfg(self.ifcfgObj)
            logging.info('Foiscsi get Ports ifconfig Params status : %s'%(status))
            
            if status == 0:
                return_data['status'] = '0'
                return_data['sip'] =  self.ifcfgObj.sip
                return_data['mask'] =  self.ifcfgObj.mask
                return_data['gw'] =  self.ifcfgObj.gw
                return simplejson.dumps(return_data)
            elif status == -2:
                return_data['status'] = '-2'
                return simplejson.dumps(return_data)
            else:
                return_data['status'] = '-1'
                return simplejson.dumps(return_data)
        elif status == -2:
            return_data['status'] = '-2'
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = '-1'
            return simplejson.dumps(return_data)
    
    
    def set_values(self, data):
        
        self.mainObj = foiscsi_ini_boost()
        status1 = 0
        status2 = 0
        status3 = 0
        status4 = 0
        status5 = 0
        err_status = 0
        return_data = {'status' : 0}
        error_set = False

        if data['vlan'] != 'NIL':
            #vlan
            logging.info('Foiscsi ports set interface cmd - interface devno=%s op=vlan ifid=%s vlan=%s :'%( data['devno'], data['ifid'], data['vlan'] ))
            status1 = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "interface devno=%s op=vlan ifid=%s vlan=%s"%( data['devno'], data['ifid'], data['vlan'] ))
            logging.info('Foiscsi ports set interface vlan cmd Status : %s'%(status1))
            
            if status1 == -2:
                return_data['status'] = -2
                return simplejson.dumps(return_data)
            elif FOISCSI_CONSTANTS.has_key(status1):
                return_data['status'] = 6
                return_data['msg'] = FOISCSI_CONSTANTS[status1]
                error_set = True
         
        #mtu
        logging.info('Foiscsi ports set interface cmd - interface devno=%s op=mtu ifid=%s mtu=%s :'%( data['devno'], data['ifid'], data['mtu'] ))
        status2 = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "interface devno=%s op=mtu ifid=%s mtu=%s"%( data['devno'], data['ifid'], data['mtu'] ))
        logging.info('Foiscsi ports set interface mtu cmd Status : %s'%(status2))
        
        if status2 == -2:
            return_data['status'] = -2
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status2) and not error_set:
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status2]
            error_set = True
        
        if data['ntype'] == 'dhcp':
            logging.info('Foiscsi ports set ifconfig cmd - interface devno=%s op=assign ifid=%s ntype=dhcp :'%( data['devno'], data['ifid'] ))
            status3 = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "interface devno=%s op=assign ifid=%s ntype=dhcp"%( data['devno'], data['ifid'] ))
            logging.info('Foiscsi ports set ntype=dhcp ifconfig cmd Status : %s'%(status3))
            
            if status3 == -2:
                return_data['status'] = -2
                return simplejson.dumps(return_data)
            elif FOISCSI_CONSTANTS.has_key(status3) and not error_set:
                return_data['status'] = 6
                return_data['msg'] = FOISCSI_CONSTANTS[status3]
                error_set = True
            
        elif data['ntype'] == 'ipv4':
            if data['gw'].strip() != '': 
                logging.info('Foiscsi ports set ifconfig cmd - ifconfig devno=%s op=assign ifid=%s ntype=ipv4 saddr=%s mask=%s gw=%s:'%( data['devno'], data['ifid'], data['sip'], data['mask'], data['gw'] ))
                status4 = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "ifconfig devno=%s op=assign ifid=%s ntype=ipv4 saddr=%s mask=%s gw=%s"%( data['devno'], data['ifid'], data['sip'], data['mask'], data['gw'] ))
                logging.info('Foiscsi ports set ntype=dhcp ifconfig cmd Status : %s'%(status4))
                
                if status4 == -2:
                    return_data['status'] = -2
                    return simplejson.dumps(return_data)
                elif FOISCSI_CONSTANTS.has_key(status4) and not error_set:
                    return_data['status'] = 6
                    return_data['msg'] = FOISCSI_CONSTANTS[status4]
            else:
                logging.info('Foiscsi ports set ifconfig cmd - ifconfig devno=%s op=assign ifid=%s ntype=ipv4 saddr=%s mask=%s:'%( data['devno'], data['ifid'], data['sip'], data['mask'] ))
                status5 = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "ifconfig devno=%s op=assign ifid=%s ntype=ipv4 saddr=%s mask=%s"%( data['devno'], data['ifid'], data['sip'], data['mask'] ))
                logging.info('Foiscsi ports set ntype=dhcp ifconfig cmd Status : %s'%(status5))
                
                if status5 == -2:
                    return_data['status'] = -2
                    return simplejson.dumps(return_data)
                elif FOISCSI_CONSTANTS.has_key(status5) and not error_set:
                    return_data['status'] = 6
                    return_data['msg'] = FOISCSI_CONSTANTS[status5]
        
        return simplejson.dumps(return_data)
        
    def port_updown(self, data):
        self.mainObj = foiscsi_ini_boost()
        logging.info('Foiscsi ports set interface cmd - interface devno=%s op=%s ifid=%s :'%( data['devno'], data['action'], data['ifid'] ))
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "interface devno=%s op=%s ifid=%s "%( data['devno'], data['action'], data['ifid'] ))
        logging.info('Foiscsi ports set interface port %s cmd Status : %s'%(data['action'], status))
        
        return_data = {}
        if status == -2 or status == 0:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
        
    def clear_ip(self, data):
        self.mainObj = foiscsi_ini_boost()
        logging.info('Foiscsi ports set ifconfig cmd - ifconfig devno=%s op=clear ifid=%s ntype=%s :'%( data['devno'], data['ifid'], data['ntype'] ))
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "ifconfig devno=%s op=clear ifid=%s ntype=%s"%( data['devno'], data['ifid'], data['ntype'] ))
        logging.info('Foiscsi ports set ifconfig cmd clear Status : %s'%(status))
        
        return_data = {}
        if status == -2 or status == 0:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
