from UmBoostLib import foiscsi_ini_boost, foiscsi_boost_instance
from Constants import FOISCSI_CONSTANTS
import settings, utils, simplejson
logging = settings.get_logger()

class FoiscsiInitiatorInstance:
    
    def __init__(self, **kwargs):
        self.sid = kwargs['sid']
        self.ip = kwargs['ip']
        self.req_type = kwargs['req_type']

    def get_initial_data(self, data):
        
        return_data = {}
        logging.info('Foiscsi Instance issue init_instance: sid : %s, ip : %s, cmd : init_instance devno=%s op=show nodeid=%s'%(self.sid, self.ip, data['devno'], data['nodeid']))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "init_instance devno=%s op=show nodeid=%s"%( data['devno'], data['nodeid'] ))
        logging.info('Foiscsi Instance issue init_instance cmd status : %s'%(status))
        
        if status == 0:
            logging.info('Foiscsi get Instance Params')
            self.instanceObj = foiscsi_boost_instance()
            status = self.mainObj.foiscsi_get_instance(self.instanceObj)
            logging.info('Foiscsi get Instance Params status : %s'%(status))
            
            if status == 0:
                return_data['status'] = '0'
                return_data['name'] =  self.instanceObj.name
                return_data['alias'] =  self.instanceObj.alias
                return_data['chap_id'] =  self.instanceObj.chap_id
                return_data['chap_sec'] =  self.instanceObj.chap_sec
                return simplejson.dumps(return_data)
            elif status == -2:
                return_data['status'] = '-2'
                return simplejson.dumps(return_data)
            elif FOISCSI_CONSTANTS.has_key(status):
                return_data['status'] = 6
                return_data['msg'] = FOISCSI_CONSTANTS[status]
                return simplejson.dumps(return_data)
            else:
                return_data['status'] = '-1'
                return simplejson.dumps(return_data)
        elif status == -2:
            return_data['status'] = '-2'
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = '-1'
            return simplejson.dumps(return_data)
        
    def clear_data(self, data):
        
        logging.info('Foiscsi Instance issue clear: sid : %s, ip : %s, cmd : init_instance devno=%s op=clear nodeid=%s'%(self.sid, self.ip, data['devno'], data['nodeid']))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "init_instance devno=%s op=clear nodeid=%s"%( data['devno'], data['nodeid'] ))
        logging.info('Foiscsi Instance issue clear cmd status : %s'%(status))
        
        return_data = {}
        if status == 0 or status == -2:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
        
    def save_data(self, data):
        cmd = 'init_instance devno=%s op=assign nodeid=%s nodename=%s'%( data['devno'], data['nodeid'], data['node_name'] )
        if data['alias'].strip() != '':
            cmd += ' alias=%s'%data['alias']
            
        if data['i_uname'].strip() != '':
            cmd += ' iusername=%s'%data['i_uname']
            
        if data['i_secret'].strip() != '':
            cmd += ' isec=%s'%data['i_secret']
        
        logging.info('Foiscsi Instance issue save: sid : %s, ip : %s, cmd : %s'%(self.sid, self.ip, cmd))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, cmd)
        logging.info('Foiscsi Instance issue save cmd status : %s'%(status))
        
        return_data = {}
        if status == 0 or status == -2:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
