from UmBoostLib import foiscsi_ini_boost, foiscsi_boost_hwinfo, foiscsi_boost_device
from Constants import FOISCSI_CONSTANTS
import settings, utils, simplejson
logging = settings.get_logger()

class FoiscsiInitiatorHwProps:
    
    def __init__(self, **kwargs):
        self.sid = kwargs['sid']
        self.ip = kwargs['ip']
        self.req_type = kwargs['req_type']

    def get_properties(self, devno):
        
        self.devno = devno
        logging.info('Foiscsi hardware info - waiting for response from UMboost sid : %s , IP : \
		%s, cmd : hwinfo devno=%s'%(self.sid, self.ip, devno))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "hwinfo devno=%s"%devno)
        logging.info('Foiscsi hardware info status : %s'%(status))
        
        return_data = {}
        if status == 0:
            return_data['status'] = 0
            logging.info('Foiscsi hardware info get properties')
            self.params = foiscsi_boost_hwinfo()
            status = self.mainObj.foiscsi_get_hwinfo(self.params)
            logging.info('Foiscsi hardware info get properties Params status : %s'%(status))
            if status == 0:
                return_data['status'] = 0
                return_data.update(self.generate_props_html())
                return simplejson.dumps(return_data)
            elif status == -2:
                return_data['status'] = -2
                return simplejson.dumps(return_data)
            elif FOISCSI_CONSTANTS.has_key(status):
                return_data['status'] = 6
                return_data['msg'] = FOISCSI_CONSTANTS[status]
                return simplejson.dumps(return_data)
            else:
                return_data['status'] = -1
                return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        elif status == -2:
            return_data['status'] = -2
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
        
    def get_adapinfo(self):
        
        logging.info('Foiscsi hardware info listadap sid : %s , IP : %s, cmd : listadap'\
		%(self.sid, self.ip))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "listadap")
        logging.info('Foiscsi hardware info listadap status : %s'%(status))
        
        if status == 0:
            logging.info('Foiscsi hardware info foiscsi_get_no_of_adapters()')
            status = self.mainObj.foiscsi_get_no_of_adapters()
            logging.info('Foiscsi hardware info foiscsi_get_no_of_adapters() status : %s'%status)
            if status > 0:
                logging.info('Foiscsi hardware info foiscsi_get_adapter()')
                device = foiscsi_boost_device()
                status = self.mainObj.foiscsi_get_adapter(int(self.devno), device)
                logging.info('Foiscsi hardware info foiscsi_get_adapter() status : %s'%status)
                if status == 0:
                    return { 'devno' : device.devno, 'path' : device.path } 
                else:
                    return -6
            else:
                return -6
        else:
            return -6


    def get_devno(self,sl_number):
        self.mainObj = foiscsi_ini_boost()
        for i in range(0,16):
           status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "hwinfo devno=%s"%i)
           if(status == 0):
              self.params = foiscsi_boost_hwinfo()
              status = self.mainObj.foiscsi_get_hwinfo(self.params)
              if self.params.sl_no == sl_number :
                 logging.info('index matched  %s'%i)
                 rdata={}
                 rdata['status'] = 0
                 rdata['devno'] = i
                 rdata['sl_number'] = sl_number
                 return simplejson.dumps(rdata)
              else:
                 pass
           else:
                 pass
	
    def generate_props_html(self):
        
   	head_html = '<ul class="horizontal head_ul">\
                     <li class="desc"><h2>Description</h2></li>\
                     <li class="value"><h2 class="bg_none" >Value</h2></li>\
                     </ul>'
        html_list = []
        
        data = self.get_adapinfo()
        if data == -6:
            html_list.append( utils.get_readonly_editor( 'Adapter index', 'N/A') )
            html_list.append( utils.get_readonly_editor( 'Path', 'N/A') )
        else:
            html_list.append( utils.get_readonly_editor( 'Adapter index', data['devno']) )
            html_list.append( utils.get_readonly_editor( 'Path', data['path']) )
        
        html_list.append( utils.get_readonly_editor( 'Name', self.params.name) )
        html_list.append( utils.get_readonly_editor( 'Model', self.params.model) )
        html_list.append( utils.get_readonly_editor( 'Serial Number', self.params.sl_no) )
        html_list.append( utils.get_readonly_editor( 'Hardware Version', self.params.hw_version) )
        html_list.append( utils.get_readonly_editor( 'Driver Version', self.params.drv_version) )
        html_list.append( utils.get_readonly_editor( 'PCI Vendor Id', str(hex(self.params.pci_vendor_id)).replace('0x','') ))
        html_list.append( utils.get_readonly_editor( 'PCI Device Id', str(hex(self.params.pci_device_id)).replace('0x','') ))
        html_list.append( utils.get_readonly_editor( 'Option Rom Version', self.params.optrom_ver) )
        html_list.append( utils.get_readonly_editor( 'Chip rev', self.params.chip_rev) )
        
        fwv = []
        fwv.append(str(hex(self.params.fwrev >> 24 & 0xff)).replace('0x',''))
        fwv.append(str(hex(self.params.fwrev >> 16 & 0xff)).replace('0x',''))
        fwv.append(str(hex(self.params.fwrev >> 8 & 0xff)).replace('0x',''))
        fwv.append(str(hex(self.params.fwrev & 0xff)).replace('0x',''))
        html_list.append( utils.get_readonly_editor( 'FW rev', '.'.join(fwv)) )
        
        html_list.append( utils.get_readonly_editor( 'Config file version', str(hex(self.params.cfg_finiver)).replace('0x','') ))
        html_list.append( utils.get_readonly_editor( 'Configfile: checksum', str(hex(self.params.cfg_finicsum)).replace('0x','') ) )
        
        if self.params.cfg_csum_status:
            cfg_csum_status = 'Valid'
        else:
            cfg_csum_status = 'Invalid'
        html_list.append( utils.get_readonly_editor( 'Configfile: status', cfg_csum_status) )
        
        if self.params.master:
            master = 'True'
        else:
            master = 'False'
        html_list.append( utils.get_readonly_editor( 'Master', master) )
        
        html_list.append( utils.get_readonly_editor( 'PCI Fn', self.params.pfn) )
        html_list.append( utils.get_readonly_editor( 'Port vector', str(hex(self.params.port_vec)).replace('0x','') ))
        html_list.append( utils.get_readonly_editor( 'Number of T4 ports', self.params.num_t4ports) )
        
        height = 0
        for i in range(self.params.num_t4ports):  
            html_list.append( utils.get_readonly_editor( 'Port %s id'%i, hex(eval('self.params.p%s_portid'%i))) )
            if eval('self.params.p%s_link_status'%i):
                link_stat = 'Up'
                link_speed = eval('self.params.p%s_link_speed'%i)
                if FOISCSI_CONSTANTS.has_key('LS%s'%link_speed):
                    link_speed_val = FOISCSI_CONSTANTS['LS%s'%link_speed] 
                html_list.append( utils.get_readonly_editor( 'Port %s link speed'%i, link_speed_val) )
                height += (4*33)
            else:
                link_stat = 'Down'
                height += (3*33)
            html_list.append( utils.get_readonly_editor( 'Port %s link status'%i, link_stat) )
            html_list.append( utils.get_readonly_editor( 'Port %s enode mac'%i, eval('self.params.p%s_enode_mac'%i)) )
            #Generating height for each port properties
            
        #Adding the fixed height without the port attributes
        height += 930
        
        html_list.append( utils.get_readonly_editor( 'Interrupt mode', self.params.intr_mode_str) )
        html_list.append( utils.get_readonly_editor( 'FW Evt ingress q msix', hex(self.params.fwevt_iq_msix)) )
        html_list.append( utils.get_readonly_editor( 'FW Evt ingress q index', hex(self.params.fwevt_iq_idx)) )
        html_list.append( utils.get_readonly_editor( 'Number of sge queues', self.params.wrm_num_sge_q) )
        
        if self.params.initiator:
            initiator_mode = 'True'
        else:
            initiator_mode = 'False'
        html_list.append( utils.get_readonly_editor( 'Initiator Mode', initiator_mode) )
        
        if self.params.target:
            target_mode = 'True'
        else:
            target_mode = 'False'
        html_list.append( utils.get_readonly_editor( 'Target Mode', target_mode) )
        html = ''.join(html_list)
        
        data = {}
        data['html'] = head_html + html
        data['height'] = height
        return data
