#from UmBoostLib import foiscsi_ini_boost, foiscsi_boost_discovery, foiscsi_boost_discovery_db
from UmBoostLib import foiscsi_ini_boost, foiscsi_boost_discovery
from Constants import FOISCSI_CONSTANTS
import settings, simplejson
logging = settings.get_logger()

class FoiscsiInitiatorDiscover:
    
    def __init__(self, **kwargs):
        self.sid = kwargs['sid']
        self.ip = kwargs['ip']
        self.req_type = kwargs['req_type']

    def discover(self, data):
        self.return_data = {}
        cmd = "discovery devno=%s saddr=%s daddr=%s dport=%s nodeid=%s"%( data['devno'], data['saddr'], data['daddr'], data['dport'], data['nodeid'] )
        logging.info('Foiscsi Discover issue discovery: sid : %s, ip : %s, cmd : %s'%(self.sid, self.ip, cmd))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, cmd)
        logging.info('Foiscsi Discover issue discovery cmd status : %s'%(status))
        
        if status == 0:
            self.return_data['status'] = 0
            #status = self.mainObj.foiscsi_execute_command(self.sid, self.sid, "discoverydb op=add devno=%s nodeid=%s dport=%s saddr=%s daddr=%s"
             #                                             %( data['devno'], data['nodeid'], data['dport'], data['saddr'], data['daddr'] ))
            self.generateHtml()
            return simplejson.dumps(self.return_data)
        elif status == -2:
            self.return_data['status'] = -2
            return simplejson.dumps(self.return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            self.return_data['status'] = 6
            self.return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)
        
    def generateHtml(self):
        tname_html = ''
        taddr_html = ''
        curr_tname_class = ''
        loop = True
        unique_parent_id = '#foiscsi_initiator_content__incend__%s .foiscsi_initiator_discover_tab'%self.ip.strip().replace('.','_')
        
        while(loop):
            logging.info('Foiscsi get Discover Params')
            self.DiscoverObj = foiscsi_boost_discovery()
            status = self.mainObj.foiscsi_get_discovery_data(self.DiscoverObj)
            logging.info('Foiscsi get Discover Params status : %s'%(status))
            
            if status == 0:
                if self.DiscoverObj.target_name.strip() != '':
                    curr_tname_class = ''.join(e for e in self.DiscoverObj.target_name.strip() if e.isalnum())
                    tname_html += '<li onclick="fo_disc_select_target(\'%s\', \'%s\', $(this))">%s</li>'%( unique_parent_id, curr_tname_class.lower(), self.DiscoverObj.target_name )
                else:
                    taddr_html += '<li class="%s as_hide">%s</li>'%( curr_tname_class.lower(), self.DiscoverObj.target_addr )
            elif status == -2:
                self.return_data['status'] = -2
                return None
            elif status == 100:
                loop = False
            elif FOISCSI_CONSTANTS.has_key(status):
                self.return_data['status'] = 6
                self.return_data['msg'] = FOISCSI_CONSTANTS[status]
                return None
            else:
                self.return_data['status'] = -1
                return None
        self.return_data['tname_html'] = tname_html
        self.return_data['taddr_html'] = taddr_html
        
        return None
            
