from UmBoostLib import FilterSummary
from UmBoostLib import FilList
from UmBoostLib import FilterList
from UmBoostLib import KList
import UmBoostLib 
import simplejson
import time

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)


class Filter:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip
    
    def get_set_filter_value(self, data):
       boostfilterobj = FilterSummary()
       
       logging.info('Filtering: %s max filter value waiting for response from UMboost sid : %s , UmServerIP : %s, ifName : %s, reqType : %s, maxFils : %s\
                   '%(data['action'], self.sid, self.ip, data['ifName'], data['reqType'], int(data['maxFils'])))
       status = boostfilterobj.GetSetMaxFilters(self.sid, self.ip, data['ifName'], int(data['reqType']), int(data['maxFils']))
       logging.info('Filtering: %s max filter value status: %s'%(data['action'], status))
       
       if data['action'] == 'set' and status == 0:
           time.sleep(2)
       
       if status == 0:
           if data['action'] == 'get':
                self.return_data = {}
                self.return_data['maxfilter'] = boostfilterobj.maxFilters
                self.return_data['rules'] = self.get_policies(data['ifName'])
                self.return_data['ifname'] = data['ifName']
                return simplejson.dumps(self.return_data)
           else:
               self.return_data = {}
               self.return_data['maxfilter'] = data['maxFils']
               return simplejson.dumps(self.return_data)
       elif status == -2:
           return -2
       else:
           return -1
    
    def get_policies(self, ifname):
        self.boostfilobj = FilList()
        self.boostfilterobj = FilterList()
        logging.info('Filtering: get policies waiting for response from UMboost sid : %s , UmServerIP : %s, ifName : %s\
                   '%(self.sid, self.ip, ifname))
        status = self.boostfilterobj.ListFilters(self.boostfilobj, self.sid, self.ip)
        logging.info('Filtering: get policies status: %s'%(status))
        
        if status == 0:
            return self.generate_rules_html() 
        elif status == -2:
            return -2
        else:
            return -1
        
    def generate_rules_html(self):
        
        height = 50
        positions = 0
        
        head_html = '<ul class="horizontal head_ul">\
            <li class="fid"><h2>FilterID</h2></li>\
            <li class="sip"><h2>SrcIp</h2></li>\
            <li><h2>DestIp</h2></li>\
            <li><h2>SrcPort</h2></li>\
            <li><h2>DestPort</h2></li>\
            <li><h2>Vlan</h2></li>\
            <li><h2>Priority</h2></li>\
            <li><h2>MacIdx</h2></li>\
            <li><h2>Action</h2></li>\
            <li><h2>Proto</h2></li>\
            <li><h2 class="bg_none">Queue</h2></li>\
         </ul>'
         
        html_list = []
        ip_id = self.ip.replace('.','_')
        parent_id = '#filtering_content__incend__%s .filtering_configuration_tab'%ip_id
        
        for i in range(0, len(self.boostfilobj)):
            height += 32
            positions += 1
            html_list.append('<ul class="horizontal content_tbl clear rules_ul position_%s" id = "fid_ul_%s_%s" >'%(self.boostfilterobj.get(self.boostfilobj,i).filterId, ip_id, self.boostfilterobj.get(self.boostfilobj,i).filterId))
            html_list.append('<li class="label fid"><input type="checkbox" onclick="fl_delete_enable(\'%s\')" name="fid" value="%s" /><span class="value">%s</span></li>'%(parent_id, self.boostfilterobj.get(self.boostfilobj,i).filterId, self.boostfilterobj.get(self.boostfilobj,i).filterId))
            
            sip = self.boostfilterobj.get(self.boostfilobj,i).sip
            mask =  self.boostfilterobj.get(self.boostfilobj,i).sip_mask
            html_list.append('<li class="sip"><input type="text" class="text" name="value_%s / %s" title="sip" value="%s / %s" /></li>'%(sip, mask, sip, mask))
            html_list.append('<li><input type="text" class="text" name="value_%s" title="dip" value="%s" /></li>'%(self.boostfilterobj.get(self.boostfilobj,i).dip, self.boostfilterobj.get(self.boostfilobj,i).dip))
            html_list.append('<li><input type="text" class="text" name="value_%s" title="sport" value="%s" /></li>'%(self.boostfilterobj.get(self.boostfilobj,i).sport, self.boostfilterobj.get(self.boostfilobj,i).sport))
            '''logging.debug('-----------------dport')
            logging.debug(self.boostfilterobj.get(self.boostfilobj,i).dport)
            logging.debug('-----------------dport')'''
            html_list.append('<li><input type="text" class="text" name="value_%s" title="dport" value="%s" /></li>'%(self.boostfilterobj.get(self.boostfilobj,i).dport, self.boostfilterobj.get(self.boostfilobj,i).dport))
            
            vlan_list = ['<div class="number_editor">\
                          <div class="fl_left input_wr">']
            vlan_list.append('<input type = "text" name="value_%s" title="%s" value="%s" class="text xsml" onblur="number_editor($(this),%s,%s,%s,\'blur\')" onkeyup="number_editor($(this),%s,%s,%s,\'validate\')"  />\
                              </div>'%(self.boostfilterobj.get(self.boostfilobj,i).vlan,'vlanid',self.boostfilterobj.get(self.boostfilobj,i).vlan,'4094','1','1','4094','1','1'))
            vlan_list.append('<div class="controls"><div class="up_arrow_wr">\
                            <img src="/images/black/up_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'inc\')"  />\
                            </div><div class= "down_arrow_wr">\
                            <img src="/images/black/down_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'dec\')" />\
                            </div></div></div>'%('4094','1','1','4094','1','1'))
            vlan_html = ''.join(vlan_list)
            html_list.append('<li>%s</li>'%vlan_html)
            
            
            priority_list = ['<select title="prio" class="value_%s" >'%self.boostfilterobj.get(self.boostfilobj,i).vlanPrio]
            for j in range(0, 8):
                if j == self.boostfilterobj.get(self.boostfilobj,i).vlanPrio:
                    priority_list.append('<option value="%s" selected="selected" >%s</option>'%(j,j))
                else:
                    priority_list.append('<option value="%s">%s</option>'%(j,j))
            priority_list.append('</select>')
            priority_html = ''.join(priority_list)
            html_list.append('<li>%s</li>'%priority_html)
            
            mac_list = ['<select title="mac" class="value_%s" >'%self.boostfilterobj.get(self.boostfilobj,i).macIdx]
            for l in range(0, 16):
                if l == self.boostfilterobj.get(self.boostfilobj,i).macIdx:
                    mac_list.append('<option value="%s" selected="selected" >%s</option>'%(l,l))
                else:
                    mac_list.append('<option value="%s">%s</option>'%(l,l))
            mac_list.append('</select>')
            mac_html = ''.join(mac_list)
            html_list.append('<li>%s</li>'%mac_html)
            
            unique_parent_id = '#filtering_content__incend__'+ self.ip.replace('.','_') +' .filtering_configuration_tab'; 
            if self.boostfilterobj.get(self.boostfilobj,i).action == 1:
                action_html = '<select title="action" class="value_pass" onchange="filter_alter_queue(\'%s\', $(this))" >'%(unique_parent_id)
                action_html += '<option value="pass" selected="selected" >Pass</option>\
                               <option value="drop" >Drop</option>\
                               </select>'
            else:
                action_html = '<select title="action" class="value_drop" onchange="filter_alter_queue(\'%s\', $(this))" >'%(unique_parent_id)
                action_html += '<option value="pass">Pass</option>\
                               <option value="drop" selected="selected" >Drop</option>\
                               </select>'
            html_list.append('<li>%s</li>'%action_html)
            
            proto_list = ['Any', 'TCP', 'UDP', 'FRAG']
            proto_html_list = ['<select title="proto" class="value_%s" >'%proto_list[self.boostfilterobj.get(self.boostfilobj,i).type].lower()]
            if self.boostfilterobj.get(self.boostfilobj,i).type > 3 or self.boostfilterobj.get(self.boostfilobj,i).type < 1: 
                proto_value = 0
            else:
                proto_value = self.boostfilterobj.get(self.boostfilobj,i).type
            
            for k in range(0,4):
                if k == proto_value:
                    proto_html_list.append('<option value="%s" selected="selected" >%s</option>'%(proto_list[k].lower(),proto_list[k]))
                else:
                    proto_html_list.append('<option value="%s" >%s</option>'%(proto_list[k].lower(),proto_list[k]))
                    
            proto_html_list.append('</select>')
            proto_html = ''.join(proto_html_list)
            html_list.append('<li>%s</li>'%proto_html)

            if self.boostfilterobj.get(self.boostfilobj,i).queue > 7 or self.boostfilterobj.get(self.boostfilobj,i).queue < 0:
                queue_val = 0
            else:
                queue_val = self.boostfilterobj.get(self.boostfilobj,i).queue
                
            queue_list = ['<select title="queue" class="value_%s" >'%queue_val]
            queue_list.append('<option value="-1" >-1</option>')
            for m in range(0, 8):
                if m == queue_val:
                    queue_list.append('<option value="%s" selected="selected" >%s</option>'%(m,m))
                else:
                    queue_list.append('<option value="%s">%s</option>'%(m,m))
            queue_list.append('</select>')
            queue_html = ''.join(queue_list)
            html_list.append('<li class="queue" >%s</li>'%queue_html)
            html_list.append('</ul>')
            
        insert_select_list = ['<select>']
        
        if positions > 1:
            positions = positions -1
        
        for i in range(positions):
            insert_select_list.append('<option value="%s">%s</option>'%(i+1, i+1))
        insert_select_list.append('</select>')
        self.return_data['insert_select_html'] = ''.join(insert_select_list)
        
        self.return_data['height'] = height
        whole_html = ''.join(html_list)
        return head_html + whole_html
    
    
    def set_filter_properties(self, data):
        
        if data['action_type'] == 'modify':
            mode = 3
        elif data['action_type'] == 'add':
            mode = 2
        
        boostSetPropertyObj = KList()
        success = True
        
        if int(data['filter_count']) > 1:
            for i in range(int(data['filter_count'])):
                logging.debug('Umkey Add M Filter for Filter Id :%s :'%( data['fid'][i] ))
                fid = UmBoostLib.UMKey('id', data['fid'][i])
                boostSetPropertyObj.append(fid)
                
                if int(data['properties_count_%s'%data['fid'][i]]) > 1:
                    for i in range(int(data['properties_count_%s'%data['fid'][i]])):
                        logging.debug('Umkey Add M Property: %s , Value : %s'%( data['propname'][i], data['value'][i]))
                        tempkey = UmBoostLib.UMKey(data['propname'][i], data['value'][i])
                        boostSetPropertyObj.append(tempkey)
                else:
                    logging.debug('Umkey Add S Property: %s , Value : %s'%( data['propname'], data['value']))
                    tempkey = UmBoostLib.UMKey(data['propname'], data['value'])
                    boostSetPropertyObj.append(tempkey)
                    
                logging.debug('Umkey Add M Filter for Ifname :%s :'%( data['ifname'] ))
                ifname = UmBoostLib.UMKey('ifname', data['ifname'])
                boostSetPropertyObj.append(ifname)
                    
                logging.info('Modify/Add  Filter Set Properties Mode %s:  - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                     '%(mode, self.sid,self.ip, data['ostype']))
                status = boostSetPropertyObj.setProperty(self.sid, self.ip, mode, int(data['ostype']))
                #status = 0
                logging.info('Modify/Add Filter Set Properties Status : %s'%status)
                if status == -2:
                    return -2
                elif status != 0:
                    success = False
        else:
            logging.debug('Umkey Add S Filter for Filter Id :%s :'%( data['fid'] ))
            fid = UmBoostLib.UMKey('id', data['fid'])
            boostSetPropertyObj.append(fid)
            
            if int(data['properties_count_%s'%data['fid']]) > 1:
                for i in range(int(data['properties_count_%s'%data['fid']])):
                    logging.debug('Umkey Add M Property: %s , Value : %s'%( data['propname'][i], data['value'][i]))
                    tempkey = UmBoostLib.UMKey(data['propname'][i], data['value'][i])
                    boostSetPropertyObj.append(tempkey)
            elif int(data['properties_count_%s'%data['fid']]) == 1:
                logging.debug('Umkey Add S Property: %s , Value : %s'%( data['propname'], data['value']))
                tempkey = UmBoostLib.UMKey(data['propname'], data['value'])
                boostSetPropertyObj.append(tempkey)
                
            logging.debug('Umkey Add S Modify/Add Filter for Ifname :%s :'%( data['ifname'] ))
            ifname = UmBoostLib.UMKey('ifname', data['ifname'])
            boostSetPropertyObj.append(ifname)

            logging.info('Modify/Add Filter Set Properties Mode : %s - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                 '%(mode, self.sid, self.ip, data['ostype']))
            status = boostSetPropertyObj.setProperty(self.sid, self.ip, mode, int(data['ostype']))
            #status = 0
            logging.info('Modify/Add Filter Set Properties Status : %s'%status)
            if status == -2:
                return -2
            elif status != 0:
                success = False
            
            if status != 0:
                success = False
        
        if success:
            return 0
        else:
            return -1

    def delete_filter(self, data):
        success = True
        if int(data['fid_count']) > 1:
            for i in range(int(data['fid_count'])):
                logging.debug('Delete M Filter waiting for boost Sid : %s, Ip: %s, ifname : %s, FID : %s'%(self.sid, self.ip, data['ifname'], data['fid'][i]))
                boostdelobj = FilterSummary()
                status = boostdelobj.DeleteFilter(self.sid, self.ip, data['ifname'], data['fid'][i])
                #status = 0
                logging.debug('Delete M Filter Status : %s'%status)
                if status == -2:
                    return -2
                elif status != 0:
                    success = False
        else:
            logging.debug('Delete S Filter waiting for boost Sid : %s, Ip: %s, ifname : %s, FID : %s'%(self.sid, self.ip, data['ifname'], data['fid']))
            boostdelobj = FilterSummary()
            status = boostdelobj.DeleteFilter(self.sid, self.ip, data['ifname'], data['fid'])
            #status = 0
            logging.debug('Delete M Filter Status : %s'%status)
            if status == -2:
                return -2
            elif status != 0:
                success = False
            
        if success:
            return 0
        else:
            return -1