from UmBoostLib import TMScheduler, TMSchedTxQClassMapLst, TMSched_TxQSets, TMSchedIfLst

import simplejson, settings  
logging = settings.get_logger()

class EgressQueueMapClass:
    
    def __init__(self, sid , ip, req_type):
        self.sid = sid
        self.ip = ip
        self.req_type = req_type
        self.ifname = -6

    def get_initial_data(self):
        
        self.return_data = {}
        self.getQueueClassMap()
        self.getIfnames()
        self.getQueueIds()
        return simplejson.dumps(self.return_data)
    
    def getQueueClassMap(self):
        
        logging.info('Egress Queue Map - ListTxQueueClassMap : Sid : %s , IP : %s'%(self.sid,self.ip))
        MainObj = TMScheduler(self.sid, self.ip)
        self.paramObj = TMSchedTxQClassMapLst()
        map_status = MainObj.ListTxQueueClassMap(self.paramObj)
        logging.info('Egress Queue Map - ListTxQueueClassMap: status : %s, len of obj : %s'%(map_status,len(self.paramObj)))
        
        if map_status == 0:
            if len(self.paramObj) == 0:
                self.return_data['map_status'] = 1
            else:
                self.generateMapHtml()
                self.return_data['map_status'] = 0
        elif map_status == -2:
            self.return_data['map_status'] = -2
        else:
            self.return_data['map_status'] = -1
        
    def generateMapHtml(self):
        
        li_html = '<li class="mgn_b10">Interface Name : <span class="green_f">%s</span> >> Class Id : <span class="green_f">%s</span> >> Tx Queue Id : <span class="green_f">%s</span></li>' 
        li_html_list = [li_html%( self.paramObj[i].ifName, self.paramObj[i].classId, self.paramObj[i].queueId  ) for i in range(len(self.paramObj))]
        self.return_data['map_html'] = '<ul class="f_bold">%s</ul>'%(''.join(li_html_list))
    
    def getQueueIds(self):
        
        if self.ifname == -6:
            logging.info('Get Qids : No ifname retrived. Hence unable to fetch the qids')
            self.return_data['qid_status'] = -1
            return
        
        logging.info('Egress Queue Map - GetQSetInfo : Sid : %s , IP : %s, ifname : %s'%(self.sid,self.ip, self.ifname))
        MainObj = TMScheduler(self.sid, self.ip)
        self.paramObj = TMSched_TxQSets()
        qid_status = MainObj.GetQSetInfo(self.ifname, self.paramObj)
        logging.info('Egress Queue Map - GetQSetInfo: status : %s, numQsets : %s'%(qid_status, self.paramObj.numQsets))
        
        if qid_status == 0:
            self.generateQidHtml()
            self.return_data['qid_status'] = 0
        elif qid_status == -2:
            self.return_data['qid_status'] = -2
        else:
            self.return_data['qid_status'] = -1

    def generateQidHtml(self):
        
        opt_html = '<option value="%s">%s</option>'
        maxid =  self.paramObj.numQsets
        opt_html_list = [opt_html%( i, i ) for i in range(maxid)]
        self.return_data['qid_html'] = '<select>%s</select>'%(''.join(opt_html_list))
        
    def getIfnames(self):
        
        logging.info('Egress Queue Map - ListInterfaces : sid : %s , IP : %s'%(self.sid,self.ip))
        paramObj = TMSchedIfLst()
        MainObj = TMScheduler(self.sid, self.ip)
        ifstatus = MainObj.ListInterfaces(paramObj)
        logging.info('Egress PQueue Map - ListInterfaces: status : %s'%(ifstatus))
        
        if ifstatus == 0:
            self.return_data['ifstatus'] = 0
            
            #Param to get the QID
            self.ifname = paramObj[0].ifName
            
            opt_html = '<option value="%s">%s</option>'
            opt_html_list = []
            opt_html_list = [opt_html%( paramObj[i].ifName, paramObj[i].ifName ) for i in range(len(paramObj)) ]
            self.return_data['ifname_html'] = '<select>%s</select>'%(''.join(opt_html_list))
        elif ifstatus == -2:
            self.return_data['ifstatus'] = -2
            self.return_data['status'] = -2
        else:
            self.return_data['ifstatus'] = -1
            
    def mapQueueClass(self, data):
        
        logging.info('Egress Queue Map - SetTxQueueToClass : sid : %s , IP : %s, iff_name : %s , schedType : %s, queueId : %s , classId : %s'%(
                                                        self.sid, self.ip, data['iff_name'], data['schedType'], data['queueId'], data['classId'] ))
        MainObj = TMScheduler(self.sid, self.ip)
        status = MainObj.SetTxQueueToClass(data['iff_name'], data['schedType'], data['queueId'], data['classId'])
        #status = 0
        logging.info('Egress PQueue Map - SetTxQueueToClass: status : %s'%(status))
        
        if status == 0 or status == -2:
            return status
        else:
            return -1
        
