from UmBoostLib import TMScheduler, TMSchedTxSchedLst, TMSchedIfLst
from Constants import EPS_RATEUNIT, EPS_RATEMODE, EPS_MODE
import simplejson, settings  
logging = settings.get_logger()

class EgressPacketSchedulerClass:
    
    def __init__(self, sid , ip, req_type):
        self.sid = sid
        self.ip = ip
        self.req_type = req_type

    def get_initial_data(self):
        
        data = {}
        logging.info('Egress Packet Scheduler - ListTxSchedulers : sid : %s , IP : %s'%(self.sid,self.ip))
        self.paramObj = TMSchedTxSchedLst()
        MainObj = TMScheduler(self.sid, self.ip)
        status = MainObj.ListTxSchedulers(self.paramObj)
        logging.info('Egress Packet Scheduler - ListTxSchedulers: status : %s'%(status))
        
        self.return_data = {}
        if status == 0:
            logging.info('Egress Packet Scheduler object length : %s'%len(self.paramObj))
            self.return_data['status'] = 0
            if len(self.paramObj) == 0:
                self.return_data['html'] = -6
                self.getIfnames()
                return simplejson.dumps(self.return_data)
            else:
                self.return_data['html'] = self.generateInitialHtml()
                self.getIfnames()
                return simplejson.dumps(self.return_data)
        elif status == -2:
            self.return_data['status'] = -2
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)
        
    def generateInitialHtml(self):
        
        ifName = '-'
        classId = '-'
        type = '-'
        channelId = '-'
        minrate = '-'
        maxrate = '-'
        pktsize = '-'
        weight = '-'
        
        #Index 2 of the constants will return "-" string 
        mode = 2
        rateunit = 2
        ratemode = 2
        
        pkt_size_style = 'width:10%!important'
        mode_style = 'width:6%!important'
        
        html = []
        height = 100
        html.append(
                    '<div class="saved_rule_wr"><ul class="horizontal head_ul">\
                        <li><h2>Scheduler</h2></li>\
                        <li><h2>Channel ID</h2></li>\
                        <li><h2>Interface</h2></li>\
                        <li class="mode"><h2>Mode</h2></li>\
                        <li><h2>Rate Mode</h2></li>\
                        <li><h2>Rate Unit</h2></li>\
                        <li><h2>Min rate</h2></li>\
                        <li><h2>Max rate</h2></li>\
                        <li class="avg_pkt_s"><h2>Packet size</h2></li>\
                        <li><h2 class="bg_none">Weight</h2></li>\
                    </ul>'
                    )
        
        for i in range(len(self.paramObj)):
            
            height += 42
            ''' Refer /mgmt/libclient/CLTMSchedCommands.cpp and print the data proeprly with all the possible descriptions '''
            ifName = self.paramObj[i].ifName
            channelId = self.paramObj[i].channelId
            
            if self.paramObj[i].classId < 0:
                #Channel hierarchy level
                #Weight set
                if self.paramObj[i].weight > 0:
                    weight = self.paramObj[i].weight
                #Class set
                else:
                    rateunit = self.paramObj[i].rateunit
                    ratemode = self.paramObj[i].ratemode
                    maxrate = self.paramObj[i].maxrate
            else:
                 #Class hierarchy level
                 classId = self.paramObj[i].classId
                 #Weight set
                 if self.paramObj[i].weight > 0:
                    weight = self.paramObj[i].weight
                 #Class set
                 else:
                    rateunit = self.paramObj[i].rateunit
                    ratemode = self.paramObj[i].ratemode
                    minrate = self.paramObj[i].minrate
                    maxrate = self.paramObj[i].maxrate
                    mode = self.paramObj[i].mode
                    if self.paramObj[i].rateunit == 1 or self.paramObj[i].mode == 1:
                        pktsize = self.paramObj[i].pktsize
                        
            html.append(
                        '<ul class="horizontal content_tbl clear_left rules_ul">\
                            <li class="center_imp label">\
                                <span class="value">%s</span>\
                            </li>\
                            <li class="center_imp label">\
                                <span class="value">%s</span>\
                            </li>\
                            <li class="center_imp label">\
                                <span class="value">%s</span>\
                            </li>\
                            <li class="center_imp label" style="%s">\
                                <span class="value">%s</span>\
                            </li>\
                            <li class="center_imp label">\
                                <span class="value">%s</span>\
                            </li>\
                            <li class="center_imp label rate_unit">\
                                <span class="value">%s</span>\
                            </li>\
                            <li class="center_imp label">\
                                <span class="value">%s</span>\
                            </li>\
                            <li class="center_imp label">\
                                <span class="value">%s</span>\
                            </li>\
                            <li class="avg_pkt_s center_imp label" style="%s">\
                                <span class="value">%s</span>\
                            </li>\
                             <li class="center_imp label">\
                                <span class="value">%s</span>\
                            </li>\
                        </ul>'%( classId, channelId, ifName, mode_style, EPS_MODE[mode], EPS_RATEMODE[ratemode], EPS_RATEUNIT[rateunit], minrate, maxrate, pkt_size_style, pktsize, weight )
                        )
            
            #Resetting the values
            ifName = '-'
            classId = '-'
            type = '-'
            channelId = '-'
            minrate = '-'
            maxrate = '-'
            pktsize = '-'
            weight = '-'
            
            #Index 2 of the constants will return "-" string 
            mode = 2
            rateunit = 2
            ratemode = 2
        
        height += 80
        self.return_data['height'] = height     
        return ''.join(html)+'</div>'
    
    def getIfnames(self):
        
        logging.info('Egress Packet Scheduler - ListInterfaces : sid : %s , IP : %s'%(self.sid,self.ip))
        paramObj = TMSchedIfLst()
        MainObj = TMScheduler(self.sid, self.ip)
        status = MainObj.ListInterfaces(paramObj)
        logging.info('Egress Packet Scheduler - ListInterfaces: status : %s , length of obj : %s '%(status, len(paramObj)))
        
        if status == 0:
            self.return_data['ifname_status1'] = 0
            ifname_list = [paramObj[i].ifName for i in range(len(paramObj))]
            self.return_data['ifnames'] = ','.join(ifname_list)
        elif status == -2:
            self.return_data['ifname_status1'] = -2
            self.return_data['status'] = -2
        else:
            self.return_data['ifname_status1'] = -1
        
        
    def save_rule(self, data):
        
        status = 6
        if data['classId'].strip() == 'null':
            #Channel
            #No weight for channel
            if data['maxrate'].strip() != '' and data['maxrate'] != '0':
                logging.info('Egress Packet Scheduler - SetTxSchedChannelParams : sid : %s , IP : %s, iff_name : %s, schedType : %s, channelId : %s\
                                                                                , mode : %s, rateunit : %s, ratemode : %s, maxrate : %s, weight : %s'%(
                                                                               self.sid, self.ip, data['iff_name'],data['schedType'], data['channelId'], data['mode'], data['rateunit'], 
                                                                               data['ratemode'], data['maxrate'], '0'))
                MainObj = TMScheduler(self.sid, self.ip)
                status = MainObj.SetTxSchedChannelParams(data['iff_name'],data['schedType'], data['channelId'], data['mode'], data['rateunit'], 
                                                         data['ratemode'], data['maxrate'], '0')
                #status = 0
                logging.info('Egress Packet Scheduler - SetTxSchedChannelParams: status : %s'%(status))
        else:
            #Class
            if data['weight'] != '0':
                #class weight
                logging.info('Egress Packet Scheduler - SetTxSchedClassParams - class Weight : sid : %s , IP : %s, iff_name : %s, schedType : %s, classId : %s, channelId : %s\
                                                                                , mode : %s, rateunit : %s, ratemode : %s, minrate : %s, maxrate : %s, pktsize : %s, weight : %s'%(
                                                                                self.sid, self.ip, data['iff_name'],data['schedType'], data['classId'], data['channelId'],
                                                                                '0', '0', '0', '0', '0', '0', data['weight']))
                MainObj = TMScheduler(self.sid, self.ip)
                status = MainObj.SetTxSchedClassParams(data['iff_name'],data['schedType'], data['classId'], data['channelId'], '0',
                                                       '0', '0', '0', '0', '0', data['weight'])
                
                logging.info('Egress Packet Scheduler - SetTxSchedClassParams - class Weight: status : %s'%(status))
            
            if data['maxrate'].strip() != '' and data['maxrate'] != '0':
                #class rate
                logging.info('Egress Packet Scheduler - SetTxSchedClassParams - class rate  : sid : %s , IP : %s, iff_name : %s, schedType : %s, classId : %s, channelId : %s'\
                                                                                ', mode : %s, rateunit : %s, ratemode : %s, minrate : %s, maxrate : %s, pktsize : %s, weight : %s'%(
                                                                                self.sid, self.ip, data['iff_name'],data['schedType'], data['classId'], data['channelId'].strip(),
                                                                                data['mode'], data['rateunit'], data['ratemode'], data['minrate'], data['maxrate'], data['pktsize'], data['weight']))
                MainObj = TMScheduler(self.sid, self.ip)
                status = MainObj.SetTxSchedClassParams(data['iff_name'],data['schedType'], data['classId'], data['channelId'], data['mode'],
                                                       data['rateunit'], data['ratemode'], data['minrate'], data['maxrate'], data['pktsize'], '0')
                #status = 0
                logging.info('Egress Packet Scheduler - SetTxSchedClassParams - class rate: status : %s'%(status))
        
        if status == 0 or status == -2 or status == 6:
            return status
        else:
            return -1
        