from UmBoostLib import IPList,IntfIPList
from UmBoostLib import IntfList,InterfaceList
from UmBoostLib import NetworkInfo
import simplejson
import utils
import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)


class DNSGatewayInfo:
    
    def __init__(self,sessionId,hostIP) :
         self.sessionId=sessionId
         self.hostIP=hostIP
         
    def get_initial_data(self, ostype, req_type):
        self.req_type = req_type
        data = {}
        data['gw'] = self.gateway_info()
        data['dns'] = self.dns_info(ostype)
        data['iflist'] = self.get_interface_list()
        return simplejson.dumps(data)

    def dns_info(self, ostype):
        
        self.boostInterfaceList = InterfaceList()
        self.boostNWInterfaceObj=IntfList()
        logging.info('DNS List - Getting interface List:  waiting for response from UMboost sid : %s , IP : %s'%(self.sessionId,self.hostIP))
        status=self.boostInterfaceList.getNetworkInformation(self.boostNWInterfaceObj,self.sessionId,self.hostIP)
        logging.info('DNS List - Getting interface List: result %s'%(status))
        
        dns_retrieved = False
        dns_html = ''
        if status == 0:
            for i in range(0,len(self.boostNWInterfaceObj)):
              
              logging.info('DNS for interface %s: waiting for response from UMboost sid : %s , IP : %s , infname : %s , ipType : %s'%(self.boostInterfaceList.get(self.boostNWInterfaceObj,i).FriendlyName,self.sessionId,self.hostIP,self.boostInterfaceList.get(self.boostNWInterfaceObj,i).FriendlyName,'1'))
              self.boostIPListObj = IPList()
              self.boostIntfIPListObj = IntfIPList()
              ifname = self.boostInterfaceList.get(self.boostNWInterfaceObj,i).FriendlyName
              status = self.boostIntfIPListObj.getIntfIPInformation(self.boostIPListObj, self.sessionId, self.hostIP, ifname, 1)
              logging.info('DNS for interface %s: status: %s'%(ifname,status))
              if status == 0 and len(self.boostIPListObj) > 0:
                  dns_retrieved = True
                  if ostype == '1':
                      dns_html += self.get_dns_html(ifname)
                      #continue
                  else:
                      break
          
        if status == -2:
            return -2
        ip_id = self.hostIP.replace('.','_')
        if dns_retrieved:
            if ostype == '1':
               if self.req_type == 'mobile':
                   return '<select onchange="fill_dns_details($(this),\'%s\')"><option value="">Select One..</option>%s</select>'%(ip_id,dns_html)
               else:
                   return dns_html
            else:
                if self.req_type == 'mobile':
                   return '<select onchange="fill_dns_details($(this),\'%s\')"><option value="">Select One..</option>%s</select>'%(ip_id,self.get_dns_html(ifname))
                else:
                   return self.get_dns_html(ifname)
        else:
            return None
        
    def get_dns_html(self, ifname):
        
        if self.req_type == 'desktop':
            dns_html = '<li class="eth dns hover_li" onclick="fill_dns_details($(this),\'%s\',\'%s\',\'%s\')" >%s\
                        <input type="hidden" class="dns_ip" value="%s" />\
                        <input type="hidden" class="ifname" value="%s" /></li>'
        else:
            dns_html = '<option value="%s__%s" >%s</option>'
        
        ip_id = self.hostIP.replace('.','_')
        
        if self.req_type == 'desktop':
            html_list = [ dns_html%(i, ip_id, ifname, i, i, ifname) for i in self.get_dns_address() ]
        else:
            html_list = [ dns_html%(i, ifname, i) for i in self.get_dns_address() ]
    
        html = ''.join(html_list)
        return html
       
    
    def get_dns_address(self) :
         
       for i in range(0,len(self.boostIPListObj)):
          yield self.boostIntfIPListObj.get(self.boostIPListObj,i).Address
    
    def gateway_info(self):
        
       self.boostInterfaceList = InterfaceList()
       self.boostNWInterfaceObj=IntfList()
       logging.info('DGDC - Gateway List - Getting interface List:  waiting for response from UMboost sid : %s , IP : %s'%(self.sessionId,self.hostIP))
       status=self.boostInterfaceList.getNetworkInformation(self.boostNWInterfaceObj,self.sessionId,self.hostIP)
       logging.info('DGDC - Gateway List - Getting interface List: result %s'%(status))
       
       gw_html_list = []
       gateway = False
       for i in range(0,len(self.boostNWInterfaceObj)):
          ifname = self.boostInterfaceList.get(self.boostNWInterfaceObj,i).FriendlyName
          self.boostIPListObj = IPList()
          self.boostIntfIPListObj = IntfIPList()
          logging.info('DGDC - Gateway for interface %s: waiting for response from UMboost sid : %s , IP : %s , infname : %s , ipType : %s'%(ifname,self.sessionId,self.hostIP,ifname,'2'))   
          status = self.boostIntfIPListObj.getIntfIPInformation(self.boostIPListObj,self.sessionId,self.hostIP,ifname,2)
          logging.info('DGDC - Gateway Information status: %s'%status)
          
          logging.info('Len %s'%len(self.boostIPListObj))
          
          if status == 0 and len(self.boostIPListObj) > 0:
               gateway = True
               gw_html_list.append(self.get_gateway_html(ifname))
          elif status == -2:
               return -2
       
       if not gateway:
           return -1
          
       whole_html = ''.join(gw_html_list)
       ip_id = self.hostIP.replace('.','_')
       if self.req_type == 'mobile':
           return '<select onchange="fill_gw_details($(this), \'%s\')"><option value="">Select One..</option>%s</select>'%(ip_id,whole_html)
       else:
           return whole_html
        
    
    def get_gateway_html(self,ifname):
        
        if self.req_type == 'desktop':
            gw_html = '<li class="eth gateway hover_li" onclick="fill_gw_details($(this),\'%s\',\'%s\',\'%s\')" >%s\
                        <input type="hidden" class="eth" value="%s" />\
                        <input type="hidden" class="gw_ip" value="%s" /></li>'
        else:
            gw_html = '<option value="%s__%s" >%s</option>'
        gw = self.get_gateway_address()
        ip_id = self.hostIP.replace('.','_')
        if gw:
            if self.req_type == 'desktop':
                return gw_html%(gw, ip_id, ifname, gw, ifname, gw)
            else:
                return gw_html%(gw, ifname, gw)
        else:
            return '' 
    
    
    def get_gateway_address(self) :
        gw = self.boostIntfIPListObj.get(self.boostIPListObj,0).Address
        if gw != '0.0.0.0':
            return gw

    
    def get_interface_list(self):
    
       self.boostInterfaceList = InterfaceList()
       self.boostNWInterfaceObj=IntfList()
       logging.info('DGDC - Get Interface List: waiting for response from UMboost sid : %s , UmServerIP : %s'%(self.sessionId,self.hostIP))
       status = self.boostInterfaceList.getNetworkInformation(self.boostNWInterfaceObj,self.sessionId,self.hostIP)
       logging.info('DGDC - Get Interface List: %s'%(status))
       
       if status == 0:
           if self.req_type == 'desktop':
               return self.generate_interface_html()
           else:
               return "<select>%s</select>"%self.generate_interface_html()
       elif status == -2:
           return -2
       else:
           return -1
       
    def get_interface_obj(self):
        for i in range(0,len(self.boostNWInterfaceObj)):
            yield self.boostInterfaceList.get(self.boostNWInterfaceObj,i) 

    
    def generate_interface_html(self):
        
        option_html = '<option value="%s" label = "[ %s ]" >%s</option>'
        whole_html = '%s'
    
        option_html_list = [ whole_html%( option_html%( i.FriendlyName, i.MacString, i.FriendlyName )) for i in self.get_interface_obj() ] 
    
        html = ''.join(option_html_list)
        return html

    
    def set_gateway(self,data):
        
        logging.info('Validate Gateway : %s, Validate : 3 '%data['gw'])
        gw_validate = utils.validate_ip(data['gw'], 3)
        logging.info('Validate Gateway status %s'%gw_validate)
        if gw_validate == -1:
            return  'Invalid GW'
    
        self.boostSetGwObj = NetworkInfo()
        logging.info('DGDC - Set Gateway: waiting for response from UMboost sid : %s , UmServerIP : %s , InterFace Name : %s , ipversion : %s, gw : %s\
                 '%(self.sessionId,self.hostIP,data['ifName'],data['ipversion'],data['gw']))
        status = self.boostSetGwObj.SetGW(self.sessionId,self.hostIP,data['ifName'],data['ipversion'],data['gw'])
        logging.info('DGDC - Set Gateway status: %s'%(status))
        
        if status == 0 or status == 283 or status == 284:
           return status
        elif status == -2:
           return -2
        else:
           return -1
        
    def set_dns(self,data):
        
        if data['action'] == 'ModifyDns':
            validate_dns = data['newdns']
        else:
            validate_dns = data['dns']
        
        logging.info('Validate DNS : %s, Validate : 1 '%validate_dns)
        dns_validate = utils.validate_ip(validate_dns, 1)
        logging.info('Validate DNS status %s'%dns_validate)
        if dns_validate == -1:
            return  'Invalid Dns'
        
        self.boostSetDnsObj = NetworkInfo()
        logging.info('DGDC - Set DNS: waiting for response from UMboost sid : %s , UmServerIP : %s , InterFace Name : %s ,\
                    reqType : %s , ipversion : %s, dns : %s , newdns : %s\
                 '%(self.sessionId,self.hostIP,data['ifName'],data['reqType'],data['ipversion'],data['dns'],data['newdns']))
        status = self.boostSetDnsObj.SetDNS(self.sessionId,self.hostIP,data['ifName'],data['reqType'],data['ipversion'],data['dns'],data['newdns'])
        logging.info('DGDC - Set DNS status: %s'%(status))
        
        if status == 0 or status == 283 or status == 284:
           return status
        elif status == -2:
           return -2
        else:
           return -1
        
    def del_dns(self,data):
     
        self.boostDelDnsObj = NetworkInfo()
        logging.info('DGDC - Delete DNS: waiting for response from UMboost sid : %s , UmServerIP : %s , InterFace Name : %s ,\
                    reqType : %s , ipversion : %s, dns : %s , newdns : %s\
                 '%(self.sessionId,self.hostIP,data['ifName'],data['reqType'],data['ipversion'],data['dns'],data['newdns']))
        status = self.boostDelDnsObj.SetDNS(self.sessionId,self.hostIP,data['ifName'],data['reqType'],data['ipversion'],data['dns'],data['newdns'])
        logging.info('DGDC - Delete DNS status: %s'%(status))
        
        if status == 0 or status == 283 or status == 284:
           return status
        elif status == -2:
            return -2
        else:
            return -1
         
    def add_dns(self,data):
     
        logging.info('Validate DNS : %s, Validate : 1 '%data['dns'])
        dns_validate = utils.validate_ip(data['dns'], 1)
        logging.info('Validate DNS status %s'%data['dns'])
        if dns_validate == -1:
            return  'Invalid Dns'
        
        self.boostDelDnsObj = NetworkInfo()
        logging.info('DGDC - Add DNS: waiting for response from UMboost sid : %s , UmServerIP : %s , InterFace Name : %s ,\
                 reqType : %s , ipversion : %s, dns : %s , newdns : %s\
              '%(self.sessionId,self.hostIP,data['ifName'],data['reqType'],data['ipversion'],data['dns'],data['newdns']))
        status = self.boostDelDnsObj.SetDNS(self.sessionId,self.hostIP,data['ifName'],data['reqType'],data['ipversion'],data['dns'],data['newdns'])
        logging.info('DGDC - Add DNS status: %s'%(status))
        
        if status == 0 or status == 283 or status == 284: 
          return status
        elif status == -2:
          return -2
        else:
          return -1