from UmBoostLib import LicInfo
from xml.dom.minidom import Document

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class CardInfo:
    def __init__(self,sessionId,hostIP):
        self.sessionId = sessionId
        self.hostIP = hostIP
        self.info = LicInfo()

    def getCardInfo(self):
        logging.info('Card Information:  waiting for response from UMboost sid : %s , IP : %s'%(self.sessionId,self.hostIP))
        status = self.info.GetLicenseInfo(self.sessionId,self.hostIP)
        logging.info('Card Information status: %s'%status)
        
        if status == 0:
            return self.generateXML()
        elif status == -2:
            return -2
        else:
            return -1
        
    def generateXML(self):
        doc = Document()
        
        cardinfo = doc.createElement("cardinfo")
        doc.appendChild(cardinfo)
        
        licto = doc.createElement("licto")
        cardinfo.appendChild(licto)
        
        licto_value = doc.createTextNode(self.info.customer)
        licto.appendChild(licto_value)
        
        licinstalled = doc.createElement("licinstalled")
        cardinfo.appendChild(licinstalled)
        
        licinstalled_value = doc.createTextNode(self.info.LicType)
        licinstalled.appendChild(licinstalled_value)
        
        serialnum = doc.createElement("serialnum")
        cardinfo.appendChild(serialnum)
        
        serialnum_value = doc.createTextNode(self.info.serNum)
        serialnum.appendChild(serialnum_value)
        
        licdevice = doc.createElement("licdevice")
        cardinfo.appendChild(licdevice)
        
        licdevice_value = doc.createTextNode(self.info.devType)
        licdevice.appendChild(licdevice_value)
            
        return doc.toprettyxml()