from UmBoostLib import bypass_boost as BypassBoost
from UmBoostLib import bypass_boost_response as BypassBoostResp
from UmBoostLib import PortInfo
from T4FilteringFile import T4Filtering
import re
from xml.dom.minidom import Document
import simplejson
import settings, utils, UmBoostLib
logging = settings.get_logger()

class Bypass:
	def __init__(self, sid, ip) :
		self.sid = sid
		self.ip = ip

	def get_port0_iface(self, card_data):
		byp_obj = BypassBoost()
		boost_data =  BypassBoostResp()
		status = byp_obj.bypass_execute_command(self.sid, self.ip, "show_iface")
		byp_obj.bypass_boost_resp(boost_data)
		iface_list_temp = boost_data.data.strip().split(' ')
		iface_list = filter(lambda ifname: ifname.strip(), iface_list_temp)
		logging.info('iface_list : %s '%iface_list)
		for i in range(1,5):
			port_obj = PortInfo()
			logging.info('Bypass Port Summary:  waiting for response from UMboost sid : %s , IP : %s , PCILOC : %s , Index : %s, ostype : %s'%(self.sid, self.ip ,card_data['pci_loc'],i,card_data['ostype']))
			status = port_obj.GetPortInfo(self.sid, self.ip, card_data['pci_loc'], i, int(card_data['ostype']))
			logging.info('Bypass Port Summary Status : %s iface: %s list: %s'%(status, port_obj.ifaceName, iface_list) )
			if status == 0:
				if port_obj.ifaceName.strip() in iface_list:
					return port_obj.ifaceName
			elif status == -2:
				return -2
		return -1
		
	def get_server_status(self, iface):
		byp_obj = BypassBoost()
		tmp_cmd = 'status_baserver iface=%s'%iface
		logging.info('Bypass getting server status sid : %s , IP : %s, cmd :%s'%( self.sid, self.ip, tmp_cmd ))
		status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp_cmd)
		logging.info('Bypass getting server status sid : %s , IP : %s, cmd :%s, status : %s'%( self.sid, self.ip, tmp_cmd, status ))
		return status

	def start_stop_server(self, in_data):
		byp_obj = BypassBoost()
		iface = in_data['iface']
		tmp_cmd = '%s_baserver iface=%s'%(in_data['value'], iface)
		logging.info('Bypass getting server action sid : %s , IP : %s, cmd :%s'%( self.sid, self.ip, tmp_cmd ))
		status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp_cmd)
		logging.info('Bypass starting or stopping server status sid : %s , IP : %s, cmd: %s, iface: %s status: %s'%( self.sid, self.ip, tmp_cmd, iface, status ))
		return status

	def get_byp_server_config(self, in_data):
		#get interface of port0 of card selected
		port0_iface = self.get_port0_iface(in_data)
		if port0_iface < 0:
			return port0_iface
		logging.info('bypass get_port0_iface iface: %s'%( port0_iface ))
		#get server status on port0_iface
		server_status = self.get_server_status(port0_iface)
		return_data = {}
		if server_status < 0:
			return_data['ba_server'] = 0
			return_data['iface'] = port0_iface
			return simplejson.dumps(return_data)
		else:
			iface = port0_iface
			logging.info('bypass server status %s'%( iface ))
			return_data['ba_server'] = 1
			return_data['iface'] = iface
			byp_obj = BypassBoost()
			boost_data =  BypassBoostResp()
			conf_list = ['current_state', 'default_state', 'watchdog', 'watchdog_timeout']
			for cnf in conf_list:
				tmp = 'cmd command="bypass '+iface+' get --'+cnf+'"'
				logging.info('Bypass server conf data : %s %s'%( cnf, tmp ))
				status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp)
				byp_obj.bypass_boost_resp(boost_data)
				logging.info('Bypass server conf data : %s %s'%( cnf,boost_data.data ))
				tmp_data = "%s"%boost_data.data
				return_data[cnf] = tmp_data.rstrip('\n')
			return simplejson.dumps(return_data)

	def set_server_config(self, in_data):
		port0_iface = in_data['iface']
		server_status = self.get_server_status(port0_iface)
		return_data = {}
		if server_status < 0:
			#return_data['ba_server'] = 0
			#return simplejson.dumps(return_data)
			return -1
		else:
			byp_obj = BypassBoost()
			boost_data =  BypassBoostResp()
			conf_list = ['current_state', 'default_state', 'watchdog_timeout']
			for cnf in conf_list:
				tmp = 'cmd command="bypass '+in_data['iface']+' set --'+cnf+' '+in_data[cnf]+'"'
				logging.info('Bypass setting server config : %s %s %s '%( cnf, in_data[cnf], tmp ))
				status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp)
				logging.info('Bypass setting server status : %s '%( status ))
				if status != 0:
					return status
			if in_data['watchdog_timeout'] != '0':
				# set watchdog
				tmp = 'cmd command="bypass '+in_data['iface']+' set --watchdog '+in_data['watchdog']+'"'
				logging.info('Bypass setting server conf data : watchdog %s %s '%( in_data['watchdog'], tmp ))
				status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp)
				logging.info('Bypass setting watchdog status : %s '%( status ))
				if status != 0:
					return status
		return 0

	def get_byp_redirect_config(self, in_data):
		port0_iface = self.get_port0_iface(in_data)
		if port0_iface < 0:
			return port0_iface
		server_status = self.get_server_status(port0_iface)
		return_data = {}
		if server_status < 0:
			return_data['ba_server'] = 0
			return_data['iface'] = port0_iface
			return simplejson.dumps(return_data)
		else:
			iface = '%s'%port0_iface
			return_data['ba_server'] = 1
			return_data['iface'] = iface
			byp_obj = BypassBoost()
			boost_data =  BypassBoostResp()
			total_tables = 0
			# get table list
			tmp_cmd = 'cmd command="redirect '+iface+' list"'
			logging.info('Bypass get rdt %s : 53' %tmp_cmd )
			status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp_cmd)
			byp_obj.bypass_boost_resp(boost_data)
			logging.info('Bypass rdt cmd: %s iface: %s status %s data %s '%( tmp_cmd, iface, status, boost_data.data ))
			if status != 0:
				logging.info('Bypass get rdt : 5')
				return status 
			for line in boost_data.data.split('\n'):
				logging.info('Bypass get rdt line %s : 5' %line )
				patt1 = re.compile('^(\d+)\s\((\w+)\):(.*)')
				res = patt1.match(line)
				if res:
					total_tables += 1
					tbl_name = 'table%s'%res.group(1)
					logging.info('Bypass patt matched name %s state %s ' %(tbl_name, res.group(2)) )
					return_data[tbl_name] = res.group(2)
				else:
					continue
			return_data['total_tables'] = total_tables
			logging.info('Bypass get rdt : 6')
			return simplejson.dumps(return_data)
		return 0
	def set_rdt_tbl_config(self, in_data):
		port0_iface = in_data['iface']
		server_status = self.get_server_status(port0_iface)
		return_data = {}
		if server_status < 0:
			return -1
		else:
			byp_obj = BypassBoost()
			boost_data =  BypassBoostResp()
			action = in_data['sub_action']
			tmp_cmd = 'cmd command="redirect '+in_data['iface']+' '+ action + ' --table='
			if action == 'create_table': 
				tmp_cmd += in_data['new_tbl_id']
			else:
				tmp_cmd += in_data['table_id']
			tmp_cmd += '"'	
			status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp_cmd)
			byp_obj.bypass_boost_resp(boost_data)
			logging.info('Bypass rdt cmd: %s iface: %s status %s data %s '%( tmp_cmd, in_data['iface'], status, boost_data.data ))
			return status 

	def parse_rdt_rule_list(self, in_data, table):
		rules_dict = {}
		tbl = 0
		logging.info('Bypass parse_rdt_rule_list')
		for line in in_data.split('\n'):
			logging.info('Bypass parsign rdt rules table : %s line %s '%( table, line ))
			patt1 = re.compile('^(\d+)\s\((\w+)\):\s+(.*)')
			patt2 = re.compile('^(\d+)\s+(\w+)\((.)\)\s+(.*)')
			patt3 = re.compile('^\s+(\d+)\s+(\w+)\((.)\)\s+(.*)')
			res1 = patt1.match(line)
			res3 = patt3.match(line)
			logging.info('Bypass parsign rdt rules table : %s line %s res1: %s res3 %s '%( table, line, res1, res3 ))
			if res1:
				tbl = res1.group(1)
				logging.info('-- 1 --Bypass parsign rdt rules table : %s tbl %s '%( table, tbl ))
				if tbl != table:
					continue
				tbl_status = res1.group(2)
				tbl_rule1 = res1.group(3)
				res2 = patt2.match(tbl_rule1)
				if res2:
					index = int(res2.group(1).strip())
					action = res2.group(2)
					port = res2.group(3)
					logging.info('-- 2 --Bypass parsign rdt rules table : %s tbl %s  index: %s, actiom: %s, port: %s'%( table, tbl, index, action, port ))
					rules_dict[index] = {}
					rules_dict[index]['action'] = action
					rules_dict[index]['port'] = port
					rules_dict[index]['ipv6'] = 0
					keys = res2.group(4)
					i = 0
					key_dict = {}
					key_list = keys.split(' ')
					logging.info('------------------------1')
					logging.info(key_list)
					logging.info('------------------------1')
					if key_list[0] == 'ipv6':
						rules_dict[index]['ipv6'] = 1
						i = 1
					while (i < len(key_list)-1):
						key_dict[key_list[i]] = key_list[i+1]
						i = i+2
					rules_dict[index]['keys'] = {} 
					rules_dict[index]['keys'] = key_dict
					logging.info('------------------------1')
					logging.info(key_dict)
					logging.info('------------------------1')
			elif res3:
				if tbl != table:
					continue
				index = int(res3.group(1).strip())
				action = res3.group(2)
				port = res3.group(3)
				logging.info('-- 4 --Bypass parsign rdt rules table : %s tbl %s  index: %s, actiom: %s, port: %s'%( table, tbl, index, action, port ))
				rules_dict[index] = {}
				rules_dict[index]['action'] = action
				rules_dict[index]['port'] = port
				rules_dict[index]['ipv6'] = 0
				keys = res3.group(4)
				i = 0
				key_dict = {}
				key_list = keys.split(' ')
				if key_list[0] == 'ipv6':
					rules_dict[index]['ipv6'] = 1
					i = 1
				while (i < len(key_list)-1):
					key_dict[key_list[i]] = key_list[i+1]
					i = i+2
				rules_dict[index]['keys'] = {} 
				rules_dict[index]['keys'] = key_dict
		return rules_dict
			
	def get_rdt_rules(self, in_data):
		port0_iface = self.get_port0_iface(in_data)
		if port0_iface < 0:
			return port0_iface
		server_status = self.get_server_status(port0_iface)
		return_data = {}
		if server_status < 0:
			return_data['ba_server'] = 0
			return_data['iface'] = port0_iface
			return simplejson.dumps(return_data)
		else:
			byp_obj = BypassBoost()
			boost_data =  BypassBoostResp()
			iface = '%s'%port0_iface
			return_data['ba_server'] = 1
			return_data['iface'] = iface
			tdl_id = in_data['table_id']
			tmp_cmd = 'cmd command="redirect '+iface+' list"'
			status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp_cmd)
			byp_obj.bypass_boost_resp(boost_data)
			logging.info('Bypass rdt rules cmd: %s iface: %s status %s data %s '%( tmp_cmd, iface, status, boost_data.data ))
			rules_dict = self.parse_rdt_rule_list(boost_data.data, in_data['table_id'])
			return self.generateRulesTable(rules_dict)

	def get_rdt_dump(self, in_data):
		port0_iface = self.get_port0_iface(in_data)
		if port0_iface < 0:
			return port0_iface
		server_status = self.get_server_status(port0_iface)
		return_data = {}
		if server_status < 0:
			return -1
		else:
			byp_obj = BypassBoost()
			boost_data =  BypassBoostResp()
			iface = '%s'%port0_iface
			tmp_cmd = 'cmd command="redirect '+iface+' dump"'
			status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp_cmd)
			byp_obj.bypass_boost_resp(boost_data)
			logging.info('Bypass rdt rules cmd: %s iface: %s status %s data %s '%( tmp_cmd, iface, status, boost_data.data ))
			return boost_data.data

	def generateRulesTable(self, rules_dict):
		
		html_str = ''
		return_data = {}
		height = 0
		count = 0
		return_data['is_rules'] = 'yes'
		if len(rules_dict) == 0:
			return_data['is_rules'] = 'no'
			return_data['height'] = 350
			html_str = '<div class="status_div f_bold green_f"><div class="center">( 0 ) Rules Found</div></div>'
			return_data['html'] = html_str
			return simplejson.dumps(return_data)
		
		fil_obj =  T4Filtering(self.sid, self.ip, 'desktop')
		html_str = '<ul class="horizontal head_ul">\
				<li class="rindex"><h2>Index</h2></li>\
				<li><h2>Action</h2></li>\
				<li><h2>Port</h2></li>\
				<li><h2>IPv6</h2></li>\
				<li><h2>Protocol</h2></li>\
				<li><h2>Source Address</h2></li>\
				<li><h2>Source Mask</h2></li>\
				<li><h2>Destination Address</h2></li>\
				<li><h2>Destination Mask</h2></li>\
				<li><h2>Source Port</h2></li>\
				<li><h2>Source Port Mask</h2></li>\
				<li><h2>Destination Port</h2></li>\
				<li><h2>Dest. Port Mask</h2></li>\
				<li><h2>Vlan</h2></li>\
			</ul>'
			
		sorted(rules_dict, key=rules_dict.get)
		for index in rules_dict.keys():
			height += 40
			count += 1
			unique_id = 'bypass_content__incend__%s_byp_t4_redirect_tab_ul%s'%( self.ip.replace('.','_'), count)
			html_str += '<ul class="horizontal content_tbl clear_left rules_ul rule_mod" id="%s">'%unique_id

			# create id item
			unique_parent_id = '#bypass_content__incend__%s .byp_t4_redirect_tab'%( self.ip.replace('.','_') )
			html_str  += '<li class="label rindex rindex_%s">\
				<input type="checkbox" name="rindex" class="rindex_chk" value="%s" onclick="byp_rule_index_chk(\'%s\')" />\
				<span class="value">%s</span>\
				</li>'%(index, index, unique_parent_id, index)

			# create action item
			action = rules_dict[index]['action']
			html_str += fil_obj.get_choice_editor(action, 'input#forward#drop', 'action')

			# create port item
			port = rules_dict[index]['port']
			if port == '*':
				port = 'ALL'
			html_str += fil_obj.get_choice_editor(port, '0#1#2#3', 'port')

			# create ipv6 item
			ipv6 = rules_dict[index]['ipv6']
			if ipv6:
				html_str += fil_obj.get_choice_editor('enable', 'enable#disable', 'ipv6')
			else:
				html_str += fil_obj.get_choice_editor('disable', 'enable#disable', 'ipv6')

			key_tracker = []
			logging.info('Bypass gen html index: %s len : %s '%( index, len(rules_dict[index]['keys'].keys()) ))
			if (len(rules_dict[index]['keys'].keys()) == 0):
				html_str += fil_obj.get_choice_editor('any', 'any#icmp#icmp6#tcp#udp', 'proto')
				html_str += fil_obj.get_text_editor('', 'srcaddr')
				html_str += fil_obj.get_text_editor('', 'srcmask')
				html_str += fil_obj.get_text_editor('', 'dstaddr')
				html_str += fil_obj.get_text_editor('', 'dstmask')
				html_str += fil_obj.get_number_editor('', 'srcport', '1#65355', 1)
				html_str += fil_obj.get_text_editor('', 'srcportmask')
				html_str += fil_obj.get_number_editor('', 'dstport', '1#65355', 1)
				html_str += fil_obj.get_text_editor('', 'dstportmask')
				html_str += fil_obj.get_number_editor('', 'vlan', '0#65355', 1)
			else:
				for key in rules_dict[index]['keys'].keys():
					logging.info('Bypass gen html index: %s key: %s '%( index, key ))

					if not 'proto' in key_tracker:
						proto = 'any'
						try:
							proto = rules_dict[index]['keys']['proto']
						except:
							proto = ''
						html_str += fil_obj.get_choice_editor(proto, 'any#icmp#icmp6#tcp#udp', 'proto')
						key_tracker.append('proto')

					if rules_dict[index]['ipv6']:
						if not 'srcaddr6'  in key_tracker:
							srcaddr6 = ''
							srcmask6 = ''
							try:
								srcaddr6 = rules_dict[index]['keys']['srcaddr'].split('/')[0]
								srcmask6 = rules_dict[index]['keys']['srcaddr'].split('/')[1]
							except:
								srcaddr6 = ''
								srcmask6 = ''
							html_str += fil_obj.get_text_editor(srcaddr6, 'srcaddr')
							html_str += fil_obj.get_text_editor(srcmask6, 'srcmask')
							key_tracker.append('srcaddr6')

						if not 'dstaddr6'  in key_tracker:
							dstaddr6 = ''
							dstmask6 = ''
							try:
								dstaddr6 = rules_dict[index]['keys']['dstaddr'].split('/')[0]
								dstmask6 = rules_dict[index]['keys']['dstaddr'].split('/')[1]
							except:
								dstaddr6 = ''
								dstmask6 = ''
							html_str += fil_obj.get_text_editor(dstaddr6, 'dstaddr')
							html_str += fil_obj.get_text_editor(dstmask6, 'dstmask')
							key_tracker.append('dstaddr6')
					else:
						if not 'srcaddr'  in key_tracker:
							srcaddr = ''
							srcmask = ''
							try:
								srcaddr = rules_dict[index]['keys']['srcaddr'].split('/')[0]
								srcmask = rules_dict[index]['keys']['srcaddr'].split('/')[1]
							except:
								srcaddr = ''
								srcmask = ''
							html_str += fil_obj.get_text_editor(srcaddr, 'srcaddr')
							html_str += fil_obj.get_text_editor(srcmask, 'srcmask')
							key_tracker.append('srcaddr')

						if not 'dstaddr'  in key_tracker:
							dstaddr = ''
							dstmask = ''
							try:
								dstaddr = rules_dict[index]['keys']['dstaddr'].split('/')[0]
								dstmask = rules_dict[index]['keys']['dstaddr'].split('/')[1]
							except:
								dstaddr = ''
								dstmask = ''
							html_str += fil_obj.get_text_editor(dstaddr, 'dstaddr')
							html_str += fil_obj.get_text_editor(dstmask, 'dstmask')
							key_tracker.append('dstaddr')

					if not 'srcport' in key_tracker:
						srcport = ''
						srcportmask = ''
						try:
							srcport = rules_dict[index]['keys']['srcport'].split('/')[0]
							srcportmask = rules_dict[index]['keys']['srcport'].split('/')[1]
						except:
							srcport = ''
							srcportmask = ''
						html_str += fil_obj.get_number_editor(srcport, 'srcport', '1#65355', 1)
						html_str += fil_obj.get_text_editor(srcportmask, 'srcportmask')
						key_tracker.append('srcport')

					if not 'dstport' in key_tracker:
						dstport = ''
						dstportmask = ''
						try:
							dstport = rules_dict[index]['keys']['dstport'].split('/')[0]
							dstportmask = rules_dict[index]['keys']['dstport'].split('/')[1]
						except:
							dstport = ''
							dstportmask = ''
						html_str += fil_obj.get_number_editor(dstport, 'dstport', '1#65355', 1)
						html_str += fil_obj.get_text_editor(dstportmask, 'dstportmask')
						key_tracker.append('dstport')

					if not 'vlan' in key_tracker:
						vlan = ''
						try:
							vlan = rules_dict[index]['keys']['vlan']
						except:
							vlan = ''
						html_str += fil_obj.get_number_editor(vlan, 'vlan', '0#65355', 1)
						key_tracker.append('vlan')

			html_str += '</ul>'
		return_data['height'] = height + 345
		return_data['html'] = html_str
		return simplejson.dumps(return_data)

	def get_new_rule(self, in_data):
		tbl_id = in_data['table_id']
		return_data = {} 
		html_str = ''
    		fil_obj =  T4Filtering(self.sid, self.ip, 'desktop')
		html_str = '<ul class="horizontal head_ul">\
				<li class="rindex"><h2>Index</h2></li>\
				<li><h2>Action</h2></li>\
				<li><h2>Port</h2></li>\
				<li><h2>IPv6</h2></li>\
				<li><h2>Protocol</h2></li>\
				<li><h2>Source Address</h2></li>\
				<li><h2>Source Mask</h2></li>\
				<li><h2>Destination Address</h2></li>\
				<li><h2>Destination Mask</h2></li>\
				<li><h2>Source Port</h2></li>\
				<li><h2>Source Port Mask</h2></li>\
				<li><h2>Destination Port</h2></li>\
				<li><h2>Dest. Port Mask</h2></li>\
				<li><h2>Vlan</h2></li>\
			</ul>'
            
		unique_id = 'bypass_content__incend__%s_byp_t4_redirect_tab_ul%s'%( self.ip.replace('.','_'), '1' )
		html_str += '<ul class="horizontal content_tbl clear_left rules_ul rule_add" id="%s">'%unique_id
		# create id item
		unique_parent_id = '#bypass_content__incend__%s .byp_t4_redirect_tab'%( self.ip.replace('.','_') )
		html_str  += '<li class="label rindex rindex_1">\
			<input type="checkbox" name="rindex" class="rindex_chk" value="1" onclick="byp_rule_index_chk(\'%s\')" />\
			<span class="value">1</span>\
			</li>'%(unique_parent_id)

		# create action item
		html_str += fil_obj.get_choice_editor('input', 'input#forward#drop', 'action')

		# create port item
		html_str += fil_obj.get_choice_editor('0', '0#1#2#3', 'port')

		# create ipv6 item
		html_str += fil_obj.get_choice_editor('disable', 'enable#disable', 'ipv6')

		html_str += fil_obj.get_choice_editor('any', 'any#icmp#icmp6#tcp#udp', 'proto')
		html_str += fil_obj.get_text_editor('', 'srcaddr')
		html_str += fil_obj.get_text_editor('', 'srcmask')
		html_str += fil_obj.get_text_editor('', 'dstaddr')
		html_str += fil_obj.get_text_editor('', 'dstmask')
		html_str += fil_obj.get_number_editor('', 'srcport', '1#65355', 1)
		html_str += fil_obj.get_text_editor('', 'srcportmask')
		html_str += fil_obj.get_number_editor('', 'dstport', '1#65355', 1)
		html_str += fil_obj.get_text_editor('', 'dstportmask')
		html_str += fil_obj.get_number_editor('', 'vlan', '0#65355', 1)

		return_data['html'] = html_str
		return simplejson.dumps(return_data)

	def delete_rule(self, in_data):
		tbl_id = in_data['table_id']
		rindex = in_data['rindex']
		iface = in_data['iface']
		status = 0
		index = rindex[0:len(rindex)-1]
		index_list = index.split(',')
		logging.info('Bypass rdt delete rule iface: %s index_list %s table %s '%( iface, index_list, tbl_id ))

		for i in index_list:
			#redirect eth2 delete --table 2 --index 9
			tmp_cmd = 'cmd command="redirect '+iface+' delete --table '+tbl_id+' --index '+i+'"'
			byp_obj = BypassBoost()
			status = byp_obj.bypass_execute_command(self.sid, self.ip, tmp_cmd)
			logging.info('Bypass rdt delete rule cmd: %s iface: %s status %s table %s '%( tmp_cmd, iface, status, tbl_id ))
		return status
	
	def save_rules(self, in_data):
		logging.info('Bypass rdt save rule data %s '%( in_data ))
		success = True
		byp_obj = BypassBoost()
		action = in_data['action_type']
		tbl_id = in_data['table_id']
		iface = in_data['iface']
		init_exec_cmd = 'cmd command="redirect '+iface+' '
		if action == 'add':
			init_exec_cmd += 'add --table '+tbl_id+' '
		elif action == 'modify':
			init_exec_cmd += 'update --table '+tbl_id+' '
        
		#Changing to tuple to prevent the order of the values.
		#if type(in_data['propname']) == list:
		#	in_data['propname'] = tuple(in_data['propname']) 
		#	in_data['value'] = tuple(in_data['value'])
		if int(in_data['rule_count']) > 1:
			for i in range(int(in_data['rule_count'])):
				logging.info('Bypass redirecting i: %s'%( i ))
				rindex = in_data['rindex'][i]
				exec_cmd = init_exec_cmd
				exec_cmd += '--index '+rindex+' '

				cnt_key = 'properties_count_%s'%rindex
				prop_key = 'propname_%s'%rindex
				value_key = 'value_%s'%rindex
				prop_cnt = int(in_data[cnt_key])
				logging.info('Bypass redirecting Index:%s action: %s count: %s command: %s'%( rindex, action, prop_cnt, exec_cmd ))
				if prop_cnt > 1:
					is_ipv6 = False
					for j in range(prop_cnt):
						logging.info('Bypass redirecting J: %s'%( j ))
						if in_data[prop_key][j] == 'port' and in_data[value_key][j] == 'all':
							in_data[value_key][j] = '*'
						elif in_data[prop_key][j] == 'srcaddr' and is_ipv6:
							in_data[prop_key][j] = 'srcaddr6'
						elif in_data[prop_key][j] == 'srcmask' and is_ipv6:
							in_data[prop_key][j] = 'srcmask6'
						elif in_data[prop_key][j] == 'dstmask' and is_ipv6:
							in_data[prop_key][j] = 'dstmask6'
						elif in_data[prop_key][j] == 'dstaddr' and is_ipv6:
							in_data[prop_key][j] = 'dstaddr6'
						elif in_data[prop_key][j] == 'ipv6' and in_data[value_key][j] == 'enable':
							in_data[value_key][j] = ''
							is_ipv6 = True
						elif in_data[prop_key][j] == 'ipv6' and in_data[value_key][j] == 'disable':
							continue
						logging.info('Bypass redirecting Index:%s Prop: %s Va: %s '%(rindex,  in_data[prop_key][j], in_data[value_key][j]))
						exec_cmd +=  '--'+in_data[prop_key][j]+' '+in_data[value_key][j]+' '
				else:
					is_ipv6 = False
					if in_data[prop_key] == 'port' and in_data[value_key] == 'all':
						in_data[value_key] = '*'
					elif in_data[prop_key] == 'ipv6' and in_data[value_key] == 'enable':
						in_data[value_key] = ''
					elif in_data[prop_key] == 'ipv6' and in_data[value_key] == 'disable':
						in_data[prop_key] = ''
					logging.info('Bypass redirecting Index:%s Prop: %s Va: %s '%(rindex,  in_data[prop_key], in_data[value_key]))
					if in_data[prop_key] != '':
						exec_cmd +=  '--'+str(in_data[prop_key])+' '+str(in_data[value_key])
				exec_cmd += '"'
				logging.info('Bypass rdt save rule cmd: %s '%( exec_cmd ))
				status = byp_obj.bypass_execute_command(self.sid, self.ip, exec_cmd)
				logging.info('Bypass rdt save rule cmd: %s status %s '%( exec_cmd, status ))
				if status == -2:
					return -2
				elif status != 0:
					success = False
		else:
			rindex = str(in_data['rindex'])
			exec_cmd = init_exec_cmd
			exec_cmd += '--index '+rindex+' '

			cnt_key = 'properties_count_%s'%rindex
			prop_key = 'propname_%s'%rindex
			value_key = 'value_%s'%rindex
			prop_cnt = int(in_data[cnt_key])
			logging.info('Bypass redirecting Index:%s action: %s count: %s command: %s'%( rindex, action, prop_cnt, exec_cmd ))
			if prop_cnt > 1:
				is_ipv6 = False
				for j in range(prop_cnt):
					logging.info('Bypass redirecting J: %s'%( j ))
					if in_data[prop_key][j] == 'port' and in_data[value_key][j] == 'all':
						in_data[value_key][j] = '*'
					elif in_data[prop_key][j] == 'srcaddr' and is_ipv6:
						in_data[prop_key][j] = 'srcaddr6'
					elif in_data[prop_key][j] == 'srcmask' and is_ipv6:
						in_data[prop_key][j] = 'srcmask6'
					elif in_data[prop_key][j] == 'dstmask' and is_ipv6:
						in_data[prop_key][j] = 'dstmask6'
					elif in_data[prop_key][j] == 'dstaddr' and is_ipv6:
						in_data[prop_key][j] = 'dstaddr6'
					elif in_data[prop_key][j] == 'ipv6' and in_data[value_key][j] == 'enable':
						in_data[value_key][j] = ''
						is_ipv6 = True
					elif in_data[prop_key][j] == 'ipv6' and in_data[value_key][j] == 'disable':
						continue
					logging.info('Bypass redirecting Index:%s Prop: %s Va: %s '%(rindex,  in_data[prop_key][j], in_data[value_key][j]))
					exec_cmd +=  '--'+in_data[prop_key][j]+' '+in_data[value_key][j]+' '
			else:
				if in_data[prop_key] == 'port' and in_data[value_key] == 'all':
					in_data[value_key] = '*'
				elif in_data[prop_key] == 'ipv6' and in_data[value_key] == 'enable':
					in_data[value_key] = ''
				elif in_data[prop_key] == 'ipv6' and in_data[value_key] == 'disable':
					in_data[value_key] = ''
					in_data[prop_key] = ''
				logging.info('Bypass redirecting Index:%s Prop: %s Va: %s '%(rindex,  in_data[prop_key], in_data[value_key]))
				if in_data[prop_key] != '':
					exec_cmd +=  '--'+str(in_data[prop_key])+' '+str(in_data[value_key])
			exec_cmd += '"'
			logging.info('Bypass rdt save rule cmd: %s '%( exec_cmd ))
			status = byp_obj.bypass_execute_command(self.sid, self.ip, exec_cmd)
			#Match		
			#cmd command="redirect eth6 match --table 5 --action drop"
			logging.info('Bypass rdt save rule cmd: %s status %s '%( exec_cmd, status ))
			if status == -2:
				return -2
			elif status != 0:
				success = False
			    
		if success:
			return 0
		else:
			return -1
