from UmBoostLib import bc_string, bulk_config_boost
from Constants import CONSTANTS_DICT

import settings, simplejson, utils
logging = settings.get_logger()

class BulkPortConf:
    def __init__(self, sid, req_type):
         self.sid = sid
         self.req_type = req_type
         
    def get_initial_data(self, data):
        
        self.agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        logging.info('BulkPortConf - List Group : sid : %s , int : 2'%( self.sid ))
        status = MainObj.execute_bc_command(self.sid, 2, "", self.agmtObj);
        logging.info('BulkPortConf - FList Group : status %s'%(status))
        logging.info('Full String : %s'%self.agmtObj.str)
        
        self.return_data = {}
        if status == 0:
            self.return_data['status'] = 0
            self.return_data['html'] = self.generateGroupHtml()
            return simplejson.dumps(self.return_data)
        elif status == -2:
            self.return_data['status'] = -2
            return simplejson.dumps(self.return_data)
        elif CONSTANTS_DICT.has_key(status):
            self.return_data['status'] = 6
            self.return_data['msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)
    
    def generateGroupHtml(self):
        
        temp_groups = self.agmtObj.str.split('\n')
        groups = temp_groups[:len(temp_groups)-1]
        logging.info("Groups List :%s"%groups)
        
        group_names = []
        is_gp = False
        is_memeber = 1
        for i in groups:
            if (i.split(' ')[2].strip().lower() == 't3port' or 
                i.split(' ')[2].strip().lower() == 't4port' or 
                i.split(' ')[2].strip().lower() == 't5port'):
		
                if i.split(' ')[3].strip() == '':
                   is_memeber = 0
                group_names.append('%s__%s__%s__%s'%(i.split(' ')[0], is_memeber, i.split(' ')[1], i.split(' ')[2]))
                is_gp = True
        logging.info("group_names :%s"%group_names)
        
        if not is_gp:
            self.return_data['status'] = 6
            self.return_data['msg'] = 'No groups available of type "t3port" or "t4port", t5port'
            return None
        
        html_head = "<select class='group_sel' onchange='$(this).removeClass(\"error\");blk_pc_get_props($(this));' ><option value=''>Select One..</option>%s</select>"
        option_html = "<option value='%s' ostype='%s' gptype='%s' name='%s'>%s</option>"
        html_list = [ option_html%( i.split('__')[0], i.split('__')[2], i.split('__')[3], i.split('__')[1], i.split('__')[0] ) for i in group_names ]
        return html_head%''.join(html_list)
        
    def get_props(self, data):
        
        height = ''
        status = '0'
        return_data = {}
        html_list = []
        html_list.append('<ul class="horizontal head_ul"><li class="desc"><h2>Description</h2></li><li class="range"><h2>Range</h2></li><li class="value"><h2 class="bg_none">Value</h2></li></ul>')
        if data['ostype'] == 'linux' or data['ostype'] == 'xen':
            if data['gptype'] == 't4port' or data['gptype'] == 't5port':
                height = 810
                html_list.append( utils.getTextEditor( propdesc = 'Tx checksum offload', propname = 'Txcksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Push/pull threshold for non full TX sk_buffs', propname = 'Rxcksum', value = '', range = '0 | 1' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Rx checksum offload', propname = 'Ddpthres', value = '', range = '>=0' ) )
                html_list.append( utils.getTextEditor( propdesc = 'TCP segmentation offload', propname = 'Tso', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'scatter gather', propname = 'Scattergather', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'generic segmentation offload', propname = 'GSO', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Driver debug level', propname = 'Msglevel', value = '', range = '[0,2^31-1]' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Link advertise mode', propname = 'Advertise', value = '', range = '10baset/half | 10baset/full | 100baset/half | 100baset/full |  1000baset/half | 1000baset/full | 10000baset/full' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Link advertise mode', propname = 'Advertise', value = '', range = '0 | 1 | 2 | 3 | 4 | 5 | 6' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Coalesce parameter', propname = 'Rxusecs', value = '', range = '[1,2^31-1]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for rx ring', propname = 'Ringrx', value = '', range = '[32,16384]' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Link speed and link duplex', propname = 'SpeedDuplex', value = '', range = 'auto | 10-full | 100-full | 1000-full' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Reset link params negotiation', propname = 'Resetautoneg', value = '', range = '1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for Rx mini ring', propname = 'Ringrxmini', value = '', range = '>=0' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Tx pause frame support', propname = 'Txpfsupport', value = '', range = '0|1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Rx pause frame support', propname = 'Rxpfsupport', value = '', range = '0|1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for Rx mini ring', propname = 'Ringrxmini', value = '', range = '[32,16384]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for Rx jumbo ring', propname = 'Ringrxjumbo', value = '', range = '[32,16384]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for tx ring', propname = 'Ringtx', value = '', range = '[8,16384]' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Tx and Rx pause frame auto negotiation', propname = 'Pauseautoneg', value = '', range = '0|1' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Port LED blink time in secs', propname = 'Blinksecs', value = '', range = '>=0' ) )
            
            elif data['gptype'] == 't3port':
                height = 810
                html_list.append( utils.getTextEditor( propdesc = 'Tx checksum offload', propname = 'Txcksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Push/pull threshold for non full TX sk_buffs', propname = 'Rxcksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'TCP segmentation offload', propname = 'Tso', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'scatter gather', propname = 'Scattergather', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'generic segmentation offload', propname = 'GSO', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Driver debug level', propname = 'Msglevel', value = '', range = '[0,2^31-1]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Link advertise mode', propname = 'Advertise', value = '', range = '0 | 1 | 2 | 3 | 4 | 5 | 6' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Coalesce parameter', propname = 'Rxusecs', value = '', range = '[1,2^31-1]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for rx ring', propname = 'Ringrx', value = '', range = '[32,16384]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Link speed and link duplex', propname = 'SpeedDuplex', value = '', range = 'auto | 10-full | 100-full | 1000-full' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Reset link params negotiation', propname = 'Resetautoneg', value = '', range = '1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for Rx mini ring', propname = 'Ringrxmini', value = '', range = '>=0' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Tx pause frame support', propname = 'Txpfsupport', value = '', range = '0|1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Rx pause frame support', propname = 'Rxpfsupport', value = '', range = '0|1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for Rx mini ring', propname = 'Ringrxmini', value = '', range = '[32,16384]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for Rx jumbo ring', propname = 'Ringrxjumbo', value = '', range = '[32,16384]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for tx ring', propname = 'Ringtx', value = '', range = '[8,16384]' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Tx and Rx pause frame auto negotiation', propname = 'Pauseautoneg', value = '', range = '0|1' ) )
        
        elif data['ostype'] == 'freebsd':
           if data['gptype'] == 't4port' or data['gptype'] == 't5port':
                height = 455
                html_list.append( utils.getTextEditor( propdesc = 'Tx checksum offload', propname = 'Txcksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Push/pull threshold for non full TX sk_buffs', propname = 'Rxcksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'TCP segmentation offload', propname = 'Tso', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Response Queue Size', propname = 'Qsize_rxq', value = '', range = '[128,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Transmit Queue Size', propname = 'Qsize_txq', value = '', range = '[512,2048]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Holdoff timer index', propname = 'Holdoff_tmr_idx', value = '', range = '[0,5]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Holdoff packet counter index', propname = 'Holdoff_pktc_idx', value = '', range = '[0,3]' ) )

           elif data['gptype'] == 't3port':
                height = 335
                html_list.append( utils.getTextEditor( propdesc = 'Tx checksum offload', propname = 'Txcksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Push/pull threshold for non full TX sk_buffs', propname = 'Rxcksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'TCP segmentation offload', propname = 'Tso', value = '', range = '0 | 1' ) )
               
        elif data['ostype'] == 'windows':
           if data['gptype'] == 't4port' or data['gptype'] == 't5port':
                height = 1040
                #html_list.append( utils.getTextEditor( propdesc = 'Link speed and link duplex', propname = 'SpeedDuplex', value = '', range = 'auto | 100-full | 1000-full' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|Disable LSO IP v4', propname = 'Lsoipv4', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|Disable LSO Ip v6', propname = 'Lsoipv6', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'FlowControl', propname = 'flowcontrol', value = '', range = '[0,3]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'IP CheckSum Offload', propname = 'ipchksumoffloadv4', value = '', range = '[0,3]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|Disable Virtual Machine Queue', propname = 'vmq_param', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|Disable VMQLookAheadSplit', propname = 'vmqlookaheadspilt', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|Disable VMQVLanFilter', propname = 'vmqvlanfiltering', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'TCP CheckSum Offload v4', propname = 'tcpchksumoffloadv4', value = '', range = '[0,3]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'TCP CheckSum Offload v6', propname = 'tcpchksumoffloadv6', value = '', range = '[0,3]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'UDP CheckSum Offload v4', propname = 'udpchksumoffloadv4', value = '', range = '[0,3]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'UDP CheckSum Offload v6', propname = 'udpchksumoffloadv6', value = '', range = '[0,3]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Max Number of Response Queue', propname = 't4nicrespquecnt', value = '', range = '[1,8]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'RSS load balancing profile', propname = 'rssprofile', value = '', range = '[0,4]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Response Queue Size', propname = 't4nicrespquesize', value = '', range = '[256,2048]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Transmit Queue Size', propname = 't4nictxquesize', value = '', range = '[512,2048]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Nic Tx Offload queue size', propname = 't4nictxofldquesize', value = '', range = '[256,4096]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Jumbo Packet', propname = 'jumbopacket', value = '', range = '[1500,900]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Number of RSS queues', propname = 'numrssqueues', value = '', range = '[1,8]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'NetWork Direct', propname = 'networkdirect', value = '', range = '[0,1]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'User Mode ND', propname = 'usermodend', value = '', range = '[0,1]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'ND Interrupt Moderation', propname = 'ndinterrupt', value = '', range = '[0,1]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Recv Segment Coalescing IPV4', propname = 'rcvcoalescipv4', value = '', range = '[0,1]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Recv Segment Coalescing IPV6', propname = 'rcvcoalescipv6', value = '', range = '[0,1]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable/Disable TCP offload', propname = 't4nictcpoffload', value = '', range = '0 | 1' ) )
            
           elif data['gptype'] == 't3port':
                height = 685
                html_list.append( utils.getTextEditor( propdesc = 'Tx checksum offload', propname = 'Txcksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Push/pull threshold for non full TX sk_buffs', propname = 'Rxcksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Link speed and link duplex', propname = 'SpeedDuplex', value = '', range = 'auto | 10-half | 100-half | 1000-half' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Tx pause frame support', propname = 'Txpfsupport', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Rx pause frame support', propname = 'Rxpfsupport', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of Rx queues', propname = 'Queues', value = '', range = '[1,8] 1 port card, [1,4] 2 port card, [1,2] 4 port card' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable iSCSI function', propname = 'IscsiFunc', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable iWARP function', propname = 'IwarpFunc', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable NDIS function', propname = 'NdisFunc', value = '', range = '1 | 2' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable ipv6 checksum offload', propname = 'Ipv6cksum', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Set optimization mode to performance or compatibility', propname = 'Optmode', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable large segmentation offload', propname = 'LSO', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable receive side scaling', propname = 'Rss', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Set vlan Id', propname = 'VlanId', value = '', range = '[0,4094]' ) )
                
        elif data['ostype'] == 'esx':
            if data['gptype'] == 't4port' or data['gptype'] == 't3port' or data['gptype'] == 't5port':
                height = 620
                html_list.append( utils.getTextEditor( propdesc = 'Driver debug level', propname = 'Msglevel', value = '', range = '[0,2^31-1]' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Link advertise mode', propname = 'Advertise', value = '', range = '0 | 1 | 2 | 3 | 4 | 5 | 6' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Coalesce parameter', propname = 'Rxusecs', value = '', range = '[1,2^31-1]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for rx ring', propname = 'Ringrx', value = '', range = '[32,16384]' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Link speed and link duplex', propname = 'SpeedDuplex', value = '', range = 'auto | 10-full | 100-full | 1000-full' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Reset link params negotiation', propname = 'Resetautoneg', value = '', range = '1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for Rx mini ring', propname = 'Ringrxmini', value = '', range = '[32,16384]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for Rx jumbo ring', propname = 'Ringrxjumbo', value = '', range = '[32,16384] ' ) )
                html_list.append( utils.getTextEditor( propdesc = 'No of ring entries for tx ring', propname = 'Ringtx', value = '', range = '[8,16384]' ) )
                #html_list.append( utils.getTextEditor( propdesc = 'Tx and Rx pause frame auto negotiation', propname = 'Pauseautoneg', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Tx pause frame support', propname = 'Txpfsupport', value = '', range = '0 | 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Rx pause frame support', propname = 'Rxpfsupport', value = '', range = '0 | 1' ) )
        else:
            status = -1
                
        return_data['html'] = ''.join(html_list)
        return_data['height'] = height
        return_data['status'] = status
        return return_data
    
    def set_port_props(self, data):
        
        agmtObj = bc_string()
        MainObj = bulk_config_boost()
    
        cli_cmd = "Chelsio SetPortProperty pci=BULKPCI port=BULKPORT %s -B %s"%( data['prop_str'], data['group_name'] )
        logging.info('BulkPortConf SetPortProperty: sid : %s , int : 3, cli_cmd : %s'%( self.sid, cli_cmd ))
        status = MainObj.execute_bc_command(self.sid, 3, cli_cmd, agmtObj)
        logging.info('BulkPortConf SetPortProperty: result %s'%(status))
        
        return_data = {}
        if status == -2 or status == 100:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif CONSTANTS_DICT.has_key(status):
            return_data['status'] = -6
            return_data['error_msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
