from UmBoostLib import bc_string, bulk_config_boost
from xml.dom.minidom import Document
from Constants import CONSTANTS_DICT


import settings, simplejson, re, os
logging = settings.get_logger()

class BulkOptionRom:
    def __init__(self, sid, ip) :
         self.sid = sid
         self.ip = ip
         
    def flash_rom(self, data):
        
        agmtObj = bc_string()
        MainObj = bulk_config_boost()

        matchObj = re.match( '^/', data['drpath'])
        if not matchObj:
            path_var = os.getcwd();
            data['drpath'] = '"%s\\%s"'%(path_var ,data['drpath'])
	
        cli_cmd = "chelsio FlashRom adapter=BULKADAPTER path=%s -B %s"%( data['drpath'], data['group_name'] )
        
        logging.info('BulkOptionRom - Flash Rom : sid : %s , int : 3, cli_cmd : %s'%( self.sid, cli_cmd ))
        status = MainObj.execute_bc_command(self.sid, 3, cli_cmd, agmtObj)
        logging.info('BulkOptionRom - Flash Rom: result %s'%(status))
        
        if status == 0 or status == -2 or status == 100:
            return self.generate_status(status)
        elif CONSTANTS_DICT.has_key(status):
            return self.generate_status(CONSTANTS_DICT[status])
        else:
            return self.generate_status('-1')
        
    def get_initial_data(self, data):
        
        self.agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        logging.info('BulkOptionRom - List Group : sid : %s , int : 2'%( self.sid ))
        status = MainObj.execute_bc_command(self.sid, 2, "", self.agmtObj);
        logging.info('BulkOptionRom - FList Group : status %s'%(status))
        logging.info('Full String : %s'%self.agmtObj.str)
        
        self.return_data = {}
        if status == 0:
            if self.agmtObj.str.strip() == '':
                self.return_data['status'] = 6
                self.return_data['msg'] = CONSTANTS_DICT[-3]
                return simplejson.dumps(self.return_data)
            else:
                self.return_data['status'] = 0
                self.return_data['html'] = self.generateGroupHtml()
                return simplejson.dumps(self.return_data)
        elif status == -2:
            self.return_data['status'] = -2
            return simplejson.dumps(self.return_data)
        elif CONSTANTS_DICT.has_key(status):
            self.return_data['status'] = 6
            self.return_data['msg'] = self.generate_status(CONSTANTS_DICT[status])
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)
    
    def generateGroupHtml(self):
        
        temp_groups = self.agmtObj.str.split('\n')
        groups = temp_groups[:len(temp_groups)-1]
        logging.info("Groups List :%s"%groups)
        
        group_names = []
        is_gp = False
        is_memeber = 1
        for i in groups:
            if (i.split(' ')[2].strip().lower() == 't4adapter' or
                i.split(' ')[2].strip().lower() == 't3adapter' or
                i.split(' ')[2].strip().lower() == 't5adapter'):

                if i.split(' ')[3].strip() == '':
                   is_memeber = 0
                group_names.append('%s__%s'%(i.split(' ')[0], is_memeber))
                is_gp = True
        logging.info("group_names :%s"%group_names)
        
        if not is_gp:
            self.return_data['status'] = 6
            self.return_data['msg'] = 'No groups available of type "t5adapter", "t4adapter" or "t3adapter"'
            return None
        
        html_head = "<select onchange='$(this).removeClass(\"error\")'><option value=''>Select One..</option>%s</select>"
        option_html = "<option value='%s' name='%s'>%s</option>"
        html_list = [option_html%(i.split('__')[0], i.split('__')[1], i.split('__')[0]) for i in group_names]
        return html_head%''.join(html_list)
        
    def generate_status(self, status):        
        
        doc = Document()
        uploadlickey = doc.createElement("uploadromfile")
        doc.appendChild(uploadlickey)
        
        status_node = doc.createElement("status")
        uploadlickey.appendChild(status_node)
        
        status_val = doc.createTextNode('%s'%str(status))
        status_node.appendChild(status_val)
        return doc.toprettyxml()
    
    def erase_option_rom(self, data):
        
        agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        #adapter value should be this - adapter=BULKADAPTER
        cli_cmd = "chelsio EraseRom adapter=BULKADAPTER force=1 -B %s"%( data['group_name'] )
        
        logging.info('BulkOptionRom - Erase Rom : sid : %s , int : 3, cli_cmd : %s'%( self.sid, cli_cmd ))
        status = MainObj.execute_bc_command(self.sid, 3, cli_cmd, agmtObj)
        logging.info('BulkOptionRom - Erase Rom: result %s'%(status))
        
        return_data = {}
        if status == -2 or status == 100:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif CONSTANTS_DICT.has_key(status):
            return_data['status'] = -6
            return_data['error_msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
        
    def set_default_settings(self, data):
        
        agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        #adapter value should be this - adapter=BULKADAPTER
        cli_cmd = "chelsio Defaultconfig adapter=BULKADAPTER force=1 -B %s"%( data['group_name'] )
        
        logging.info('BulkOptionRom - Defaultconfig : sid : %s , int : 3, cli_cmd : %s'%( self.sid, cli_cmd ))
        status = MainObj.execute_bc_command(self.sid, 3, cli_cmd, agmtObj)
        logging.info('BulkOptionRom - Defaultconfig: result %s'%(status))
        
        return_data = {}
        if status == -2 or status == 100:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif CONSTANTS_DICT.has_key(status):
            return_data['status'] = -6
            return_data['error_msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
