from UmBoostLib import FavouriteList,UMFavouriteList, ConnectToUmServer 
import settings
import logging, time
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class BulkDriverInstall:
    def __init__(self, sid, ip):
        self.sid = sid
        self.ip = ip

    def get_bookmarks(self):
        self.bookmark = FavouriteList()
        self.bookmarks = UMFavouriteList()
        logging.info('Bulk Driver Install Get BookmarkList - Waiting for Boost - sid :%s'%self.sid)
        status = self.bookmarks.getFavouriteUmServers(self.bookmark,self.sid)
        logging.info('Bulk Driver Install Get Result, Status : %s'%status)
        
        if  status == 0:
            return self.generateHTML()
        elif status == -2:
            return -2
        else :
            return -1

    def getItems(self):
        for i in range(0,len(self.bookmark)):
            yield self.bookmarks.getitem(self.bookmark,i)

    def generateHTML(self):
        html_list = []
        for i in self.getItems():
            html = '<li class="%s as_hide" onclick="bk_dr_select_system($(this))"><span class="ip">%s </span>\
                    &nbsp;&nbsp;-&nbsp;&nbsp;<span class="hostname">%s</span>\
                    </li>'
            if not i.ConnectionStatus and i.UmPasswd:
                html_list.append( html%( i.OsName.lower() ,  i.hostip , i.hostName ) )
    
        html = ''.join(html_list)
        return html
    
    def install_driver(self,data):
        self.boostDriverInstallObj = ConnectToUmServer()
        
        if data['drType'].strip() == 'um':
            data['cardtype'] = '2'
        
        logging.info('Bulk Driver Install:  waiting for response from UMboost sid : %s , Server List : %s , cardType : %s, osType : %s, drType : %s, drpath : %s, iscsipath : %s, ofedpath : %s, ofedpkg : %s, conftype : %s\
                '%(self.sid, self.ip, data['cardtype'], data['ostype'], data['drType'], data['drpath'], data['iscsipath'], data['ofedpath'], data['ofedpkg'], data['conftype'] ))
        status = self.boostDriverInstallObj.BulkDriverInstallation(self.sid, self.ip, int(data['cardtype']), int(data['ostype']), data['drType'], data['drpath'], data['iscsipath'], data['ofedpath'], data['ofedpkg'],  data['conftype'])
        logging.info('Bulk Driver Install status: %s'%status)
        
        if status == 0:
            
            ip_list = self.ip.split(',')
            ip_list_status = self.boostDriverInstallObj.insStatus.split(',')
            poll_server_list = []
            result = {}
            atleast_one_sucess = False
            i = 0
            for ip_i in ip_list:
                if ip_list_status[i] == '0':
                    atleast_one_sucess = True
                    poll_server_list.append(ip_i)
                else:
                     result[ip_i] = 'Failed'
                i += 1
            
            if not atleast_one_sucess:
                result['status'] = 0
                return result
            
            poll_server_str = ','.join(poll_server_list)
            
            logging.info('Bulk Driver Poll:  waiting for response from UMboost sid : %s , ServerList : %s , drType : %s\
                '%(self.sid, poll_server_str, data['drType'] ))
            
            do_poll = True
            #time.sleep(20);
            while do_poll:
                status = self.boostDriverInstallObj.pollBulkDriverInstallResult(self.sid, poll_server_str, data['drType'])
                
                if status == 0:
                    pass
                else:
                    break
                
                poll_ip_status = self.boostDriverInstallObj.insStatus.split(',')
                temp_poll_ip =  poll_server_str.split(',')
                next_poll_server = []
                i = 0
                for ip in temp_poll_ip:
                    if poll_ip_status[i] == '0':
                        logging.info('Success ------------------------------------------------------------------ip : %s'%ip)
                        result[ip] = 'Success'
                    elif poll_ip_status[i] == '100' or poll_ip_status[i] == '101':
                        logging.info('Repoll-------ip : %s'%ip)
                        next_poll_server.append(ip)
                        i += 1
                        continue
                    else:
                        logging.info('Failed---------------------------------------------------------------------ip : %s'%ip)
                        result[ip] = 'Failed'
                    i += 1
                
                logging.info('-------------next_poll_server length: %s'%len(next_poll_server))
                if not len(next_poll_server):
                    do_poll = False
                    result['status'] = status = 0
                else:
                    poll_server_str = ','.join(next_poll_server)
                    logging.info('-------------next_poll_server string: %s'%poll_server_str)
		time.sleep(4);
        
        if status == -2 or status == 50:
            return { 'status' : status }
        elif status == 0:
            return result
        else:
            return { 'status' : -1 }
