from UmBoostLib import bc_string, bulk_config_boost
from Constants import CONSTANTS_DICT

import settings, simplejson, utils
logging = settings.get_logger()

class BulkCardConf:
    def __init__(self, sid, req_type) :
         self.sid = sid
         self.req_type = req_type
         
    def get_initial_data(self, data):
        
        self.agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        logging.info('BulkCardConf - List Group : sid : %s , int : 2'%( self.sid ))
        status = MainObj.execute_bc_command(self.sid, 2, "", self.agmtObj);
        logging.info('BulkCardConf - FList Group : status %s'%(status))
        logging.info('Full String : %s'%self.agmtObj.str)
        
        self.return_data = {}
        if status == 0:
            self.return_data['status'] = 0
            self.return_data['html'] = self.generateGroupHtml()
            return simplejson.dumps(self.return_data)
        elif status == -2:
            self.return_data['status'] = -2
            return simplejson.dumps(self.return_data)
        elif CONSTANTS_DICT.has_key(status):
            self.return_data['status'] = 6
            self.return_data['msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)
    
    def generateGroupHtml(self):
        
        temp_groups = self.agmtObj.str.split('\n')
        groups = temp_groups[:len(temp_groups)-1]
        logging.info("Groups List :%s"%groups)
        
        group_names = []
        is_gp = False
        is_memeber = 1
        for i in groups:
            if (i.split(' ')[2].strip().lower() == 't4adapter' or 
                i.split(' ')[2].strip().lower() == 't3adapter' or
                i.split(' ')[2].strip().lower() == 't5adapter'):

                if i.split(' ')[3].strip() == '':
                   is_memeber = 0
                group_names.append('%s__%s__%s__%s'%(i.split(' ')[0], is_memeber, i.split(' ')[1], i.split(' ')[2]))
                is_gp = True
        logging.info("group_names :%s"%group_names)
        
        if not is_gp:
            self.return_data['status'] = 6
            self.return_data['msg'] = 'No groups available of type "t3adapter" or "t4adapter" or "t5adapter" '
            return None
        
        html_head = "<select class='group_sel' onchange='$(this).removeClass(\"error\");blk_cc_get_props($(this));' ><option value=''>Select One..</option>%s</select>"
        option_html = "<option value='%s' ostype='%s' gptype='%s' name='%s'>%s</option>"
        html_list = [ option_html%( i.split('__')[0], i.split('__')[2], i.split('__')[3], i.split('__')[1], i.split('__')[0] ) for i in group_names ]
        return html_head%''.join(html_list)
        
    def get_props(self, data):
        
        height = ''
        status = '0'
        return_data = {}
        html_list = []
        html_list.append('<ul class="horizontal head_ul"><li class="desc"><h2>Description</h2></li><li class="range"><h2>Range</h2><li class="value"><h2 class="bg_none">Value</h2></li></ul>')
        if data['ostype'] == 'linux':
            if data['gptype'] == 't4adapter' or  data['gptype'] == 't5adapter':
                height = 874
                html_list.append( utils.getTextEditor( propdesc = 'Maximun host RAM consumed by send buffer', propname = 'Maxhostsndbuf', value = '', range = '>=0' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Push/pull threshold for non full TX sk_buffs', propname = 'Txholdthres', value = '', range = '>=0' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Minimun recv msg size before activating ddp', propname = 'Ddpthres', value = '', range = '[0,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable or disable recv coalescing ', propname = 'Ddprcvcoalesce', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Failover algorithm', propname = 'failover_alg', value = '', range = '[-1,3]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Max TX_DATA write payload size', propname = 'Mss', value = '', range = '[1,2^20]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Delayed ACK control', propname = 'Delack', value = '', range = '[0,3]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Max offloaded connections', propname = 'Maxconn', value = '', range = '[-1,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable listen backlog limit', propname = 'Softbackloglimit', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Bytes copied in sendmsg zcopy', propname = 'Zcopycopy', value = '', range = '[MIN,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Put new connections in ddp mode', propname = 'Ddp', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Return while DMA is pending', propname = 'Zcopypendingdma', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Push/pull threshold for non full TX sk_buffs', propname = 'Rxcreditthres', value = '', range = '>=1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Bytes copied in partial zcopy', propname = 'Zcopypartialcopy', value = '', range = '[MIN,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Min value for sendmsg partial zcopy', propname = 'Zcopypartialthres', value = '', range = '[MIN,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Min value for send msg zcopy', propname = 'Zcopythres', value = '', range = '[MIN,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable blocking ddp wait for PSH flag  ', propname = 'Ddppushwait', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'TOE engine activation state', propname = 'Activated', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'COP Managed offload Enabled', propname = 'cop_managed_offloading', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Allow kernel buffers for ddp', propname = 'Ksegddp', value = '', range = '0 or 1' ) )
            
            elif data['gptype'] == 't3adapter':
                height = 874
                html_list.append( utils.getTextEditor( propdesc = 'Maximun host RAM consumed by send buffer', propname = 'Maxhostsndbuf', value = '', range = '>=0' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Push/pull threshold for non full TX sk_buffs', propname = 'Txholdthres', value = '', range = '>=0' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Minimun recv msg size before activating ddp', propname = 'Ddpthres', value = '', range = '[0,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable or disable recv coalescing ', propname = 'Ddprcvcoalesce', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Max TX_DATA write payload size', propname = 'Mss', value = '', range = '[1,2^20]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Delayed ACK control', propname = 'Delack', value = '', range = '[0,3]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Max offloaded connections', propname = 'Maxconn', value = '', range = '[-1,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable listen backlog limit', propname = 'Softbackloglimit', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Bytes copied in sendmsg zcopy', propname = 'Zcopycopy', value = '', range = '[MIN,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Max outstanding writes per connection', propname = 'Maxwrs', value = '', range = '[3,variable]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Put new connections in ddp mode', propname = 'Ddp', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Return while DMA is pending', propname = 'Zcopypendingdma', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Push/pull threshold for non full TX sk_buffs', propname = 'Rxcreditthres', value = '', range = '>=1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Bytes copied in partial zcopy', propname = 'Zcopypartialcopy', value = '', range = '[MIN,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Min value for sendmsg partial zcopy', propname = 'Zcopypartialthres', value = '', range = '[MIN,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Min value for send msg zcopy', propname = 'Zcopythres', value = '', range = '[MIN,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Enable|disable blocking ddp wait for PSH flag  ', propname = 'Ddppushwait', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'TOE engine activation state', propname = 'Activated', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'COP Managed offload Enabled', propname = 'cop_managed_offloading', value = '', range = '0 or 1' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Allow kernel buffers for ddp', propname = 'Ksegddp', value = '', range = '0 or 1' ) )
        
        elif data['ostype'] == 'xen':
                status = '-6'
                return_data['error_msg'] = 'Setting of card properties for Xen agent is not supported'
        
        elif data['ostype'] == 'freebsd':
           if data['gptype'] == 't4adapter' or data['gptype'] == 't5adapter':
	
                height = 365
                html_list.append( utils.getTextEditor( propdesc = 'Maximun host RAM consumed by send buffer', propname = 'Maxhostsndbuf', value = '', range = '>=0' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Minimun recv msg size before activating ddp', propname = 'Ddpthres', value = '', range = '[0,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'DDP Max indicate size allowed', propname = 'Ddpindsz', value = '', range = '[0,MAX]' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Put new connections in ddp mode', propname = 'Ddp', value = '', range = '0 or 1' ) )
            
           elif data['gptype'] == 't3adapter':
               status = '-6'
               return_data['error_msg'] = 'Setting of T3 card properties for freebsd agent is not supported'
               
        elif data['ostype'] == 'windows':
           if data['gptype'] == 't4adapter' or  data['gptype'] == 't5adapter':
                height = 265
                html_list.append( utils.getTextEditor( propdesc = 'Max VMQ', propname = 'MaxVmQueues', value = '', range = '[0,16]' ) )
            
           elif data['gptype'] == 't3adapter':
                height = 395
                html_list.append( utils.getTextEditor( propdesc = 'Rx queue size for jumbo', propname = 'Jumboqsize', value = '', range = '[128,4096] step 128' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Rx queue size for std 1500B frames', propname = 'Regqsize', value = '', range = '[128,4096]  step 128' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Tx que queue', propname = 'Toectrlqsize', value = '', range = '[128,4096] step 128' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Tx que queue', propname = 'Toeqsize', value = '', range = '[128,4096] step 128' ) )
                html_list.append( utils.getTextEditor( propdesc = 'Tx que', propname = 'Tunqsize', value = '', range = '[128,4096] step 128' ) )
        
        return_data['html'] = ''.join(html_list)
        return_data['height'] = height
        return_data['status'] = status
        return return_data
    
    def set_card_props(self, data):
        
        agmtObj = bc_string()
        MainObj = bulk_config_boost()
    
        cli_cmd = "Chelsio SetCardProperty pci=BULKPCI %s -B %s"%( data['prop_str'], data['group_name'] )
        logging.info('BulkcardConf SetCardProperty: sid : %s , int : 3, cli_cmd : %s'%( self.sid, cli_cmd ))
        status = MainObj.execute_bc_command(self.sid, 3, cli_cmd, agmtObj)
        logging.info('BulkcardConf SetCardProperty: result %s'%(status))
        
        return_data = {}
        if status == -2 or status == 100:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif CONSTANTS_DICT.has_key(status):
            return_data['status'] = -6
            return_data['error_msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
