from fcoeutils import BootUtils, T3BootProperties, T4BootProperties
from UmBoostLib import KList
from xml.dom.minidom import Document
import simplejson
import settings, utils, UmBoostLib
from FcoeFile import Fcoe
logging = settings.get_logger()

class Boot:
    def __init__(self, sid, ip) :
         self.sid = sid
         self.ip = ip

    #iSCSI
    def flash_rom(self, data):
        boot_boost_obj = BootUtils( self.sid, self.ip )
        logging.info('Boot Flash Rom :waiting for response from UMboost sid : %s , IP : %s, username : %s, card_index : %s, fname : %s'%(
                                                                                            self.sid, self.ip, data['username'], data['card_index'], data['fname'] ))
        status = boot_boost_obj.flashROM( data['username'], data['card_index'], data['fname'] )
        logging.info('Boot Flash Rom Status: result %s'%(status))
        return self.generate_status(status)
    
    def generate_status(self, status):        
        
        doc = Document()
        uploadlickey = doc.createElement("uploadromfile")
        doc.appendChild(uploadlickey)
        
        status_node = doc.createElement("status")
        uploadlickey.appendChild(status_node)
        
        status_val = doc.createTextNode('%s'%str(status))
        status_node.appendChild(status_val)
        return doc.toprettyxml()
    
    def erase_rom(self, index):
        
        boot_boost_obj = BootUtils( self.sid, self.ip )
        logging.info('Boot Erase iSCSI Option Rom :waiting for response from UMboost sid : %s , IP : %s, index : %s , bForce : true'%( self.sid, self.ip, index ))
        status = boot_boost_obj.eraseROM( index, 'true' )
        logging.info('Boot Erase iSCSI Option Rom with bforce true Status: result %s'%(status))
        if status == -2 or status == 0:
            return status
        else:
            return -1
        
    def erase_settings(self, index):
        
        boot_boost_obj = BootUtils( self.sid, self.ip )
        logging.info('Boot Erase iSCSI boot settings :waiting for response from UMboost sid : %s , IP : %s, index : %s , bForce : true'%( self.sid, self.ip, index ))
        status = boot_boost_obj.eraseSettings( index, 'true' )
        logging.info('Boot Erase iSCSI boot settings with bforce true Status: result %s'%(status))
        if status == -2 or status == 0:
            return status
        else:
            return -1
            
    def get_data(self, data):
        
        return_data = {}
        return_data['is_valid_rom'] = 1
        return_data['is_settings'] = 1
        return_data['version'] = ''
        
        html = self.get_boot_settings(data['index'])
        if html == -2 or html == -1:
            return html
        
        if html == 10:
            return_data['is_valid_rom'] = 0
            return_data['is_settings'] = 0
        else:
            return_data['version'] = "[ %s ]"%self.boost_agmt_obj.scsiOptionROMVersion.val 
        
        return_data['html'] = html
        
        return simplejson.dumps(return_data)
        
    def get_boot_settings(self, index):
        
        logging.info('Boot T3 Properties : waiting for response from UMboost sid : %s, ip : %s, index : %s'%( self.sid, self.ip, index ))
        self.boost_agmt_obj = T3BootProperties()
        self.boot_boost_obj = BootUtils( self.sid, self.ip )
        status = self.boot_boost_obj.getT3BootProperties(str(index), self.boost_agmt_obj)
        #status = -2
        logging.info('Boot T3 Properties : waiting for response from UMboost status : %s'%status)
        
        if status == 0:
            return self.generate_settings_html()
        elif status == -2 or status == 10:
            return status
        else:
            return -1
    
    def generate_settings_html(self):
        
        head_html = '<ul class="horizontal head_ul">\
                     <li class="desc"><h2>Description</h2></li>\
                     <li class="value"><h2 class="bg_none" >Value</h2></li>\
                     </ul>'
        html_list = []
        
        logging.info("-----------T3 Property Logs Begins")
        #isBiosEnabled - Boolean editor
        html_list.append( utils.get_boolean_editor( 'Card is enabled for iSCSI boot', self.boost_agmt_obj.isBiosEnabled.propname, self.boost_agmt_obj.isBiosEnabled.val) )
        logging.info("sBiosEnabled.val : %s"%self.boost_agmt_obj.isBiosEnabled.val)

        #isChelsioOSInitiator - Boolean editor
        html_list.append( utils.get_boolean_editor( 'Chelsio OS initiator is used for boot', self.boost_agmt_obj.isChelsioOSInitiator.propname, self.boost_agmt_obj.isChelsioOSInitiator.val) )
        logging.info("sChelsioOSInitiator.val : %s"%self.boost_agmt_obj.isChelsioOSInitiator.val)         
            
        #initiatorName - text editor
        html_list.append( utils.get_text_editor( 'Boot initiator IQN name', self.boost_agmt_obj.initiatorName.propname, self.boost_agmt_obj.initiatorName.val) )
        logging.info("nitiatorName.val : %s"%self.boost_agmt_obj.initiatorName.val)
        
        #isHeaderDigestEnabled  - Boolean editor
        html_list.append( utils.get_boolean_editor( 'Prefer header digests if available', self.boost_agmt_obj.isHeaderDigestEnabled.propname, self.boost_agmt_obj.isHeaderDigestEnabled.val) )
        logging.info("sHeaderDigestEnabled.val : %s"%self.boost_agmt_obj.isHeaderDigestEnabled.val)
        
        #isDataDigestEnabled  - Boolean editor
        html_list.append( utils.get_boolean_editor( 'Prefer data digests if available', self.boost_agmt_obj.isDataDigestEnabled.propname, self.boost_agmt_obj.isDataDigestEnabled.val) )
        logging.info("sDataDigestEnabled.val : %s"%self.boost_agmt_obj.isDataDigestEnabled.val)
        
        #initiatorCHAPAuthenticationType  - choice editor
        html_list.append( utils.get_choice_editor( 'CHAP authentication Policy', self.boost_agmt_obj.initiatorCHAPAuthenticationType.propname, self.boost_agmt_obj.initiatorCHAPAuthenticationType.val, 'none#oneway#mutual') )
        logging.info("nitiatorCHAPAuthenticationType.val : %s"%self.boost_agmt_obj.initiatorCHAPAuthenticationType.val)
            
        #initiatorCHAPuser  - readonly editor
        html_list.append( utils.get_text_editor("Initiator's CHAP username", self.boost_agmt_obj.initiatorCHAPuser.propname, self.boost_agmt_obj.initiatorCHAPuser.val) )
        logging.info("nitiatorCHAPuser.val : %s"%self.boost_agmt_obj.initiatorCHAPuser.val)
        
        #initiatorCHAPsecret  - readonly editor
        html_list.append( utils.get_text_editor("Initiator's CHAP secret", self.boost_agmt_obj.initiatorCHAPsecret.propname, self.boost_agmt_obj.initiatorCHAPsecret.val) )
        logging.info("nitiatorCHAPsecret.val : %s"%self.boost_agmt_obj.initiatorCHAPsecret.val)
        
        #ipAddressType  - choice editor
        html_list.append( utils.get_choice_editor( 'IP Address Type', self.boost_agmt_obj.ipAddressType.propname, self.boost_agmt_obj.ipAddressType.val, 'dhcp#static') )
        logging.info("pAddressType.val : %s"%self.boost_agmt_obj.ipAddressType.val)
        
        #ipAddress  - readonly editor
        html_list.append( utils.get_readonly_editor( 'Static IP Address', self.boost_agmt_obj.ipAddress.val.strip() ) )
        logging.info("pAddress.val : %s"%self.boost_agmt_obj.ipAddress.val.strip())
        
        #subnetmask  - readonly editor
        html_list.append( utils.get_readonly_editor( 'Static netmask', self.boost_agmt_obj.subnetmask.val.strip() ) )
        logging.info("subnetmask.val : %s"%self.boost_agmt_obj.subnetmask.val.strip())
        
        #gateway  - readonly editor
        html_list.append( utils.get_readonly_editor( 'Static IP gateway', self.boost_agmt_obj.gateway.val.strip() ) )
        logging.info("gateway.val : %s"%self.boost_agmt_obj.gateway.val.strip())
        
        #vlanId  - number editor
        html_list.append( utils.get_number_editor('VLAN ID ( 1 - 4095 ) 0 to disable', 'vlanId', '0#4094', 1, self.boost_agmt_obj.vlanId.val) )
        logging.info("vlanId.val : %s"%self.boost_agmt_obj.vlanId.val)
        
        #preferredPort  - choice editor
        html_list.append( utils.get_choice_editor( 'Preferred Ethernet Port of the card', self.boost_agmt_obj.preferredPort.propname, self.boost_agmt_obj.preferredPort.val, '0#1#any') )
        logging.info("preferredPort.val : %s"%self.boost_agmt_obj.preferredPort.val)
        
        #targetViaDHCPStatus  - Boolean editor
        html_list.append( utils.get_boolean_editor( 'Obtain target parameters via DHCP (RFC 4173)', self.boost_agmt_obj.targetViaDHCPStatus.propname, self.boost_agmt_obj.targetViaDHCPStatus.val) )
        logging.info("targetViaDHCPStatus.val : %s"%self.boost_agmt_obj.targetViaDHCPStatus.val)
        
        #targetName - text editor
        html_list.append( utils.get_text_editor( 'Boot target IQN name', self.boost_agmt_obj.targetName.propname, self.boost_agmt_obj.targetName.val) )
        logging.info("targetName.val : %s"%self.boost_agmt_obj.targetName.val)
        
        #preferredPortalGroup - number editor
        html_list.append( utils.get_number_editor('Preferred Boot Target Portal Group', self.boost_agmt_obj.preferredPortalGroup.propname, '1#2', 1, self.boost_agmt_obj.preferredPortalGroup.val) )
        logging.info("preferredPortalGroup.val : %s"%self.boost_agmt_obj.preferredPortalGroup.val)
        
        #targetPortalIPAddress #1 - text editor
        html_list.append( utils.get_text_editor( 'Boot target portal #1 IP address', self.boost_agmt_obj.portal1.propname, self.boost_agmt_obj.portal1.val.IPAddress) )
        logging.info("portal1.val.IPAddress : %s"%self.boost_agmt_obj.portal1.val.IPAddress)
        
        #targetPortalTCPPort #1 - number editor
        html_list.append( utils.get_number_editor('Boot target portal #1 TCP port', self.boost_agmt_obj.portal1.propname, '1#65535', 1, self.boost_agmt_obj.portal1.val.TCPPort) )
        logging.info("portal1.val.TCPPort : %s"%self.boost_agmt_obj.portal1.val.TCPPort)
        
        #targetPortalTCPPort #2 - number editor
        html_list.append( utils.get_text_editor( 'Boot target portal #2 IP address', self.boost_agmt_obj.portal2.propname, self.boost_agmt_obj.portal2.val.IPAddress) )
        logging.info("portal2.val.IPAddress : %s"%self.boost_agmt_obj.portal2.val.IPAddress)
        
        #targetPortalTCPPort #2 - number editor
        html_list.append( utils.get_number_editor('Boot target portal #2 TCP port', self.boost_agmt_obj.portal2.propname, '1#65535', 1, self.boost_agmt_obj.portal2.val.TCPPort) )
        logging.info("portal2.val.TCPPort : %s"%self.boost_agmt_obj.portal2.val.TCPPort)
        
        #targetBootLun - number editor
        html_list.append( utils.get_number_editor('Target lun to use for booting the system', self.boost_agmt_obj.targetBootLun.propname, '0#7', 1, self.boost_agmt_obj.targetBootLun.val) )
        logging.info("targetBootLun.val : %s"%self.boost_agmt_obj.targetBootLun.val)
        
        #targetCHAPUserName  - readonly editor
        html_list.append( utils.get_text_editor( 'Target CHAP username', self.boost_agmt_obj.targetCHAPUserName.propname, self.boost_agmt_obj.targetCHAPUserName.val ) )
        logging.info("targetCHAPUserName.val : %s"%self.boost_agmt_obj.targetCHAPUserName.val)
        
        #targetCHAPSecret  - readonly editor
        html_list.append( utils.get_text_editor( 'Target CHAP password', self.boost_agmt_obj.targetCHAPSecret.propname, self.boost_agmt_obj.targetCHAPSecret.val ) )
        logging.info("targetCHAPSecret.val : %s"%self.boost_agmt_obj.targetCHAPSecret.val)
        logging.info("-----------T3 Property Logs Ends")
        
        html = ''.join(html_list)
        return head_html + html
    
    def set_boot_settings(self,kwargs):
        
        boostSetPropertyObj = KList()
        success = True
        
        logging.info('Boot - iSCSI Boot Option Rom Settings Umkey - adapater :%s '%( kwargs['card_index'] ))
        adapaterkey = UmBoostLib.UMKey('adapter', kwargs['card_index'])
        boostSetPropertyObj.append(adapaterkey)
        
        if int(kwargs['properties_count']) > 1:
            for i in range(int(kwargs['properties_count'])):
                logging.info('Boot - iSCSI Boot Settings Umkey - propname :%s , value : %s '%( kwargs['propname'][i], kwargs['value'][i] ))
                prop_key = UmBoostLib.UMKey(kwargs['propname'][i],kwargs['value'][i])
                boostSetPropertyObj.append(prop_key)
        else:
            logging.info('Boot - iSCSI Boot Settings Umkey - propname :%s , value : %s '%( kwargs['propname'], kwargs['value']))
            prop_key = UmBoostLib.UMKey(kwargs['propname'],kwargs['value'])
            boostSetPropertyObj.append(prop_key)
        
        logging.info('Boot Set iSCSI Boot Properties - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                     '%(self.sid,self.ip, kwargs['ostype']))
        status = boostSetPropertyObj.setProperty(self.sid, self.ip, 6, int(kwargs['ostype']))
        logging.info('Boot Set iSCSI Boot Properties Status : %s'%status)
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1

    #T4        
    def get_t4_data(self, data):
        logging.info('Boot T4 Option Rom Validity : waiting for response from UMboost sid : %s, ip : %s, index : %s'%( self.sid, self.ip, data['index'] ))
        self.boost_agmt_obj = T4BootProperties()
        self.boot_boost_obj = BootUtils( self.sid, self.ip )
        status = self.boot_boost_obj.getT4BootProperties(str(data['index']), self.boost_agmt_obj)
        logging.info('Boot T4 Option Rom Validity status : %s'%status)
        
        if status == 0 or status == 10 :
            data = {}
            if self.boost_agmt_obj.optionROMValidity.val:
                data['is_installed'] = self.boost_agmt_obj.optionROMValidity.val 
                data['version'] = self.boost_agmt_obj.biosVersion.val
                #data['cfg_version'] = self.boost_agmt_obj.configType.val
            else: 
                data['is_installed'] = 0 
                data['version'] = ''
            return simplejson.dumps(data)
        elif status == -2:
            return status
        else:
            return -1   
    
    def flash_t4rom(self, data):
        boot_boost_obj = BootUtils( self.sid, self.ip )
        logging.info('Boot Flash T4 Rom :waiting for response from UMboost sid : %s , IP : %s, username : %s, card_index : %s, fname : %s'%(
                                                                                            self.sid, self.ip, data['username'], data['card_index'], data['fname'] ))
        status = boot_boost_obj.flashROM( data['username'], data['card_index'], data['fname'] )
        #status = 0
        logging.info('Boot Flash T4 Rom Status: result %s'%(status))
        return self.generate_status(status)
    
    def generate_status(self, status):        
        
        doc = Document()
        uploadlickey = doc.createElement("uploadromfile")
        doc.appendChild(uploadlickey)
        
        status_node = doc.createElement("status")
        uploadlickey.appendChild(status_node)
        
        status_val = doc.createTextNode('%s'%str(status))
        status_node.appendChild(status_val)
        return doc.toprettyxml()
    
    def erase_t4rom(self, index):
        
        boot_boost_obj = BootUtils( self.sid, self.ip )
        logging.info('Boot Erase T4 Option Rom :waiting for response from UMboost sid : %s , IP : %s, index : %s , bForce : true'%( self.sid, self.ip, index ))
        status = boot_boost_obj.eraseROM( index, 'true' )
        #status = 0
        logging.info('Boot Erase T4 Option Rom with bforce true Status: result %s'%(status))
        if status == -2 or status == 0:
            return status
        else:
            return -1

    def get_t4_conf_data(self, data):
        
        logging.info('Boot T4 Properties : waiting for response from UMboost sid : %s, ip : %s, index : %s'%( self.sid, self.ip, data['index'] ))
        self.boost_agmt_obj = T4BootProperties()
        self.boot_boost_obj = BootUtils( self.sid, self.ip )
        status = self.boot_boost_obj.getT4BootProperties(str(data['index']), self.boost_agmt_obj)
        logging.info('Boot T4 Properties : waiting for response from UMboost status : %s'%status)
        
        if status == 0:
            return self.generate_t4_props_html()
        elif status == -2 or status == 10:
            return status
        else:
            return -1        
        
    def generate_t4_props_html(self):
        
        return_data = {}
        #Adapter Configuration
        logging.info(self.boost_agmt_obj.biosStatus.val)
        return_data['biosStatus'] = self.boost_agmt_obj.biosStatus.val
        return_data['biosStatus_propname'] = self.boost_agmt_obj.biosStatus.propname
        return_data['mode'] = self.boost_agmt_obj.mode.val
        return_data['mode_propname'] = self.boost_agmt_obj.mode.propname
        return_data['ebda'] = self.boost_agmt_obj.ebda.val
        return_data['ebda_propname'] = self.boost_agmt_obj.ebda.propname
        
        logging.info("biosVersion : %s"%self.boost_agmt_obj.biosVersion.val)
        logging.info("pciId : %s"%self.boost_agmt_obj.pciId.val)
        return_data['biosVersion'] = self.boost_agmt_obj.biosVersion.val
        return_data['devid'] = self.boost_agmt_obj.pciId.val.split(':')[1]
        
        return_data['edd'] = self.boost_agmt_obj.edd.val
        return_data['edd_propname'] = self.boost_agmt_obj.edd.propname
        return_data['pcibus'] = self.boost_agmt_obj.bus.val
        return_data['dev'] = self.boost_agmt_obj.dev.val
        return_data['fw'] = self.boost_agmt_obj.biosVersion.val
        return_data['init_platform'] = self.boost_agmt_obj.initailizationPlatform.val
        
        return_data['mac'] = self.boost_agmt_obj.macAddress.val
        return_data['ctrl_name'] = self.boost_agmt_obj.model.val.strip()
        
        #PXE Configuration
        return_data['target'] = str(self.boost_agmt_obj.wwpn[0].val)
        return_data['target_propname'] = str(self.boost_agmt_obj.wwpn[0].propname)
        return_data['lun'] = str(self.boost_agmt_obj.lun[0].val)
        return_data['lun_propname'] = str(self.boost_agmt_obj.lun[0].propname)
        for i in range(0,4):
            return_data['pxeBIOS_%s'%i] = self.boost_agmt_obj.pxeBIOS[i].val
            return_data['pxeBIOS_propname%s'%i] = self.boost_agmt_obj.pxeBIOS[i].propname
            #return_data['pxeIPv6_%s'%i] = self.boost_agmt_obj.pxeIPv6[i].val
            #return_data['pxeIPv6_propname%s'%i] = self.boost_agmt_obj.pxeIPv6[i].propname
            #return_data['pxeVlan_%s'%i] = self.boost_agmt_obj.pxeVlan[i].val
            #return_data['pxeVlan_propname%s'%i] = self.boost_agmt_obj.pxeVlan[i].propname
            return_data['pxeVlanId%s'%i] = self.boost_agmt_obj.pxeVlanId[i].val
            return_data['pxeVlanId_propname%s'%i] = self.boost_agmt_obj.pxeVlanId[i].propname
            #return_data['pxeVlanPriority_%s'%i] = self.boost_agmt_obj.pxeVlanPriority[i].val
            #return_data['pxeVlanPriority_propname%s'%i] = self.boost_agmt_obj.pxeVlanPriority[i].propname
            #for j in range(0,4):
            #    return_data['pxePort_%s%s'%(i,j)] = (self.boost_agmt_obj.pxePort.getitem(i, j)).val
            #    return_data['pxePort_propname%s%s'%(i,j)] = (self.boost_agmt_obj.pxePort.getitem(i, j)).propname
                
        #FCOE Configuration Function
        return_data['fcoeBios'] = self.boost_agmt_obj.fcoeBios.val
        return_data['fcoeBios_propname'] = self.boost_agmt_obj.fcoeBios.propname
        for i in range(0,4):
            logging.info(self.boost_agmt_obj.fcoeport[i].val)
            return_data['fcoeport_%s'%i] = self.boost_agmt_obj.fcoeport[i].val
            logging.info(self.boost_agmt_obj.fcoeport[i].propname)
            return_data['fcoeport_propname%s'%i] = self.boost_agmt_obj.fcoeport[i].propname
        return_data['DiscoverTimeout'] = self.boost_agmt_obj.DiscoverTimeout.val
        return_data['DiscoverTimeout_propname'] = self.boost_agmt_obj.DiscoverTimeout.propname
        return_data['fcoewwpn'] = self.boost_agmt_obj.showportwwpnstr.val

	#iSCSI function Config
	iscsi_func_conf_list = ['iscsibios', 'iscsidisctime', 'iscsiport1bootorder', 'iscsiport2bootorder', 'iscsiport3bootorder', 'iscsiport4bootorder', 't4chapmethod']
	for cnf in iscsi_func_conf_list:
		tmp_iscsi_var = '%s'%cnf
		#tmp_iscsi_prop = '%s_propname'%cnf
		return_data[tmp_iscsi_var] = eval("self.boost_agmt_obj.%s.val"%tmp_iscsi_var)
		#return_data[tmp_iscsi_prop] = eval("self.boost_agmt_obj.%s.val"%tmp_iscsi_prop)

	#iSCSI Initiator Config
	iscsi_init_conf_list = ['t4oschelsioini', 't4headerdigest', 't4datadigest', \
		't4chaptype', 't4ininame', 't4inichapusername', 't4inichapuserpasswd',\
		't4immediatedata', 't4initialr2t', 't4iscsidiscovertimeout', \
		't4maxburstlength', 't4maxoutstandingr2t','t4maxreceivedatasegmentlength',\
		't4firstburstlength', 't4defaulttime2wait', 't4defaulttime2retain', \
		't4targetfromdhcp']

	for cnf in iscsi_init_conf_list:
		tmp_iscsi_var = '%s'%cnf
		#tmp_iscsi_prop = '%s_propname'%cnf
		return_data[tmp_iscsi_var] = eval("self.boost_agmt_obj.%s.val"%tmp_iscsi_var)
		logging.info('iSCSI Initiator Config:%s,  %s'%(tmp_iscsi_var,return_data[tmp_iscsi_var]))
		#return_data[tmp_iscsi_prop] = eval("self.boost_agmt_obj.%s.val"%tmp_iscsi_prop)

	#iSCSI Network Config
	iscsi_net_conf_list = ['ipmethod', 'ipv6', 'vlanid', 'ip', 'mask', 'gw']
	for i in range(1,5):
		for cnf in iscsi_net_conf_list:
			tmp_iscsi_var = 'iscsiport%s%s'%(i,cnf)
			#tmp_iscsi_prop = 'iscsiport%s%s_propname'%(i,cnf)
			return_data[tmp_iscsi_var] = eval("self.boost_agmt_obj.%s.val"%tmp_iscsi_var)
			#return_data[tmp_iscsi_prop] = eval("self.boost_agmt_obj.%s.val"%tmp_iscsi_prop)

	#iSCSI Boot Config
	#iscsi_boot_conf_list = ['t4targetlun', 't4targetname', 't4targetchapuser', 't4targetchappass', 't4preferredportal' ]
	iscsi_boot_conf_list = ['t4targetlun', 't4targetname', 't4targetchapuser', 't4targetchappass']
	for cnf in iscsi_boot_conf_list:
		tmp_iscsi_var = '%s'%cnf
		#tmp_iscsi_prop = '%s_propname'%cnf
		return_data[tmp_iscsi_var] = eval("self.boost_agmt_obj.%s.val"%tmp_iscsi_var)
		#return_data[tmp_iscsi_prop] = eval("self.boost_agmt_obj.%s.val"%tmp_iscsi_prop)
        return_data['t4targetportal1_IPAddress'] = self.boost_agmt_obj.t4targetportal1.val.IPAddress
        #return_data['t4targetportal1_IPAddress_propname'] = self.boost_agmt_obj.t4targetportal1.val.IPAddress.propname
        return_data['t4targetportal1_TCPPort'] = self.boost_agmt_obj.t4targetportal1.val.TCPPort
        #return_data['t4targetportal1_TCPPort_propname'] = self.boost_agmt_obj.t4targetportal1.val.TCPPort.propname
        #return_data['t4targetportal2_IPAddress'] = self.boost_agmt_obj.t4targetportal2.val.IPAddress
        #return_data['t4targetportal2_IPAddress_propname'] = self.boost_agmt_obj.t4targetportal2.val.IPAddress.propname
        #return_data['t4targetportal2_TCPPort'] = self.boost_agmt_obj.t4targetportal2.val.TCPPort
        #return_data['t4targetportal2_TCPPort_propname'] = self.boost_agmt_obj.t4targetportal2.val.TCPPort.propname

        return simplejson.dumps(return_data)
        
    def get_targets(self, data):
        fcoe_obj = Fcoe(data['sid'], data['ip'])
        adapter_list_obj = fcoe_obj.list_adapters()
        
        if adapter_list_obj == -2 or adapter_list_obj == -1:
              return adapter_list_obj
        elif len(adapter_list_obj) == 0:
            return -1
        
        adapname = adapter_list_obj[int(data['card_index'])].adapName
        local_ports_obj = fcoe_obj.list_local_ports(adapname)
        
        if local_ports_obj == -2 or local_ports_obj == -1:
              return local_ports_obj
        elif local_ports_obj == 1:
            target_html = '<li class="bt_targets" >0 Targets Found</li>'
            data['target_html'] = target_html
            return simplejson.dumps(data)
        
        target_html = ''
        lun_html = ''
        ip_id = self.ip.replace('.','_')
        
        if data['req_type'] == 'desktop':
            unique_parent_id = '#boot_content__incend__'+ ip_id +' .boot_t4_boot_config_tab'
        else:
            unique_parent_id = '#boot_t4config__' + ip_id + '__incend'
        
        is_targets = False
        for lport_index in range(0,len(local_ports_obj)):
            remote_ports_obj = fcoe_obj.list_remote_ports(adapname, local_ports_obj[lport_index].PortAttr.PortWWN)
            
            if remote_ports_obj == -2:
               return remote_ports_obj
            elif remote_ports_obj == 1:
               continue
            
            for rport_index in range(0,len(remote_ports_obj)):
                is_targets = True
                target_html += '<li class="bt_targets" onclick = "boot_show_lun($(this), \'%s\', \'lun_of_%s\')" >Target #%s - [ %s ]\
                                                                    <input type="hidden" value="%s" class="portwwn" />\
                                                                    </li>'%(unique_parent_id,
                                                                    rport_index, rport_index+1, remote_ports_obj[rport_index].PortAttr.PortWWN,
                                                                    remote_ports_obj[rport_index].PortAttr.PortWWN)
                luns_obj = fcoe_obj.list_luns(adapname, local_ports_obj[lport_index].PortAttr.PortWWN, remote_ports_obj[rport_index].PortAttr.PortWWN, data['ostype'])
                
                if luns_obj == -2:
                   return luns_obj    
                elif luns_obj == 1:
                   continue
                
                for lun_index in range(0,len(luns_obj)):
                    lun_html += '<li class="bt_luns lun_of_%s as_hide luns" onclick="boot_select_lun($(this),\'%s\')" >\
                                Lun #%s\
                                <input type="hidden" value="%s" class="size" />\
                                <input type="hidden" value="%s" class="lunid" />\
                                <input type="hidden" value="%s" class="vendor" />\
                                </li>'%( rport_index, unique_parent_id, lun_index, luns_obj[lun_index].capacity, luns_obj[lun_index].getLunId(), luns_obj[lun_index].vendor )
        
        if not is_targets:
            target_html = '<li class="bt_targets" >0 Targets Found</li>'
            data['target_html'] = target_html
            return simplejson.dumps(data)
        
        data = {}
        data['target_html'] = target_html
        data['lun_html'] = lun_html
        return simplejson.dumps(data)
        
    def set_default_t4_settings(self, data):
            boot_boost_obj = BootUtils( self.sid, self.ip )
            logging.info('Boot Set T4 default settings :waiting for response from UMboost sid : %s , IP : %s, adapName : %s , bForce : true'%( self.sid, self.ip, data['card_index'] ))
            status = boot_boost_obj.setDefaultSettings( data['card_index'], 'true' )
            logging.info('Boot Set T4 default settings with bforce true Status: result %s'%(status))
            if status == -2 or status == 0:
                return status
            else:
                return -1
            
    def set_t4_properties(self, kwargs):
        boot_boost_obj = BootUtils( self.sid, self.ip )
        
        boostSetPropertyObj = KList()
        success = True
        
        logging.info('Boot Set T4 adapter configuration settings Umkey - adapater :%s '%( kwargs['card_index'] ))
        adapaterkey = UmBoostLib.UMKey('adapter', kwargs['card_index'])
        boostSetPropertyObj.append(adapaterkey)
        
        if int(kwargs['properties_count']) > 1:
            for i in range(int(kwargs['properties_count'])):
                logging.info('Boot - Set T4 configuration settings - propname :%s , value : %s '%( kwargs['propname'][i], kwargs['value'][i] ))
                prop_key = UmBoostLib.UMKey(kwargs['propname'][i],kwargs['value'][i])
                boostSetPropertyObj.append(prop_key)
        else:
            logging.info('Boot - Set T4 configuration settings - propname :%s , value : %s '%( kwargs['propname'], kwargs['value']))
            prop_key = UmBoostLib.UMKey(kwargs['propname'],kwargs['value'])
            boostSetPropertyObj.append(prop_key)
        
        logging.info('Boot Set T4 configuration settings - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                     '%(self.sid,self.ip, kwargs['ostype']))
        status = boostSetPropertyObj.setProperty(self.sid, self.ip, 6, int(kwargs['ostype']))
        logging.info('Boot Set T4 configuration settings Status : %s'%status)
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
