from UmBoostLib import FavouriteList,UMFavouriteList
from UmBoostLib import UserFavourites
from xml.dom.minidom import Document as XML
import utils, settings
logging = settings.get_logger()

class Bookmarks:
    def __init__(self,sessionId):
        self.sessionId = sessionId

    #Gets all the bookmarks for the user belonging to the sessionId
    def getBookmarks(self):
        self.bookmark = FavouriteList()
        self.bookmarks = UMFavouriteList()
        logging.info('BookmarkList - Waiting for Boost - sid :%s'%self.sessionId)
        status = self.bookmarks.getFavouriteUmServers(self.bookmark,self.sessionId)
        logging.info('BookmarkList Result, Status : %s, len : %s'%(status,len(self.bookmark)))
        
        if  status == 0:
            return self.generateHTML()
        elif status == -2:
            return -2
        else :
            return -1

    def getItems(self):
        for i in range(0,len(self.bookmark)):
            yield self.bookmarks.getitem(self.bookmark,i)

    def generateHTML(self):
        
        html = '<li class="%s"><span class="ip">%s </span>\
                &nbsp;&nbsp;-&nbsp;&nbsp;<span class="hostname">%s</span>\
                <input type="hidden" value="%s" class="osname">\
                <input type="hidden" value="%s" class="port">\
                <input type="hidden" value="%s" class="username">\
                <input type="hidden" value="%s" class="pwd">\
                <input type="hidden" value="%s" class="totalconnection">\
                <input type="hidden" value="%s" class="last_accessed"></li>'
        
        html_list = []
        for i in self.getItems():
            pwd = i.UmPasswd
            if pwd.count('/>'):
                pwd = pwd.replace('/>', '____')
            html_list.append(html%( i.OsName.lower() ,  i.hostip , i.hostName ,  i.OsName.lower(), i.port ,i.UmUserId , pwd, i.TotalConnections , i.TimeLastConnected ))
            
        #html_list = [ html%( i.OsName.lower() ,  i.hostip , i.hostName ,  i.OsName.lower(), i.port ,i.UmUserId , i.UmPasswd, i.TotalConnections , i.TimeLastConnected  ) for i in self.getItems()]
        html = ''.join(html_list)
        return html
    
    #Set User Favourites or Bookmarks
    def set_bookmarks(self,kwargs):
        
        self.boostFavAddObj = UserFavourites()
        success = True
        if int(kwargs['total_agents']) > 1:
            for i in range(int(kwargs['total_agents'])):
                data = {}
                data['ip'] = kwargs['ip'][i]
                data['hostname'] = kwargs['hostname'][i]
                data['ostype'] = kwargs['ostype'][i]
                status = self.add_boomark(data)
                if status == -2:
                    return -2
                elif status != 0:
                    success = False
        else:
            data = {}
            data['ip'] = kwargs['ip']
            data['hostname'] = kwargs['hostname']
            data['ostype'] = kwargs['ostype']
            status = self.add_boomark(data)
            if status == -2:
                return -2
            elif status != 0:
                 success = False
            
        if success:
            return 0
        else:
            return -1
            
    def add_boomark(self,data):
        
        self.boostFavAddObj.sethostIP(data['ip'])
        self.boostFavAddObj.sethostName(data['hostname'])
        self.boostFavAddObj.setOsName(data['ostype'])

        logging.info('Add Bookmark - Waiting for Boost - sid :%s , ip: %s , hostname : %s , ostype : %s'%(self.sessionId,data['ip'],data['hostname'],data['ostype']))
        status = self.boostFavAddObj.AddToFavourites(self.sessionId)
        logging.info('Add Bookmark, Status : %s'%status)
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1

    def delete_bookmark(self,ip):
         
        self.boostFavDeleteObj = UserFavourites()
        self.boostFavDeleteObj.sethostIP(ip)
        logging.info('Delete Bookmark - Waiting for Boost - sid :%s , ip: %s '%(self.sessionId,ip))
        status = self.boostFavDeleteObj.RemoveFromFavourites(self.sessionId)
        logging.info('Delete Bookmark, Status : %s'%status)
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
        
    def update_bookmarks(self,data):
        
        logging.info('Validate IP : %s, Validate : 1 '%data['ip'])
        ip_validate = utils.validate_ip(data['ip'], 1)
        logging.info('IP Validate status %s'%ip_validate)
        if ip_validate == -1:
            return  'Invalid IP'
         
        self.boostFavModifyObj = UserFavourites()
        logging.info('---Modify Bookmark--')
        logging.info('Values Passed: sid :%s , ip: %s , system : %s , username : %s , pwd : %s , OldIp : %s , Port : %s , Emptyflag : %s\
                    '%(self.sessionId,data['ip'],data['system'],data['username'],data['password'],data['oldip'],data['port'],data['emptyflag']))
        self.boostFavModifyObj.sethostIP(data['ip'])
        self.boostFavModifyObj.setUmPort(int(data['port']))
        self.boostFavModifyObj.sethostName(data['system'])
        self.boostFavModifyObj.setUMUser(data['username'])
        self.boostFavModifyObj.setUmPasswd(data['password'],int(data['emptyflag']))
        logging.info('Modify Bookmark - Waiting for Boost - sid :%s , OldIp : %s , Fav : %s '%(self.sessionId,data['oldip'],data['fav']))
        status = self.boostFavModifyObj.ModifyFavourites(self.sessionId,data['oldip'],int(data['fav']))
        logging.info('Modify Bookmark, Status : %s'%status)
        logging.info('---Modify Bookmark--')
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1