$(document).ready(function(){
	$('.vm_tree_li a.tree_action').live('click',function(){
		$('.vm_tree_li a:not(.tree_action)').removeClass('selected');
		$(this).next().trigger('click');
	});
});

function fill_xen_bridge_conf(ip_id){	
	var unique_parent_id = '#hypervisor_xen_content__incend__'+ ip_id+' .xen_bridge_conf_tab';
	$(unique_parent_id+' .initializer').show();
	$(unique_parent_id+' .xen_tree_wr').html('');
	$(unique_parent_id+' .detail_wr').hide();
	$(unique_parent_id+' .detail_wr dd:not(.network_name_description_dd)').html('&nbsp;');
	$(unique_parent_id+' .detail_wr .network_name_description').html('&nbsp;');
	
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip+'&type=desktop';
	
	$(unique_parent_id + ' .refresh a').attr('onclick', '$("' + unique_parent_id + ' .xen_tree_wr").html("");fill_xen_bridge_conf("' + ip_id + '")');
	$(unique_parent_id + ' .delete_bridge').attr('onclick','xen_delete_bridge("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'" )');
	$(unique_parent_id + ' .delete_vif').attr('onclick','xen_delete_vif("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'")');
	load_xen_bridge_conf(unique_parent_id, getdata);
}

function load_xen_bridge_conf(unique_parent_id, getdata){
	getdata += '&action=get'
	$.ajax({
		url: '/python/xen_bridge_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(html){
			$(unique_parent_id+' .initializer').hide();
			
			if ( html == '-2' ) {
				show_redirect_alert();
			}
			else if ( html != '-1' ) {
				$(unique_parent_id+' .xen_tree_wr').html(html);
				if($(unique_parent_id+' .xen_tree_wr ul .vm_tree_li').length){
					$(unique_parent_id+' .xen_tree_wr ul .first_br:first').trigger('click');
				}
			}
		}
	});	
}


function xen_conf_select(unique_parent_id, element, c_type ){
	$(unique_parent_id+' .vm_tree_li a:not(.tree_action)').removeClass('selected');
	element.addClass('selected');
	$(unique_parent_id+' .detail_wr').hide();
	$(unique_parent_id+' .xbc_'+c_type+'_wr').fadeIn(300);
	if( c_type == 'bridge' ){
		$(unique_parent_id+' .vif_mtu').html(xen_bridge_check_value(element.children('.vif_mtu').val()));
		$(unique_parent_id+' .network_uuid').html(xen_bridge_check_value(element.children('.network_uuid').val()));
		$(unique_parent_id+' .network_name_label').html(xen_bridge_check_value(element.children('.network_name_label').val()));
		$(unique_parent_id+' .network_name_description').html(xen_bridge_check_value(element.children('.network_name_description').val()));
		$(unique_parent_id+' .network_name_description').attr('title', element.children('.bridge_desc_title').val());
		$(unique_parent_id+' .vif_uuid').html(xen_bridge_check_value(element.children('.vif_uuid').val()));
		$(unique_parent_id+' .pif_uuid').html(xen_bridge_check_value(element.children('.pif_uuid').val()));
		$(unique_parent_id+' .vif_mtu').html(xen_bridge_check_value(element.children('.vif_mtu').val()));
	}
	else if( c_type == 'pif' ){
		$(unique_parent_id+' .xbc_pif_wr .uuid').html(xen_bridge_check_value(element.children('.uuid').val()));
		$(unique_parent_id+' .xbc_pif_wr .vendor_id').html(xen_bridge_check_value(element.children('.vendor_id').val()));
		$(unique_parent_id+' .xbc_pif_wr .vlan').html(xen_bridge_check_value(element.children('.vlan').val()));
		$(unique_parent_id+' .xbc_pif_wr .physical').html(xen_bridge_check_value(element.children('.physical').val()));
		$(unique_parent_id+' .xbc_pif_wr .device_id').html(xen_bridge_check_value(element.children('.device_id').val()));
		$(unique_parent_id+' .xbc_pif_wr .devname').html(xen_bridge_check_value(element.children('.devname').val()));
		$(unique_parent_id+' .xbc_pif_wr .mac_pif').html(xen_bridge_check_value(element.children('.mac_pif').val()));
		$(unique_parent_id+' .xbc_pif_wr .speed').html(xen_bridge_check_value(element.children('.speed').val()));
		$(unique_parent_id+' .xbc_pif_wr .device_name').html(xen_bridge_check_value(element.children('.device_name').val()));
		$(unique_parent_id+' .xbc_pif_wr .pci_bus_path').html(xen_bridge_check_value(element.children('.pci_bus_path').val()));
		$(unique_parent_id+' .xbc_pif_wr .network_uuid').html(xen_bridge_check_value(element.children('.network_uuid').val()));
		$(unique_parent_id+' .xbc_pif_wr .network_name_label').html(xen_bridge_check_value(element.children('.network_name_label').val()));
		$(unique_parent_id+' .xbc_pif_wr .vendor_name').html(xen_bridge_check_value(element.children('.vendor_name').val()));
	}
	else if( c_type == 'vif' ){
		$(unique_parent_id+' .xbc_vif_wr .device').html(xen_bridge_check_value(element.children('.device').val()));
		$(unique_parent_id+' .xbc_vif_wr .mac_pif').html(xen_bridge_check_value(element.children('.mac_pif').val()));
		$(unique_parent_id+' .xbc_vif_wr .mac_type').html(xen_bridge_check_value(element.children('.mac_type').val()));
		$(unique_parent_id+' .xbc_vif_wr .vif_mtu').html(xen_bridge_check_value(element.children('.vif_mtu').val()));
		$(unique_parent_id+' .xbc_vif_wr .attach_type').html(xen_bridge_check_value(element.children('.attach_type').val()));
		$(unique_parent_id+' .xbc_vif_wr .network_uuid').html(xen_bridge_check_value(element.children('.network_uuid').val()));
		$(unique_parent_id+' .xbc_vif_wr .network_name_label').html(xen_bridge_check_value(element.children('.network_name_label').val()));
		$(unique_parent_id+' .xbc_vif_wr .vm_uuid').html(xen_bridge_check_value(element.children('.vm_uuid').val()));
		$(unique_parent_id+' .xbc_vif_wr .vif_uuid').html(xen_bridge_check_value(element.children('.vif_uuid').val()));
		$(unique_parent_id+' .xbc_vif_wr .vm_name_label').html(xen_bridge_check_value(element.children('.vm_name_label').val()));
	}
	else if( c_type == 'vm' ){
		$(unique_parent_id+' .name_label').html(xen_bridge_check_value(element.children('.name_label').val()));
		$(unique_parent_id+' .uuid').html(xen_bridge_check_value(element.children('.uuid').val()));
		$(unique_parent_id+' .vfpci').html(xen_bridge_check_value(element.children('.vfpci').val()));
		$(unique_parent_id+' .mac_type').html(xen_bridge_check_value(element.children('.mac_type').val()));
		$(unique_parent_id+' .powerstate').html(xen_bridge_check_value(element.children('.powerstate').val()));
	}
}

function xen_delete_bridge( unique_parent_id, getdata, ip_id ){
	if( !$(unique_parent_id+' .tree_ul li a.selected').length ){
		return
	}
	getdata += '&action=del_bridge&id='+$(unique_parent_id+' .tree_ul li a.selected').children('.network_uuid').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/xen_bridge_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .xen_tree_wr').html('');
				fill_xen_bridge_conf(ip_id);
			}
			else{
				show_error_info(unique_parent_id, data);
			}
		}
	});		
}

function xen_delete_vif( unique_parent_id, getdata, ip_id ){
	if( !$(unique_parent_id+' .tree_ul li a.selected').length ){
		return
	}
	getdata += '&action=del_vif&id='+$(unique_parent_id+' .tree_ul li a.selected').children('.vif_uuid').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/xen_bridge_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .xen_tree_wr').html('');
				fill_xen_bridge_conf(ip_id);
			}
			else{
				show_error_info(unique_parent_id, data);
			}
		}
	});		
}

function xen_bridge_check_value(value){
	if( $.trim(value) == '' ){
		return '-';
	}
	else{
		return value;
	}
}