$(document).ready(function(){
	$('.vm_tree_li a.tree_action').live('click',function(){
		$('.vm_tree_li a:not(.tree_action)').removeClass('selected');
		$(this).next().trigger('click');
	});
});

function fill_virtual_network_topology(ip_id){
	var unique_parent_id = '#hypervisor_content__incend__' + ip_id+' .virtual_network_topology_tab';
	$(unique_parent_id+' .initializer:first').hide();
	var loader_selector = unique_parent_id + ' .h_vnt_deft_loader';
	
	var ip = replace_with(ip_id, '_', '.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&ip=' + ip;
	$(unique_parent_id + ' .h_vnt_switch_wr').html('');
	$(unique_parent_id + ' .vnt_interface_list').html('');
	vnt_make_default(unique_parent_id);
	
	//Initializing
	$(unique_parent_id +' .tree_ul .vnt_switch_m').attr('onclick','vnt_toggle_detail("'+ unique_parent_id +'", $(this) )');
	$(unique_parent_id +' .tree_ul .vnt_pg_m').attr('onclick','vnt_toggle_detail("'+ unique_parent_id +'", $(this) )');
	$(unique_parent_id +' .tree_ul .vnt_vmnic_m').attr('onclick','vnt_toggle_detail("'+ unique_parent_id +'", $(this) )');
	$(unique_parent_id +' .tree_ul .vnt_vmswif_m').attr('onclick','vnt_toggle_detail("'+ unique_parent_id +'", $(this) )');
	$(unique_parent_id +' .rect_btn_wrapper').attr('onclick','$(\''+ unique_parent_id +' .global_error\').show();');
	$(unique_parent_id +' .vnt_specific_button').attr('onclick','vnt_specific_action("'+ unique_parent_id +'", "'+sid+'", "'+ip+'" )');
	$(unique_parent_id +' .save_changes').attr('onclick','vnt_save_changes("'+ unique_parent_id +'", "'+sid+'", "'+ip+'", "'+ip_id+'" )');
	$(unique_parent_id +' .discard_changes').attr('onclick','vnt_make_default("'+ unique_parent_id +'")');
	
	if( $(loader_selector).css('display') == 'block' || $(unique_parent_id +' .global_error').css('display') == 'block' ){
		$(loader_selector).hide();
		return
	}
	
	//get_switch_tree(unique_parent_id, sid, ip);
	$(unique_parent_id+' .h_vnt_deft_loader').show();
	var getdata = 'sid=' + sid + '&ip=' +ip;
	var counter = 0;
	var failure = false;
	$.ajax({
		url: '/python/virtual_network_topology.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=get_switch_tree',
		success: function(data){
			counter++;
			if (counter == 2) {
				$(unique_parent_id + ' .h_vnt_loader').hide();
			}
			
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data != '-1') {
				$(unique_parent_id + ' .h_vnt_switch_wr').html('<ul class="tree_ul">'+data+'</ul>');
			}
			else{
				failure = true;
				if( failure && counter == 2 ){
					$(unique_parent_id + ' .global_error').show(300);
				}
			}
		}
	});
	
	$.ajax({
		url: '/python/virtual_network_topology.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=get_interface_list',
		success: function(data){
			counter++;
			if (counter == 2) {
				$(unique_parent_id + ' .h_vnt_loader').hide();
			}
			
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data != '-1') {
				$(unique_parent_id + ' .vnt_interface_list').html('<ul>'+data+'</ul>');
			}
			else{
				failure = true;
				if( failure && counter == 2 ){
					$(unique_parent_id + ' .global_error').show(300);
				}
			}
		}
	});		
}

function vnt_toggle_detail(unique_parent_id, element){
	$(unique_parent_id+' .vnt_btn_wr button').removeClass('disabled').addClass('blue').removeAttr('disabled');
	$(unique_parent_id+' .tab_content_right .fieldset').hide();
	$(unique_parent_id+ ' .vm_tree_li a:not(.tree_action)').removeClass('selected');
	$(element).addClass('selected');
	if( $(element).hasClass('vnt_switch_m') ){
		$(unique_parent_id+' .vnt_switch_wr .selected_switch').html($(element).children('.switch_name').val());
		$(unique_parent_id+' .vnt_switch_wr .mtu').val($(element).children('.mtu').val());
		$(unique_parent_id+' .vnt_interface_list ul li').removeClass('selected');
		$(unique_parent_id+' .h_vnt_switch_wr a.selected').siblings('.vmmnics_ul').find('.vnt_vmnic_m').each(function(i){
			$(unique_parent_id+' .vnt_interface_list ul li.'+replace_with($.trim($(this).children('.vmnic_name').html()), '.', '_')).addClass('selected');
		});
		$(unique_parent_id+' .vnt_specific_button strong').html('Delete vSwitch').removeAttr('class').addClass('del_vswitch');
		$(unique_parent_id+' .tab_content_right .vnt_switch_wr').fadeIn(300);
	}
	else if( $(element).hasClass('vnt_vmnic_m') ){
		var vminc_name = $.trim($(element).children('.vmnic_name').html());
		var vminc_li = $(unique_parent_id+' .vnt_interface_list ul li.'+replace_with(vminc_name,'.','_'));
		$(unique_parent_id+' .vnt_nic_wr .selected_switch').html(vminc_li.children('.svs').val());
		$(unique_parent_id+' .vnt_nic_wr .detail_desc').attr('title', vminc_li.children('.desc_title').val());
		$(unique_parent_id+' .vnt_nic_wr .detail_desc').html(vminc_li.children('.desc').val());
		$(unique_parent_id+' .vnt_nic_wr .mtu').html(vminc_li.children('.mtu').val());
		$(unique_parent_id+' .vnt_nic_wr .vlan').html(vminc_li.children('.vlan').val());
		
		var status = $.trim(vminc_li.children('.status').val()).split('__')[1].split('**')[0];
		var link_status = $.trim(vminc_li.children('.status').val()).split('__')[1].split('**')[1];
		var status_class = $.trim(vminc_li.children('.status').val()).split('__')[0];
		var status_value = status+' '+link_status;
		$(unique_parent_id+' .vnt_nic_wr .vmnic_status').html(status_value);
		$(unique_parent_id +' .vnt_nic_wr .vmnic_status').removeAttr('class').addClass('vmnic_status '+status_class);
		
		$(unique_parent_id+' .vnt_specific_button strong').html('Delete Uplink').removeAttr('class').addClass('del_uplink');
		$(unique_parent_id+' .tab_content_right .vnt_nic_wr').fadeIn(300);
	}
	else if( $(element).hasClass('vnt_pg_m') ){
		$(unique_parent_id+' .vm_nw_wr .selected_pg').html($(element).children('.pg_name').val());
		$(unique_parent_id+' .vm_nw_wr .vlanid').val($(element).children('.vlanid').val());
		if ( $(element).children('.uplinks').length ){
			var uplinks = $(element).children('.uplinks').val().split(',');
			uplinks_html = '';
			for(i in uplinks)
			{
				uplinks_html += '<li class="selected" onclick="vnt_toggle_class($(this))" >\
								<input type="hidden" value="'+uplinks[i]+'" class="name" />'+uplinks[i]+'</li>';
			}
			$(unique_parent_id+' .vm_nw_wr .pg_vminc').html(uplinks_html);			
		}
		else{
			$(unique_parent_id+' .vm_nw_wr .pg_vminc').html('');
		}
		$(unique_parent_id+' .vnt_specific_button strong').html('Delete PortGroup').removeAttr('class').addClass('del_pg');
		$(unique_parent_id+' .tab_content_right .vm_nw_wr').fadeIn(300);
	}
	else if( $(element).hasClass('vnt_vmswif_m') ){
		$(unique_parent_id+' .vnt_specific_button strong').html('Delete vswif').removeAttr('class').addClass('del_vswif');
		$(unique_parent_id+' .tab_content_right .vnt_vsw_wr').fadeIn(300);
	}
}

function vnt_specific_action(unique_parent_id, sid, ip){
	if( $(unique_parent_id+' .vnt_specific_button strong').hasClass('del_vswitch') ){
		var switch_name = $(unique_parent_id+' .vnt_switch_m.selected').children('.switch_name').val();
		var getdata = 'sid='+sid+'&ip='+ip+'&action=specific_call&vmnic=';
		getdata += '&reqType=4&PGName=&VSwitchName='+switch_name;
		var ip_id = replace_with(ip, '.', '_');
		vnt_call_ajax(ip_id, unique_parent_id, getdata)
	}
	else if( $(unique_parent_id+' .vnt_specific_button strong').hasClass('del_pg') ){
		var pg_name = $(unique_parent_id+' .vnt_pg_m.selected').children('.pg_name').val();
		var switch_name = $(unique_parent_id+' .tree_ul .selected').parent().parent().siblings('.vnt_switch_m').children('.switch_name').val();
		var getdata = 'sid='+sid+'&ip='+ip+'&action=specific_call&vmnic=';
		getdata += '&reqType=5&PGName='+pg_name+'&VSwitchName='+switch_name;
		var ip_id = replace_with(ip, '.', '_');
		vnt_call_ajax(ip_id, unique_parent_id, getdata)
	}
	else if( $(unique_parent_id+' .vnt_specific_button strong').hasClass('del_uplink') ){
		if( $(unique_parent_id+' .tree_ul .selected').hasClass('pg_vmnic') ){
			var uplink_name = $.trim($(unique_parent_id+' .pg_vmnic.selected').children('.vmnic_name').html());
			var pg_name = $(unique_parent_id+' .pg_vmnic.selected').children('.pgname').val();
			var switch_name = $(unique_parent_id+' .pg_vmnic.selected').children('.vswitchname').val();
			var getdata = 'sid='+sid+'&ip='+ip+'&action=specific_call&vmnic='+uplink_name;
			getdata += '&reqType=7&PGName='+pg_name+'&VSwitchName='+switch_name;
			var ip_id = replace_with(ip, '.', '_');
			vnt_call_ajax(ip_id, unique_parent_id, getdata);
		}
		else{
			var uplink_name = $.trim($(unique_parent_id+' .tree_ul .selected').children('.vmnic_name').html());
			var switch_name = $(unique_parent_id+' .tree_ul .selected').parent().parent().siblings('.vnt_switch_m').children('.switch_name').val();
			var getdata = 'sid='+sid+'&ip='+ip+'&action=specific_call&vmnic='+uplink_name;
			getdata += '&reqType=6&PGName=&VSwitchName='+switch_name;
			var ip_id = replace_with(ip, '.', '_');
			vnt_call_ajax(ip_id, unique_parent_id, getdata);
		}
	}
	
}

function vnt_call_ajax(ip_id, unique_parent_id, getdata){
	$(unique_parent_id+' .h_vnt_loader').hide();
	$(unique_parent_id+' .h_vnt_processing').show();
	$.ajax({
		url: '/python/virtual_network_topology.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .h_vnt_loader').hide();
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '0') {
				fill_virtual_network_topology(ip_id);
			}
			else{
				$(unique_parent_id + ' .global_error').show();
			}
		}
	});
}

function vnt_save_changes(unique_parent_id, sid, ip, ip_id){
	$(unique_parent_id+' .h_vnt_loader').hide();
	$(unique_parent_id+' .h_vnt_processing').show();
	var getdata = 'sid=' + sid + '&ip=' +ip;
	if($(unique_parent_id+' .tree_ul .selected').hasClass('vnt_switch_m')){
		var mtu = $(unique_parent_id+' .tab_content_right .mtu').val();
		var switch_name = $(unique_parent_id+' .vnt_switch_m.selected').children('.switch_name').val();
		$.ajax({
		url: '/python/virtual_network_topology.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=set_mtu&mtu='+mtu+'&ifname='+switch_name,
		success: function(data){
				$(unique_parent_id + ' .h_vnt_loader').hide();
				if (data == '-2') {
					show_redirect_alert();
				}
				else if (data == '0') {
					//fill_virtual_network_topology(ip_id);
				}
				else{
					$(unique_parent_id + ' .global_error').show(300);
				}
			}
		});
		
		var uplink_name = '';
		var total_uplink = $(unique_parent_id+' .vnt_interface_list ul li.selected').length;
		var ip_id = replace_with(ip, '.', '_');
		getdata += '&action=specific_call&reqType=2&PGName=&VSwitchName='+switch_name;
		
		//Generating current uplink
		var total_cuplinks = $(unique_parent_id+' .h_vnt_switch_wr a.selected').siblings('.vmmnics_ul').find('.vnt_vmnic_m').length;
		var cuplink = '';
		$(unique_parent_id+' .h_vnt_switch_wr a.selected').siblings('.vmmnics_ul').find('.vnt_vmnic_m').each(function(i){
			if( i == total_cuplinks-1 || i == 0 ){
				//IF LAST
				if( i == total_cuplinks-1 ){
					cuplink += $.trim($(this).children('.vmnic_name').html());			
				}
				else if( i == 0 ){
					//first but not the last
					cuplink += $.trim($(this).children('.vmnic_name').html())+',';			
				}	
			}
			else{
				cuplink += $.trim($(this).children('.vmnic_name').html())+',';
			}
		});
		//Not adding the uplinks which are already added & generating the selected uplinks string
		var total_suplinks = $(unique_parent_id+' .vnt_interface_list ul li.selected').length;
		var suplink = '';  
		$(unique_parent_id+' .vnt_interface_list ul li.selected').each(function(i){
			
			if( i == total_suplinks-1 || i == 0 ){
				//IF LAST
				if( i == total_suplinks-1 ){
					suplink += $.trim($(this).children('.name').val());			
				}
				else if( i == 0 ){
					//first but not the last
					suplink += $.trim($(this).children('.name').val())+',';			
				}	
			}
			else{
				suplink += $.trim($(this).children('.name').val())+',';
			}
			
			if (cuplink.search($(this).children('.name').val()) == -1){
				var temp_getdata = getdata;
				temp_getdata += '&vmnic='+$(this).children('.name').val();
				vnt_call_ajax(ip_id, unique_parent_id, temp_getdata);				
			}
		});
		
		//Delete the already present uplinks , if they are unchecked while saving
		var cuplink_arr = cuplink.split(',');
		for(i in cuplink_arr){
			if( suplink.search(cuplink_arr[i]) == -1){
				//Delete uplink
				var uplink_name = cuplink_arr[i];
				var getdata = 'sid='+sid+'&ip='+ip+'&action=specific_call&vmnic='+uplink_name;
				getdata += '&reqType=6&PGName=&VSwitchName='+switch_name;
				vnt_call_ajax(ip_id, unique_parent_id, getdata);
			}
		}
		
	}
	else if($(unique_parent_id+' .tree_ul .selected').hasClass('vnt_pg_m')){
		var vlanid = $(unique_parent_id+' .tab_content_right .vlanid').val();
		var pg_name = $(unique_parent_id+' .vnt_pg_m.selected').children('.pg_name').val();
		var switch_name = $(unique_parent_id+' .tree_ul .selected').parent().parent().siblings('.vnt_switch_m').children('.switch_name').val();
		$.ajax({
		url: '/python/virtual_network_topology.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=set_vlanid&vlanid='+vlanid+'&vswitchname='+switch_name+'&PGName='+pg_name,
		success: function(data){
				$(unique_parent_id + ' .h_vnt_loader').hide();
				if (data == '-2') {
					show_redirect_alert();
				}
				else if (data == '0') {
					//fill_virtual_network_topology(ip_id);
				}
				else{
					$(unique_parent_id + ' .global_error').show(300);
				}
			}
		});
		
		getdata += '&action=specific_call&reqType=3&PGName='+pg_name+'&VSwitchName='+switch_name;
		var ip_id = replace_with(ip, '.', '_');
		if ($(unique_parent_id + ' .tree_ul .selected').children('.uplinks').length) {
			//Generating current uplink of pg
			var cuplink = $(unique_parent_id + ' .tree_ul .selected').children('.uplinks').val();
			//Not adding the uplinks which are already added & generating the selected uplinks string
			var total_suplinks = $(unique_parent_id+' .vm_nw_wr .pg_vminc li.selected').length;
			var suplink = '';  
			$(unique_parent_id+' .vm_nw_wr .pg_vminc li.selected').each(function(i){
				
				if( i == total_suplinks-1 || i == 0 ){
					//IF LAST
					if( i == total_suplinks-1 ){
						suplink += $.trim($(this).children('.name').val());			
					}
					else if( i == 0 ){
						//first but not the last
						suplink += $.trim($(this).children('.name').val())+',';			
					}	
				}
				else{
					suplink += $.trim($(this).children('.name').val())+',';
				}
				
				if (cuplink.search($(this).children('.name').val()) == -1){
					var temp_getdata = getdata;
					temp_getdata += '&vmnic=' + $(this).children('.name').val();
					vnt_call_ajax(ip_id, unique_parent_id, temp_getdata);			
				}
			});
			
			//Delete the already present uplinks , if they are unchecked while saving
			var cuplink_arr = cuplink.split(',');
			for(i in cuplink_arr){
				if( suplink.search(cuplink_arr[i]) == -1){
					//Delete uplink
					var uplink_name = cuplink_arr[i];
					var pg_name = $(unique_parent_id + ' .tree_ul .selected').children('.pg_name').val();
					var getdata = 'sid='+sid+'&ip='+ip+'&action=specific_call&vmnic='+uplink_name;
					getdata += '&reqType=7&PGName='+pg_name+'&VSwitchName='+switch_name;
					vnt_call_ajax(ip_id, unique_parent_id, getdata);
				}
			}
		}
	}
	
}

function vnt_toggle_class(element){
	if( $(element).hasClass('selected') ) {
		$(element).removeClass('selected');
	}
	else{ 
		$(element).addClass('selected');
	}
}

function vnt_make_default(unique_parent_id){
	$(unique_parent_id+' input[type=text]').val('');
	$(unique_parent_id+' .vnt_interface_list ul li').removeClass('selected');
	$(unique_parent_id+' .pg_vminc').html('');
	$(unique_parent_id+' .vnt_btn_wr button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
	$('.vm_tree_li a:not(.tree_action)').removeClass('selected');
}
