var menu_callback_fn = false;
var global_dict = {}

$(document).ready(function(){
	
  	$("body").keypress(function(e){
  		 var code = (e.keyCode ? e.keyCode : e.which);
		 if(code == 27) {
		 	if ($('#modalogBox').length) {
				if ($.trim($('#dialogBoxHdr h3').html()) == 'Add System' && $('#modalogBox .lb_loading').css('display') == 'none') {
					$('.dummy').chLightbox('destroy');
				}
			}
		 }
    });
	
	$('.left_top_nav  ul li a.menu_toggle').click(function(){
		$('.left_top_nav  ul li a.menu_toggle').removeClass('selected');
		$(this).addClass('selected');
	});
	
	$('a:not(.menu_toggle)').live('click', function(){
		$('.left_top_nav  ul li a.menu_toggle').removeClass('selected');
	});
	
	$(window).load( function(){
		load_right_content('home_content.html');
	});
	
	$('.add_pc').click(function(){
		add_system_popup();
	});
	
	$('.bulk').click(function(){
		load_right_content('bulk_content.html');
	});
	
	$('.remove_pc').click(function(){
		if($(this).hasClass('inactive')){
			return
		}
		var system_name = $.trim($('.details h1.show').html());
		$('.remove_pc').chLightbox('confirm', {
			cnfmTitle: 'Remove System',
            cnfmMsg: 'Are you sure you want to remove <span class="lb_black f_bold f_size14">'+system_name+' ?</span>',
            cnfmOk: 'Yes',
			cnfmCancel: 'No',
			cnfStatus:'Disconnecting...',
			successfn:'remove_system()',
            lbWidth: 420,
            top_extra: 50
		});
	});
	
	$('#b_port_chk').live('change',function(){
		if($(this).is(':checked')){
			$('#b_p_tcp').attr('disabled','disabled').addClass('disabled');		
			var element = $('.b_list ul li.selected');
			$('#b_p_tcp').val('35001');	
		}
		else{
			$('#b_p_tcp').removeAttr('disabled').removeClass('disabled');
		}
	});
	
	$('.main_home').live('click',function(){
		load_right_content('home_content.html')
		$('#m_tree_wrap .tree .tree_ul a:not(.tree_action)').removeClass('selected');
	});
	
	$('.ul_success').live('click',function(){
		$(this).fadeOut();
	});
	
	$('#modalogContent .text').live('keyup',function(){
		$(this).removeClass('error');
	});
	
	$('.subscribe').click(function(){
		$('#global_loader').show();
		load_subscribtion_page();
	});
	
	$('.ch_refresh').click(function(){
		
		if( $('.details h1.show').length ){
			var hostname = $.trim($('.details h1.show').html());
			var msg = 'reload <span class="f_bold">'+hostname+'</span>';
		}
		else{
			var msg = 'refresh';			
		}
		
		$('.refresh').chLightbox('confirm', {
			cnfmTitle: 'Refresh',
            cnfmMsg: 'Are you sure you want to '+msg+'?',
            cnfmOk: 'Yes',
			cnfmCancel: 'No',
			cnfStatus:'Refreshing...',
			successfn:'invoke_refresh()',
            lbWidth: 420,
            top_extra: 50
		});
	});
	
	$('.main_help').live('click',function(event){
		event.stopPropagation();
	});
	
});

function logout() {
	$('#global_loader .init_loader span').html('Loading..');
	$('#global_loader').show();
	$.get('python/py_logout',{ sid : GetCookie("chelsio_webgui_sid") , user : GetCookie("chelsio_webgui_user") },function(data){
		DeleteCookie( 'chelsio_webgui_sid' , "/", '' );
		DeleteCookie( 'chelsio_webgui_user' , "/", '' );
		window.location.replace('index.html');	
	});
}

function add_system_popup(){
	$('.dummy').chLightbox('popup', {
		PopTitle: 'Add System',
		PopOk: 'Connect to system',
		PopDivId: 'system_connect_div',
		successfn: 'system_connect()',
		lbWidth: '385',
		PopStatus: 'Connecting to system.... ',
		top_extra: 50
	});
	$('#b_ip').focus();
}

function remove_system(){
	$('.remove_pc').chLightbox('lbShowStaus');
	var sid = GetCookie("chelsio_webgui_sid");
	var hostname = $.trim($('.details h1.show').html());
	var ip_id = $('.details h1.show').attr('id').replace('rm_pc_','');
	var ip  = replace_with( ip_id , '_' , '.' );
	var xml_name = GetCookie("chelsio_webgui_user")+'_menu.xml';
	var getdata = 'sid='+sid+'&hostname='+hostname+'&ip='+ip+'&filename='+xml_name;
	$.ajax({
		url : 'python/remove_system.py',
		data: getdata,
		type: 'GET',
		cache:false,
		success:function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data != '-1') {
				$('.remove_pc').chLightbox('lbChangeStaus', {
					lbLdStatus: 'Removing system specific files...'
				});
				generate_menu();
				$('.'+ip_id).remove();
				//load_right_content('home_content.html');
				$('.remove_pc').chLightbox('destroy');
				$('.remove_pc').chLightbox('alert', {
					alertTitle: 'Success!',
					alertMsg: 'Succesfully Disconnected ',
					alertOk: 'OK',
					lbWidth: 420,
					top_extra: 50
				});
				
				
				//fill the added agent in the services discovery panel
				try{
					fill_services_disc();
				}
				catch(e){}
			}
			else{
				$('.remove_pc').chLightbox('destroy');
				$('.remove_pc').chLightbox('alert', {
					alertTitle: 'Error!',
					alertMsg: 'Remove system failed. Please try again later, if the problem persists try signing out and signing in again.',
					alertOk: 'OK',
					lbWidth: 420,
					top_extra: 50
				});
			}
		}
	});
}

function system_connect(){
	$('#modalogCloseButton').hide();
	$('#shareModal .ip_msg').hide();
	$('#shareModal .host_msg').hide();
	$('#shareModal .input_type_msg').hide();
	var success = true;
	var postdata = '';
	var element = $('.b_list ul li.selected');
	var input_type = $('.lb_fieldset [name=b_p_type]:checked').val();
	
	var sid = GetCookie("chelsio_webgui_sid");
	var username = GetCookie("chelsio_webgui_user");

	if (!$('.lb_fieldset [name=b_p_type]:checked').length) {
		$('#shareModal .input_type_msg').show();
		success = false;
	}
	else {
		postdata += '&input_type=' + input_type;
	}
	
	if( input_type == 'host' ){
		host_flag = false;
		if (/[a-zA-Z]/.test($.trim($('#modalogContent #b_ip').val()))) {
			host_flag = true;
		}
		
		if( !host_flag ){
			$('#shareModal .host_msg').show();
			$('#b_connect_s').chLightbox('lbHideStaus');
			return
		}
	}
	
	//hostname field is not used as of now, both hostname and ip are passed in the IP field itself.
	postdata += '&hostname=';

	$('.lb_fieldset input.text').each(function(i){
		if($.trim($(this).val()) == '' ){
			$(this).addClass('error');
			success = false;
		}
		else{
			$(this).removeClass('error');
			var name = $(this).attr('name');
			//Validate Port 0-65535
			if( name == 'port' ){
				var val = parseInt($(this).val());
				if( val < 0 || val > 65535 ){
					$(this).addClass('error');
					$('#shareModal .port_msg').show();
					success = false;
				}
				else{
					$('#shareModal .port_msg').hide();
				}
			}
			
			postdata += '&'+name+'='+encodeURIComponent($(this).val());
		}
	});
	
	if(!success){
		return false;
	}
	
	postdata += '&sid='+sid;
	postdata += '&bookmark=1';
	
	if($('#b_p_remember').is(':checked')){
		postdata += '&savepass=1';		
	}
	else{
		postdata += '&savepass=0';
	}
	
	$('#b_connect_s').chLightbox('lbShowStaus');
	
	$.ajax({
		url:  '/python/py_do_system_connect.py',
		type: 'POST',
		cache: false,
		data: postdata,
		success: function(success){
			if (success == '-2') {
				show_redirect_alert();
			}
			else if( success == '-6' ){
				$('#shareModal .ip_msg').show();
				$('#b_connect_s').chLightbox('lbHideStaus');
			}
			else if( success == '-16' || success == '-1'  ){
				$('#b_connect_s').chLightbox('destroy'); 
				$('#b_connect_s').chLightbox('alert', {
					alertTitle: 'Error!',
	                alertMsg: 'System Connect failed. The UM Server is busy, it may be in use by other clients',
	                alertOk: 'OK',
	                lbWidth: 420,
	                top_extra: 50
				});
			}
			else if( success == '-8' ){
				$('#b_connect_s').chLightbox('destroy'); 
				$('#b_connect_s').chLightbox('alert', {
					alertTitle: 'Error!',
	                alertMsg: 'System Connect failed. The UM Server may not be running.',
	                alertOk: 'OK',
	                lbWidth: 420,
	                top_extra: 50
				});
			}
			else if( success == '-15' ){
				$('#b_connect_s').chLightbox('destroy'); 
				$('#b_connect_s').chLightbox('alert', {
					alertTitle: 'Error!',
	                alertMsg: 'The management server version is incompatible with this version of the client.',
	                alertOk: 'OK',
	                lbWidth: 420,
	                top_extra: 50
				});
			}
			else if( success == '-10' ){
				$('#b_connect_s').chLightbox('destroy'); 
				$('#b_connect_s').chLightbox('alert', {
					alertTitle: 'Error!',
	                alertMsg: 'Invalid Username or Password',
	                alertOk: 'OK',
	                lbWidth: 420,
	                top_extra: 50
				});
			}
			else{
				$('#b_connect_s').chLightbox('lbChangeStaus', {
					lbLdStatus: 'Building menu... '
				});
				var pwd = $('.lb_fieldset #b_p_pwd').val();
				var ip  = $('#modalogContent #b_ip').val();
				var getdata = 'sid='+sid+'&ip='+ip+'&username='+username+'&pwd='+pwd;
				var ipid = replace_with(ip,'.','_');
				$.ajax({
					url:  '/python/py_menu.py',
					type: 'GET',
					cache: false,
					data: getdata,
					success: function(data){
						if (data == '-2') {
							show_redirect_alert();
						}
						else if (data != '-1') {
							generate_menu();
							$('.b_main .btn_wraper button').removeAttr('class').addClass('btn disabled').attr('disabled','disabled');
							$('#b_systems li').removeClass('selected');
							//load_right_unique_content('system_content__incend__'+ipid);
							$('#b_connect_s').chLightbox('destroy');
							/*try{
								setTimeout("right_tabs_slide($('#system_content__incend__"+ipid+" .ch_fn4') ,'system_summary.html','fill_system_summary',true)",500);
							}
							catch(e){}*/
						}
						else {
							$('#b_connect_s').chLightbox('destroy');
							$('#b_connect_s').chLightbox('alert', {
								alertTitle: 'Error!',
								alertMsg: 'System Connect failed. There is a pre-existing connection to the system from a management client. \
										   <br/><br/>A new connection can be established only on disconnecting the old connection or restarting the \
										   management service on the managed system or your current session has expired.<br/> <br/>If the problem persists \
										   try signing out and signing in again.',
								alertOk: 'OK',
								lbWidth: 420,
								top_extra: 50
							});
						}
					}
				});
			}
		}
	});
}

function load_right_content(src){
	var id = src.replace('.html','');
	$('#global_loader .init_loader span').html('Loading..');
	$('#global_loader').show();
	if ( !$('#' + id).length ) {
		$.ajax({
			url:  src,
			type: 'GET',
			cache: false,
			success: function(data){
				$('#right_content').prepend(data)
				page_init();
				$('#global_loader,.right_content_wrapper').hide();
				$('#' + id).fadeIn(300);
				$('#'+id+ ' .fn_tab div.close').append('<a href="javascript:void(0)" onclick="show_help($(this))" class="main_help"></a>');
			}
		});
	}
	else{
		$('#global_loader,.right_content_wrapper').hide();
		$('#' + id).fadeIn(300);
	}
}

function load_right_unique_content(value){
	$('#global_loader .init_loader span').html('Loading..');
	$('#global_loader').show();
	
	var src = value.split('__inc')[0]+'.html';
	var ip_id = value.split('end__')[1];
	var part_id = value.split('__')[0] + '__' + value.split('__')[1];
	var unique_id = part_id + '__' + ip_id;
	
	if ( !$('#'+unique_id).length ) {
		$.ajax({
			url:  src,
			type: 'GET',
			cache: false,
			success: function(data){
				var html = '<div id="'+unique_id+'" class="as_hide right_content_wrapper '+ ip_id +'">'+ data +'</div>';
				$('#right_content').prepend(html);
				$('#global_loader,.right_content_wrapper').hide();
				var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
				if (src == 'system_content.html') {
					var is_kvm = $.trim($('#ip_' + ip_id + ' .selected').children('.kvm').val());
					var kvm_status = $.trim($('#ip_' + ip_id + ' .selected').children('.kvm_status').val());
					var is_hyperv = $.trim($('#ip_' + ip_id + ' .selected').children('.hyperv').val());
					var license = $.trim($('#ip_' + ip_id + ' .system_link').children('.license').val());
					if (ostype == '8') {
						if (license == '1') {
							//Xen
							$('#' + unique_id + ' .xen_panel_show').show();
						}
					}
					else if(is_kvm == 'yes') {
						if (license == '1') {
							//Enable/Disable KVM panel , show for all kvm capable machines - if "kvm" is present in the capabilities
							$('#' + unique_id + ' .linux_kvm_capable_show').show();
							//Display all KVM panels - show only when getKVMStatus() returns status as enabled
							if (kvm_status == 'yes') {
								$('#' + unique_id + ' .linux_kvm_show').show();
							}
						}
					}
					else if(is_hyperv == 'yes' ){
						if (license == '1') {
							$('#' + unique_id + ' .win_vm_panel_show').show();
						}
					}
					
					//show only for licensed win, freebsd, linux agents
					if(license == '1') {
						if (ostype == '1' || ostype == '2' || ostype == '4' || ostype == '8' ) {
							$('#' + unique_id + ' .fn_diags_tab').show();
						}
					}
					if((ostype == '3') || (ostype == '4') || (ostype == '5') || (ostype == '6')){
					 	$('#' + unique_id + ' .system_um_update').hide();
					}
					
				}
				else if (src == 'card_content.html') {
					var card_type = $.trim($('#ip_' + ip_id + ' .selected').children('.chiptype').val());
					if ( ostype == '1' ) {
						//Windows						
						$('#' + unique_id + ' .tcp_offload_fntab').show();
						$('#' + unique_id + ' .tcp_offload_fntab .card_heading').html('Device Driver Settings');
						$('#' + unique_id + ' .cardstats_fntab').show();
					}
					else if ( ostype == '2' ){
						//Linux
						$('#' + unique_id + ' .tcp_offload_fntab').show();
						$('#' + unique_id + ' .cardstats_fntab').show();
					}
					else if ( ostype == '4' ){
						//FBSD	
						$('#' + unique_id + ' .tcp_offload_fntab').show();
						//$('#' + unique_id + ' .cardstats_fntab').show();
					}
					else if ( ostype == '5' ){
						//ESX
						//$('#' + unique_id + ' .cardstats_fntab').show();
					}
					else if ( ostype == '6' ){
						//MAC
						//$('#' + unique_id + ' .tcp_offload_fntab').show();
						//$('#' + unique_id + ' .cardstats_fntab').show();
					}
					else if ( ostype == '7' ){
						//USS
						$('#' + unique_id + ' .tcp_offload_fntab').show();
						$('#' + unique_id + ' .cardstats_fntab').show();
					}
					else if ( ostype == '8' ){
						//Xen
						$('#' + unique_id + ' .tcp_offload_fntab').show();
						$('#' + unique_id + ' .cardstats_fntab').show();
					}

					if ( $.trim($('#ip_' + ip_id + ' .system_link').children('.license').val()) == '0'  ) {
						$('#' + unique_id + ' .tcp_offload_fntab').hide();
						$('#' + unique_id + ' .cardstats_fntab').hide();
					}
					
					if(card_type == 'T4'){
						$('#' + unique_id + ' .t4_specific_fntab').show();
					}
				}
				else if(src == 'network_content.html'){
					 if (ostype != '5') {
					 	$('#' + unique_id + ' .fn_nw_team').show();
						$('#' + unique_id + ' .fn_nw_nts').show();
					 }
				}
				else if(src == 'fcoe_maincontent.html'){
					var is_fcoe = $.trim($('#ip_' + ip_id + ' .selected').children('.is_fcoe').val());
					/*if ( is_fcoe == 'true' ){
						$('#' + unique_id + ' .fcoe_enabled_panel').show();
					}*/
				}
				/*else if(src == 'fport_content.html'){
					if( $.trim($('#ip_' + ip_id + ' .selected').children('.fport_mac').val()) != 'Not Available' && $.trim($('#ip_' + ip_id + ' .selected').children('.fport_mac').val()) != 'undefined'  ){
						$('#' + unique_id + ' .fport_stats').show();
						$('#' + unique_id + ' .fport_npiv').show();
					}
				}*/
				else if(src == 'boot_content.html'){
					 if ( $('#ip_' + ip_id + ' .t4').length && ( $('#ip_' + ip_id + ' .t3').length ) ) {
					 	$('#' + unique_id + ' .fn_tab').show();
					 }
					 else if ( $('#ip_' + ip_id + ' .t4').length ) {
					 	$('#' + unique_id + ' .t4_boot_tab').show();
					 }
					 else if ( $('#ip_' + ip_id + ' .t3').length ) {
					 	$('#' + unique_id + ' .iscsi_boot_tab').show();
					 }
					 else if ( $('#ip_' + ip_id + ' .ncard').length ) {
					 	$('#' + unique_id + ' .iscsi_boot_tab').show();
					 }
					 
					 if(ostype == '5'){
					 	$('#' + unique_id + ' .iscsi_boot_tab').hide();
					 }
					 else if(ostype == '4'){
					 	$('#' + unique_id + ' .os_4').hide();
					 }
					 else if(ostype == '8' || ostype == '2'){
					 	$('#' + unique_id + ' .os_'+ostype).show();
					 }   
				}
				else if(src == 'filtering_content.html'){
					$('#' + unique_id + ' .os_'+ostype).show();
				}
				$('#'+unique_id).fadeIn(300);
				$('#'+unique_id+ ' .fn_tab div.close').append('<a href="javascript:void(0)" onclick="show_help($(this))" class="main_help"></a>');
				if( $('#'+unique_id).find('.fn_tab').length == 1){
					$('#'+unique_id+' .fn_tab h2').trigger('click');
				}
			}
		});
	}
	else{
		$('#global_loader,.right_content_wrapper').hide();
		$('#'+unique_id).fadeIn(300);
		//$('#'+unique_id+' .fn_tab h2').trigger('click');
	}
}

function load_subscribtion_page(){
	$.ajax({
		url:  '/subscribe.html',
		type: 'GET',
		cache: false,
		success: function(data){
			$('#global_loader').hide();
			$('.subscribe').chLightbox('ajax', {
				lbTitle: 'Email Alert',
	            lbOk: 'Save',
				lbCancel: 'Close',
				ajaxStatus:'Saving...',
				ajaxHtml:data,
				lbWidth: 420
			});
		}
	});	
}

function invoke_refresh(){
	var shown_len = $('#m_tree_wrap .tree.shown').length;
	if ( !shown_len ){
		$('#b_connect_s').chLightbox('lbShowStaus');
		window.location.reload();
	}
	else{
		var ip_id = $('.details h1.show').attr('id').replace('rm_pc_','');
		var ip = replace_with(ip_id, '_', '.');
		refresh_system(ip);
	}
}

function refresh_system(ip){
	var ip_id = replace_with(ip, '.', '_');
	$('.'+ip_id).remove();
	$('.dummy').chLightbox('destroy');
	$('#global_loader').show();	
	var xml_name = GetCookie("chelsio_webgui_user")+'_menu.xml';
	var getdata = 'ip='+ ip +'&filename='+xml_name
	$.ajax({
		url: '/python/remove_system_node.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				show_redirect_alert();
			}
			else if( data == '0' ){
				var sid = GetCookie("chelsio_webgui_sid");
				var username = GetCookie("chelsio_webgui_user");
				var getdata = 'sid='+sid+'&ip='+ip+'&username='+username;
				$.ajax({
					url:  '/python/py_menu.py',
					type: 'GET',
					cache: false,
					data: getdata,
					success: function(data){
						if ( data == '-2' ){
							show_redirect_alert();
						}
						else if (data != '-1') {
							var ip_id = replace_with( ip , '.' , '_' )
							generate_menu();
							$('#system_content__'+ip_id).remove();
							//load_right_unique_content('system_content__incend__'+ip_id);
							$('#global_loader').hide();
							$('.dummy').chLightbox('destroy');
							$('.dummy').chLightbox('alert', {
								alertTitle: 'Success!',
								alertMsg: 'Succesfully Refreshed The System',
								alertOk: 'OK',
								//successfn: "right_tabs_slide($('.ch_fn4'),'system_summary.html','fill_system_summary',true);$('.dummy').chLightbox('destroy');",
								successfn: "$('.dummy').chLightbox('destroy');",
								lbWidth: 420,
								top_extra: 50
							});
						}
						else {
							$('#global_loader').hide();	
							$('#b_connect_s').chLightbox('destroy');
							$('#b_connect_s').chLightbox('alert', {
								alertTitle: 'Error!',
								alertMsg: 'Menu Generation Failed. Please try again later, if the problem persists try signing out and signing in again.',
								alertOk: 'OK',
								lbWidth: 420,
								top_extra: 50
							});
						}
					}
				});
			}			
		}
	});	
}

function load_panel_page(element,page,initial_fn,arg){
	
	if( arg ){
		var ip_id = $(element).parent().parent().parent().attr('id').split('__')[2]
		if (initial_fn) {
			initial_fn = initial_fn + '("' + ip_id + '")';
		}
	}
	
	if ($(main_content_element).css('display') == 'none') {
		$(main_content_element).slideDown(300,function(){
			if(!$(main_content_element).children('.content_wrapper').length){
				load_fntab_page(page,main_content_element,initial_fn);
			}
			else{
				$(main_content_element).children(' .content_wrapper').fadeIn(300);
				if (initial_fn) {
					eval(initial_fn);
				}
			}
		});
		$(element).parent().parent().parent().find('.open').removeAttr('class').addClass('close');
		$(element).parent().removeAttr('class').addClass('open');
	}
	else{
		$(main_content_element).slideUp(300);
		$(element).parent().parent().parent().find('.open').removeAttr('class').addClass('close');
	}
}

function expand_shrink(expand){
	
	/*var is_minus = $.trim($('#m_tree_wrap .tree.shown .fcoe_lport').prev().children().attr('src'));
	if ( is_minus != '/images/black/tree_minus.png'){
		expand = false;
	}
	
	var fcoe_port = $('#m_tree_wrap .tree.shown .fcoe_lport').parent().parent();
	var fcoe_port_parent = fcoe_port.parent().parent();
	var fcoe_port_parent1 = fcoe_port_parent.parent().parent();
	var fcoe_port_parent2 = fcoe_port_parent.parent().parent();
	
	if ( is_minus == '/images/black/tree_minus.png' && fcoe_port.css('display') == 'block' && fcoe_port_parent.css('display') == 'block' && fcoe_port_parent1.css('display') == 'block' && fcoe_port_parent2.css('display') == 'block'){
		expand = true;
	}*/
	
	if ($('#size-stylesheet').attr('href') == 'css/elastic.css') {
		if (expand && $('#is_expand').val() == 'no') {
			$('.left_top_nav').animate({
				'left': '25%'
			});
			$('.left_col').animate({
				'left': '1%',
				'width': '23%'
			});
			$('.right_col').animate({
				'left': '25%',
			});
			$('#is_expand').val('yes');
		}
	}
	
	/*
	else if( !expand && $('#is_expand').val() == 'yes' ){
		$('.left_top_nav').animate({
			'left': '2%',
			'width' : '19%'
		});
		$('.left_col').animate({
			'left': '2%',
			'width' : '20%'
		});
		$('.right_col').animate({
			'left': '24%',
		});
		$('#is_expand').val('no');
	}*/
}
