function fill_t4_filtering_conf(ip_id){
	var unique_parent_id = '#filtering_content__incend__' + ip_id+' .t4_filtering_conf_tab';
	var loader_selector = unique_parent_id + ' .initializer';
	$(loader_selector).hide();

	if( $(loader_selector).css('display') == 'block' || $(unique_parent_id +' .overlay_disp_wr .ch_popup').css('display') == 'block' ){
		return
	}
	
	t4_fl_discard_changes(unique_parent_id);
	$(loader_selector).show();
	var ip = replace_with(ip_id, '_', '.');
	var sid = GetCookie("chelsio_webgui_sid");
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var getdata = 'sid=' + sid + '&ip=' + ip + '&req_type=desktop&ostype='+ostype;
	
	//Initializing
	$(unique_parent_id +' .refresh').attr('onclick','fill_t4_filtering_conf("'+ ip_id +'")');

	$(unique_parent_id +' .t4_fl_set_comb_wr').attr('onclick','t4_fl_set_comb("'+ loader_selector +'", "'+ unique_parent_id +'", "'+ getdata +'", "'+ ip_id +'")');
	$(unique_parent_id+' .second_wr li').attr('onclick','t4_fl_comb_select("'+ unique_parent_id +'", "'+ getdata +'", $(this), "'+ ip_id +'")');
	$(unique_parent_id+' .t4_fl_ad_filter').attr('onclick','t4_fl_add_filter("'+ unique_parent_id +'", "'+ ip_id +'", "'+ getdata +'")');
	$(unique_parent_id+' .t4_fl_delete_filter').attr('onclick','t4_fl_delete_filter("'+ unique_parent_id +'", "'+ getdata +'")');
	$(unique_parent_id+' .t4_fl_save').attr('onclick','t4_fl_save_filter("'+ unique_parent_id +'", "'+ getdata +'")');
	$(unique_parent_id+' .t4_fl_discard').attr('onclick','t4_fl_discard_changes("'+ unique_parent_id +'")');
	//t4_fl_get_intial_data(loader_selector, unique_parent_id, getdata);

	var card_list = '';
	var total_cards = $('#ip_' + ip_id + ' .card').length-1;
	var regex_match = /^(T4|B4)/;
	var t4_present=0;
	var t4_pci="";
	var t5_pci="";
	var t5_present=0;
	var serial_input = '';
	var card_list = '<select class="mgn_l10" onchange="t4_fl_get_intial_data('+'\''+loader_selector+'\''+ ', ' +'\''+ unique_parent_id+'\'' +', '+ '\''+getdata+'\'' +');" title="pci_info"><option value="null">Select One..</option>';
	$('#ip_' + ip_id + ' .card').each(function(i){
		var chiptype = $.trim($(this).children('.chiptype').val());
		if( chiptype == 'T4' ){ // chip type is same for T5 and T4.
			if(regex_match.test($(this).children('.tree_cardname').html())){
			      t4_present =1;
			      t4_pci = $(this).children('.pciloc').val(); // pci location of any T4 card
			      

		        }else{
			      t5_present =1;
			      t5_pci = $(this).children('.pciloc').val();
				
			}
		}
	});
	
	if(t4_present){

		card_list += '<option value="'+t4_pci+'" >'+ 'T4'+'</option>';
	}
	if(t5_present){

		card_list += '<option value="'+t5_pci+'" >'+ 'T5'+'</option>';
	}
	card_list += '</select>';
	$(unique_parent_id+' .t4_filter_conf_card_wr').html(card_list);

	//PR 19555
	$(loader_selector).hide();
}

function t4_fl_get_intial_data(loader_selector, unique_parent_id, getdata){
	getdata += '&action=get_initial_data';
		
	var pci_str = $.trim($(unique_parent_id+' .mgn_l10 option:selected').val());
	var card_name = $.trim($(unique_parent_id+' .mgn_l10 option:selected').text());
	var card_type = "";
	var t5_match = /^T5/;
	var t4_match = /^(T4|B4)/;
	if(t5_match.test(card_name)){
		card_type = "T5";

	}else if(t4_match.test(card_name)){
		card_type = "T4";
	}
	
	if(pci_str != 'null'){
			$(unique_parent_id+' .combination_list').show();
			$(unique_parent_id+' .active_comb').show();
	}else{
			$(unique_parent_id+' .combination_list').hide();
			$(unique_parent_id + ' .active_comb').html("");
			return ;

	}

	getdata += '&pci_str='+pci_str;

	$.ajax({
		url: '/python/t4_filtering_conf.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(loader_selector).hide();
			if (data['status'] == '-2' || data['status1'] == '-2') {
				show_redirect_alert();
				return
			}
			
			if ( data['status'] == '0' ) {
				var active_comb = data['active_comb'];
				var active_comb_list  = active_comb.split("\n");
				var regex = new RegExp(card_type, "i");
				for (i=0; i< active_comb_list.length; i++){
					if (active_comb_list[i].match(regex)){
						active_comb = active_comb_list[i];
					}
				}
				
				$(unique_parent_id + ' .active_comb').html(active_comb);
				var active_comb_class = replace_with(active_comb, ' ' , '');
				active_comb_class = replace_with(active_comb_class, ',' , '_');
				active_comb_class = active_comb_class.replace(/^.*?:\s*/gi, ""); 
				
				$(unique_parent_id + ' .second_wr li span').hide();
				$(unique_parent_id + ' .'+active_comb_class+' span').show();
			}
			
			if ( data['status1'] == '0' ) {
				var current_comb = data['current_comb'];
				if (current_comb != '264') {
				
					var current_comb_class = replace_with(current_comb, ' ', '');
					current_comb_class = replace_with(current_comb_class, ',', '_');
					var current_comb_arr = current_comb_class.split('#');
					var len = current_comb_arr.length - 1;
					if (len == 0) {
						var temp_comb_class = current_comb_arr;
						$(unique_parent_id + " ." + temp_comb_class).prependTo(unique_parent_id + "  .ul_menu");
					}
					else {
						for (i = 0; i < current_comb_arr.length; i++) {
							var temp_comb_class = current_comb_arr[i];
							$(unique_parent_id + " ." + temp_comb_class).prependTo(unique_parent_id + "  .ul_menu");
						}
					}
				}
			}
			
			if (data['status'] == '-1' && data['status1'] == '-1') {
				show_error_msg(unique_parent_id, 'Failed to retrieve the "Acitve and Current Combination" details.');
				return				
			}
			
			if (data['status'] == '-1') {
				show_error_msg(unique_parent_id, 'Failed to retrieve the Acitve Combination detail.');		
			}
			
			if (data['status1'] == '-1') {
				show_error_msg(unique_parent_id, 'Failed to retrieve the Current Combination details.');		
			}
		}
	});
}

function t4_fl_set_comb(loader_selector, unique_parent_id, getdata, ip_id){
	$(loader_selector).show();
	var html_str = $(unique_parent_id+' .second_wr li.selected').html();
	$(unique_parent_id+' .second_wr li.selected span').remove();
	var comb_str = $(unique_parent_id+' .second_wr li.selected').html();
	
	$(unique_parent_id+' .second_wr li.selected').html(html_str);
	getdata += '&action=set_comb'+'&comb_str='+comb_str;

	var pci_str = $.trim($(unique_parent_id+' select[title=pci_info]').val());
	getdata += "&pci_str="+pci_str;
	$.ajax({
		url: '/python/t4_filtering_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(html){
			$(loader_selector).hide();
			if (html == '-2') {
				show_redirect_alert();
			}
			else if (html != '-1') {
				fill_t4_filtering_conf(ip_id);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});
}

function t4_fl_comb_select(unique_parent_id, getdata, element, ip_id){
	$(unique_parent_id+' .fourth_wr').hide();
	$(unique_parent_id+' .fourth_wr .grid').html('');
	$(unique_parent_id+' .t4_fl_set_comb_wr button').removeClass('disabled').removeAttr('disabled').addClass('blue');
	$(unique_parent_id + ' .initializer').show();
	$(unique_parent_id+' .second_wr li').removeClass('selected');
	$(element).addClass('selected');
	var html_str = $(unique_parent_id+' .second_wr li.selected').html();
	$(unique_parent_id+' .second_wr li.selected span').remove();
	var comb_str = $(unique_parent_id+' .second_wr li.selected').html();
	$(unique_parent_id+' .second_wr li.selected').html(html_str);
	getdata += '&action=get_comb_filters'+'&comb_str='+comb_str;
	
	if( element.children('span').css('display') == 'inline' ){
		getdata += "&is_active=1";		
	}
	else{
		getdata += "&is_active=0";
	}
	
	var pci_str = $.trim($(unique_parent_id+' select[title=pci_info]').val());
	getdata += "&pci_str="+pci_str;
	
	$('#ip_' + ip_id + ' .card').each(function(i){
		var chiptype = $.trim($(this).children('.chiptype').val());
		if( chiptype == 'T4' ){
			getdata += '&t4_card='+$.trim($(this).children('.tree_cardname').html())+'__'+$.trim($(this).children('.pciloc').val());
		}
	});
	$.ajax({
		url: '/python/t4_filtering_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(data){
			$(unique_parent_id + ' .initializer').hide();
			if (data['status'] == '-2') {
				show_redirect_alert();
			}
			else if (data['len'] == 0 ) {
				$(unique_parent_id+' .fourth_wr').hide();
				$(unique_parent_id).animate({
					'height' : '400px'
				},300);
				$(unique_parent_id+' .t4_fl_delete_filter button').addClass('disabled').attr('disabled','disabled');
				$(unique_parent_id+' .t4_fl_save button').removeClass('disabled').removeClass('blue').addClass('disabled').attr('disabled','disabled');
				$(unique_parent_id+' .t4_fl_ad_filter button').removeClass('disabled').addClass('yellow').removeAttr('disabled');
			}
			else if (data['status'] == '0') {
				$(unique_parent_id+' .fourth_wr').fadeIn(300);
				$(unique_parent_id+' .fourth_wr .grid').html(data['html']).css('width',data['width']+'px')
				$(unique_parent_id).animate({
					'height' : data['height']+'px'
				},300);
				$(unique_parent_id+' .t4_fl_ad_filter button').removeClass('disabled').addClass('yellow').removeAttr('disabled');
				$(unique_parent_id+' .t4_fl_save button').removeClass('disabled').removeAttr('disabled').addClass('blue');
			}
			else if (data['status'] == '264') {
				/*$(unique_parent_id+' .fourth_wr').fadeIn(300);
				$(unique_parent_id+' .fourth_wr .grid').html(data['html']).css('width',data['width']+'px')
				$(unique_parent_id).animate({
					'height' : data['height']+'px'
				},300);*/
				$(unique_parent_id+' .t4_fl_ad_filter button').removeClass('disabled').addClass('yellow').removeAttr('disabled');
				/*$(unique_parent_id+' .t4_fl_save button').removeClass('disabled').removeAttr('disabled').addClass('blue');*/
			}
			else{
				display_failed(unique_parent_id);
				$(unique_parent_id+' .fourth_wr').hide();
				$(unique_parent_id).animate({
					'height' : '400px'
				},300);
				$(unique_parent_id+' .t4_fl_save button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
				$(unique_parent_id+' .t4_fl_delete_filter button,'+unique_parent_id+' .t4_fl_ad_filter button').removeClass('yellow').addClass('disabled').attr('disabled','disabled');
			}
		}
	});
}

function t4_fl_add_filter(unique_parent_id, ip_id, getdata){
	//Filters exists
	if( $(unique_parent_id+' .fourth_wr .grid ul').length ){
		var height = $(unique_parent_id).css('height');
		height = parseInt(height)+40; 
		$(unique_parent_id).animate({
			'height' : height+'px'
		},300);
		var clone_html = $(unique_parent_id+' .fourth_wr .grid .rules_ul:last').clone();
		$(unique_parent_id+' .fourth_wr .grid .rules_ul:last').after(clone_html);
		//Since the newly added filter row fid li doesnt have span which holds the fid. The length should be calculate with the rules_ul length
		var fid = $(unique_parent_id+' .fourth_wr .grid .rules_ul').length+1;
		var new_fid = (unique_parent_id+'_'+fid).replace('#','');
		new_fid = replace_with( new_fid , ' ' , '' );
		new_fid = replace_with( new_fid , '.' , '_' );  
		//To differentiate b/w newly added filter row and existing filter row. 
		$(unique_parent_id+' .fourth_wr .grid .rules_ul:last').addClass('fl_add').attr('id',new_fid).removeClass('fl_mod');
		//Making all the values to empty incase of textbox and null incase of select box
		$(unique_parent_id+' .fourth_wr .grid .rules_ul:last input').val('').removeAttr('name').attr('name','value_');
		$(unique_parent_id+' .fourth_wr .grid .rules_ul:last select').val('null').removeClass().addClass('value_null');
		$(unique_parent_id+' .fourth_wr .grid .rules_ul:last .fid').html('<input type="text" value="" class="xsml text fid_input" onkeyup="$(this).removeClass(\'error\');digit_validate($(this))" />');
		$(unique_parent_id+' .fourth_wr .grid .rules_ul:last .actionCmd').html('');
		$(unique_parent_id+' .fourth_wr .grid .rules_ul:last select').removeAttr('disabled');
		$(unique_parent_id+' .t4_fl_save button').removeClass('disabled').removeAttr('disabled').addClass('blue');
	}
	else if( $(unique_parent_id+' .ul_menu li.selected') ){
		$(unique_parent_id + ' .initializer').show();
		getdata += '&action=filter_row&comb_str='+get_comb_str(unique_parent_id);
		
		$('#ip_' + ip_id + ' .card').each(function(i){
			var chiptype = $.trim($(this).children('.chiptype').val());
			if( chiptype == 'T4' ){
				getdata += '&t4_card='+$.trim($(this).children('.tree_cardname').html())+'__'+$.trim($(this).children('.pciloc').val());
			}
		});
		
		$.ajax({
			url: '/python/t4_filtering_conf.py',
			type: 'GET',
			dataType: 'json',
			data: getdata,
			success: function(data){
				$(unique_parent_id + ' .initializer').hide();
				$(unique_parent_id+' .fourth_wr').fadeIn(300);
				$(unique_parent_id+' .fourth_wr .grid').html(data['html']).css('width',data['width']+'px')
				$(unique_parent_id).animate({
					'height' : '490px'
				},300);
				$(unique_parent_id+' .t4_fl_ad_filter button').removeClass('disabled').addClass('yellow').removeAttr('disabled');
				$(unique_parent_id+' .t4_fl_save button').removeClass('disabled').removeAttr('disabled').addClass('blue');
			}
		});	
	}
}

function t4_fl_save_filter(unique_parent_id, postdata){
	var all_uique_id_flag = true;
	$(unique_parent_id + ' .initializer').show();
	var post_initial_data = postdata;
	if ($(unique_parent_id + ' .fl_add').length) {
		//Add
		var success = true;
		$(unique_parent_id+' .fl_add .fid input').each(function(){
			if($.trim($(this).val()) == ''){
				$(this).addClass('error');
				success = false;
			}
			else{
				var fid = $(this).val();
				$(this).parent().removeClass().addClass('label fid fid_'+fid);
			}
		});
		
		$(unique_parent_id+' .fl_add select[title=pci]').each(function(){
			if($.trim($(this).val()) == 'null'){
				$(this).addClass('error');
				success = false;
			}
		});
		
		if(!success){
			$(unique_parent_id + ' .initializer').hide();
			return
		}
		
		var fid_count = 0;
		$(unique_parent_id+' .fl_add').each(function(){
			var ul_id = '#'+$(this).attr('id');
			var properties_count = 0;
			$(ul_id+' select:not([title=pci]').each(function(){
				if ( $.trim($(this).attr('class').replace('value_', '')) != $.trim($(this).val())) {
					postdata += '&propname=' + $(this).attr('title');
					postdata += '&value=' + $(this).val();
					properties_count += 1;
				}
			});
			
			$(ul_id+' input[type=text]:not(.fid_input)').each(function(){
				if( $.trim($(this).val()) != '' ){
					postdata += '&propname='+$(this).attr('title');
					postdata += '&value='+$(this).val();
					properties_count += 1;
				}
			});
			
			if( properties_count){
				var fid = $.trim($(ul_id+' .fid input').val());
				if( $(unique_parent_id+' .fl_add .fid_'+fid).length > 1 || $(unique_parent_id+' .fl_mod .fid_'+fid).length ){
					$(ul_id+' .fid input').addClass('error');
					show_error_msg(unique_parent_id, 'Filter ID should be unique. Filter Id: <span class="red_f">'+fid+'</span> has more than one occurance.');
					all_uique_id_flag = false;
					return
				}
				postdata += '&fid='+fid;
				postdata += '&properties_count_'+ fid +'='+properties_count;
				fid_count += 1;
				
				var curr_pci = $.trim($(ul_id+' select[title=pci]').val());
				postdata += '&pci='+curr_pci;
			}
			else{
				show_error_msg(unique_parent_id, "You didn't provide any value for the filter id : "+ $.trim($(ul_id+' .fid input').val()) +" .");
				all_uique_id_flag = false;
			}
			
		});
		
		if( !all_uique_id_flag ){
			$(unique_parent_id + ' .initializer').hide();
			return;
		}
		
		if (!fid_count) {
			$(unique_parent_id + ' .initializer').hide();
			return;
		}
		else{
			postdata += '&filter_count='+fid_count+'&comb_str='+get_comb_str(unique_parent_id);
			postdata += '&action=save&action_type=add';
			$.ajax({
				url: '/python/t4_filtering_conf.py',
				type: 'POST',
				cache: false,
				data: postdata,
				success: function(status){
					$(unique_parent_id + ' .initializer').hide();
					if (status == '-2') {
						show_redirect_alert();
					}
					else if (status == '0') {
						t4_fl_save_modified(unique_parent_id, post_initial_data);
						//$(unique_parent_id+' .ul_menu li.selected').trigger('click');
						//display_success(unique_parent_id);
					}
					else{
						display_failed(unique_parent_id);
					}
				}
			});	
		}
	}
	else{
		t4_fl_save_modified(unique_parent_id, postdata);
	}
}

function t4_fl_save_modified(unique_parent_id, postdata){
	//Modify
	$(unique_parent_id + ' .initializer').show();
	
	var fid_count = 0;
	$(unique_parent_id+' .fl_mod').each(function(){
		var ul_id = '#'+$(this).attr('id');
		var properties_count = 0;
		$(ul_id+' select:not([title=pci])').each(function(){
			if ( $.trim($(this).attr('class').replace('value_', '')) != $.trim($(this).val())) {
				postdata += '&propname=' + $(this).attr('title');
				postdata += '&value=' + $(this).val();
				properties_count += 1;
			}
		});
		
		$(ul_id+' input[type=text]').each(function(){
			if( $(this).attr('name').replace('value_','') != $(this).val() ){
				postdata += '&propname='+$(this).attr('title');
				postdata += '&value='+$(this).val();
				properties_count += 1;
			}
		});
		
		if( properties_count){
			var fid = $.trim($(ul_id+' .fid input').val());
			postdata += '&fid='+fid;
			postdata += '&properties_count_'+ fid +'='+properties_count;
			fid_count += 1;
			var curr_pci = $.trim($(ul_id+' select[title=pci]').val());
			postdata += '&pci='+curr_pci;
		}
		
	});
	
	if (!fid_count) {
		$(unique_parent_id + ' .initializer').hide();
		$(unique_parent_id+' .ul_menu li.selected').trigger('click');
		return;
	}
	else{
		postdata += '&filter_count='+fid_count+'&comb_str='+get_comb_str(unique_parent_id);
		postdata += '&action=save&action_type=modify';
		$.ajax({
			url: '/python/t4_filtering_conf.py',
			type: 'POST',
			cache: false,
			data: postdata,
			success: function(status){
				$(unique_parent_id + ' .initializer').hide();
				if (status == '-2') {
					show_redirect_alert();
				}
				else if (status == '0') {
					$(unique_parent_id+' .ul_menu li.selected').trigger('click');
					//display_success(unique_parent_id);
				}
				else{
					display_failed(unique_parent_id);
				}
			}
		});	
	}
}

function t4_fl_discard_changes(unique_parent_id){
	$(unique_parent_id+' .second_wr li').removeClass('selected');
	$(unique_parent_id+' .active_comb').hide();
	$(unique_parent_id+' .fourth_wr').hide();
	$(unique_parent_id+' button:not(.t4_fl_discard_btn)').removeClass('blue').addClass('disabled').attr('disabled','disabled');
	$(unique_parent_id+' .t4_fl_ad_filter button').removeClass('yellow').addClass('disabled').attr('disabled','disabled');
	$(unique_parent_id).animate({
		'height' : '400px'
	},300);
}

function get_comb_str(unique_parent_id){
	var html_str = $(unique_parent_id+' .second_wr li.selected').html();
	$(unique_parent_id+' .second_wr li.selected span').remove();
	var comb_str = $(unique_parent_id+' .second_wr li.selected').html();
	$(unique_parent_id+' .second_wr li.selected').html(html_str);
	return comb_str
}

function t4_fl_filterid_chk(unique_parent_id){
	if($(unique_parent_id+' .fid_chk').is(':checked')){
		$(unique_parent_id+' .t4_fl_delete_filter button').removeClass('disabled').removeAttr('disabled').addClass('yellow');
	}
	else{
		$(unique_parent_id+' .t4_fl_delete_filter button').removeClass('yellow').addClass('disabled').attr('disabled','disabled');
	}
}

function t4_fl_delete_filter(unique_parent_id, getdata){
	$(unique_parent_id + ' .initializer').show();
	getdata += '&action=delete_filter&comb_str='+get_comb_str(unique_parent_id);
	
	var fid = '';
	$(unique_parent_id+' .fid_chk:checked').each(function(){
		var t_fid = $(this).val();
		var t_pci = $(this).parent().next().children('select').val();
		var del_str = t_fid+'__'+t_pci;
		fid += ','+del_str+',';
	});
	getdata += '&fid='+fid;
	
	$.ajax({
		url: '/python/t4_filtering_conf.py',
		type: 'GET',
		data: getdata,
		success: function(status){
			$(unique_parent_id + ' .initializer').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				$(unique_parent_id+' .ul_menu li.selected').trigger('click');
				$(unique_parent_id+' .t4_fl_delete_filter button').removeClass('yellow').addClass('disabled').attr('disabled','disabled');
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});		
}
