function fill_linux_vf_conf(ip_id){
	
	var unique_parent_id = '#system_content__incend__'+ ip_id+' .system_linux_vf_conf_tab';
	
	if( $(unique_parent_id+' .vm_wr ul').length ){
		return
	}
	
	$(unique_parent_id+' .initializer').show();
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip;
	
	$(unique_parent_id + ' .refresh a').attr('onclick', '$("' + unique_parent_id + ' .vm_wr").html("");$("' + unique_parent_id + ' .vf_wr").html("");$("' + unique_parent_id + ' .free_vf_wr").html("");fill_linux_vf_conf("' + ip_id + '")');
	$(unique_parent_id + ' .add_vf_vm').attr('onclick','lin_add_vfs_to_vm("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'" )');
	$(unique_parent_id + ' .remove_vf_vm').attr('onclick','lin_kvm_show_popup("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'" )');
	load_lin_vf_data(unique_parent_id, getdata);
}

function load_lin_vf_data(unique_parent_id, getdata){
	getdata += '&action=get&type=desktop'
	$.ajax({
		url: '/python/lin_vf_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data.vm_html != '-1' && data.mapped_vf_html != '-1' && data.free_vf_html != -1 ) {
				$(unique_parent_id+' .vm_wr').html(data.vm_html);
				$(unique_parent_id+' .vf_wr').html(data.mapped_vf_html);
				$(unique_parent_id+' .free_vf_wr').html(data.free_vf_html);
			}
		}
	});	
}

function select_lin_vm(unique_parent_id, element, vmid){
	$(unique_parent_id+' .vm_wr li').removeClass('selected');
	element.addClass('selected');
	toggle_button(unique_parent_id);
	$(unique_parent_id+' .vf_wr li').hide();
	$(unique_parent_id+' .vf_wr .vm_'+vmid).fadeIn(300);
	
}

function select_free_vf(unique_parent_id, element){
	if( element.hasClass('selected') ){
		element.removeClass('selected');
	}
	else{
		element.addClass('selected');		
	}
	toggle_button(unique_parent_id);
}

function select_mapped_vf(unique_parent_id, element){
	if( element.hasClass('selected') ){
		element.removeClass('selected');
	}
	else{
		element.addClass('selected');		
	}
	toggle_button(unique_parent_id);
}

function toggle_button(unique_parent_id){
	if( $(unique_parent_id+' .vm_wr li.selected').length && $(unique_parent_id+' .vf_wr li.selected').length ){
		$(unique_parent_id+' .remove_vf_vm button').removeClass('disabled').addClass('blue').removeAttr('disabled');
	}
	else{
		$(unique_parent_id+' .remove_vf_vm button').addClass('disabled').removeClass('blue').attr('disabled','disabled');
	}
	
	if( $(unique_parent_id+' .vm_wr li.selected').length && $(unique_parent_id+' .free_vf_wr li.selected').length ){
		$(unique_parent_id+' .add_vf_vm button').removeClass('disabled').addClass('blue').removeAttr('disabled');
	}
	else{
		$(unique_parent_id+' .add_vf_vm button').addClass('disabled').removeClass('blue').attr('disabled','disabled');	
	}
}

function lin_add_vfs_to_vm(unique_parent_id, getdata, ip_id){
	$(unique_parent_id+' .initializer').show();
	getdata += '&action=assign&type=desktop&vmid='+$(unique_parent_id+' .vm_wr li.selected').children('.vmid').val();
	var vfpci = '';
	$(unique_parent_id+' .free_vf_wr li.selected').each(function(i){
		vfpci += ','+$(this).children('.vfpci').val()+',';
	});
	getdata += '&vfpci='+vfpci;
	
	$.ajax({
		url: '/python/lin_vf_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .vm_wr').html('');
				$(unique_parent_id+' .vf_wr').html('');
				$(unique_parent_id+' .free_vf_wr').html('');
				fill_linux_vf_conf(ip_id);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});		
}

function lin_kvm_show_popup(unique_parent_id, getdata, ip_id){
	
	if ( !$(unique_parent_id + ' .vm_wr li.selected').length || !$(unique_parent_id + ' .vf_wr li.selected').length) {
		return;
	}
	
	var html = '<div class="ch_popup">\
		<div class="overlay"></div>\
		<div class="pop_wr">\
			<div class="pop_cross" onclick="$(this).parent().parent().remove();" ></div>\
			<div>\
				<div class="center">\
					<p class="f_bold">Device cannot be removed from running VM. The change will effect on next VM reboot</p>\
				</div>\
				<div class="btn_wraper rect_btn_wrapper clear_left" onclick="lin_vf_remove_vfs_vm(\'' + unique_parent_id + '\',\'' + getdata + '\',\'' + ip_id + '\')">\
				    <button class="btn yellow" type="submit">\
				        <strong>OK</strong>\
				    </button>\
				</div>\
			</div>\
		</div>\
	</div>'
	$(unique_parent_id + ' .lin_kvm_pop_wr').html(html).show();
}
	
function lin_vf_remove_vfs_vm(unique_parent_id, getdata, ip_id){
	$(unique_parent_id+' .lin_kvm_pop_wr').html('');
	$(unique_parent_id+' .initializer').show();
	getdata += '&action=remove&type=desktop&vmid='+$(unique_parent_id+' .vm_wr li.selected').children('.vmid').val();
	var vfpci = '';
	$(unique_parent_id+' .vf_wr li.selected').each(function(i){
		vfpci += ','+$(this).children('.vfpci').val()+',';
	});
	getdata += '&vfpci='+vfpci;
	
	$.ajax({
		url: '/python/lin_vf_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .vm_wr').html('');
				$(unique_parent_id+' .vf_wr').html('');
				$(unique_parent_id+' .free_vf_wr').html('');
				fill_linux_vf_conf(ip_id);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});		
}