function initialize_pg_update(ip_id){
	var unique_parent_id = '#pg_content__incend__' + ip_id+' .pg_content_update_tp_tab';
	$(unique_parent_id + ' .initializer:first').hide();
	var loader_selector = unique_parent_id + ' .default_loader';
	
	if( $(loader_selector).css('display') == 'block' || $(unique_parent_id +' .global_error').css('display') == 'block' || $(unique_parent_id +' .targets_list').length ){
		return
	}
	
	$(loader_selector).show();
	var ip = replace_with(ip_id, '_', '.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&ip=' + ip;
	
	//Initializing
	$(unique_parent_id +' .status_link, '+ unique_parent_id +' .refresh').attr('onclick','$("'+unique_parent_id +' .i_pu_loader").hide();$("'+unique_parent_id +' .targets_list").remove();initialize_pg_update("'+ ip_id +'")');
	$(unique_parent_id +' .i_pu_move_up').attr('onclick','i_pu_alter_position("'+ unique_parent_id +'", "up")');
	$(unique_parent_id +' .i_pu_move_down').attr('onclick','i_pu_alter_position("'+ unique_parent_id +'", "down")');
	$(unique_parent_id +' .i_pu_delete_portal').attr('onclick','i_pu_delete_pg("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'","'+ loader_selector +'","delete")');
	
	$(unique_parent_id +' .i_pu_save_wr').attr('onclick','i_pu_save_changes("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'","'+ loader_selector +'")');
	$(unique_parent_id +' .i_pu_discard_wr').attr('onclick','i_pu_discard_changes("'+ unique_parent_id +'", "'+ ip_id +'", "'+ ip +'", "'+ loader_selector +'")');
	
	i_pu_make_default(unique_parent_id);
	
	$.ajax({
		url: '/python/iscsi_target_pg_update.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=get_targets',
		success: function(html){
			$(loader_selector).hide();
			if (html == '-2') {
				show_redirect_alert();
			}
			else  if ( html == '67' ) {
				show_error_msg(unique_parent_id, 'iSCSI Target driver not loaded');
			}
			else if (html != '-1') {
				$(unique_parent_id + ' .i_pu_select_li').html(html);
			}
			else{
				//$(unique_parent_id + ' .global_error').show(300);
			}
		}
	});
}

function i_pu_get_portals(unique_parent_id, ip_id, ip, loader_selector){
	
	i_pu_make_default(unique_parent_id);	
	if( $.trim($(unique_parent_id +' .targets_list').val()) == 'null' ){
		return false
	}
	
	$(loader_selector).show();

	target_status = $.trim($(unique_parent_id+' .targets_list option:selected').attr('title'));
	if ( target_status == '0' ){
		$(unique_parent_id+' .i_pu_tstatus').html('STOPPED').removeAttr('class').addClass('i_pu_tstatus i_pu_tstopped mgn_l10 f_bold');	
	}
	else if ( target_status == '1' ){
		$(unique_parent_id+' .i_pu_tstatus').html('STARTED').removeAttr('class').addClass('i_pu_tstatus i_pu_tstarted mgn_l10 f_bold');
	}
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var getdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&index='+$(unique_parent_id +' .targets_list').val()+'&ostype='+ostype;
	$.ajax({
		url: '/python/iscsi_target_pg_update.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=get_portals',
		success: function(html){
			$(loader_selector).hide();
			if (html == '-2') {
				show_redirect_alert();
			}
			else if (html != '-1') {
				$(unique_parent_id + ' .i_pu_pg_list').html(html);
			}
			else{
				//$(unique_parent_id + ' .global_error').show(300);
			}
		}
	});
}

function i_pu_pg_select(element, unique_parent_id, ip_id, ip, loader_selector){

	$(unique_parent_id+' .error_status').html('');
	if( $(element).hasClass('selected') ){
		$(element).removeClass('selected');
	}
	else{
		$(element).addClass('selected');
	}
	
	if ( $(unique_parent_id + ' .i_pu_pg_list ul li.selected').length > 1 ) {
		$(unique_parent_id + ' .i_pu_delete_portal button').removeClass('blue').addClass('disabled');
		$(unique_parent_id+' input[type=text]').removeAttr('disabled').val('').attr('disabled','disabled');
		$(unique_parent_id+' input[type=radio]').removeAttr('checked');
		return false;
	}
	else if ( $(unique_parent_id + ' .i_pu_pg_list ul li.selected').length == 0 ) {
		$(unique_parent_id + ' .i_pg_update_wr button').removeClass('blue').addClass('disabled');
		$(unique_parent_id+' input[type=text]').removeAttr('disabled').val('').attr('disabled','disabled');
		$(unique_parent_id+' input[type=radio]').removeAttr('checked');
		return false;
	}
	
	i_pu_fill_values(unique_parent_id);
}

function i_pu_fill_values(unique_parent_id){
	$(unique_parent_id + ' .i_pg_update_wr button').removeClass('disabled').addClass('blue');
	$(unique_parent_id+' .i_pu_form_fd .ip').removeAttr('disabled').val($(unique_parent_id + ' .i_pu_pg_list ul li.selected').children('.ip').val()).attr('disabled','disabled');
	$(unique_parent_id+' .i_pu_form_fd .time').removeAttr('disabled').val($(unique_parent_id + ' .i_pu_pg_list ul li.selected').children('.time').val()).attr('disabled','disabled');
	$(unique_parent_id+' .i_pu_form_fd .redirect').removeAttr('disabled').val($(unique_parent_id + ' .i_pu_pg_list ul li.selected').children('.redirecttag').val()).attr('disabled','disabled');
	$(unique_parent_id+' .i_pu_form_fd .port').removeAttr('disabled').val($(unique_parent_id + ' .i_pu_pg_list ul li.selected').children('.tcp').val()).attr('disabled','disabled');
}

function i_pu_make_default(unique_parent_id){
	$(unique_parent_id+' .i_pu_pg_list').html('');
	$(unique_parent_id+' input[type=text]').removeAttr('disabled').val('').attr('disabled','disabled');
	$(unique_parent_id+' input[type=checkbox]').removeAttr('checked');
	$(unique_parent_id+' .i_pu_tstatus').html('');
	$(unique_parent_id+' .i_pg_update_wr button').removeClass('blue').addClass('disabled');
	$(unique_parent_id+' .error_status').html('');
}

function i_pu_alter_position(unique_parent_id, direction){
	
	$(unique_parent_id+' .error_status').html('');
	if( $(unique_parent_id+' .i_pg_update_wr button').hasClass('disabled') ){
		return;
	}
	
	var current_html = $(unique_parent_id+' .i_pu_pg_list li.selected').clone();
	
	if( direction == 'up' ){
		
		if($(unique_parent_id+' .i_pu_pg_list li.selected:first').hasClass('position_1')){
			$(unique_parent_id+' .error_status').html('Operation not allowed. Cannot move up');
			return false;
		}
		else if ($(unique_parent_id + ' .i_pu_pg_list li.selected').length == $(unique_parent_id + ' .i_pu_pg_list li').length) {
			$(unique_parent_id + ' .error_status').html('Operation not allowed.');
		}
		else if ($(unique_parent_id + ' .i_pu_pg_list li.selected').length > 1) {
				var li_len = $(unique_parent_id + ' .i_pu_pg_list li.selected').length;
				var iter_len = 0;
				var counter_start = false;
				var error_flag = false;
				$(unique_parent_id + ' .i_pu_pg_list li').each(function(i){
				
					if ($(this).hasClass('selected')) {
						counter_start = true;
					}
					
					if (counter_start) {
						iter_len++;
						if ($(this).hasClass('selected')) {
							if (iter_len > li_len) {
								$(unique_parent_id + ' .error_status').html('Operation not allowed. Cannot move up');
								error_flag = true;
								return false
							}
						}
					}
					
					if (i == parseInt($(unique_parent_id + ' .i_pu_pg_list li').length) - 1 && !error_flag) {
						i_pu_moveup(unique_parent_id, current_html);
					}
					
				});
			}
			else {
				i_pu_moveup(unique_parent_id, current_html);
			}
	}
	else if( direction == 'down' ){
		if($(unique_parent_id+' .i_pu_pg_list li.selected:last').hasClass('position_'+String($(unique_parent_id+' .i_pu_pg_list li').length))){
			$(unique_parent_id+' .error_status').html('Operation not allowed. Cannot move down');
			return false;
		}
		else if ($(unique_parent_id + ' .i_pu_pg_list li.selected').length == $(unique_parent_id + ' .i_pu_pg_list li').length) {
			$(unique_parent_id + ' .error_status').html('Operation not allowed.');
		}
		else if( $(unique_parent_id+' .i_pu_pg_list li.selected').length > 1 ){
			var li_len = $(unique_parent_id+' .i_pu_pg_list li.selected').length;
			var iter_len = 0;
			var counter_start = false;
			var error_flag = false;
			$(unique_parent_id+' .i_pu_pg_list li').each(function(i){

				if( $(this).hasClass('selected') ){
					counter_start = true;
				}

				if( counter_start ){
					iter_len++;
					if( $(this).hasClass('selected') ){
						if( iter_len > li_len ){
							$(unique_parent_id+' .error_status').html('Operation not allowed. Cannot move Down');
							error_flag = true;
							return false
						}	
					}	
				}
				
				if( i == parseInt($(unique_parent_id+' .i_pu_pg_list li').length)-1 && !error_flag ){
					i_pu_movedown(unique_parent_id, current_html);
				}
				
			});
		}
		else{
			i_pu_movedown(unique_parent_id, current_html);
		}
		
	}
	else{
		return false;
	}
}

function i_pu_moveup(unique_parent_id, current_html){
	var current_position = parseInt($.trim($(unique_parent_id+' .i_pu_pg_list li.selected:first').attr('name')).replace('position_','')); 
	current_position--;
	$(unique_parent_id+' .i_pu_pg_list li.selected').remove();
	$(unique_parent_id+' .position_'+String(current_position)).before(current_html);
	i_pu_assign_position(unique_parent_id);
}

function i_pu_movedown(unique_parent_id, current_html){
	var current_position = parseInt($.trim($(unique_parent_id+' .i_pu_pg_list li.selected:last').attr('name')).replace('position_','')); 
	current_position++;
	$(unique_parent_id+' .i_pu_pg_list li.selected').remove();
	$(unique_parent_id+' .position_'+String(current_position)).after(current_html);
	i_pu_assign_position(unique_parent_id);
}

function i_pu_assign_position(unique_parent_id){
	$(unique_parent_id+' .i_pu_pg_list ul li').each(function(i){
		$(this).attr('name',i+1);
		var select_class = '';
		if( $(this).hasClass('selected') ){
			var select_class = 'selected';
		}
		$(this).removeAttr('class').addClass(select_class+' pg hover_li position_'+String(i+1));		
	});
	$(unique_parent_id+' input[type=text]').removeAttr('disabled').val('').attr('disabled','disabled');
	$(unique_parent_id+' input[type=checkbox]').removeAttr('checked');
	if( $(unique_parent_id+' .i_pu_pg_list li.selected').length == 1 ){
		i_pu_fill_values(unique_parent_id);		
	}  
}

function i_pu_save_changes(unique_parent_id, ip_id, ip, loader_selector){
	
	if( $(unique_parent_id+' .i_pu_save_wr button').hasClass('disabled') ){
		return;
	}
	
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&index='+$(unique_parent_id +' .targets_list').val();
	var pgname_str = '';
	var total_pg_str = $(unique_parent_id+' .pgstring_order').length;
	$(unique_parent_id+' .pgstring_order').each(function(i){
		if( i == total_pg_str-1 || i == 0 ){
			//IF LAST
			if( i == total_pg_str-1 ){
				pgname_str += $(this).val();			
			}
			else if( i == 0 ){
				//first but not the last
				pgname_str += $(this).val()+'#';			
			}	
		}
		else{
			pgname_str += $(this).val()+'#';
		}
	});
	postdata += '&pgnamestr='+encodeURIComponent(pgname_str);
	$(unique_parent_id + ' .i_pu_loader').hide();
	$(unique_parent_id + ' .global_processing').show();
	$.ajax({
		url: '/python/iscsi_target_pg_update.py',
		type: 'POST',
		cache: false,
		data: postdata+'&action=save_order',
		success: function(status){
			$(loader_selector).hide();
			$(unique_parent_id + ' .i_pu_loader').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status != '-1') {
				$(unique_parent_id + ' .global_sucess').show();
			}
			else{
				//$(unique_parent_id + ' .global_error').show();
			}
		}
	});
}

function i_pu_discard_changes(unique_parent_id, ip_id, ip, loader_selector){
	if( $(unique_parent_id+' .i_pu_discard_wr button').hasClass('disabled') ){
		return false;
	}
	else{
		i_pu_get_portals(unique_parent_id, ip_id, ip, loader_selector);
		$(unique_parent_id+' .i_pu_update_wr button').removeClass('blue').addClass('disabled');
		$(unique_parent_id+' .error_status').html('');		
	}
}

function i_pu_delete_pg(unique_parent_id, ip, ip_id, loader_selector){
	
	if( $(unique_parent_id+' .i_pu_delete_portal button').hasClass('disabled') ){
		return;
	}
	
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&index='+$(unique_parent_id +' .targets_list').val();
	postdata += '&pgnamestr='+encodeURIComponent($(unique_parent_id+' .i_pu_pg_list li.selected').children('.pgstring').val());
	$(unique_parent_id + ' .i_pu_loader').hide();
	$(unique_parent_id + ' .global_processing').show();
	$.ajax({
		url: '/python/iscsi_target_pg_update.py',
		type: 'POST',
		cache: false,
		data: postdata+'&action=delete_pg',
		success: function(status){
			$(loader_selector).hide();
			$(unique_parent_id + ' .i_pu_loader').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status != '-1') {
				$(unique_parent_id + ' .global_sucess').show();
			}
			else{
				//$(unique_parent_id + ' .global_error').show();
			}
		}
	});
}