var sns_timeOuts = new Array();

function initialize_sns(ip_id){
	var unique_parent_id = '#network_content__incend__'+ ip_id+' .network_sns_tab';
	var ip = replace_with(ip_id, '_', '.');
	var loader_selector = unique_parent_id + ' .initializer';
	if( $(unique_parent_id +' .global_error').css('display') == 'block' || $(unique_parent_id + ' .interface_list li').length ){
		return
	}
	$(loader_selector).show();
	
	//initializing
	$(unique_parent_id +' .interface_list li').attr('onclick','sns_eth_select("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .global_error .status_link').attr('onclick','$("'+unique_parent_id +' .global_error").hide();initialize_sns("'+ ip_id +'")');
	$(unique_parent_id +' input[name=nw_stats_option]').attr('onclick','sns_toggle_button("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' input[type=checkbox]').attr('onclick','sns_toggle_button("'+ unique_parent_id +'",$(this))');
	$(unique_parent_id +' .show_stats_wr').attr('onclick','sns_show_statistics("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'")');
	$(unique_parent_id +' .select_widget').attr('onchange','sns_select_widget("'+ unique_parent_id +'",$(this))');
	
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&ip=' + ip;
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	sns_get_interface_list(getdata,unique_parent_id,loader_selector, ostype);
}

function sns_get_interface_list(getdata,unique_parent_id,loader_selector, ostype){
	getdata += '&action=interfaceList&ostype='+ostype;
	$.ajax({
		url: '/python/network_statistics.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(html){
			$(loader_selector).hide();
			if (html == '-2') {
				show_redirect_alert();
			}
			else if (html != '-1') {
				$(unique_parent_id + ' .interface_list').html(html);
				$(unique_parent_id + ' .interface_list').fadeIn(300);
			}
			else{
				$(unique_parent_id +' .global_error').fadeIn(300);
			}
		}
	});	
}

function sns_eth_select(unique_parent_id, element){
	if (!element.hasClass('eth_bk')) {
		$(element).toggleClass('selected');
		sns_toggle_button(unique_parent_id);
	}
}

function sns_toggle_button(unique_parent_id, element){
	if( $(unique_parent_id+ ' input[name=nw_stats_option]' ).is(':checked') ){
		$(unique_parent_id+ ' .option_wrapper').addClass('disabled_wr');
		$(unique_parent_id+ ' .'+$(unique_parent_id+ ' input:radio[name=nw_stats_option]:checked').val()).removeClass('disabled_wr');
	}
	
	if ( $(element).is(':radio') && $(element).is(':checked') ) {
		$(unique_parent_id+ ' .option_wrapper  input[type=checkbox]').attr('disabled','disabled').removeAttr('checked');
		$(unique_parent_id+ ' .'+$(unique_parent_id+ ' input:radio[name=nw_stats_option]:checked').val()+' input[type=checkbox]').removeAttr('disabled');
		if( $(element).val() == 'ans' ){
			$(unique_parent_id+' .stats_type').val('table');
			$(unique_parent_id+' .stats_type_dl').slideUp(300);
			$(unique_parent_id+' .select_widget').removeAttr('disabled');
		}
		else{
			$(unique_parent_id+' .stats_type_dl').show();
			$(unique_parent_id+' .select_widget').val('none').attr('disabled','disabled');
		}
	}
	
	if( $(unique_parent_id+ ' input[name=nw_stats_option]' ).is(':checked') && $(unique_parent_id + ' .interface_list li.selected').length && $(unique_parent_id+ ' .'+$(unique_parent_id+ ' input:radio[name=nw_stats_option]:checked').val()+' input[type=checkbox]').is(':checked') ){
		$(unique_parent_id+ ' .btn_wraper button').removeClass('disabled').addClass('blue');
	}
	else{
		$(unique_parent_id+ ' .btn_wraper button').removeClass('blue').addClass('disabled');
	}
}

function sns_show_statistics(unique_parent_id, ip, ip_id){
	if( !$(unique_parent_id +' .show_stats_wr button').hasClass('blue') ){
		return
	}
	
	if( $.trim($(unique_parent_id +' .polling_time').val()) == '' ){
		$(unique_parent_id +' .polling_time').addClass('error');
		return
	}
	
	if( $(unique_parent_id +' .stats_type').val() == 'table' ){
		sns_show_table_stats(unique_parent_id, ip, ip_id);
	}
	else{
		sns_show_graph_stats(unique_parent_id, ip, ip_id);
	}
}

function sns_show_graph_stats(unique_parent_id, ip, ip_id){
	var popup_id = unique_parent_id.replace('#','');
	var loader_selector = unique_parent_id + ' .default_loader';
	$(loader_selector).show();
	$.get('graph.html',function(html){
		$(loader_selector).hide();
		$('.dummy').chLightbox('ajax',{
			 lbTitle 	: 'Network Statistics',
			 lbOk	 	: 'Close',
			 ajaxHtml	: html ,
			 successfn	: 'sns_clear_timeout("'+ unique_parent_id +'")',
			 lbWidth	: '665',
			 top_extra	: 50
		});
		$('#modalogBox .as_form_cancel,#modalogCloseButton').hide();
		sns_poll(unique_parent_id, $(unique_parent_id +' .polling_time').val(), ip, ip_id);
	});
}

function build_chk_html(unique_parent_id){
	
	//Eth html
	var eth_list = new Array();
	var eth_selected_count = $(unique_parent_id+ ' .interface_list li.selected').length;
	var grid_width =  eth_selected_count*155;
	var table_stats_html = '<ul class="horizontal head_ul"><li><h2>&nbsp;</h2></li>'
	$(unique_parent_id+ ' .interface_list li.selected .ifname').each(function(i){
		if ( i == ($(unique_parent_id+ ' .interface_list li.selected').length)-1 ) {
			var eth_html = '<li class="eth_head"><h2 class="bg_none">'+ $(this).val() +'</h2></li>';
		}
		else{
			var eth_html = '<li class="eth_head"><h2>'+ $(this).val() +'</h2></li>';
		}
		
		table_stats_html += eth_html;
		eth_list[i] = $(this).val();
	});
	table_stats_html += '</ul>';
	
	//chk Html
	var init_loader = '<img src="/images/black/loader_init.gif"  alt="loading.." />'
	$(unique_parent_id+ ' input[type=checkbox]:checked').each(function(){
		table_stats_html += '<ul class="horizontal content_tbl clear"><li class="label">'+ $(this).attr('name') +'&nbsp;</li>';
		
		for( i in eth_list ){
			var eth_class = eth_list[i].split(' ')
			eth_class = eth_class.join('_');
			if (i == (eth_list.length)-1) {
				table_stats_html += '<li class="eth_stats bg_none ' + $(this).val() + ' ' + eth_class.toLowerCase() + '">'+ init_loader +'&nbsp;</li>';
			}
			else{
				table_stats_html += '<li class="eth_stats ' + $(this).val() + ' ' + eth_class.toLowerCase() + '">'+ init_loader +'&nbsp;</li>';
			}
		}
						
		table_stats_html += '</ul>';
	});
	
	table_stats_html += '<div class="clear_left"></div>';
	$(unique_parent_id+ ' .grid').html(table_stats_html);
	return grid_width
}

function sns_show_table_stats(unique_parent_id, ip, ip_id){
	
	var popup_id = unique_parent_id.replace('#','');
	var grid_width = build_chk_html(unique_parent_id);
	$('.dummy').chLightbox('popup', {
		PopTitle: 'Network Statistics',
		PopDivId: popup_id+' .stats_table_wr',
		lbWidth: 255+grid_width,
		successfn: 'sns_clear_timeout("'+ unique_parent_id +'")',
		PopOk: 'Close',
		top_extra: 50
	});
	$('#modalogBox .as_form_cancel,#modalogCloseButton').hide();
	var actual_grid_width = grid_width + 218;
	$('#modalogBox .grid').css('width',actual_grid_width);
	
	sns_poll(unique_parent_id, $(unique_parent_id +' .polling_time').val(), ip, ip_id);
}

function sns_poll(unique_parent_id, poll_value, ip, ip_id){
	
	var ifname = '';
	$(unique_parent_id+ ' .interface_list li.selected .ifname').each(function(i){	
		ifname += '&ifname='+$(this).val();
	});
	ifname += '&ethcount='+$(unique_parent_id+ ' .interface_list li.selected').length;
	
	var stats_properties = '';
	//Main statistics checkbox
	$(unique_parent_id+ ' input[type=checkbox]:checked').each(function(i){
		if ( $(unique_parent_id + ' input:radio[name=nw_stats_option]:checked').val() == 'tm' ) {
			stats_properties += '&properties=ifInOctets&properties=ifOutOctets';
		}
		else if ($(unique_parent_id + ' input:radio[name=nw_stats_option]:checked').val() == 'tps') {
			stats_properties += '&properties=ifInUcastPkts&properties=ifInMulticastPkts&properties=ifInBroadcastPkts&properties=ifOutUcastPkts&properties=ifOutMulticastPkts&properties=ifOutBroadcastPkts';
		}
		else if ($(unique_parent_id + ' input:radio[name=nw_stats_option]:checked').val() == 'ans') {
			stats_properties += '&properties=' + $(this).val();
		}
		else{
			sns_clear_timeout(unique_parent_id);
		}
	});
	
	if ($(unique_parent_id + ' input:radio[name=nw_stats_option]:checked').val() == 'tm') {
		stats_properties += '&propertiescount=2';		
	}
	else if ($(unique_parent_id + ' input:radio[name=nw_stats_option]:checked').val() == 'tps') {
		stats_properties += '&propertiescount=6';		
	}
	else{
		stats_properties += '&propertiescount='+$(unique_parent_id+ ' input[type=checkbox]:checked').length;
	}
	
	var timeout_sec = parseInt(poll_value)*1000;
	//Table
	if( $(unique_parent_id+ ' .stats_type').val() == 'table' ){
		var specific_url = '';
		var eth_len = $(unique_parent_id+ ' .interface_list li.selected').length;
		if ($(unique_parent_id + " input:radio[name=nw_stats_option]:checked").val() == 'tps') {
			$(unique_parent_id+ ' .interface_list li.selected').each(function(i){	
				specific_url += '&tps_rps_prev_val=0&tps_tps_prev_val=0&tps_bdps_prev_val=0';
				if( i == eth_len-1 ){
					sns_table_call_byinterval(unique_parent_id, ip, ifname, timeout_sec, specific_url);
				}
			});
		}
		else if ($(unique_parent_id + " input:radio[name=nw_stats_option]:checked").val() == 'tm') {
			$(unique_parent_id+ ' .interface_list li.selected').each(function(i){	
				specific_url += '&tm_rm_prev_val=0&tm_tm_prev_val=0&tm_bdm_prev_val=0';
				if( i == eth_len-1 ){
					sns_table_call_byinterval(unique_parent_id, ip, ifname, timeout_sec, specific_url);
				}
			});
		}
		else if ($(unique_parent_id + " input:radio[name=nw_stats_option]:checked").val() == 'ans') {
			sns_table_ans_call_byinterval(unique_parent_id, ip, ifname, stats_properties, timeout_sec);
		}
	}
	//Graph
	else{
		if ($(unique_parent_id + " input:radio[name=nw_stats_option]:checked").val() == 'tps') {
			var specific_url = '';
			var eth_len = $(unique_parent_id+ ' .interface_list li.selected').length;
			$(unique_parent_id+ ' .interface_list li.selected').each(function(i){	
				specific_url += '&tps_rps_prev_val=0&tps_tps_prev_val=0&tps_bdps_prev_val=0';
				if( i == eth_len-1 ){
					sns_graph_call_byinterval(unique_parent_id, ip, ifname, timeout_sec, specific_url);
				}
			});
		}
		else if ($(unique_parent_id + " input:radio[name=nw_stats_option]:checked").val() == 'tm') {
			var specific_url = '';
			var eth_len = $(unique_parent_id+ ' .interface_list li.selected').length;
			$(unique_parent_id+ ' .interface_list li.selected').each(function(i){	
				specific_url += '&tm_rm_prev_val=0&tm_tm_prev_val=0&tm_bdm_prev_val=0';
				if( i == eth_len-1 ){
					sns_graph_call_byinterval(unique_parent_id, ip, ifname, timeout_sec, specific_url);
				}
			});
		}
	} 
}

function sns_table_call_byinterval(unique_parent_id, ip, ifname, timeout_sec, specific_url){
	var sid = GetCookie("chelsio_webgui_sid");
	var type = $(unique_parent_id +" input:radio[name=nw_stats_option]:checked").val();
	var getdata = 'sid=' + sid + '&ip=' + ip+'&action=poll'+ifname+'&type='+type+'&poll_time='+(timeout_sec/1000)+specific_url;
	
	$.ajax({
		url: '/python/network_statistics.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: "xml",
		success: function(xml){
			
			if( $.trim($('status', xml).text()) == '-2' ){
				show_redirect_alert();
				return	
			}
			
			var specific_url ='';
			var eth_len = $('eth', xml).length;
			
			$('eth', xml).each(function(i){
				
				var ifname_label = $(this).attr('ifname').split(' ');
				ifname_label = ifname_label.join('_');
				if (type == 'tps') {
					specific_url += '&tps_rps_prev_val='+$(this).find('tps_rps').text();
					specific_url += '&tps_tps_prev_val='+$(this).find('tps_tps').text();
					specific_url += '&tps_bdps_prev_val='+$(this).find('tps_bdps').text();
					
					if ($(unique_parent_id + ' .tps_rps').is(':checked')) {
						$('#modalogBox .' + ifname_label + '.tps_rps').html($.trim($(this).find('plot_tps_rps').text()));
					}
					if ($(unique_parent_id + ' .tps_tps').is(':checked')) {
						$('#modalogBox .' + ifname_label + '.tps_tps').html($.trim($(this).find('plot_tps_tps').text()));
					}
					if ($(unique_parent_id + ' .tps_bdps').is(':checked')) {
						$('#modalogBox .' + ifname_label + '.tps_bdps').html($.trim($(this).find('plot_tps_bdps').text()));
					}
				}
				else if (type == 'tm') {
					specific_url += '&tm_rm_prev_val='+$(this).find('tm_rm').text();
					specific_url += '&tm_tm_prev_val='+$(this).find('tm_tm').text();
					specific_url += '&tm_bdm_prev_val='+$(this).find('tm_bdm').text();
					
					if ( $(unique_parent_id + ' .tm_rm').is(':checked') ) {
						$('#modalogBox .'+ifname_label+'.tm_rm').html($(this).find('plot_tm_rm').text());
					}
					if ( $(unique_parent_id + ' .tm_tm').is(':checked') ) {
						$('#modalogBox .'+ifname_label+'.tm_tm').html($(this).find('plot_tm_tm').text());
					}
					if ( $(unique_parent_id + ' .tm_bdm').is(':checked') ) {
						$('#modalogBox .'+ifname_label+'.tm_bdm').html($(this).find('plot_tm_bdm').text());
					}
				}
			
				if( i == eth_len -1  ){
					sns_timeOuts['sns_poll'+unique_parent_id] = setTimeout(function() {
					    sns_table_call_byinterval(unique_parent_id, ip, ifname, timeout_sec, specific_url);
					}, timeout_sec);
				}
			
			});
		}
	});
}

function sns_table_ans_call_byinterval(unique_parent_id, ip, ifname_value, stats_properties, timeout_sec){
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&ip=' + ip+'&action=ans_poll'+ifname_value+stats_properties;
	var first_call = true;
	$.ajax({
		url: '/python/network_statistics.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: "xml",
		success: function(xml){
			
			if( $.trim($('status', xml).text()) == '-2' ){
				show_redirect_alert();
				return	
			}
			
			$('eth', xml).each(function(i){
				var eth_class =  $(this).attr('ifname').split(' ')
				ifname = eth_class.join('_');
				var eth_element = $(this);
				if ($(unique_parent_id + ' input:radio[name=nw_stats_option]:checked').val() == 'ans') {
					$(unique_parent_id+ ' input[type=checkbox]:checked').each(function(){
						$('#modalogBox .'+ifname+'.'+$(this).val()).html($(eth_element).find($(this).val()).text());
					});
				}
				else{
					sns_clear_timeout(unique_parent_id);
				}
				
			});
			sns_timeOuts['sns_poll'+unique_parent_id] = setTimeout('sns_table_ans_call_byinterval("'+unique_parent_id+'", "'+ip+'", "'+ifname_value+'" , "'+stats_properties+'",'+timeout_sec+')',timeout_sec);
		}
	});	
}

function sns_clear_timeout(unique_parent_id){
	$('.dummy').chLightbox('destroy');
    //clearTimeout(sns_timeOuts['sns_poll'+unique_parent_id]);  
	for( key in sns_timeOuts ){  
     clearTimeout(sns_timeOuts[key]);  
   	}  
}

function sns_validate(element){
	var is_digit = /^\d+$/;	
	if (!is_digit.test($(element).val())) {
		$(element).val($(element).val().substring(0,$(element).val().length-1));
	}
	$(element).removeClass('error')
}

function sns_select_widget(unique_parent_id, element){
	if( $(element).val() == 'none' ){
		$(unique_parent_id+' .nw_stats_third input[type=checkbox]').removeAttr('checked');
	}
	else{
		$(unique_parent_id+' .nw_stats_third input[type=checkbox]').attr('checked','checked');
	}
	sns_toggle_button(unique_parent_id,$(unique_parent_id+' .nw_stats_third input[name=ifInDiscards]'));
}
