var menu_ipid = '';
$(document).ready(function(){
	generate_menu();
	
	$('#m_tree_wrap .tree .tree_ul a:not(.tree_action)').live('click',function(){
		menu_select($(this));
	});
	
	$('#m_tree_wrap .tree .tree_ul a.tree_action').live('click',function(){
		$('#m_tree_wrap .tree .tree_ul a:not(.tree_action)').removeClass('selected');
		menu_select($(this).next());
	});
	
	$('.tree_action').live('click',function(){
		var plus_img_src = '/images/black/tree_plus.png';
		var minus_img_src = '/images/black/tree_minus.png';
		if($(this).siblings('ul').css('display') == 'none' ){
			//$(this).siblings('ul').slideDown(300);
			$(this).children('img').attr('src',minus_img_src);
		}
		else{
			//$(this).siblings('ul').slideUp(300);
			$(this).children('img').attr('src',plus_img_src);
		}
		$(this).siblings('ul').animate({ 
			height: 'toggle', opacity: 'toggle' 
		}, 300,function(){
			call_expand_shrink($(this).next());
		});
	});
	
	$('#m_tree_wrap .system').live('click',function(){
		
		menu_select($(this).next().children('.tree_ul').children('li').children('.tree_action:first').next());
		
		//If user is clicking on a system menu which is already in open state.
		if( $(this).children('h1').attr('class') == 'show' ){
			$(this).children('h1').removeClass('show').addClass('hide');
			$(this).siblings('.tree').slideUp(300,function(){
				$(this).removeClass('shown').addClass('hidden');
			});

			if(!$('#m_tree_wrap .show').length){
				$('.left_top_nav a.remove_pc').removeClass('effect').addClass('inactive').removeAttr('style');	
			}
			return;
		}
		
		//Normal slide operation
		$('#m_tree_wrap .tree').slideUp(300,function(){
			$(this).removeClass('shown').addClass('hidden');
		});
		$('#m_tree_wrap .details .system h1').removeClass('show').addClass('hide');
		$(this).children('h1').removeClass('hide').addClass('show');
		$(this).siblings('.tree').slideDown(300,function(){
			$(this).removeClass('hidden').addClass('shown');
		});
		$('.left_top_nav a.remove_pc').removeClass('inactive').addClass('effect');
	});
	
});

function generate_menu(){
	
	var xml_name = GetCookie("chelsio_webgui_user")+'_menu.xml';
	var end_flag = false;
	
	$('#m_tree_wrap .details:not(.menu_status_wrapper)').remove();
	
	$.ajax({
		url:  xml_name,
		type: 'GET',
		cache: false,
		dataType: "xml",
		success: function(xml){
			var last_id_count = '';
			var system_count = 0;
			
			$('system ', xml).each(function(i){
				system_count += 1;
				$('.left_top_nav a.remove_pc').removeClass('inactive').addClass('effect');				
				
				$('.menu_status_wrapper').hide();
				var system_html = '';
				last_id_count = i;
				
				//Build home and card tree node
				var system_name = $(this).attr('name');
				var ostype = $(this).attr('ostype');
				//ostype = '8'
				var osname = $(this).attr('osname');
				var is_kvm = $(this).attr('kvm');
				var kvm_status = $.trim($(this).attr('kvm_status'));
				var is_hyperv = $(this).attr('hyperv');
				var ip_id = replace_with($(this).attr('ip'),'.','_');
				menu_ipid = ip_id;

				if (i == 0) {
					var mgn_class = 'mgn_b0';
				}
				else {
					mgn_class = '';
				}
				
				var is_card_exists = $(this).find('card').length;
				
				system_html += '<div class="details ' + mgn_class + '" id="details_' + String(i) + '">\
								<a href="javascript:void(0);" onclick="load_right_unique_content(\'system_content__incend__' +ip_id +'\');" class="system" >\
								<h1 class="hide" id = "rm_pc_'+ String(ip_id) +'" >' + system_name + '</h1></a><div class="tree as_hide hidden">';
				
				var card_count = $(this).attr('cardcount');
				if( card_count == '0' ){
					var sys_class = ' as_hide';  
				}
				else{
					var sys_class = ' ';
				}
				
				var is_licensed = $(this).attr('license');
				
				system_html += '<ul class="tree_ul"><li id="ip_' + String(ip_id) + '">\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'system_content__incend__' +ip_id +'\');" class = "tree_action '+ sys_class +'">\
							<img src="/images/black/tree_minus.png"></a>\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'system_content__incend__' +ip_id +'\');" class="selected system_link" >\
							<input type="hidden" class="license" value="'+ is_licensed +'" />\
							<input type="hidden" class="ostype" value="'+ ostype +'" />\
							<input type="hidden" class="kvm" value="'+ is_kvm +'" />\
							<input type="hidden" class="kvm_status" value="'+ kvm_status +'" />\
							<input type="hidden" class="hyperv" value="'+ is_hyperv +'" />\
							<input type="hidden" class="osname" value="'+ osname +'" />\
							<img class = "icon" src="images/black/connected_pc_col.png" >' +system_name +'</a>';
				
				//Build Network node
				if ($(this).find('networking').length) {
					system_html += '<ul><li>\
						<a href="javascript:void(0);" onclick="load_right_unique_content(\'network_maincontent__incend__' + ip_id + '\');" class = "tree_action">\
						<img src="/images/black/tree_plus.png"></a>\
						<a href="javascript:void(0);" onclick="load_right_unique_content(\'network_maincontent__incend__' +
					ip_id +
					'\');" >\
						<img class="icon" src="images/black/nw_col.png" >Network</a>';
					
					//Build card node
					var freebsd_port_idx = -1;
					$(this).find('card').each(function(c){
					
						var port_len = $(this).children('port').length;
						if (port_len) {
							card_class = '';
						}
						else {
							card_class = ' as_hide';
						}
						
						var cardname = $(this).attr('name');
						var connector = $(this).attr('connector');
						var phy_idx = $(this).attr('phy_idx');
						var serialnumb_class = 'card_serialnumb_'+$(this).attr('serialnumb');
						var serial_numb = $(this).attr('serialnumb');
						
						if ( is_licensed == '1' ){
							var card_type_class = $(this).attr('type').toLowerCase();
							var chip_type = $(this).attr('type');
							if( card_type_class == 't5' ){
								card_type_class = 't4';
								chip_type = 'T4';
							}
						}
						else{
							var card_type_class = '';
							var chip_type = '';
						}
						
						var card_name_firstchar = cardname.charAt(0).toLowerCase();
						var card_html = '<ul class="as_hide"><li><a href="javascript:void(0);" class = "tree_action ' + card_class + '" onclick="load_right_unique_content(\'card_content__inc' + c + 'end__' + ip_id + '\');" >\
									<img src="/images/black/tree_plus.png"></a><a class="card card_'+c+' '+serialnumb_class+'" href="javascript:void(0);" name = "inc' +
						c +
						'" onclick="load_right_unique_content(\'card_content__inc' +
						c +
						'end__' +
						ip_id +
						'\');">\
									<img src="images/black/nic_col.png" class="icon"><span class="tree_cardname '+card_type_class+'">' +
						cardname +
						'</span>\
						<input type="hidden" class="chiptype '+card_name_firstchar+'card" value="'+chip_type+'" />\
						<input type="hidden" class="connector" value="'+connector+'" />\
						<input type="hidden" class="phy_idx" value="'+phy_idx+'" />\
						<input type="hidden" class="serial_numb" value="'+serial_numb+'" />\
						<input type="hidden" class="firmwareVersion" value="'+$(this).attr('firmwareVersion')+'" />\
						<input type="hidden" class="pciloc" value="'+$(this).attr('pciloc')+'" /></a>';
						//Append card under system
						system_html += card_html;
						
						//Build port nodes
						var is_port_exists = false;
						var port_html_li = '';
						$(this).children('port').each(function(j){
							freebsd_port_idx += 1;
							is_port_exists = true;
							port_html_li += '<li class="menu_port_li"> <a rel="freebsd_p_idx_'+freebsd_port_idx+'" class="port_' + j + '" href="javascript:void(0);" name="inc' + c + j + '" onclick="load_right_unique_content(\'port0_content__inc' + c + j + 'end__' + ip_id + '\');" >\
										<img src="images/black/port_col.png" class="icon">\
										' +
							$(this).attr('name') +
							'</a></li>';
						});
						
						//Append port under card
						if (is_port_exists) {
							//merge port under card
							system_html += '<ul class="as_hide">' + port_html_li + '</ul>';
						}
						//end card
						system_html += '</li></ul>';
					});
					
					//Network Management node
					var show_win_hpyberv = false;
					if ($(this).attr('hyperv') == 'yes') {
						show_win_hpyberv = true;
					}
					
					var show_lin_hpyberv = false;
					if (kvm_status == 'yes') {
						show_lin_hpyberv = true;
					}

					if ($(this).find('networkmgm').length) {
						var nw_name = $(this).find('networkmgm').attr('name');
						if( ostype == "5" || ostype == "8" || show_win_hpyberv || show_lin_hpyberv ){
							
							var fn_str = ' ';
							if (ostype == "8") {
								fn_str = 'hypervisor_xen_content__incend__';
							}
							else if (ostype == "1") {
								fn_str = 'hypervisor_win_content__incend__';
							}
							else if (ostype == "5") {
								fn_str = 'hypervisor_content__incend__';
							}
							else if (ostype == "2") {
								fn_str = 'hypervisor_linux_content__incend__';
							}
							
							var nw_html = '<ul class="as_hide"><li>\
							<a href="javascript:void(0);" class = "tree_action" onclick="load_right_unique_content(\'network_content__incend__' + ip_id + '\');" >\
							<img src="/images/black/tree_plus.png"></a>\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'network_content__incend__' + ip_id + '\');">\
						    <img class = "icon" src="images/black/network.png">' +
							nw_name +
							'</a>';
							//Hypervisor
							nw_html += '<ul class="as_hide"><li><a href="javascript:void(0);" onclick="load_right_unique_content(\'' + fn_str + ip_id + '\');">\
						    <img class = "icon" src="images/black/hypervisor.png">Hypervisor</a></li></ul>';
							//End of networkmgm
							nw_html += '</li></ul>';
							
							/*var nw_html = '<ul class="as_hide"><li><a href="javascript:void(0);" onclick="load_right_unique_content(\'network_content__incend__' + ip_id + '\');">\
						    <img class = "icon" src="images/black/network.png">' +nw_name + '</a>\
							<ul class="as_hide"><li><a href="javascript:void(0);" >\
						    <img class = "icon" src="images/black/nw_col.png">Hypervisor</a></li><ul>\
							</li></ul>';*/
						}
						else{
							var nw_html = '<ul class="as_hide"><li><a href="javascript:void(0);" onclick="load_right_unique_content(\'network_content__incend__' + ip_id + '\');">\
									   <img class = "icon" src="images/black/network.png">' +
							nw_name +
							'</a></li></ul>';
						}
						//Append Network Management under system
						system_html += nw_html;
					}
					
					if ($(this).find('iwarp').length) {
						var iwarp_html = '<ul class="as_hide"><li><a href="javascript:void(0);" onclick="load_right_unique_content(\'iwarp_content__incend__' + ip_id + '\');">\
									   <img class = "icon" src="images/black/iwarp1.png">iWarp</a></li></ul>';
					  	system_html += iwarp_html;
					}
					
					if ($(this).find('wdudp').length) {
						var wdudp_html = '<ul class="as_hide"><li><a href="javascript:void(0);" onclick="load_right_unique_content(\'wiredirect_content__incend__' + ip_id + '\');">\
									   	  <img class = "icon" src="images/black/wdudp.png">Wire Direct</a></li></ul>';
					  	system_html += wdudp_html;
					}
					
					//end Network node
					system_html += '</li></ul>';
					
				}
				
				if ($(this).find('storage').length) {
					
					/*if( ostype == '5' || ostype == '6' || ostype == '4' || ostype == '8' ){
						//Storage Main Node
						system_html += '<ul><li>\
								<a href="javascript:void(0);" onclick="load_right_unique_content(\'storage_maincontent__incend__' +
						ip_id +
						'\');" >\
								<img class="icon" src="images/black/storage.png" >Storage</a>';
					}
					else{*/
						//Storage Main Node
						system_html += '<ul><li>\
								<a id="storage_'+ip_id+'" href="javascript:void(0);" onclick="load_right_unique_content(\'storage_maincontent__incend__' + ip_id + '\');" class = "tree_action">\
								<img src="/images/black/tree_plus.png"></a>\
								<a href="javascript:void(0);" onclick="load_right_unique_content(\'storage_maincontent__incend__' +
						ip_id +
						'\');" >\
								<img class="icon" src="images/black/storage.png" >Storage</a>';
					//}
					
					//Fcoe Node
					if ($(this).find('fcoe').length) {
						if ($(this).find('fcard').length) {
							system_html += '<ul class="as_hide m_fcoe"><li>\
							<a href="javascript:void(0);" id="fcoe_initiator_'+ip_id+'" onclick="load_right_unique_content(\'fcoe_maincontent__incend__' + ip_id + '\');" class = "tree_action">\
							<img src="/images/black/tree_plus.png"></a>\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'fcoe_maincontent__incend__' +
							ip_id +
							'\');" >\
							<img class="icon" src="images/black/fcoe.png" >FCoE Initiator\
							<input type="hidden" value="'+$(this).find('fcoe').attr('cards_count')+'" class="fcards_count" />\
							<input type="hidden" value="'+$(this).find('fcoe').attr('lports_count')+'" class="lports_count" />\
							<input type="hidden" value="'+$(this).find('fcoe').attr('is_fcoe')+'" class="is_fcoe" />\
							<input type="hidden" value="'+$(this).find('fcoe').attr('version')+'" class="fcoe_version" />\
							</a>';
						}
						else {
							system_html += '<ul class="as_hide"><li>\
						<a href="javascript:void(0);" onclick="load_right_unique_content(\'fcoe_maincontent__incend__' + ip_id + '\');" >\
						<img class="icon" src="images/black/fcoe.png" >FCoE Initiator\
						<input type="hidden" value="'+$(this).find('fcoe').attr('is_fcoe')+'" class="is_fcoe" />\
						<input type="hidden" value="'+$(this).find('fcoe').attr('cards_count')+'" class="fcards_count" />\
						<input type="hidden" value="'+$(this).find('fcoe').attr('lports_count')+'" class="lports_count" />\
						<input type="hidden" value="'+$(this).find('fcoe').attr('version')+'" class="fcoe_version" />\
						</a>';
						}
						
						//FCOE Card Page
						if ($(this).find('fcard').length) {
							$(this).find('fcard').each(function(k){
							
								//FCARD HTML
								var serialnumb_class = 'fcard_serialnumb_'+$(this).attr('serialnumb');
								var fcard_idx = $(this).attr('index');
								if ($(this).find('flport').length) {
									system_html += '<ul class="as_hide"><li>\
									<a href="javascript:void(0);" id="fcard'+k+'_'+ip_id+'" onclick="load_right_unique_content(\'fcard_content__inc'+k+'end__' + ip_id + '\');" class = "tree_action">\
									<img src="/images/black/tree_plus.png"></a>\
									<a href="javascript:void(0);" name="inc'+k+'" class="'+serialnumb_class+'" onclick="load_right_unique_content(\'fcard_content__inc'+k+'end__' +
										ip_id +
										'\');" >\
									<img class="icon" src="images/black/nic_col.png" >' +$(this).attr('name') +'\
									<input type="hidden" value="' +$(this).attr('name') +'" class="fcardname" />\
									<input type="hidden" value="' +$(this).attr('fcard_lports_count') +'" class="fcard_lports_count" />\
									<input type="hidden" value="' +$(this).attr('fcard_firm_ver') +'" class="fcard_firm_ver" />\
									<input type="hidden" value="' +$(this).attr('fcard_interrupt') +'" class="fcard_interrupt" />\
									<input type="hidden" value="' +$(this).attr('fcard_state') +'" class="fcard_state" />\
									<input type="hidden" value="' + fcard_idx +'" class="index" />\
									</a>';
								}
								else {
									system_html += '<ul class="as_hide"><li>\
									<a href="javascript:void(0);" class="'+serialnumb_class+'" name="inc'+k+'" onclick="load_right_unique_content(\'fcard_content__inc'+k+'end__' + ip_id + '\');" >\
									<img class="icon" src="images/black/nic_col.png" >' +
									$(this).attr('name') +'\
									<input type="hidden" value="' +$(this).attr('name') +'" class="fcardname" />\
									<input type="hidden" value="0" class="fcard_lports_count" />\
									<input type="hidden" value="' +$(this).attr('fcard_firm_ver') +'" class="fcard_firm_ver" />\
									<input type="hidden" value="' +$(this).attr('fcard_interrupt') +'" class="fcard_interrupt" />\
									<input type="hidden" value="' +$(this).attr('fcard_state') +'" class="fcard_state" />\
									<input type="hidden" value="' + fcard_idx +'" class="index" />\
									</a>';
								}
								
								$(this).find('flport').each(function(m){
									if ($(this).find('frport').length || $(this).find('fvport').length) {
										//FLPORT HTML
										system_html += '<ul class="as_hide"><li>\
									<a href="javascript:void(0);" onclick="load_right_unique_content(\'fport_content__inc'+k+''+m+'end__' + ip_id + '\');" class = "tree_action expand">\
									<img src="/images/black/tree_plus.png"></a>\
									<a class="fcoe_lport expand" href="javascript:void(0);" id="'+ip_id+'_fcoe_lport_'+k+''+m+'" name="inc'+k+''+m+'" onclick="load_right_unique_content(\'fport_content__inc'+k+''+m+'end__' +
										ip_id +
										'\');" >\
									<img class="icon" src="images/black/port_col.png" >' +
										$(this).attr('name') +'\
										<input type="hidden" value="' +$(this).attr('fport_adpname') +'" class="fport_adpname" />\
										<input type="hidden" value="' +$(this).attr('fport_enode_mac') +'" class="fport_enode_mac" />\
										<input type="hidden" value="' +$(this).attr('fport_state') +'" class="fport_state" />\
										<input type="hidden" value="' +$(this).attr('fport_nodewwn') +'" class="fport_nodewwn" />\
										<input type="hidden" value="' +$(this).attr('fport_portwwn') +'" class="fport_portwwn" />\
										<input type="hidden" value="' + m +'" class="fport_index" />\
										<input type="hidden" value="' +$(this).attr('fport_mac') +'" class="fport_mac" />'
									}
									else {
										//FLPORT HTML
										system_html += '<ul class="as_hide"><li>\
									<a class="fcoe_lport expand" href="javascript:void(0);" id="'+ip_id+'_fcoe_lport_'+k+''+m+'" name="inc'+k+''+m+'" onclick="load_right_unique_content(\'fport_content__inc'+k+''+m+'end__' + ip_id + '\');" >\
									<img class="icon" src="images/black/port_col.png" >' +
										$(this).attr('name') +'\
										<input type="hidden" value="' +$(this).attr('fport_adpname') +'" class="fport_adpname" />\
										<input type="hidden" value="' +$(this).attr('fport_enode_mac') +'" class="fport_enode_mac" />\
										<input type="hidden" value="' +$(this).attr('fport_state') +'" class="fport_state" />\
										<input type="hidden" value="' +$(this).attr('fport_nodewwn') +'" class="fport_nodewwn" />\
										<input type="hidden" value="' +$(this).attr('fport_portwwn') +'" class="fport_portwwn" />\
										<input type="hidden" value="' + m +'" class="fport_index" />\
										<input type="hidden" value="' +$(this).attr('fport_mac') +'" class="fport_mac" />';
									}
									
									if( $.trim($(this).attr('fport_mac')) != 'Not Available' ){
										system_html += '<input type="hidden" value="' +$(this).attr('fport_vlan_id') +'" class="fport_vlan_id" />\
										<input type="hidden" value="' +$(this).attr('fport_fabricname') +'" class="fport_fabricname" />\
										<input type="hidden" value="' +$(this).attr('fport_portfcid') +'" class="fport_portfcid" />\
										<input type="hidden" value="' +$(this).attr('fport_pscs') +'" class="fport_pscs" />\
										<input type="hidden" value="' +$(this).attr('fport_osdevice') +'" class="fport_osdevice" />\
										<input type="hidden" value="' +$(this).attr('fport_portspeed') +'" class="fport_portspeed" />\
										<input type="hidden" value="' +$(this).attr('fport_portmaxframesize') +'" class="fport_portmaxframesize" />\
										<input type="hidden" value="' +$(this).attr('fport_scsitargetscount') +'" class="fport_scsitargetscount" />\
										</a>';
									}
									else{
										system_html += '</a>';					
									}
									
									
									$(this).find('frport').each(function(n){
										if ($(this).find('flun').length) {
											//FRPORT HTML
											system_html += '<ul class="as_hide"><li>\
											<a href="javascript:void(0);" onclick="load_right_unique_content(\'frport_content__inc'+k+''+m+''+n+'end__' + ip_id + '\');" class = "tree_action expand">\
											<img src="/images/black/tree_plus.png"></a>\
											<a class="fcoe_rport expand" href="javascript:void(0);" name="inc'+k+''+m+''+n+'" onclick="load_right_unique_content(\'frport_content__inc'+k+''+m+''+n+'end__' +
												ip_id +
												'\');" >\
											<img class="icon" src="images/black/rport.png" >' +
												$(this).attr('name') +
												'<input type="hidden" value="'+ n +'" class="frport_index" />\
												<input type="hidden" value="' +$(this).attr('frport_portwwn') +'" class="frport_portwwn" />\
												</a>';
										}
										else {
											//FRPORT HTML
											system_html += '<ul class="as_hide"><li>\
											<a class="fcoe_rport expand" href="javascript:void(0);" name="inc'+k+''+m+''+n+'"  onclick="load_right_unique_content(\'frport_content__inc'+k+''+m+''+n+'end__' + ip_id + '\');" >\
											<img class="icon" src="images/black/rport.png" >' +
													$(this).attr('name') +
													'<input type="hidden" value="'+ n +'" class="frport_index" />\
													<input type="hidden" value="' +$(this).attr('frport_portwwn') +'" class="frport_portwwn" />\
													</a>';
										}
										
										/*$(this).find('flun').each(function(p){
											//FLUN HTML
											system_html += '<ul class="as_hide"><li>\
											<a href="javascript:void(0);" class="expand" name="inc'+k+''+m+''+n+''+p+'"  onclick="load_right_unique_content(\'flun_content__inc'+k+''+m+''+n+''+p+'end__' + ip_id + '\');" >\
											<img class="icon" src="images/black/flun.png" >' +
												$(this).attr('name') +
												'<input type="hidden" value="'+ p +'" class="flun_index" />\
												</a></li></ul>';
										});*/
										
										//FRPORT CLOSE
										system_html += '</li></ul>';
									
									});
									
									//VPORT
									$(this).find('fvport').each(function(q){
									if ($(this).find('fvrport').length) {
										//FVPORT HTML
										system_html += '<ul class="as_hide"><li>\
									<a href="javascript:void(0);" onclick="load_right_unique_content(\'fvport_content__inc'+m+''+q+'end__' + ip_id + '\');" class = "tree_action expand">\
									<img src="/images/black/tree_plus.png"></a>\
									<a class="fvport expand" name = "inc'+m+''+q+'" href="javascript:void(0);" onclick="load_right_unique_content(\'fvport_content__inc'+m+''+q+'end__' +
										ip_id +
										'\');" >\
									<img class="icon" src="images/black/vport.png" >' +
										$(this).attr('name') +
										'<input type="hidden" value="'+ q +'" class="fvport_index" />\
										<input type="hidden" value="' +$(this).attr('fvport_portwwn') +'" class="fvport_portwwn" />\
										</a>';
									}
									else {
										//FVPORT HTML
										system_html += '<ul class="as_hide"><li>\
									<a class="fvport expand" name = "inc'+m+''+q+'" href="javascript:void(0);" onclick="load_right_unique_content(\'fvport_content__inc'+m+''+q+'end__' + ip_id + '\');" >\
									<img class="icon" src="images/black/vport.png" >' +
										$(this).attr('name') +
										'<input type="hidden" value="'+ q +'" class="fvport_index" />\
										</a>';
									}
									
									$(this).find('fvrport').each(function(r){
										if ($(this).find('fvlun').length) {
											//FVRPORT HTML
											system_html += '<ul class="as_hide"><li>\
											<a href="javascript:void(0);" onclick="load_right_unique_content(\'fvrport_content__incend__' + ip_id + '\');" class = "tree_action expand">\
											<img src="/images/black/tree_plus.png"></a>\
											<a class="fcoe_vrport expand" name="inc'+q+''+r+'" href="javascript:void(0);" onclick="load_right_unique_content(\'fvrport_content__inc'+q+''+r+'end__' +
												ip_id +
												'\');" >\
											<img class="icon" src="images/black/rport.png" >' +
												$(this).attr('name') +
												'<input type="hidden" value="'+ r +'" class="fvrport_index" />\
												<input type="hidden" value="' +$(this).attr('fvrport_portwwn') +'" class="fvrport_portwwn" />\
												</a>';
										}
										else {
											//FVRPORT HTML
											system_html += '<ul class="as_hide"><li>\
											<a class="fcoe_vrport expand" name="inc'+q+''+r+'" href="javascript:void(0);" onclick="load_right_unique_content(\'fvrport_content__inc'+q+''+r+'end__' + ip_id + '\');" >\
											<img class="icon" src="images/black/rport.png" >' +
													$(this).attr('name') +
													'<input type="hidden" value="'+ r +'" class="fvrport_index" />\
													<input type="hidden" value="' +$(this).attr('fvrport_portwwn') +'" class="fvrport_portwwn" />\
													</a>';
										}
										
										/*$(this).find('fvlun').each(function(s){
											//FVLUN HTML
											system_html += '<ul class="as_hide"><li>\
											<a class="expand" name="inc'+k+''+m+''+q+''+r+''+s+'" href="javascript:void(0);" onclick="load_right_unique_content(\'fvlun_content__inc'+k+''+m+''+q+''+r+''+s+'end__' + ip_id + '\');" >\
											<img class="icon" src="images/black/flun.png" >' +
												$(this).attr('name') +
												'<input type="hidden" value="'+ s +'" class="fvlun_index" />\
												</a></li></ul>';
										});*/
										//FVRPORT CLOSE
										system_html += '</li></ul>';
										});
										//FVPORT CLOSE
										system_html += '</li></ul>';
									});
									//FLPORT CLOSE
									system_html += '</li></ul>';
								});
								//FCARD CLOSE
								system_html += '</li></ul>';
							});
						}
						//FCOE CLOSE
						system_html += '</li></ul>';
					}
					
					//Build iscsiinitiator node
					if ($(this).find('iscsiinitiator').length) {
						var iscsiinitiator_name = $(this).find('iscsiinitiator').attr('name');
						var iscsiinitiator_html = '<ul class="as_hide m_iscsi_initiator" ><li><a href="javascript:void(0);" onclick="load_right_unique_content(\'iscsi_initiator_content__incend__' + ip_id + '\');">\
											   <img class = "icon" src="images/black/iscsi_col.png">' +
						iscsiinitiator_name +
						'</a></li></ul>';
						//Append iscsiinitiator under system
						system_html += iscsiinitiator_html;
					}
					
					 //Build FoIscsiinitiator node
                    if ($(this).find('foiscsiinitiator').length) {
                            var foiscsiinitiator_name = $(this).find('foiscsiinitiator').attr('name');
                            var foiscsiinitiator_html = '<ul class="as_hide" ><li><a href="javascript:void(0);" onclick="load_right_unique_content(\'foiscsi_initiator_content__incend__' + ip_id + '\');">\
                                                                       <img class = "icon" src="images/black/iscsi_col.png">' +
                            foiscsiinitiator_name +
                            '</a></li></ul>';
                            //Append foiscsiinitiator under system
                            system_html += foiscsiinitiator_html;
                    }

					//Build iscsitarget node
					if ($(this).find('iscsitarget').length) {
						var iscsitarget_name = $(this).find('iscsitarget').attr('name');
						var iscsitarget_html = '<ul class="as_hide m_iscsi_target"><li><a href="javascript:void(0);" onclick="load_right_unique_content(\'iscsi_target_content__incend__' + ip_id + '\');" class = "tree_action"><img src="/images/black/tree_plus.png"></a>\
								<a href="javascript:void(0);" onclick="load_right_unique_content(\'iscsi_target_content__incend__' +
						ip_id +
						'\');" >\
								<img class = "icon" src="images/black/iscsi_col.png">' +
						iscsitarget_name +
						'</a>';
						//Append card under system
						system_html += iscsitarget_html;
						
						
						//Build iscsitarget sub nodes
						system_html += '<ul class="as_hide">';
						//Build luns node
						if ($(this).find('luns').length) {
							var lun_name = $(this).find('luns').attr('name');
							var luns_html = '<li><a href="javascript:void(0);" onclick="load_right_unique_content(\'lun_content__incend__' + ip_id + '\');" >\
										 <img class = "icon" src="images/black/lun_col.png" />\
									' +
							lun_name +
							'</a></li>';
							system_html += luns_html;
						}
						//Build pgs node
						if ($(this).find('pgs').length) {
							var pgs_name = $(this).find('pgs').attr('name');
							var pgs_html = '<li><a href="javascript:void(0);" onclick="load_right_unique_content(\'pg_content__incend__' + ip_id + '\');" >\
										<img class = "icon" src="images/black/pg_col.png" />\
									' +
							pgs_name +
							'</a></li>';
							system_html += pgs_html;
						}
						//Build acls node
						if ($(this).find('acls').length) {
							var acls_name = $(this).find('acls').attr('name');
							var acls_html = '<li><a href="javascript:void(0);" onclick="load_right_unique_content(\'acl_content__incend__' + ip_id + '\');" >\
										 <img class = "icon" src="images/black/acls_col.png">\
									' +
							acls_name +
							'</a></li>';
							system_html += acls_html;
						}
						//End iscsitarget sudnodes
						system_html += '</ul>';
						//End iscsitarget node
						system_html += '</li></ul>';
					}
					
					//End Storage node
					system_html += '</li></ul>';
				}
				
				if ($(this).find('hardware').length) {
					//Hardware Main Node
					if (ostype == '3' || ostype == '6' ) {
						system_html += '<ul><li>\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'hardware_maincontent__incend__' +
						ip_id +
						'\');" >\
							<img class="icon" src="images/black/hw.png" >Hardware Features</a>';
					}
					else{
						system_html += '<ul><li>\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'hardware_maincontent__incend__' + ip_id + '\');" class = "tree_action">\
							<img src="/images/black/tree_plus.png"></a>\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'hardware_maincontent__incend__' +
						ip_id +
						'\');" >\
							<img class="icon" src="images/black/hw.png" >Hardware Features</a>';
					}
					
					//Build filtering node
					if ($(this).find('filtering').length) {
						var filtering_name = $(this).find('filtering').attr('name');
						var filtering_html = '<ul class="as_hide m_filter" ><li><a  href="javascript:void(0);" onclick="load_right_unique_content(\'filtering_content__incend__' + ip_id + '\');" >\
										  <img  class = "icon" src="images/black/filter_col.png">' +
						filtering_name +
						'</a></li></ul>';
						//Append filtering under system
						system_html += filtering_html;
					}
					
					//Build TM node
					if ($(this).find('tm').length) {
						//Build traffic management node
						var tm_name = $(this).find('tm').attr('name');
						var tm_html = '<ul class="as_hide m_tm"><li><a href="javascript:void(0);" onclick="load_right_unique_content(\'traffic_manage_content__incend__' + ip_id + '\');" >\
								   <img class = "icon" src="images/black/tm_col.png">\
								' +
						tm_name +
						'</a></li></ul>';
						//Append tm under system
						system_html += tm_html;
					}
					
					//Build Boot node
					if ($(this).find('boot').length) {
						system_html += '<ul class="as_hide m_boot"><li>\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'boot_content__incend__' + ip_id + '\');" >\
							<img class="icon" src="images/black/boot.png" >Boot</a></li></ul>';
					}

					//Build Bypass node
					if ($(this).find('bypass').length) {
						system_html += '<ul class="as_hide m_bypass"><li>\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'bypass_content__incend__' + ip_id + '\');" >\
							<img class="icon" src="images/black/bypass.png" >Bypass</a></li></ul>';
					}
					
					
					//T4 Egress Class Schedulers Node
					if ($(this).find('t4Egress').length) {
						system_html += '<ul class="as_hide"><li>\
							<a href="javascript:void(0);" onclick="load_right_unique_content(\'egress_content__incend__' + ip_id + '\');" >\
							<img class="icon" src="images/black/scheduler.png" >T4 Egress Class Schedulers</a></li></ul>';
					}
					
					//End Hardware Node
					system_html += '</li></ul>';
				}
				
				//End system node
				system_html += '</li></ul>';
				
				//End home node
				system_html += '</div></div>';
				$('#m_tree_wrap').prepend(system_html);
				
				if(menu_callback_fn){
					eval(menu_callback_fn);
					end_flag = true;
				}
				
			});
			
			if(end_flag){
				return;
			}
			
			if( !system_count ){
				$('.menu_status_wrapper').show();
				$('.left_top_nav a.remove_pc').removeClass('effect').addClass('inactive').removeAttr('style');	
			}
			
			$('#details_' + last_id_count + ' h1').removeClass('hide').addClass('show');
			$('#details_' + last_id_count + ' .tree').slideDown(300,function(){
				$(this).removeClass('hidden').addClass('shown');
			});
			
			//fill the added agent in the services discovery panel
			try{
				fill_services_disc();
			}
			catch(e){}
			
			//Load its system page by default
			if( menu_ipid == '' ){
				load_right_content('home_content.html');
			}
			else{
				load_right_unique_content('system_content__incend__'+menu_ipid);
			}
			menu_ipid = '';
		}
	});
}

function menu_select(element){
	call_expand_shrink(element);
	$('#m_tree_wrap .tree .tree_ul a:not(.tree_action)').removeClass('selected');
	$(element).addClass('selected');
}

function call_expand_shrink(element){
	if($(element).hasClass('expand')){
		expand_shrink(true);
	}
	else{
		expand_shrink(false);
	}
}