//Lun list is returning an empty list
function initialize_lun_update(ip_id){
	var unique_parent_id = '#lun_content__incend__' + ip_id+' .lun_content_update_lun_tab';
	var loader_selector = unique_parent_id + ' .initializer';
	$(loader_selector).hide();
	
	if( $(loader_selector).css('display') == 'block' || $(unique_parent_id +' .global_error').css('display') == 'block' || $(unique_parent_id +' .targets_list').length ){
		return
	}
	
	$(loader_selector).show();
	var ip = replace_with(ip_id, '_', '.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&ip=' + ip;
	
	//Initializing
	$(unique_parent_id +' .status_link, '+ unique_parent_id +' .refresh').attr('onclick','$("'+loader_selector +'").hide();$("'+unique_parent_id +' .targets_list").remove();initialize_lun_update("'+ ip_id +'")');
	$(unique_parent_id +' .i_lu_move_up').attr('onclick','i_lu_alter_position("'+ unique_parent_id +'", "up")');
	$(unique_parent_id +' .i_lu_move_down').attr('onclick','i_lu_alter_position("'+ unique_parent_id +'", "down")');
	$(unique_parent_id +' .i_lu_delete_lun').attr('onclick','i_lu_delete_lun("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'","'+ loader_selector +'","delete")');
	
	$(unique_parent_id +' .i_lu_psave_wr').attr('onclick','i_lu_save_changes("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'","'+ loader_selector +'")');
	$(unique_parent_id +' .i_lu_pdiscard_wr').attr('onclick','i_lu_discard_changes("'+ unique_parent_id +'", "'+ ip_id +'", "'+ ip +'", "'+ loader_selector +'")');
	
	i_lu_make_default(unique_parent_id);
	
	$.ajax({
		url: '/python/iscsi_target_lun_update.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=get_targets',
		success: function(html){
			$(loader_selector).hide();
			if (html == '-2') {
				show_redirect_alert();
			}
			else if (html == '67') {
				show_error_msg(unique_parent_id, 'iSCSI Target driver not loaded');
			}
			else if (html != '-1') {
				$(unique_parent_id + ' .i_lu_select_li').html(html);
			}
			else{
				//display_failed(unique_parent_id);
			}
		}
	});
}

function i_lu_get_luns(unique_parent_id, ip_id, ip, loader_selector){
	
	i_lu_make_default(unique_parent_id);	
	if( $.trim($(unique_parent_id +' .targets_list').val()) == 'null' ){
		return false
	}
	
	$(loader_selector).show();

	target_status = $.trim($(unique_parent_id+' .targets_list option:selected').attr('title'));
	if ( target_status == '0' ){
		$(unique_parent_id+' .i_lu_tstatus').html('STOPPED').removeAttr('class').addClass('i_lu_tstatus i_lu_tstopped mgn_l10 f_bold');	
	}
	else if ( target_status == '1' ){
		$(unique_parent_id+' .i_lu_tstatus').html('STARTED').removeAttr('class').addClass('i_lu_tstatus i_lu_tstarted mgn_l10 f_bold');
	}
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var getdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&index='+$(unique_parent_id +' .targets_list').val()+'&ostype='+ostype;
	$.ajax({
		url: '/python/iscsi_target_lun_update.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=get_lun_list',
		success: function(html){
			$(loader_selector).hide();
			if (html == '-2') {
				show_redirect_alert();
			}
			else if (html != '-1') {
				$(unique_parent_id + ' .i_lu_lun_list').html(html);
			}
			else{
				//display_failed(unique_parent_id);
			}
		}
	});
}

function i_lu_lun_select(element, unique_parent_id, ip_id, ip, loader_selector){

	$(unique_parent_id+' .error_status').html('');
	if( $(element).hasClass('selected') ){
		$(element).removeClass('selected');
	}
	else{
		$(element).addClass('selected');
	}
	
	if ( $(unique_parent_id + ' .i_lu_lun_list ul li.selected').length > 1 ) {
		$(unique_parent_id + ' .i_lu_delete_lun button').removeClass('blue').addClass('disabled');
		$(unique_parent_id+' input[type=text]').removeAttr('disabled').val('').attr('disabled','disabled');
		$(unique_parent_id+' input[type=radio]').removeAttr('checked');
		return false;
	}
	else if ( $(unique_parent_id + ' .i_lu_lun_list ul li.selected').length == 0 ) {
		$(unique_parent_id + ' .i_lun_update_wr button').removeClass('blue').addClass('disabled');
		$(unique_parent_id+' input[type=text]').removeAttr('disabled').val('').attr('disabled','disabled');
		$(unique_parent_id+' input[type=radio]').removeAttr('checked');
		return false;
	}
	
	i_lu_fill_values(unique_parent_id);
}

function i_lu_fill_values(unique_parent_id){
	$(unique_parent_id + ' .i_lun_update_wr button').removeClass('disabled').addClass('blue');
	$(unique_parent_id+' .i_lu_form_fd input[type=text]').removeAttr('disabled');
	$(unique_parent_id+' .i_lu_form_fd input[type=radio]').removeAttr('disabled');
	$(unique_parent_id+' .i_lu_form_fd .lunname').removeAttr('disabled').val($(unique_parent_id + ' .i_lu_lun_list ul li.selected').children('.lunname').val())
	$(unique_parent_id+' .i_lu_form_fd .ramdisk').removeAttr('disabled').val($(unique_parent_id + ' .i_lu_lun_list ul li.selected').children('.ramdisk').val());
	$(unique_parent_id+' .i_lu_form_fd .permissions_ul input[value='+$(unique_parent_id + ' .i_lu_lun_list ul li.selected').children('.permissions').val()+']').attr('checked','checked');
	$(unique_parent_id+' .i_lu_form_fd .mode_ul input[value='+$(unique_parent_id + ' .i_lu_lun_list ul li.selected').children('.devicetype').val()+']').attr('checked','checked')
	$(unique_parent_id+' .i_lu_form_fd .options_ul input[value='+$(unique_parent_id + ' .i_lu_lun_list ul li.selected').children('.options').val()+']').attr('checked','checked');
	$(unique_parent_id+' .i_lu_form_fd input[type=text]').attr('disabled','disabled');
	$(unique_parent_id+' .i_lu_form_fd input[type=radio]').attr('disabled','disabled');
}

function i_lu_make_default(unique_parent_id){
	$(unique_parent_id+' .i_lu_lun_list').html('');
	$(unique_parent_id+' input[type=text]').removeAttr('disabled').val('').attr('disabled','disabled');
	$(unique_parent_id+' input[type=radio]').removeAttr('checked');
	$(unique_parent_id+' .i_lu_tstatus').html('');
	$(unique_parent_id+' .i_lun_update_wr button').removeClass('blue').addClass('disabled');
	$(unique_parent_id+' .error_status').html('');
}

function i_lu_alter_position(unique_parent_id, direction){
	$(unique_parent_id+' .error_status').html('');
	if( $(unique_parent_id+' .i_lun_update_wr button').hasClass('disabled') ){
		return;
	}
	
	var current_html = $(unique_parent_id+' .i_lu_lun_list li.selected').clone();
	
	if( direction == 'up' ){
		
		if($(unique_parent_id+' .i_lu_lun_list li.selected:first').hasClass('position_1')){
			$(unique_parent_id+' .error_status').html('Operation not allowed. Cannot move up');
			return false;
		}
		else if ($(unique_parent_id + ' .i_lu_lun_list li.selected').length == $(unique_parent_id + ' .i_lu_lun_list li').length) {
			$(unique_parent_id + ' .error_status').html('Operation not allowed.');
		}
		else if ($(unique_parent_id + ' .i_lu_lun_list li.selected').length > 1) {
				var li_len = $(unique_parent_id + ' .i_lu_lun_list li.selected').length;
				var iter_len = 0;
				var counter_start = false;
				var error_flag = false;
				$(unique_parent_id + ' .i_lu_lun_list li').each(function(i){
				
					if ($(this).hasClass('selected')) {
						counter_start = true;
					}
					
					if (counter_start) {
						iter_len++;
						if ($(this).hasClass('selected')) {
							if (iter_len > li_len) {
								$(unique_parent_id + ' .error_status').html('Operation not allowed. Cannot move up');
								error_flag = true;
								return false
							}
						}
					}
					
					if (i == parseInt($(unique_parent_id + ' .i_lu_lun_list li').length) - 1 && !error_flag) {
						i_lu_moveup(unique_parent_id, current_html);
					}
					
				});
			}
			else {
				i_lu_moveup(unique_parent_id, current_html);
			}
		
	}
	else if( direction == 'down' ){
		
		if($(unique_parent_id+' .i_lu_lun_list li.selected:last').hasClass('position_'+String($(unique_parent_id+' .i_lu_lun_list li').length))){
			$(unique_parent_id+' .error_status').html('Operation not allowed. Cannot move down');
			return false;
		}
		else if ($(unique_parent_id + ' .i_lu_lun_list li.selected').length == $(unique_parent_id + ' .i_lu_lun_list li').length) {
			$(unique_parent_id + ' .error_status').html('Operation not allowed.');
		}
		else if( $(unique_parent_id+' .i_lu_lun_list li.selected').length > 1 ){
			var li_len = $(unique_parent_id+' .i_lu_lun_list li.selected').length;
			var iter_len = 0;
			var counter_start = false;
			var error_flag = false;
			$(unique_parent_id+' .i_lu_lun_list li').each(function(i){

				if( $(this).hasClass('selected') ){
					counter_start = true;
				}

				if( counter_start ){
					iter_len++;
					if( $(this).hasClass('selected') ){
						if( iter_len > li_len ){
							$(unique_parent_id+' .error_status').html('Operation not allowed. Cannot move Down');
							error_flag = true;
							return false
						}	
					}	
				}
				
				if( i == parseInt($(unique_parent_id+' .i_lu_lun_list li').length)-1 && !error_flag ){
					i_lu_movedown(unique_parent_id, current_html);
				}
				
			});
		}
		else{
			i_lu_movedown(unique_parent_id, current_html);
		}
		
	}
	else{
		return false;
	}
}

function i_lu_moveup(unique_parent_id, current_html){
	var current_position = parseInt($.trim($(unique_parent_id+' .i_lu_lun_list li.selected:first').attr('name')).replace('position_','')); 
	current_position--;
	$(unique_parent_id+' .i_lu_lun_list li.selected').remove();
	$(unique_parent_id+' .position_'+String(current_position)).before(current_html);
	i_lu_assign_position(unique_parent_id);
}

function i_lu_movedown(unique_parent_id, current_html){
	var current_position = parseInt($.trim($(unique_parent_id+' .i_lu_lun_list li.selected:last').attr('name')).replace('position_','')); 
	current_position++;
	$(unique_parent_id+' .i_lu_lun_list li.selected').remove();
	$(unique_parent_id+' .position_'+String(current_position)).after(current_html);
	i_lu_assign_position(unique_parent_id);
}

function i_lu_assign_position(unique_parent_id){
	$(unique_parent_id+' .i_lu_lun_list li').each(function(i){
		$(this).attr('name',i+1);
		var select_class = '';
		if( $(this).hasClass('selected') ){
			var select_class = 'selected';
		}
		$(this).removeAttr('class').addClass(select_class+' lun hover_li position_'+String(i+1));		
	});
	$(unique_parent_id+' input[type=text]').removeAttr('disabled').val('').attr('disabled','disabled');
	$(unique_parent_id+' input[type=radio]').removeAttr('checked');
	if( $(unique_parent_id+' .i_lu_lun_list li.selected').length == 1 ){
		i_lu_fill_values(unique_parent_id);		
	}  
}

function i_lu_save_changes(unique_parent_id, ip_id, ip, loader_selector){
	
	if( $(unique_parent_id+' .i_lu_psave_wr button').hasClass('disabled') ){
		return;
	}
	
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&index='+$(unique_parent_id +' .targets_list').val();
	var lunname_str = '';
	var totla_lun_str = $(unique_parent_id+' .lunnamestr').length;
	$(unique_parent_id+' .lunnamestr').each(function(i){
		if( i == totla_lun_str-1 || i == 0 ){
			lunname_str += $(this).val();			
		}
		else{
			lunname_str += $(this).val()+'#';
		}
	});
	postdata += '&lunnamestr='+lunname_str;
	$(loader_selector).show();
	$.ajax({
		url: '/python/iscsi_target_lun_update.py',
		type: 'POST',
		cache: false,
		data: postdata+'&action=save_order',
		success: function(status){
			$(loader_selector).hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status != '-1') {
				display_success(unique_parent_id);
				i_lu_make_default(unique_parent_id);
				$(unique_parent_id+' .targets_list').trigger('change');
			}
			else{
				//display_failed(unique_parent_id);
			}
		}
	});
}

function i_lu_discard_changes(unique_parent_id, ip_id, ip, loader_selector){
	if( $(unique_parent_id+' .i_lu_pdiscard_wr button').hasClass('disabled') ){
		return false;
	}
	else{
		i_lu_get_luns(unique_parent_id, ip_id, ip, loader_selector);
		$(unique_parent_id+' .i_lun_update_wr button').removeClass('blue').addClass('disabled');
		$(unique_parent_id+' .error_status').html('');		
	}
}

function i_lu_delete_lun(unique_parent_id, ip, ip_id, loader_selector){
	
	if( $(unique_parent_id+' .i_lu_delete_lun button').hasClass('disabled') ){
		return;
	}
	
	var postdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&index='+$(unique_parent_id +' .targets_list').val();
	postdata += '&lunnamestr='+$(unique_parent_id+' .i_lu_lun_list li.selected').children('.lunnamestr').val();
	$(loader_selector).show();
	$.ajax({
		url: '/python/iscsi_target_lun_update.py',
		type: 'POST',
		cache: false,
		data: postdata+'&action=delete_lun',
		success: function(status){
			$(loader_selector).hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status != '-1') {
				display_success(unique_parent_id);
				i_lu_make_default(unique_parent_id);
				$(unique_parent_id+' .targets_list').trigger('change');
			}
			else{
				//display_failed(unique_parent_id);
			}
		}
	});
}