function initialize_add_lun(ip_id){
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var unique_parent_id = '#lun_content__incend__' + ip_id+' .lun_content_add_lun_tab';
	var loader_selector = unique_parent_id + ' .initializer';
	$(loader_selector).hide();
	
	if( $(loader_selector).css('display') == 'block' || $(unique_parent_id +' .global_error').css('display') == 'block' ){
		return
	}
	
	$(loader_selector).show();
	var ip = replace_with(ip_id, '_', '.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&ip=' + ip;
	
	//Initializing
	$(unique_parent_id +' .status_link, '+ unique_parent_id +' .refresh').attr('onclick','$("'+loader_selector +'").hide();$("'+unique_parent_id +' .targets_list").remove();initialize_add_lun("'+ ip_id +'")');
	$(unique_parent_id +' .i_la_psave_wr').attr('onclick','i_la_save_changes("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'")');
	$(unique_parent_id +' .i_la_pdiscard_wr').attr('onclick','i_la_discard("'+ unique_parent_id +'")');
	
	i_la_make_default(unique_parent_id);
	
	$.ajax({
		url: '/python/iscsi_target_add_lun.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata+'&action=initial&ostype='+ostype,
		success: function(data){
			$(loader_selector).hide();
			if ( data.targets_list == '-2' || data.devices_list == '-2' ) {
				show_redirect_alert();
				return false;
			}
			
			if ( data.targets_list == '67' || data.devices_list == '67' ) {
				show_error_msg(unique_parent_id, 'iSCSI Target driver not loaded');
				return false;
			}
			
			if( data.targets_list !=  '-1' ) {
				$(unique_parent_id + ' .targets_list_dl').html(data.targets_list);
			}
			else{
				//$(unique_parent_id + ' .global_error').show(300);
			}
			
			if( data.devices_list !=  '-1' ) {
				$(unique_parent_id + ' .devices_list_dl').html(data.devices_list);
			}
			else{
				//$(unique_parent_id + ' .global_error').show(300);
			} 
		}
	});
}

function i_la_show_type( element, unique_parent_id, ip_id, ip, loader_selector ){
	$(unique_parent_id + ' .ram_disk_input').val('');
	if( $(element).val() == 'null') {
		$(unique_parent_id + ' .type_dl').html('&nbsp;');
		return false;
	}
	else{
		$(element).removeClass('error');
		if( parseInt($.trim($(unique_parent_id+' .devices_list option:selected').attr('name'))) == 5 ){
			$(unique_parent_id + ' .type_dl').html('MEM');
			$(unique_parent_id + ' .ram_disk_input').removeAttr('disabled').removeClass('disabled');
		}
		else if( parseInt($.trim($(unique_parent_id+' .devices_list option:selected').attr('name'))) == 6 ){
			$(unique_parent_id + ' .type_dl').html('BLK');
			$(unique_parent_id + ' .ram_disk_input').attr('disabled','disabled').addClass('disabled');
		}
		else if( parseInt($.trim($(unique_parent_id+' .devices_list option:selected').attr('name'))) == 7 ){
			$(unique_parent_id + ' .type_dl').html('FILE');
			$(unique_parent_id + ' .ram_disk_input').attr('disabled','disabled').addClass('disabled');
		}
	}
}

function i_la_save_changes( unique_parent_id, ip, ip_id ){
	
	var success = true;
	$(unique_parent_id + ' select').each(function(){
		if( $(this).val() == 'null' ){
			$(this).addClass('error');
			success = false;
		}	
	})
	
	if( $.trim($(unique_parent_id + ' .devices_list option:selected').attr('name')) == '5' && $.trim($(unique_parent_id + ' .ram_disk_input').val()) == '' ){
		$(unique_parent_id + ' .ram_disk_input').addClass('error');
		success = false;
	}
	
	if( !$(unique_parent_id + ' .targets_list').length ){
		success = false;
	}
	
	if( !success ){
		return false;
	}
	
	var ip = replace_with(ip_id, '_', '.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&ip=' + ip+'&index='+$(unique_parent_id + ' .targets_list').val();
	if( $.trim($(unique_parent_id + ' .devices_list option:selected').attr('name')) == '5' ){
		var next_ramkdisk = '';
		if( $(unique_parent_id + ' .devices_list').val() == '5' ){
			next_ramkdisk = 'ramdisk'+$(unique_parent_id + ' .ramdisk').val()+',';
		}
		lun_string = next_ramkdisk+'MEM,size='+ $(unique_parent_id + ' .ram_disk_input').val() +'MB';		
	}
	else{
		lun_string = $.trim($(unique_parent_id + ' .devices_list option:selected').html().split('-')[0])+','+ $.trim($(unique_parent_id + ' .type_dl').html());
	}
	
	getdata += '&lun_string='+lun_string;
	$(unique_parent_id + ' .btn_wraper').hide();
	$(unique_parent_id + ' .result').hide();
	$(unique_parent_id + ' .la_action_status').show();
	
	$.ajax({
		url: '/python/iscsi_target_add_lun.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=save',
		success: function(data){
			
			$(unique_parent_id + ' .btn_wraper').hide();
			$(unique_parent_id + ' .result').hide();
			
			if ( data == '-2' ) {
				$(unique_parent_id + ' .la_error_status').show();
				show_redirect_alert();
			}
			else if(data !=  '-1' ) {
				$(unique_parent_id + ' .la_del_success_status').show();
			}
			else{
				$(unique_parent_id + ' .la_error_status').show();
			}

		}
	});
}

function i_la_discard(unique_parent_id){
	i_la_make_default(unique_parent_id);
}

function i_la_make_default(unique_parent_id){
	$(unique_parent_id + ' select').removeClass('error');
	$(unique_parent_id + ' input').removeClass('error');
	$(unique_parent_id + ' .targets_list').val('null');
	$(unique_parent_id + ' .devices_list').val('null');
	$(unique_parent_id + ' .ram_disk_input').val('');
	$(unique_parent_id + ' .type_dl').html('&nbsp;');
	$(unique_parent_id + ' .result').hide();
	$(unique_parent_id + ' .btn_wraper').show();
}

function i_add_lun_get_next_ramdisk(element, unique_parent_id, ip){
	$(element).removeClass('error');
	if( $(element).val() == 'null' ){
		return
	}
	var sid = GetCookie("chelsio_webgui_sid");
	var index = $(unique_parent_id+' .targets_list').val();
	var ip_id = replace_with(ip,'.','_');
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var getdata = 'sid='+sid+'&ip='+ip+'&index='+index+'&ostype='+ostype;
	$(unique_parent_id + ' .initializer').show();
	$.ajax({
		url: '/python/iscsi_target_add_lun.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=get_next_ramdisk',
		success: function(data){
			$(unique_parent_id + ' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if(data !=  '-1' ) {
				$(unique_parent_id + ' .ramdisk').val(data);
			}
			else{
				//$(unique_parent_id + ' .global_error').show();
			}

		}
	});
}