$(document).ready(function(){
	$('.vm_tree_li a.tree_action').live('click',function(){
		$('.vm_tree_li a:not(.tree_action)').removeClass('selected');
		$(this).next().trigger('click');
	});
});

function fill_lin_bridge_conf(ip_id){	
	var unique_parent_id = '#hypervisor_linux_content__incend__'+ ip_id+' .lin_bridge_conf_tab';
	$(unique_parent_id+' .initializer').show();
	
	$(unique_parent_id+' .lin_tree_wr').html('');
	$(unique_parent_id+' .detail_wr').hide();
	$(unique_parent_id+' .detail_wr dd:not(.value_dd)').html('&nbsp;');
	$(unique_parent_id+' .detail_wr .value_dd input').val('').removeClass('error');
	
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip+'&type=desktop';
	
	$(unique_parent_id + ' .refresh a').attr('onclick', '$("' + unique_parent_id + ' .lin_tree_wr").html("");fill_lin_bridge_conf("' + ip_id + '")');
	$(unique_parent_id + ' .delete_bridge').attr('onclick','lin_delete_bridge("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'" )');
	$(unique_parent_id + ' .delete_vif').attr('onclick','lin_delete_vif("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'")');
	$(unique_parent_id + ' .delete_pif').attr('onclick','lin_delete_pif("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'")');
	$(unique_parent_id + ' .save_bridge_values').attr('onclick','lin_save_bridge_values("'+ unique_parent_id +'", "'+ getdata +'", "'+ip_id+'")');
	load_lin_bridge_conf(unique_parent_id, getdata);
}

function load_lin_bridge_conf(unique_parent_id, getdata){
	getdata += '&action=get'
	$.ajax({
		url: '/python/lin_bridge_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(html){
			$(unique_parent_id+' .initializer').hide();
			
			if ( html == '-2' ) {
				show_redirect_alert();
			}
			else if ( html != '-1' ) {
				$(unique_parent_id+' .lin_tree_wr').html(html);
				$(unique_parent_id+' .lin_tree_wr ul:first li a[alt=bridge]').trigger('click');
			}
		}
	});	
}


function lin_conf_select(unique_parent_id, element, c_type ){
	$(unique_parent_id+' .vm_tree_li a:not(.tree_action)').removeClass('selected');
	element.addClass('selected');
	$(unique_parent_id+' .detail_wr').hide();
	$(unique_parent_id+' .lbc_'+c_type+'_wr').fadeIn(300);
	if( c_type == 'bridge' ){
		$(unique_parent_id+' .lbc_bridge_wr .name').html(lin_bridge_check_value(element.children('.name').val()));
		$(unique_parent_id+' .lbc_bridge_wr .pathCost').html(lin_bridge_check_value(element.children('.pathCost').val()));
		$(unique_parent_id+' .lbc_bridge_wr .maxAge').val(lin_bridge_check_value(element.children('.maxAge').val()));
		$(unique_parent_id+' .lbc_bridge_wr .helloTime').val(lin_bridge_check_value(element.children('.helloTime').val()));
		$(unique_parent_id+' .lbc_bridge_wr .ageingTime').val(lin_bridge_check_value(element.children('.ageingTime').val()));
		$(unique_parent_id+' .lbc_bridge_wr .forwardDelay').val(lin_bridge_check_value(element.children('.forwardDelay').val()));
		$(unique_parent_id+' .lbc_bridge_wr .tcnTimer').html(lin_bridge_check_value(element.children('.tcnTimer').val()));
		$(unique_parent_id+' .lbc_bridge_wr .helloTimer').val(lin_bridge_check_value(element.children('.helloTimer').val()));
		$(unique_parent_id+' .lbc_bridge_wr .topologyChangeTimer').html(lin_bridge_check_value(element.children('.topologyChangeTimer').val()));
		$(unique_parent_id+' .lbc_bridge_wr .gcTimer').html(lin_bridge_check_value(element.children('.gcTimer').val()));
		$(unique_parent_id+' .lbc_bridge_wr .id').html(lin_bridge_check_value(element.children('.id').val()));
		$(unique_parent_id+' .lbc_bridge_wr .designatedRoot').html(lin_bridge_check_value(element.children('.designatedRoot').val()));
	}
	else if( c_type == 'pif' ){
		$(unique_parent_id+' .lbc_pif_wr .vendor_id').html(lin_bridge_check_value(element.children('.vendor_id').val()));
	}
	else if( c_type == 'vif' ){
		$(unique_parent_id+' .lbc_vif_wr .ifname').html(lin_bridge_check_value(element.children('.ifname').val()));
	}
	else if( c_type == 'vm' ){
		$(unique_parent_id+' .lbc_vm_wr .name').html(lin_bridge_check_value(element.children('.name').val()));
		$(unique_parent_id+' .lbc_vm_wr .osType').html(lin_bridge_check_value(element.children('.osType').val()));
		$(unique_parent_id+' .lbc_vm_wr .uuid').html(lin_bridge_check_value(element.children('.uuid').val()));
		$(unique_parent_id+' .lbc_vm_wr .domainState').html(lin_bridge_check_value(element.children('.domainState').val()));
	}
}

function lin_delete_bridge( unique_parent_id, getdata, ip_id ){
	if( !$(unique_parent_id+' .tree_ul li a.selected').length ){
		return
	}
	getdata += '&action=del_bridge&brname='+$(unique_parent_id+' .tree_ul li a.selected').children('.name').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/lin_bridge_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .lin_tree_wr').html('');
				fill_lin_bridge_conf(ip_id);
			}
			else{
				show_error_info(unique_parent_id, data);
			}
		}
	});		
}

function lin_delete_vif( unique_parent_id, getdata, ip_id ){
	if( !$(unique_parent_id+' .tree_ul li a.selected').length ){
		return
	}
	
	getdata += '&action=del_vif&brname='+$(unique_parent_id+' .tree_ul li a.selected').children('.brname').val();
	getdata += '&ifname='+$(unique_parent_id+' .tree_ul li a.selected').children('.ifname').val();
	getdata += '&vmid='+$(unique_parent_id+' .tree_ul li a.selected').children('.vmid').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/lin_bridge_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .lin_tree_wr').html('');
				fill_lin_bridge_conf(ip_id);
				show_error_msg(unique_parent_id, 'VIF / VNET deleted Successfully. Please do restart the VM to see the changes.')
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});		
}

function lin_delete_pif( unique_parent_id, getdata, ip_id ){
	
	if( !$(unique_parent_id+' .tree_ul li a.selected').length ){
		return
	}
	
	getdata += '&action=del_pif&brname='+$(unique_parent_id+' .tree_ul li a.selected').children('.brname').val();
	getdata += '&ifname='+$(unique_parent_id+' .tree_ul li a.selected').children('.ifname').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/lin_bridge_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .lin_tree_wr').html('');
				fill_lin_bridge_conf(ip_id);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});		
}


function lin_save_bridge_values( unique_parent_id, getdata, ip_id ){
	
	var success = true;
	$(unique_parent_id+' .lbc_bridge_wr input').each(function(){
		if( $.trim( $(this).val() ) == '' ){
			$(this).addClass('error');
			success = false;
		}
	});
	
	if( !success ){
		return
	}
	
	getdata += '&action=save_bridge_val&brname='+$(unique_parent_id+' .tree_ul li a.selected').children('.name').val();
	getdata += '&maxAge='+$(unique_parent_id+' .lbc_bridge_wr .maxAge').val()+'&helloTime='+$(unique_parent_id+' .lbc_bridge_wr .helloTime').val();
	getdata += '&ageingTime='+$(unique_parent_id+' .lbc_bridge_wr .ageingTime').val()+'&forwardDelay='+$(unique_parent_id+' .lbc_bridge_wr .forwardDelay').val();
	$(unique_parent_id+' .initializer').show();
	$.ajax({
		url: '/python/lin_bridge_conf.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if ( data == '-2' ) {
				show_redirect_alert();
			}
			else if ( data == '0' ) {
				$(unique_parent_id+' .lin_tree_wr').html('');
				fill_lin_bridge_conf(ip_id);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});		
}

function lin_bridge_check_value(value){
	if( $.trim(value) == '' ){
		return '-';
	}
	else{
		return value;
	}
}