function initialize_iwarp_settings(ip_id){
	var unique_parent_id = '#iwarp_content__incend__' + ip_id+' .iwarp_settings_tab';
	var ip = replace_with(ip_id,'_','.');
	var loader_selector = unique_parent_id +' .initializer';
	$(loader_selector).hide();
	
	if( $(loader_selector).css('display') == 'block' || $.trim($(unique_parent_id +' .overlay_disp_wr').html()) != '' ){
		return
	}
	
	$(loader_selector).show();
	var sid = GetCookie("chelsio_webgui_sid");
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var getdata = 'sid='+sid+'&ip='+ip+'&type=desktop&ostype='+ostype;
	
	//Initializing
	$(unique_parent_id +' .refresh a').attr('onclick','initialize_iwarp_settings("'+ ip_id +'")');
	$(unique_parent_id +' .discard_wr').attr('onclick','iw_discard_changes("'+ unique_parent_id +'","'+ ip_id +'","'+ ostype +'")');
	$(unique_parent_id +' .save_changes_wr').attr('onclick','iw_save_changes("'+ unique_parent_id +'","'+ getdata +'","'+ ip_id +'","'+ ostype +'")');
	$(unique_parent_id +' .iw_driver').attr('onchange','iwarp_get_settings("'+ unique_parent_id +'","'+ getdata +'","'+ ostype +'", $(this))');
	
	$(unique_parent_id+' .iwarp_settings_main').html('');
	$(unique_parent_id+' .iw_properties').hide();
	if( ostype == '1' ){
		$(unique_parent_id+ ' .win').show();
		//Generate the Card select box
		var card_html = '';
		var card_option_html = '<option value="">Select One..</option>';
		var port_html = '';
		$(unique_parent_id+' .iw_port_li').html('<select class="iw_port card_d" ><option value="">Select One..</option></select>');
		$('#ip_'+ip_id+' .card').each(function(i){
			if ($(this).children('.t3').length) {
				var pciloc = $(this).children('.pciloc').val();
				card_option_html += '<option value="'+pciloc+'__card_'+i+'" >'+$(this).children('.tree_cardname').html()+'</option>';
				port_html = '';
				for( j=0; j<$(this).next().find('.menu_port_li').length; j++){
					k = j+1;
					port_html += '<option value="'+k+'" >Port #'+k+'</option>';
				}
				$(unique_parent_id+' .iw_port_li').append('<select class="iw_port as_hide card_'+i+'" \
				onchange = "iwarp_get_settings(\''+unique_parent_id+'\', \''+getdata+'\',\''+ ostype +'\', $(this))"\
				>'+port_html+'</select>');		
			}
		});
		$(unique_parent_id+' .iw_card_li').html('<select class="iw_card" onchange = "iwarp_show_port(\''+unique_parent_id+'\', $(this))" >'+card_option_html+'</select>');
	}
	else if( ostype == '2' ){
		$(unique_parent_id+ ' .linux').show();
		$(unique_parent_id+ ' .iw_driver').val('');
		$(unique_parent_id).animate({
			height: '103px'
		},300);
	}
	else if( ostype == '4' ){
		$(unique_parent_id+ ' .freebsd').show();
		$(unique_parent_id+ ' .iw_driver').val('');
		$(unique_parent_id).animate({
			height: '103px'
		},300);
		$(unique_parent_id +' .iw_driver').attr('onclick','get_iwarp_driver_details("'+ unique_parent_id +'","'+ getdata +'","'+ ostype +'")');
	}
	
	get_iwarp_driver_details(unique_parent_id, getdata, ostype);	
}

function iwarp_show_port(unique_parent_id, element){
	$(unique_parent_id+' .iw_port').hide().removeClass('shown');
	if( $(element).val() == '' ){
		$(unique_parent_id+' .card_d').fadeIn(300).addClass('shown').trigger('change');
		$(unique_parent_id+' .iw_properties').hide();
		$(unique_parent_id).animate({
			height: '134px'
		},300);
	}
	else{
		var port_class = $(element).val().split('__')[1];
		$(unique_parent_id+' .'+port_class).show().addClass('shown').trigger('change');
	}
}

function iwarp_get_settings(unique_parent_id, getdata, ostype, element){
	
	var pciloc = '';
	var pindex = '1';
	var driver_name = '';
	if (ostype == '1') {
		pciloc = $(unique_parent_id + ' .iw_card').val().split('__')[0];
		pindex = $(unique_parent_id + ' .shown').val();
	}
	else if (ostype == '2') {
		if( $.trim($(element).val()) == '' ){
			$(unique_parent_id).animate({
				height: '103px'
			},300);
			$(unique_parent_id+' .iw_properties').hide();
			return
		}
		driver_name = $(element).val();		
	}
	else if (ostype == '4') {
		$(unique_parent_id).animate({
			height: '103px'
		},300);
		$(unique_parent_id+' .iw_properties').hide();
		driver_name = 'iw_cxgbe';	
	}
	
	if( driver_name == 'iw_cxgb3' && $(unique_parent_id+' .iw_cxgb3_loaded').val() == 'no' ){
		show_error_msg(unique_parent_id, 'iw_cxgb3 driver is not loaded');
		return
	}
	else if( driver_name == 'iw_cxgb4' && $(unique_parent_id+' .iw_cxgb4_loaded').val() == 'no' ){
		show_error_msg(unique_parent_id, 'iw_cxgb4 driver is not loaded');
		return
	}
	else if( driver_name == 'iw_cxgbe' && $(unique_parent_id+' .iw_cxgbe_loaded').val() == 'no' ){
		show_error_msg(unique_parent_id, 'iw_cxgbe driver is not loaded');
		return
	}
	else if( ostype == '1' && $(unique_parent_id+' .chiwarp_loaded').val() == 'no' ){
		show_error_msg(unique_parent_id, 'chiwarp driver is not loaded');
		return
	}
	
	$(unique_parent_id+' .initializer').show();	
	getdata += '&action=get_settings&pciloc='+pciloc+'&pindex='+pindex+'&driver_name='+driver_name;
	$.ajax({
		url: '/python/iwarp_settings.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType : 'json',
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '-80') {
				display_failed(unique_parent_id);
				$(unique_parent_id+' .iwarp_settings_main').html('');
				$(unique_parent_id+' .iw_properties').hide();
				if (ostype == '2') {
					$(unique_parent_id).animate({
						height: '103px'
					}, 300);
				}
				else if (ostype == '1') {
					$(unique_parent_id).animate({
						height: '134px'
					}, 300);
				}
			}
			else if (data != '-1') {
				var height = 195;
				if (ostype == '2') {
					height = 165;
				}
				$(unique_parent_id).animate({
					'height': height+data.height
				},300);
				$(unique_parent_id+' .iwarp_settings_main').html(data.html);
				$(unique_parent_id+' .iw_properties').fadeIn(300);
			}
			else {
				display_failed(unique_parent_id);
				$(unique_parent_id+' .iwarp_settings_main').html('');
				$(unique_parent_id+' .iw_properties').hide();
				if (ostype == '2') {
					$(unique_parent_id).animate({
						height: '103px'
					}, 300);
				}
				else if (ostype == '1') {
					$(unique_parent_id).animate({
						height: '134px'
					}, 300);
				}
			}
		}
	});
}

function iw_discard_changes(unique_parent_id, ip_id, ostype){
	$(unique_parent_id+ ' ul').removeClass('from_server');
	if( ostype == '1' ){
		$(unique_parent_id+' .iw_card').trigger('change');	
	}
	else if( ostype == '2' ){
		$(unique_parent_id+' .linux .iw_driver').trigger('change');
	}
	else if( ostype == '4' ){
		$(unique_parent_id+' .freebsd .iw_card_li .iw_driver').trigger('change');
	}
}

function iw_save_changes(unique_parent_id, postdata, ip_id, ostype){
	$(unique_parent_id+' .initializer').show();
	
	var getdata = postdata;
	var pciloc = '';
	var port_index = '';
	var driver_name = '';
	if (ostype == '2') {
		driver_name = $(unique_parent_id+' .linux .iw_driver').val();		
	}
	if (ostype == '4') {
		driver_name = 'iw_cxgbe';		
	}
	else if (ostype == '1') {
		var pciloc = $(unique_parent_id + ' .iw_card').val().split('__')[0];
		var port_index = $(unique_parent_id + ' .shown').val();
	}
	
	
	postdata += '&pciloc='+pciloc+'&pinstance='+port_index+'&driver_name='+driver_name;
	var properties_count = 0;
	$(unique_parent_id+' .iwarp_settings_main select').each(function(){
		if( parseInt($(this).attr('class').replace('value_','')) != parseInt($(this).val()) ){
			postdata += '&propname='+$(this).attr('title');
			postdata += '&value='+$(this).val();
			properties_count += 1;
		}
	});
	$(unique_parent_id+' .iwarp_settings_main input').each(function(){
		if( $(this).attr('name').replace('value_','') != $(this).val() ){
			postdata += '&propname='+$(this).attr('title');
			postdata += '&value='+$(this).val();
			properties_count += 1;
		}
	});
	postdata += '&properties_count='+properties_count;
	
	if(!properties_count){
		$(unique_parent_id+' .initializer').hide();
		display_success(unique_parent_id);
		return
	}
	
	postdata += '&action=set_properties'
	$.ajax({
		url: '/python/iwarp_settings.py',
		type: 'POST',
		cache: false,
		data: postdata,
		success: function(status){
			$(unique_parent_id+' .initializer').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0') {
				$(unique_parent_id + ' ul').removeClass('from_server');
				if( ostype == '1' ){
					$(unique_parent_id+' .iw_card').trigger('change');	
				}
				else if( ostype == '2' ){
					$(unique_parent_id+' .linux .iw_driver').trigger('change');
				}
				else if( ostype == '4' ){
					iwarp_get_settings(unique_parent_id, getdata, ostype, '');	
				}
				$(unique_parent_id + ' .global_sucess').fadeIn(300);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});	
}

function get_iwarp_driver_details(unique_parent_id, getdata, ostype){
	$.ajax({
		url: '/python/iwarp_settings.py',
		type: 'GET',
		cache: false,
		data: getdata+'&action=get_driver_details',
		dataType: 'json',
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			if (data == '-2') {
				show_redirect_alert();
			}
			else if(data == '-1') {
				show_error_msg(unique_parent_id, 'Unable to retrive iWarp driver details');
			}
			else{
				if( ostype == '1' ){
					$(unique_parent_id+' .chiwarp_loaded').val(data.chiwarp);
				}
				else if( ostype == '2' ){
					$(unique_parent_id+' .iw_cxgb3_loaded').val(data.iw_cxgb3);
					$(unique_parent_id+' .iw_cxgb4_loaded').val(data.iw_cxgb4);
				}
				//t4
				else if( ostype == '4' ){
					$(unique_parent_id+' .iw_cxgbe_loaded').val(data.iw_cxgbe);
					iwarp_get_settings(unique_parent_id, getdata, ostype, '');
				}
			}
		}
	});
}
