function initialize_iscsi_ntc(ip_id){
	var unique_parent_id = '#iscsi_target_content__incend__' + ip_id+' .iscsi_target_ntc_tab';
	var loader_selector = unique_parent_id + ' .initializer';
	var ip = replace_with(ip_id, '_', '.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&ip=' + ip;

	$(loader_selector).show();

	//Initializing
	$(unique_parent_id +' .status_link').attr('onclick','$("'+unique_parent_id +' .i_tp_loader").hide();$("'+unique_parent_id +' .i_tp_select_li .targets_list").remove();initialize_iscsi_tp("'+ ip_id +'")');
	$(unique_parent_id +' .i_ntc_save_wr').attr('onclick','i_ntc_save("'+ unique_parent_id +'","'+ ip +'","'+ ip_id +'","'+ loader_selector +'")');
	i_ntc_driver_status(unique_parent_id, getdata);
}

function i_ntc_driver_status(unique_parent_id, getdata){
	$(unique_parent_id + ' .initializer').show();
	getdata += '&action=get_driver_status';
	$.ajax({
		url: '/python/iscsi_target_stack_creation.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id + ' .initializer').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '6') {
				show_error_msg(unique_parent_id, 'iSCSI Target driver not loaded');
				enable_disable_btn(unique_parent_id + ' .i_ntc_save_wr button', 'blue', 'disabled');
			}
			else if (status == '0') {
				enable_disable_btn(unique_parent_id + ' .i_ntc_save_wr button', 'blue', 'enable');
			}
		}
	});	
}


function i_ntc_save(unique_parent_id, ip, ip_id, loader_selector){
	var success = true;
	$(unique_parent_id+' input').each(function(){
		if( $.trim($(this).val()) == '' ){
			$(this).addClass('error');
			success = false;
		}		
	});
	
	if( !success ){
		return false
	}
	
	$(unique_parent_id + ' .initializer').show();
	var getdata = 'sid='+GetCookie("chelsio_webgui_sid")+'&ip='+ip+'&targetname='+$.trim($(unique_parent_id+' .i_ntc_target_name').val());
		getdata += '&targetalias='+$.trim($(unique_parent_id+' .i_ntc_target_alias').val())+'&action=create';
	
	$.ajax({
		url: '/python/iscsi_target_stack_creation.py',
		type: 'POST',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id + ' .initializer').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '190') {
				show_error_msg(unique_parent_id, 'Max targets have been reached.')
			}
			else if (status == '204') {
				show_error_msg(unique_parent_id, 'Target entry already exists in the conf file, hence cannot add Target node')
			}
			else{
				show_error_msg(unique_parent_id, 'iSCSI Target Node added but not started. Add TargetDevice & Portal details.')
			}
			
			/*else if (status != '-1') {
				$(unique_parent_id + ' .i_ntc_success_status').fadeIn(300);
			}
			else{
				$(unique_parent_id + ' .i_ntc_error_status').fadeIn(300);
			}*/
		}
	});	
}
