var UM_MSG = 'On successful installation of the UM Update, the connection with the machine will be lost and it will be disconnected. You have to reconnect it manually for further use.<div class="f_bold mgn_t10"> Are you sure you want to proceed with installation?</div>';
$(document).ready(function(){
	$('.bk_dr_ostype').change(function(){
		var os = $('.bk_dr_ostype option:selected').html();
		$('.bk_dr_system_wr li').hide();
		$('.bk_dr_system_wr li.'+os).fadeIn(300);
	});
	$('.bk_dr_ostype').trigger('change');
	$('.home_driver_installation_tab .initializer').hide();
});

function bk_dr_fill_agents(){
	$('.home_driver_installation_tab .file_text').removeClass('error');
	$('.home_driver_installation_tab .cardtype').val('0');
	$('.home_driver_installation_tab .bk_dr_ostype').val('2');
	$('.home_driver_installation_tab .bk_dr_system_wr ul').html('');
	$('.home_driver_installation_tab .initializer').show();
	var sid = GetCookie("chelsio_webgui_sid");
	$('.bk_dr_button_wr .rect_btn_wrapper button').removeClass('blue').addClass('disabled').attr('disabled','disabled');
	$.ajax({
			url: '/python/bulk_driver_install.py',
			type: 'GET',
			cache: false,
			data: 'sid='+sid+'&action=get_bookmarks&ip=',
			success: function(html){
				$('.home_driver_installation_tab .initializer').hide();
				if (html == '-2') {
					show_redirect_alert();
				}
				else if( html == '-1' ){
					$('.dummy').chLightbox('destroy');
					$('.dummy').chLightbox('alert', {
						alertTitle: 'Error!',
						alertMsg: 'BookMarks List failed to load. Please try again later, if the problem persists try signing out and signing in again.',
						alertOk: 'OK',
						lbWidth: 420,
						top_extra: 150
					});
				}
				else{
					$('.bk_dr_system_wr ul').html(html);
					$('.bk_dr_system_wr ul li.linux').fadeIn(300);
				}
			}
	});
	$('.bk_dr_ostype').trigger('change');
}

function bk_dr_ostype_manipulation(element){
	var ostype = $(element).val();
	var unique_parent_id = '.home_driver_installation_tab ';
	$('.home_driver_installation_tab .bk_dr_system_wr ul li').removeClass('selected');
	$('.bk_dr_button_wr button').removeClass('blue').attr('disabled','disabled').addClass('disabled');
	$(unique_parent_id+ ' .os_specific').hide();
	$(unique_parent_id+ ' .os_'+ostype).show();
	$(unique_parent_id+' .cardtype').trigger('change');
	$(unique_parent_id+' .ofed').hide();
	$(unique_parent_id+' .chelsio').trigger('click');
	$(unique_parent_id+' .cardtype').removeAttr('disabled');
	if (ostype == '1') {
		//windows
		/*$(unique_parent_id+ ' .win_t4').hide();
		$(unique_parent_id+ ' .win_t3').show();
		$(unique_parent_id+' .chelsio').css('width','250px');
		
		var height = '';
		if( $(unique_parent_id+' .cardtype').val() == '0' ){
			height = '635px';
		}
		else{
			height = '660px';
		}
		
		$(unique_parent_id).animate({
			'height': height
		}, 300);*/
		
	}
	else if (ostype == '2') {
		//linux
		$(unique_parent_id+' .linux_show').show();
		/*$(unique_parent_id+ ' .lin_t4').hide();
		$(unique_parent_id+ ' .lin_t3').show();
		$(unique_parent_id).animate({
			'height': '598px'
		}, 300);*/
		$(unique_parent_id+' .ofed').show();
	}
	else if(ostype == '3' || ostype == '6' ){
		//solaris and mac
		$(unique_parent_id).animate({
			'height': '520px'
		}, 300);
	}
	else if(ostype == '4' ){
		//Freebsd
		$(unique_parent_id+' .os_4').show();
		$(unique_parent_id+' .cardtype').val('1').attr('disabled','disabled');
		$(unique_parent_id + ' .cxgb3_name').html('T4');
		$(unique_parent_id).animate({
			'height': '565px'
		}, 300);
	}	
	else if(ostype == '5' ){
		//esx
		$(unique_parent_id).animate({
			'height': '520px'
		}, 300);
	}
	
	if( $(unique_parent_id+' .cardtype').val() == '0' ){
		$(unique_parent_id+' .fcoe_ul').hide();	
	}
		
}

function bk_dr_chkbox_manipulation(unique_parent_id, element){
	//Only for chelsio drivers
	var ostype = $(unique_parent_id +' .bk_dr_ostype').val();
	$(unique_parent_id + ' .chelsio_content .file_text').removeClass('error');
	
	//T4 card
	if( $(unique_parent_id+' .cardtype').val() == '1' ){
		//To allow checkboxes to be unchecked for linux otherwise it wont allow user to uncheck
		
		if (ostype == '2') {

                        var conftype = $(unique_parent_id+' .conftype').val()
			if(element.val() == 'wdtoe'){
				//disable everything and show only wdtoe_install, and .wdtoe_support
					if($(unique_parent_id+' .t4conftype_'+conftype+' .wdtoe').is(':checked')){
						$(unique_parent_id+' .t4conftype_'+conftype).show();
						$(unique_parent_id+' .t4conftype_'+conftype+' input[type=checkbox]').removeAttr('checked');
						$(unique_parent_id+' .t4conftype_'+conftype+'.wdtoe_support'+' input[type=checkbox]').attr('checked','checked');
					}else{
						$(unique_parent_id+' .t4conftype_'+conftype+'.wdtoe_support'+' input[type=checkbox]').removeAttr('checked');
					}

			}else if(element.val() == 'wdudp'){
				//disable everything and show only wdtoe_wdudp_install, and .wdtoe_wdudp_support
				if($(unique_parent_id+' .t4conftype_'+conftype+' .wdudp').is(':checked')){
					$(unique_parent_id+' .t4conftype_'+conftype).show();
					$(unique_parent_id+' .t4conftype_'+conftype+' input[type=checkbox]').removeAttr('checked');
					$(unique_parent_id+' .t4conftype_'+conftype +'.wdtoeudp_support' + ' input[type=checkbox]').attr('checked','checked');
				}else{
					$(unique_parent_id+' .t4conftype_'+conftype +'.wdtoeudp_support' + ' input[type=checkbox]').removeAttr('checked');
				}

			}else if(element.val() == 'bypass'){
				if($(unique_parent_id+' .t4conftype_'+conftype +' .bypass').is(':checked')){
					$(unique_parent_id+' .t4conftype_'+conftype).show();
					$(unique_parent_id+' .t4conftype_'+conftype+' input[type=checkbox]').removeAttr('checked');
					$(unique_parent_id+' .t4conftype_'+conftype +'.bypass_support' + ' input[type=checkbox]').attr('checked','checked');
				}else{
					$(unique_parent_id+' .t4conftype_'+conftype +'.bypass_support' + ' input[type=checkbox]').removeAttr('checked');
				}
			}else if($(element).hasClass('wdudp_optional') || ($(element).hasClass('wdtoe_optional'))){
				//pass
			}else {
				$(unique_parent_id+' .t4conftype_'+conftype+'_no_default'+' input[type=checkbox]').removeAttr('checked');
			}
		}

		if (ostype != '2') {
			bk_dr_card_change(unique_parent_id,  $(unique_parent_id+' .cardtype'));
		}
		//solaris
		if (ostype == '3') {
			if ($(unique_parent_id + ' .nic').is(':checked')) {
				enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
			}
			else {
				enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
			}
		}
		//windows
		else if (ostype == '1') {
			if ($(unique_parent_id + ' .win_t4_chk').is(':checked')) {
				enable_disable(unique_parent_id, 'enable', '.windowsdriver_file_li_wr');
			}
			else {
				enable_disable(unique_parent_id, 'disable', '.windowsdriver_file_li_wr');
			}
			
			//If any one of the widn_t4_pair_* chk is checked then uncheck the other pair chk
			if ( $(element).is(':checked') && $(element).hasClass('wind_t4_pair_1') ) {
				$(unique_parent_id+' .vnic,'+unique_parent_id+' .nd').removeAttr('checked');
			}
			else if ( $(element).is(':checked') && $(element).hasClass('vnic') ) {
				$(unique_parent_id+' .wind_t4_pair_1,'+unique_parent_id+' .nd').removeAttr('checked');
			}
			else if ( $(element).is(':checked') && $(element).hasClass('nd') ) {
				$(unique_parent_id+' .wind_t4_pair_1,'+unique_parent_id+' .vnic').removeAttr('checked');
			}
		}
		//Freebsd
		else if (ostype == '4') {
			if ($(unique_parent_id + ' .toe').is(':checked')) {
				$(unique_parent_id+' .nic').attr('checked','checked');
				enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
				return
			}
			
			if ($(unique_parent_id + ' .os_4_chk').is(':checked')) {
				enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
			}
			else{
				enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
			}
		}
		//esx
		else if (ostype == '5') {
			if( $(element).is(':checked') && $(element).hasClass('nic') ){
				enable_disable(unique_parent_id, 'enable', '.multiport_file_li_wr');
			}
			else{
				enable_disable(unique_parent_id, 'disable', '.multiport_file_li_wr');
			}
		}
		else if (ostype == '6') {
			if( $(element).is(':checked') && $(element).hasClass('nic') ){
				enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
			}
			else{
				enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
			}
		}
		return 
	}
	
	//T3
	if( ostype == '1' ){
		if( $(unique_parent_id+ ' input[type=checkbox]').is(':checked') ){
			enable_disable(unique_parent_id, 'enable', '.windowsdriver_file_li_wr');						
		}
		else{
			enable_disable(unique_parent_id, 'disable', '.windowsdriver_file_li_wr');
		}
		
		/*if( $(element).hasClass('toe_chk') && $(element).is(':checked') ){
			$(unique_parent_id+' .toe').attr('checked','checked');
		}*/
		return
	}
	else if( ostype == '3' || ostype == '6' ){
		if( $(unique_parent_id+ ' .nic').is(':checked') ){
			enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
		}
		else{
			enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
		}
		return
	}
	else if( ostype == '5' ){
		if( $(element).is(':checked') ){
			$(unique_parent_id+ ' .esx_input').removeAttr('checked');
			$(element).attr('checked','checked');
			enable_disable(unique_parent_id, 'enable', '.multiport_file_li_wr');
		}
		else{
			enable_disable(unique_parent_id, 'disable', '.multiport_file_li_wr');
		}
		return
	}
	
	//linux and t3
	var is_iscsi_checked = $(unique_parent_id+' input.iscsi').is(':checked');

	if (is_iscsi_checked) {
		enable_disable(unique_parent_id, 'enable', '.iscsi_file_li_wr');
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
	}
	else {
		enable_disable(unique_parent_id, 'disable', '.iscsi_file_li_wr');
	}
	
	if( !is_iscsi_checked && $(element).hasClass('iscsi') ){
		$(unique_parent_id+' input.cmn').removeAttr('checked');
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
		return
	}
	
	if( $(element).hasClass('cmn') && $(element).is(':checked') ){
		$(unique_parent_id+' input.cmn').removeAttr('checked');
		$(element).attr('checked','checked');
		enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
	}
	
	if ( $(element).hasClass('toe') && is_iscsi_checked && !$(element).is(':checked') ) {
		$(unique_parent_id+' input.cmn').removeAttr('checked');
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
		return		
	}
	
	if ( is_iscsi_checked && $(unique_parent_id+' input.cmn').is(':checked') ) {
		$(unique_parent_id+' .cmn').attr('checked','checked');
		enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
	}
	
	if ( $(element).hasClass('cmn') && !$(element).is(':checked') && !$(unique_parent_id+' .cmn').is(':checked') ) {
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
	}
}

function enable_disable(unique_parent_id, type, li_class){
	if( type == 'enable' ){
		$(unique_parent_id+' '+li_class+' input.text').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' '+li_class+' .file_input_wr').removeClass('disabled').addClass('yellow');
		$(unique_parent_id+' '+li_class+' .sl_file_input').removeAttr('disabled').addClass('file_enabled');
	}
	else{
		/*$(unique_parent_id+' '+li_class+' .iscsi_file').val('');
		$(unique_parent_id+' '+li_class+' .cxb3_file').val('');*/
		$(unique_parent_id+' '+li_class+' .iscsi_text').removeClass('error');
		$(unique_parent_id+' '+li_class+' .cxb3_text').removeClass('error');
		$(unique_parent_id+' '+li_class+' input.text').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id+' '+li_class+' .file_input_wr').addClass('disabled').removeClass('yellow');
		$(unique_parent_id+' '+li_class+' .sl_file_input').attr('disabled','disabled').removeClass('file_enabled');
	}
}

function bk_dr_trigger_fileinput(unique_parent_id, element){
	$(element).removeClass('error');
	if( $(element).hasClass('cxb3_text') ){
		$(unique_parent_id+' .cxb3_file').trigger("click");
	}
	else if( $(element).hasClass('windows_text') ){
		$(unique_parent_id+' .windows_file').trigger("click");
	}
	else if( $(element).hasClass('iscsi_text') ){
		$(unique_parent_id+' .iscsi_file').trigger("click");
	}
	else if( $(element).hasClass('multiport_text') ){
		$(unique_parent_id+' .multiport_file').trigger("click");
	}
	else if( $(element).hasClass('ocfp_text') ){
		$(unique_parent_id+' .ocfp_file').trigger("click");
	}
	else if( $(element).hasClass('odt_text') ){
		$(unique_parent_id+' .odt_file').trigger("click");
	}
}

function bk_dr_display_filepath(unique_parent_id, element){
	if( $(element).hasClass('cxb3_file') ){
		$(unique_parent_id+' .cxb3_text').val($(element).val());
	}
	else if( $(element).hasClass('windows_file') ){
		$(unique_parent_id+' .windows_text').val($(element).val());
	}
	else if( $(element).hasClass('iscsi_file') ){
		$(unique_parent_id+' .iscsi_text').val($(element).val());
	}
	else if( $(element).hasClass('multiport_file') ){
		$(unique_parent_id+' .multiport_text').val($(element).val());
	}
	else if( $(element).hasClass('ocfp_file') ){
		$(unique_parent_id+' .ocfp_text').val($(element).val());
	}
	else if( $(element).hasClass('odt_file') ){
		$(unique_parent_id+' .odt_text').val($(element).val());
	}
}

function bk_dr_toggle_tab(unique_parent_id,element){
	if( $(element).hasClass('selected') ){
		return
	}
	var os_type = $(unique_parent_id +' .bk_dr_ostype').val();
	$(unique_parent_id+' .tab_head li').removeClass('selected');	
	$(element).addClass('selected');
	
	if($(element).hasClass('chelsio')){
		var tab_content = '.chelsio_content';
		height = '310px';
		if(os_type == '2'){
			var height = '598px';
			if( $(unique_parent_id+ ' .cardtype').val() == '1' ){
				height = '1032px';
			}
			else{
				height = '598px';
			}
		}
		else if( os_type == '1' ){
			if( $(unique_parent_id+ ' .cardtype').val() == '1' ){
				height = '354px';
			}
			else{
				height = '598px';
			}
		}
		else if(os_type == '3' || os_type == '6' ){
			var height = '240px';
		}
		$(unique_parent_id).animate({
				'height':height
		},300);
	}
	else if($(element).hasClass('ofed')){
		var tab_content = '.ofed_content';
		$(unique_parent_id).animate({
				'height':'565px'
		},300);
	}
	else{
		return
	}
	$(unique_parent_id+' .tab_content,'+unique_parent_id+' .btn_wr').hide();
	$(unique_parent_id+' '+tab_content+','+unique_parent_id+' .btn_wr').fadeIn(300);
}

function bk_dr_card_change(unique_parent_id, element){
	$(unique_parent_id+' .file_text').val('');
	$(unique_parent_id+' input[type=file]').val('');
	var ostype = $(unique_parent_id + ' .bk_dr_ostype').val();
	
	//T4
	if( $(element).val() == '1' ){
		$(unique_parent_id + ' .cxgb3_name').html('T4');
		//linux
		if (ostype == '2') {
			$(unique_parent_id + ' .lin_t3').hide();
			$(unique_parent_id + ' .lin_t4').show();
			$(unique_parent_id + ' .chelsio_content .cmn,' + unique_parent_id + ' .chelsio_content .iscsi').attr('checked', 'checked');
			$(unique_parent_id + ' .chelsio_content .fcoe').attr('checked', 'checked');
			enable_disable(unique_parent_id, 'enable', '.cxb3_file_li_wr');
			enable_disable(unique_parent_id, 'disable', '.iscsi_file_li_wr');
			$(unique_parent_id +' .fcoe_ul').show();
			var height = '';
			if ($(unique_parent_id + ' .tab_head li.chelsio').hasClass('selected')) {
				height = '1060px';
			}
			else if ($(unique_parent_id + ' .tab_head li.ofed').hasClass('selected')) {
				height = '565px';
			}
			$(unique_parent_id).animate({
					'height':height
			},300);
			$(unique_parent_id + ' .conftype').trigger('change');
		}
		//windows
		else if(ostype == '1') {
			$(unique_parent_id + ' .win_t3').hide();
			$(unique_parent_id + ' .win_t4').show();
			$(unique_parent_id).animate({
					'height':'660px'
			},300);
		}
		else if(ostype == '5') {
			$(unique_parent_id+' .esx_t3').hide();
		}
	}
	//T3
	else{
		$(unique_parent_id + ' .cxgb3_name').html('T3');
		//Linux
		if (ostype == '2') {
			$(unique_parent_id + ' .lin_t4').hide();
			$(unique_parent_id + ' .lin_t3').show();
			$(unique_parent_id + ' .chelsio_content .cmn,' + unique_parent_id + ' .chelsio_content .iscsi').removeAttr('checked');
			enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
			enable_disable(unique_parent_id, 'disable', '.iscsi_file_li_wr');
			
			$(unique_parent_id +' .fcoe_ul').hide();
			$(unique_parent_id +' .fcoe_ul input').removeAttr('checked');
			
			var height = '';
			if ($(unique_parent_id + ' .tab_head li.chelsio').hasClass('selected')) {
				height = '598px';
			}
			else if ($(unique_parent_id + ' .tab_head li.ofed').hasClass('selected')) {
				height = '565px';
			}
			$(unique_parent_id).animate({
					'height':height
			},300);
		}
		//windows
		else if(ostype == '1') {
			$(unique_parent_id+' .win_t4').hide();
			$(unique_parent_id+' .win_t3').show();			
			var height = '';
			if ($(unique_parent_id + ' .tab_head li.chelsio').hasClass('selected')) {
				height = '635px';
			}
			else if ($(unique_parent_id + ' .tab_head li.ofed').hasClass('selected')) {
				height = '565px';
			}
			$(unique_parent_id).animate({
					'height':height
			},300);
		}
		else if(ostype == '5') {
			$(unique_parent_id+' .esx_t3').show();
		}
		else if(ostype == '3' || ostype == '6' ) {
			//solaris and mac
			$(unique_parent_id + ' .cxgb3_name').html('T3');
		}
	}
}

function bk_dr_select_system(element){
	if( $(element).hasClass('selected') ){
		$(element).removeClass('selected');
	}
	else{
		$(element).addClass('selected');		
	}
	$('.bk_dr_button_wr button').removeClass('disabled').removeAttr('disabled').addClass('blue');
}

function bk_dr_install(unique_parent_id){
	
	if( $('.home_driver_installation_tab .install_wr button').hasClass('disabled') ){
		return
	}
	
	var ip = '';
	var total_ip = $(unique_parent_id+' .bk_dr_system_wr ul li.selected').length;
	$(unique_parent_id+' .bk_dr_system_wr ul li.selected .ip').each(function(i){
		if( i == total_ip-1 || i == 0 ){
			//IF LAST
			if( i == total_ip-1 ){
				ip += $.trim($(this).html());			
			}
			else if( i == 0 ){
				//first but not the last
				ip += $.trim($(this).html())+',';			
			}	
		}
		else{
			ip += $.trim($(this).html())+',';
		}
	});
	$(unique_parent_id +' .chelsio_content .path').val('');
	var ostype = $(unique_parent_id +' .bk_dr_ostype').val();
	//Linux and Freebsd
	if ( ostype == '2' || ostype == '4' ) {
		//Chelsio Drivers
		if ($(unique_parent_id + ' .tab_head li.selected').hasClass('chelsio')) {
			
			//Common for ( iscsi or iscsi and cxgb3 ) or ( cxgb3 driver alone )
			driver_type = '&driver_type=chelsio';
			var success = true;
			
			//iscsi or iscsi and cxgb3
			if ($(unique_parent_id + ' .chelsio_content .iscsi_file').hasClass('file_enabled')) {
				var drtype = '&drType=iscsi';
				var file_id = $(unique_parent_id + ' .chelsio_content .iscsi_file').attr('id');
				//iscsi - single driver
				if (!$(unique_parent_id + ' .chelsio_content .cmn').is(':checked')) {
					if( $.trim($(unique_parent_id + ' .chelsio_content .iscsi_text').val()) == '' ){
						$(unique_parent_id + ' .chelsio_content .iscsi_text').addClass('error');
						success = false;
					}
					else{
						success = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .iscsi_text'), ostype);
					}
					
					if (success) {
						bk_dr_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
					}
				}
				//iscsi & cxgb3- multiple driver
				else {
					var cxgb3_file_id = $(unique_parent_id + ' .chelsio_content .cxb3_file').attr('id');
					var iscsi_file_id = file_id;
					var success1 = true;
					var success2 = true;
					
					if ($.trim($(unique_parent_id + ' .chelsio_content .cxb3_text').val()) == '') {
						$(unique_parent_id + ' .chelsio_content .cxb3_text').addClass('error');
						success1 = false;
					}
					else{
						success1 = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .cxb3_text'), ostype);
					}
					
					if ($.trim($(unique_parent_id + ' .chelsio_content .iscsi_text').val()) == '') {
						$(unique_parent_id + ' .chelsio_content .iscsi_text').addClass('error');
						success2 = false;
					}
					else{
						success2 = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .iscsi_text'), ostype);
					}
					
					// if all the validations are true 
					if(success1 && success2) {
						bk_dr_iscsi_mulitple_driver_upload(unique_parent_id, iscsi_file_id, cxgb3_file_id, ip, drtype, driver_type);
					}
				}
			}
			//Chelsio cxgb3 driver alone
			else {
				if ($(unique_parent_id + ' .cardtype').val() == '1') {
					//T4 card
					var chk_length = $(unique_parent_id + ' .chelsio_content .lin_t4 input:checked').length;
					
					if( chk_length == 0 ){
						show_error_msg(unique_parent_id, 'Please select atleast one driver.');
						return;
					}
					
					if (chk_length == 16){
						var drtype = '&drType=all';						
					}
					else{
						var drtype = '&drType=';
						var total_chk = chk_length - 1;
						$(unique_parent_id + ' .chelsio_content .lin_t4 input:checked').each(function(i){
							if (total_chk == i) {
								drtype += $(this).val();
							}
							else {
								drtype += $(this).val() + ',';
							}
						});
					}
					
					drtype += '&conftype='+$(unique_parent_id+' .conftype').val();
				}
				else {
					//T3 card
					var drtype = '&drType=' + $(unique_parent_id + ' .chelsio_content .cmn:checked').val();
				}
				
				if ( !$(unique_parent_id + ' .chelsio_content .cxb3_file_li_wr .file_input_wr').hasClass('disabled') ) {
					
					if ($.trim($(unique_parent_id + ' .chelsio_content .cxb3_text').val()) != '') {
						success = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .cxb3_text'), ostype);
					}
					
					if ($.trim($(unique_parent_id + ' .chelsio_content .cxb3_text').val()) == '') {
						$(unique_parent_id + ' .chelsio_content .cxb3_text').addClass('error');
						success = false;
					}
					//if even file type is correct
					else if(success) {
						var file_id = $(unique_parent_id + ' .chelsio_content .cxb3_file').attr('id');
						bk_dr_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
					}
				}
			}
			if( !success ){
				return;
			}
		}
		//OFED Drivers
		else if ($(unique_parent_id + ' .tab_head li.selected').hasClass('ofed')) {
			var success = true;
			var drtype = '&drType=ofed';
			var dr_ofed_pkg_type = $(unique_parent_id+' .dr_ofed_pkg_type').val();
			//driver_type & ofedpkg
			var driver_type = '&driver_type=ofed&ofed_pkg='+dr_ofed_pkg_type;
			if ( dr_ofed_pkg_type == 'conffile' ) {
				var success1 = true;
				var success2 = true;
				
				//multiple driver
				if( $.trim($(unique_parent_id + ' .ofed_content .odt_file').val()) == '' ){
					$(unique_parent_id + ' .ofed_content .odt_text').addClass('error');
					success1 = false;
				}
				else{
					success1 = validation_file(unique_parent_id, $(unique_parent_id + ' .ofed_content .odt_text'), ostype);
				}
				
				if( $.trim($(unique_parent_id + ' .ofed_content .ocfp_file').val()) == '' ){
					$(unique_parent_id + ' .ofed_content .ocfp_text').addClass('error');
					success2 = false;
				}
				else{
					success2 = validation_file(unique_parent_id, $(unique_parent_id + ' .ofed_content .ocfp_text'), ostype);
				}
				
				if( success1 && success2 ){
					var odt_file_id = $(unique_parent_id + ' .ofed_content .odt_file').attr('id');
					var ocfp_file_id = $(unique_parent_id + ' .ofed_content .ocfp_file').attr('id');
					bk_dr_iscsi_mulitple_driver_upload(unique_parent_id, odt_file_id, ocfp_file_id, ip, drtype, driver_type);					
				}
				else{
					return false;
				}
			}
			else{
				//single driver
				if( $.trim($(unique_parent_id + ' .ofed_content .odt_file').val()) == '' ){
					$(unique_parent_id + ' .ofed_content .odt_text').addClass('error');
					success = false;
				}
				else{
					success = validation_file(unique_parent_id, $(unique_parent_id + ' .ofed_content .odt_text'), ostype);
				}
				
				if (success) {
					var file_id = $(unique_parent_id + ' .ofed_content .odt_file').attr('id');
					bk_dr_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
				}
				else{
					return false;
				}
			}
		}
	}
	//windows
	else if(ostype == '1') {
		if($(unique_parent_id + ' .tab_head li.selected').hasClass('chelsio')) {
			var return_flag = false;
			if( $.trim($(unique_parent_id + ' .chelsio_content .windows_file').val()) == '' ){
				$(unique_parent_id + ' .chelsio_content .windows_text').addClass('error');
				return_flag = true;
			}
			else{
				success = validation_file(unique_parent_id, $(unique_parent_id + ' .chelsio_content .windows_text'), ostype);
				if(!success){
					return_flag = true;
				}
			}
			
			if(return_flag){
				return
			}
			
			var driver_type = '&driver_type=chelsio';
			var drtype_link = '&drType=';
			var drtype = '';
			//T3
			var chk_len = $(unique_parent_id + ' .chelsio_content .wind:checked').length;
			if( $(unique_parent_id+' .cardtype').val() == '0' ){
				if( chk_len == 5){
					drtype = 'all';
				}
				else{
					var total_chk = ($(unique_parent_id + ' .chelsio_content .wind:checked').length) - 1;
					$(unique_parent_id + ' .chelsio_content .wind:checked').each(function(i){
						if (total_chk == i) {
							drtype += $(this).val();
						}
						else {
							drtype += $(this).val() + ',';
						}
					});
				}
				drtype_link += drtype;
			}
			//T4
			else{
				if ($(unique_parent_id + ' .wind_t4_pair_1').is(':checked')) {
					var chk_len = $(unique_parent_id + ' .wind_t4_pair_1:checked').length;
					if (chk_len == 3) {
						drtype = 'all';
					}
					else {
						var total_chk = ($(unique_parent_id + ' .wind_t4_pair_1:checked').length) - 1;
						$(unique_parent_id + ' .wind_t4_pair_1:checked').each(function(i){
							if (total_chk == i) {
								drtype += $(this).val();
							}
							else {
								drtype += $(this).val() + ',';
							}
						});
					}
				}
				else if ($(unique_parent_id + ' .vnic').is(':checked')) {
					drtype = 'vnic';
				}
				else if ($(unique_parent_id + ' .nd').is(':checked')) {
					drtype = 'nd';
				}
				drtype_link += drtype;
			}
			
			var file_id = $(unique_parent_id + ' .chelsio_content .windows_file').attr('id');
			
			bk_dr_upload_driver(unique_parent_id, file_id, ip, drtype_link, driver_type, 'single');
		}
	}
	//solaris
	else if (ostype == '3') {
		if($(unique_parent_id + ' .tab_head li.selected').hasClass('chelsio')) {
			if( $.trim($(unique_parent_id + ' .chelsio_content .cxb3_file').val()) == '' ){
				$(unique_parent_id + ' .chelsio_content .cxb3_text').addClass('error');
				return false;
			}
			var driver_type = '&driver_type=chelsio';
			var drtype = '&drType=nic';
			var file_id = $(unique_parent_id + ' .chelsio_content .cxb3_file').attr('id');
			bk_dr_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
		}
	}
	//mac
	else if (ostype == '6') {
		//ony chelsio drivers
		if( $.trim($(unique_parent_id + ' .chelsio_content .cxb3_file').val()) == '' ){
			$(unique_parent_id + ' .chelsio_content .cxb3_text').addClass('error');
			return false;
		}
		var driver_type = '&driver_type=chelsio';
		var drtype = '&drType=nic';
		var file_id = $(unique_parent_id + ' .chelsio_content .cxb3_file').attr('id');
		bk_dr_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
	}
	//esx
	else if(ostype == '5') {
		//For esx multiport file wr is used for both nic and multiport
		if( $.trim($(unique_parent_id + ' .chelsio_content .multiport_file').val()) == '' ){
			$(unique_parent_id + ' .chelsio_content .multiport_text').addClass('error');
			return false;
		}
		var drtype = '&drType=nic';
		var driver_type = '&driver_type=chelsio';
		var file_id = $(unique_parent_id + ' .chelsio_content .multiport_file').attr('id');
		bk_dr_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, 'single');
	}
}

function bk_dr_discard(unique_parent_id){

	if( $(unique_parent_id+' .discard_wr button').hasClass('disabled') ){
		return;
	}

	$('.home_driver_installation_tab .bk_dr_system_wr ul li').removeClass('selected');
	$('.bk_dr_button_wr button').removeClass('blue').attr('disabled','disabled').addClass('disabled');
	if ($(unique_parent_id + ' .tab_widget li.selected').hasClass('chelsio')) {
		$(unique_parent_id + ' .chelsio_content input[type=checkbox]').removeAttr('checked');
		$(unique_parent_id + ' .chelsio_content .file_text').val('');
		$(unique_parent_id + ' .chelsio_content input[type=file]').val('');
		if ($(unique_parent_id + ' .bk_dr_ostype').val() == '4') {
			$(unique_parent_id + ' .cardtype').val('1');
		}
		else {
			$(unique_parent_id + ' .cardtype').val('0').trigger('change');
		}
		enable_disable(unique_parent_id, 'disable', '.cxb3_file_li_wr');
		enable_disable(unique_parent_id, 'disable', '.iscsi_file_li_wr');
		enable_disable(unique_parent_id, 'disable', '.windowsdriver_file_li_wr');
		enable_disable(unique_parent_id, 'disable', '.multiport_file_li_wr');
		$(unique_parent_id + ' .chelsio_content .file_text').removeClass('error');
	}
	else if ($(unique_parent_id + ' .tab_widget li.selected').hasClass('ofed')) {
		$(unique_parent_id + ' .cardtype').val('0');
		$(unique_parent_id + ' .ofed_content .dr_ofed_pkg_type').val('all');
		$(unique_parent_id + ' .ofed_content .odt_text').val('');
		$(unique_parent_id + ' .ofed_content .ocfp_text').removeAttr('disabled').val('').attr('disabled','disabled');
		$(unique_parent_id + ' .ofed_content .ocfp_file').removeAttr('disabled').val('').attr('disabled','disabled');
		bk_dr_ofed_packge_type(unique_parent_id, $(unique_parent_id + ' .ofed_content .dr_ofed_pkg_type'));
		$(unique_parent_id + ' .ofed_content input[type=file]').val('');
	}
}

function bk_dr_upload_driver(unique_parent_id, file_id, ip, drtype, driver_type, upload_count){
	var sid = GetCookie("chelsio_webgui_sid");
	var user = GetCookie("chelsio_webgui_user");
	var getdata = '?sid='+sid+'&ip='+ip+'&file_id='+file_id+'&cardtype='+$(unique_parent_id+' .cardtype').val()+drtype+'&user='+user+driver_type;
	getdata += '&call_granted=yes&first_path='+$(unique_parent_id +' .chelsio_content .path').val()+'&upload_count='+upload_count+'&action=';
	var ostype = $('.bk_dr_ostype').val();
	getdata += '&ostype='+ostype;
	$('.home_driver_installation_tab .initializer').hide();
	
	if( upload_count != 'multiple' ){
		show_progressbar(unique_parent_id,0);		
	}
	
	jQuery.ajaxFileUpload({
		url: 'python/bulk_driver_install.py'+getdata,
		secureuri: true,
		fileElementId: file_id,
		dataType: 'xml',
		success: function(xml){
			var status = String($.trim($('status', xml).text()));
			if (status == '-2') {
				$(unique_parent_id+' .progressbass-wr').hide();
				show_redirect_alert();
			}
			else if(status == '0') {
				//progress_complete(unique_parent_id);
				//Clearing settimeout
				for( key in progress_timeOuts ){  
			    	clearTimeout(progress_timeOuts[key]);  
			   	}
				$(unique_parent_id+' .progressbass-wr').hide();
				
				$('.dummy').chLightbox('popup', {
					PopTitle: 'Bulk Driver Installation Results',
					PopDivId: 'blk_dr_result_div',
					successfn: "$('.dummy').chLightbox('destroy')",
					lbWidth: '385',
					top_extra: 50
				});
				var html = '<ul class="horizontal head_ul">\
			        		<li><h2>Ip</h2></li>\
			        		<li><h2 class="bg_none" >Status</h2></li>\
			     			</ul>';
				var count = 0;
				$('system', xml).each(function(){
					count++;
					html += '<ul class="horizontal content_tbl clear_left">';
					html += '<li class="label bk_dr_r_ip">'+$(this).attr('ip')+'</li>';
					var status_class = 'green_f';
					if ($.trim($(this).attr('status')) == 'Failed'){
						status_class = 'red_f';
					}
					html += '<li class="label bk_dr_r_status '+status_class+'">'+$(this).attr('status')+'</li>';
					html += '</ul>'
				});
				html += '<div class="clear_left">&nbsp;</div>'
				if ( count > 10 ){
					html += '<style>\
						.grid {\
						height: 300px;\
						overflow-y: scroll;\
						}\
						</style>'					
				}
				$('#modalogContent .grid').html(html);
			}
			else {
				//Clearing settimeout
				for( key in progress_timeOuts ){  
			    	clearTimeout(progress_timeOuts[key]);  
			   	}
				$(unique_parent_id+' .progressbass-wr').hide();
				display_failed(unique_parent_id);
			}
		}
	});
}

function bk_dr_iscsi_mulitple_driver_upload(unique_parent_id, iscsi_file_id, cxgb3_file_id, ip, drtype, driver_type){
	var sid = GetCookie("chelsio_webgui_sid");
	var user = GetCookie("chelsio_webgui_user");
	var getdata = '?sid='+sid+'&ip='+ip+'&file_id='+iscsi_file_id+'&cardtype='+$(unique_parent_id+' .cardtype').val()+drtype+'&user='+user+driver_type+'&upload_count=null';
	getdata += '&call_granted=no&first_path=&action=';
	var ostype = $('.bk_dr_ostype').val();
	getdata += '&ostype='+ostype;
	$('.home_driver_installation_tab .initializer').hide();
	show_progressbar(unique_parent_id,0);
	jQuery.ajaxFileUpload({
		url: 'python/bulk_driver_install.py'+getdata,
		secureuri: true,
		fileElementId: iscsi_file_id,
		dataType: 'xml',
		success: function(xml){
			var iscsi_path = $.trim($('status', xml).text());
			$('.home_driver_installation_tab .initializer').hide();
			if (status == '-2') {
				$(unique_parent_id+' .progressbass-wr').hide();
				show_redirect_alert();
			}
			else if (status != '-1') {
				$(unique_parent_id +' .chelsio_content .path').val(iscsi_path);
				bk_dr_upload_driver(unique_parent_id, cxgb3_file_id, ip, drtype, driver_type, 'multiple');
			}
			else {
				//Clearing settimeout
				for( key in progress_timeOuts ){  
			    	clearTimeout(progress_timeOuts[key]);  
			   	}
				$(unique_parent_id+' .progressbass-wr').hide();
				display_failed(unique_parent_id);
			}
		}
	});
}

function bk_dr_ofed_packge_type(unique_parent_id, element){
	$(unique_parent_id+'  .file_text').removeClass('error');
	if( $(element).val() == 'conffile' ){
		$(unique_parent_id+' .ofed_conffile_wr .file_text').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' .ofed_conffile_wr .sl_file_input').removeAttr('disabled');
		$(unique_parent_id+' .ofed_conffile_wr .file_input_wr').removeClass('disabled').addClass('yellow');
	}
	else{
		$(unique_parent_id+' .ofed_conffile_wr .file_text').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id+' .ofed_conffile_wr .sl_file_input').attr('disabled','disabled');
		$(unique_parent_id+' .ofed_conffile_wr .file_input_wr').removeClass('yellow').addClass('disabled');
	}
}

function validation_file(unique_parent_id, element, ostype){
	if( ostype == '1' ){
		var ext = element.val().toLowerCase().split('.exe');
	}
	else if (ostype == '2' || ostype == '3' || ostype == '4') {
		if (ostype == '2') {
			 if ($(unique_parent_id + ' .tab_widget .tab_head li.ofed').hasClass('selected')) {
				var ext1 = element.val().toLowerCase().split('.tgz');
				var ext1_stats = ext1.length < 2;
				
				var ext2 = element.val().toLowerCase().split('.tar.gz');
				var ext2_stats = ext2.length < 2;
				
				if ( element.hasClass('ocfp_text') ) {
					var ext3 = element.val().toLowerCase().split('.conf');
					var ext3_stats = ext3.length < 2;
					if(ext3_stats == false){
						return true;
					}
					else{
						$(element).addClass('error');
						show_error_msg(unique_parent_id, 'Unsupported file type');
						return false;
					}
				}
				
				if(ext1_stats == false || ext2_stats  == false ){
					return true;
				}
				else{
					$(element).addClass('error');
					show_error_msg(unique_parent_id, 'Unsupported file type');
					return false;
				}
			 }
			 else {
			 	var ext = element.val().toLowerCase().split('.tar.gz');
			 }
		}
		else{
			var ext = element.val().toLowerCase().split('.tar.gz');
		}	
		
	}
	else if( ostype == '5' ){
		var ext = element.val().toLowerCase().split('.iso');
	}
	else if( ostype == '6' ){
		var ext = element.val().toLowerCase().split('.dmg');
	}
	
	if(ext.length < 2){
		$(element).addClass('error');
		show_error_msg(unique_parent_id, 'Unsupported file type');
		return false;
	}
	else{
		return true;		
	}
	return false;
}



function sdi_confchange(unique_parent_id, element){
        $(unique_parent_id + ' .chelsio_content input[type=checkbox]').removeAttr('checked');
        $(unique_parent_id + ' .chelsio_content .file_text').val('');
        $(unique_parent_id + ' .chelsio_content input[type=file]').val('');
        $(unique_parent_id+' .t4conftype_hide').hide();
        $(unique_parent_id+' .t4conftype_'+element.val()).show();
        $(unique_parent_id+' .t4conftype_'+element.val()+' input[type=checkbox]').attr('checked','checked');
        $(unique_parent_id+' .t4conftype_'+element.val()+'_no_default'+' input[type=checkbox]').removeAttr('checked');
        var height = '';

        if( element.val() == '0' ){
                height = '1000px';
        }
        else if( element.val() == '1' ){
                height = '750px';
        }
        else if( element.val() == '2' || element.val() == '3' ){
                height = '900px';
        }
        else if( element.val() == '4' ){
                height = '600px';
        }
        $(unique_parent_id).animate({
                        'height':height
        },500);

}

