function initialize_fcoe_port_npiv(ip_id){
	var unique_inc = $('#ip_' + ip_id + ' .selected').attr('name')+'end';
	var unique_parent_id = '#fport_content__'+ unique_inc + '__' + ip_id+ ' .fcoe_port_npiv_mgm_tab';
	$(unique_parent_id+' .initializer:first').hide();
	var ip = replace_with(ip_id, '_', '.');
	var loader_selector = unique_parent_id + ' .default_loader';
	
	if( $(unique_parent_id +' .npiv_loader').css('display') == 'block' ){
		return;
	}
	
	var fport_portwwn =  $.trim($('#ip_' + ip_id + ' .selected').children('.fport_portwwn').val())
	var fport_nodewwn = $.trim($('#ip_' + ip_id + ' .selected').children('.fport_nodewwn').val())
	
	$(unique_parent_id +' input[name=npiv]').attr('onclick','npiv_update("'+ unique_parent_id +'","'+ fport_portwwn +'", "'+ fport_nodewwn +'",  $(this))');
	$(unique_parent_id +' input[name=type]').attr('onclick','npiv_type("'+ unique_parent_id +'","'+ fport_portwwn +'", "'+ fport_nodewwn +'",  $(this))');
	$(unique_parent_id +' .create_wr').attr('onclick','npiv_create("'+ unique_inc +'","'+ unique_parent_id +'","'+ ip_id +'","'+ fport_portwwn +'", "'+ fport_nodewwn +'", "'+ loader_selector +'")');
	$(unique_parent_id +' .delete_wr').attr('onclick','npiv_delete("'+ ip_id +'","'+ unique_parent_id +'","'+ unique_inc +'", "'+ ip +'")');
	$(unique_parent_id +' .close_link').attr('onclick','$("'+unique_parent_id +' .npiv_loader").hide();npiv_make_default("'+ unique_parent_id +'")');
	$(unique_parent_id +' .refresh a').attr('onclick','initialize_fcoe_port_npiv("'+ ip_id +'")');
	$(unique_parent_id +' .npiv_discard_changes').attr('onclick','npiv_make_default("'+ unique_parent_id +'")');
	
	var fport_portwwn_arr = fport_portwwn.split(':');
	var fport_nodewwn_arr = fport_nodewwn.split(':');
	
	$(unique_parent_id+' .wwpn_ul input').each(function(i){
		$(this).val(fport_portwwn_arr[i]).attr('disabled','disabled');
	});
	
	$(unique_parent_id+' .wwnn_ul input').each(function(i){
		$(this).val(fport_nodewwn_arr[i]).attr('disabled','disabled');
	});
	
	$(unique_parent_id+' .c_wwpn_ul input:not(.enabled)').each(function(i){
		$(this).val(fport_portwwn_arr[i]).attr('disabled','disabled');
	});
	
	$(unique_parent_id+' .c_wwnn_ul input:not(.enabled)').each(function(i){
		$(this).val(fport_nodewwn_arr[i]).attr('disabled','disabled');
	});
	npiv_make_default(unique_parent_id);
	
	fcoe_get_virtualport_list(unique_inc, ip_id, ip, unique_parent_id);
}

function npiv_update(unique_parent_id, fport_portwwn, fport_nodewwn, element){
	$(unique_parent_id + ' input.enabled').removeClass('error').val('');
	if( $(element).is(':checked') && $.trim($(element).val()) == 'create' ){
		$(unique_parent_id+' .main_tab').hide();
		$(unique_parent_id+' .second_wr').fadeIn(300);
		$(unique_parent_id+' input[value=manual]').attr('checked','checked');
		$(unique_parent_id+' input.enabled').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' .c_wwpn_ul input:not(.enabled)').each(function(i){
			$(this).removeAttr('disabled').val(fport_portwwn.split(':')[i]).attr('disabled','disabled');
		});
		
		$(unique_parent_id+' .c_wwnn_ul input:not(.enabled)').each(function(i){
			$(this).removeAttr('disabled').val(fport_nodewwn.split(':')[i]).attr('disabled','disabled');
		});		
	}
	else if( $(element).is(':checked') && $(element).val() == 'delete' ){
		$(unique_parent_id+' .main_tab').hide();
		$(unique_parent_id+' .third_wr').fadeIn(300);
	}
}

function npiv_type(unique_parent_id, fport_portwwn, fport_nodewwn, element){
	$(unique_parent_id + ' input.enabled').removeClass('error');
	if( $(element).is(':checked') && $.trim($(element).val()) == 'manual' ){
		$(unique_parent_id+' .c_wwpn_ul input').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' .c_wwnn_ul input').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' .c_wwpn_ul input:not(.enabled)').each(function(i){
			$(this).removeAttr('disabled').val(fport_portwwn.split(':')[i]).attr('disabled','disabled').addClass('disabled');
		});
		
		$(unique_parent_id+' .c_wwnn_ul input:not(.enabled)').each(function(i){
			$(this).removeAttr('disabled').val(fport_nodewwn.split(':')[i]).attr('disabled','disabled').addClass('disabled');;
		});
	}
	else if( $(element).is(':checked') && $(element).val() == 'auto' ){
		$(unique_parent_id+' .c_wwpn_ul input').val('').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id+' .c_wwnn_ul input').val('').attr('disabled','disabled').addClass('disabled');
	}
}

function npiv_create(unique_inc, unique_parent_id, ip_id, fport_portwwn, fport_nodewwn, loader_selector){
	
	if ( $.trim($(unique_parent_id + ' input[name=type]:checked').val()) == 'manual') {
		var success = true;
		var display_msg = false;
		var wwpn_exists = false;
		var wwnn_exists = false;
		var empty = false;
		$(unique_parent_id + ' input.enabled').each(function(){
			var current_val = $.trim($(this).val());
			if (current_val == '') {
				success = false;
				empty = true;
				$(this).addClass('error');
			}
			else{
				if( $(this).hasClass('entered_wwpn') ){
					if(jQuery.inArray(current_val, global_dict[ip_id+'_wwpn']) != -1){
						display_msg = true;
						success = false;
						wwpn_exists = true;
					}
				}
				else{
					if(jQuery.inArray(current_val, global_dict[ip_id+'_wwnn']) != -1){
						display_msg = true;
						success = false;
						wwnn_exists = true;
					}
				}
			}
		});
		
		if (!success) {

			if (display_msg && !empty) {
				console.log(global_dict[ip_id+'_wwpn'])
				console.log(global_dict[ip_id+'_wwnn'])
				var msg = '';
				if (wwpn_exists && wwnn_exists) {
					msg = 'Duplicate NPIV. The entered WWPN and WWNN already exists';
				}
				else if (wwpn_exists) {
					msg = 'Duplicate NPIV. The entered WWPN already exists';
				}
				else if (wwnn_exists) {
					msg = 'Duplicate NPIV. The entered WWNN already exists';
				}
				show_error_msg(unique_parent_id, msg);
			}
			return;
		}
	}
	
	$('#global_loader .init_loader span').html('Processing..');
	$('#global_loader').show();
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var vPortWWPN = '';	
	var vPortWWNN = '';
	var mode = 0;
	if( $(unique_parent_id+' input[name=type]:checked').val() == 'manual' ){
		mode = 1;
		var total_len = $(unique_parent_id+' .c_wwpn_ul input').length; 
		$(unique_parent_id+' .c_wwpn_ul input').each(function(i){
			if( i == total_len-1 ){
				vPortWWPN += $(this).val();
			}
			else{
				vPortWWPN += $(this).val()+':'
			}
		});
		
		var total_len = $(unique_parent_id+' .c_wwnn_ul input').length; 
		$(unique_parent_id+' .c_wwnn_ul input').each(function(i){
			if( i == total_len-1 ){
				vPortWWNN += $(this).val();
			}
			else{
				vPortWWNN += $(this).val()+':'
			}
		});
	}
	var adpname = $.trim($('#ip_' + ip_id + ' .selected').children('.fport_adpname').val());
	var getdata = "sid="+sid+"&ip="+ip+"&adapname="+adpname+'&parentWWPN='+fport_portwwn+'&parentWWNN='+fport_nodewwn+'&npiVmode='+mode;
		getdata += '&vPortWWPN='+vPortWWPN+'&vPortWWNN='+vPortWWNN+'&action=create';

	$.ajax({
		url: '/python/npiv_management.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(data){
			if (data == '-2') {
				$('#global_loader').hide();
				show_redirect_alert();
			}
			else if (data == '-1') {
				$('#global_loader').hide();
				$(unique_parent_id+' .npiv_error').show();				
			}
			else {
				fcoe_get_virtualport_list(unique_inc, ip_id, ip, unique_parent_id);
				var xml_name = GetCookie("chelsio_webgui_user")+'_menu.xml';
				var getdata = 'ip='+ ip +'&filename='+xml_name;
				$('#global_loader .init_loader span').html('Refreshing Menu..');
				$.ajax({
					url: '/python/remove_system_node.py',
					type: 'GET',
					cache: false,
					data: getdata,
					success: function(data){
						if (data == '-2') {
							$('#global_loader').hide();
							show_redirect_alert();
						}
						else if( data == '0' ){
							
							var username = GetCookie("chelsio_webgui_user");
							var getdata = 'sid='+sid+'&ip='+ip+'&username='+username;
							$.ajax({
								url:  '/python/py_menu.py',
								type: 'GET',
								cache: false,
								data: getdata,
								success: function(data){
									if (data == '-2') {
										$('#global_loader').hide();
										show_redirect_alert();
									}
									else if (data != '-1') {
										var current_port_id = $('#ip_' + ip_id + ' .selected').attr('id');
										var current_card_id = $('#ip_' + ip_id + ' .selected').parent().parent().siblings('.tree_action').attr('id');
										menu_callback_fn = 'npiv_mangement_success("'+unique_parent_id+'", "'+current_card_id+'", "'+ip_id+'", "#'+current_port_id+'")';
										generate_menu();
									}
									else {
										$('#global_loader').hide();
										$(unique_parent_id+' .npiv_error').show();			
									}
								}
							});
						}
						else{
							$('#global_loader').hide();
							$(unique_parent_id+' .npiv_error').show();
						}
					}
				});
			}
		}
	});
}

function npiv_mangement_success(unique_parent_id, current_card_id, ip_id, current_port_id){
	menu_callback_fn = false;
	setTimeout(function(){
		// Menu displaying without effect , hence giving user an effect as if the menu is not being refreshed
		$('#m_tree_wrap .tree').hide();
		$('#m_tree_wrap .details .system h1').removeClass('show').addClass('hide');
		$('#rm_pc_'+ip_id).removeClass('hide').addClass('show');
		$('#rm_pc_'+ip_id).parent().siblings('.tree').show();
		$('.left_top_nav a.remove_pc').removeClass('inactive').addClass('effect');
		var minus_img_src = '/images/black/tree_minus.png';
		$('#storage_'+ip_id).siblings('ul').show();
		$('#storage_'+ip_id).children('img').attr('src',minus_img_src);
		$('#fcoe_initiator_'+ip_id).siblings('ul').show();
		$('#'+current_card_id).siblings('ul').show();
		$('#fcoe_initiator_'+ip_id).children('img').attr('src',minus_img_src);
		$(current_port_id).trigger('click');
		$('#global_loader').fadeOut(300);
		$('#global_loader .init_loader span').html('Loading..');							
		$(unique_parent_id+' .npiv_loader').hide();
		$(unique_parent_id+' .global_sucess').fadeIn(300);		
	}, 1000);
}

function fcoe_get_virtualport_list(unique_inc, ip_id, ip, unique_parent_id){
	$(unique_parent_id + ' .default_loader').show();
	$(unique_parent_id+' .vport_list').html('');
	var adapname = $.trim($('#ip_' + ip_id + ' .selected').children('.fport_adpname').val());
	var flportindex = $.trim($('#ip_' + ip_id + ' .selected').children('.fport_portwwn').val());
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = '&sid='+sid+'&ip='+ip+'&adapname='+adapname+"&flportindex="+flportindex+'&action=get_vports&unique_inc='+unique_inc;
	$.ajax({
		url:  '/python/npiv_management.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+ ' .npiv_loader').hide();
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '1') {
				return
			}
			else if (data == '-1') {
				$(unique_parent_id+' .npiv_error').show();
			}
			else {
				var current_wwpn = data.current_wwpn;
				var current_wwnn = data.current_wwnn;
				var static_wwpn = $(unique_parent_id+' .current_wwpn_val').val();
				var static_wwnn = $(unique_parent_id+' .current_wwnn_val').val();
				if( current_wwpn == '' ){
					global_dict[ip_id+'_wwpn'] = new Array(static_wwpn);	
				}
				else{
					current_wwpn += ','+static_wwpn;
					global_dict[ip_id+'_wwpn'] = current_wwpn.split(',');				
				}
				
				if( current_wwnn == '' ){
					global_dict[ip_id+'_wwnn'] = new Array(static_wwnn);	
				}
				else{
					current_wwnn += ','+static_wwnn;
					global_dict[ip_id+'_wwnn'] = current_wwnn.split(',');				
				}
				
				$(unique_parent_id + ' .vport_list').html(data.vports_html);
			}
		}
	});
}

function npiv_vport_select(unique_parent_id, element){
	if( $(element).hasClass('selected') ){
		$(element).removeClass('selected');
	}
	else{
		$(element).addClass('selected');
	}
	
	if($(unique_parent_id+' .vport_list li.selected').length){
		$(unique_parent_id+ ' .delete_wr button').removeAttr('disabled').removeClass('disabled').addClass('blue');		
	}
	else{
		$(unique_parent_id+ ' .delete_wr button').attr('disabled','disabled').removeClass('blue').addClass('disabled');
	}
}

function npiv_delete(ip_id, unique_parent_id, unique_inc, ip){
	var sid = GetCookie("chelsio_webgui_sid");
	var adapname = $.trim($('#ip_' + ip_id + ' .selected').children('.fport_adpname').val());
	var parentWWPN =  $.trim($('#ip_' + ip_id + ' .selected').children('.fport_portwwn').val());
	var parentWWNN = $.trim($('#ip_' + ip_id + ' .selected').children('.fport_nodewwn').val());
	
	var total_len = $(unique_parent_id+' .vport_list li.selected').length;
	var counter = 0;
	var success = true;
	var atleast_one_success = false;
	
	$('#global_loader .init_loader span').html('Processing..');
	$('#global_loader').show();
	
	$(unique_parent_id+' .vport_list li.selected').each(function(){
		var vportWWPN = $(this).children('.vportwwpn').val();
		var vportWWNN = $(this).children('.vportwwnn').val();
		var getdata = '&sid='+sid+'&ip='+ip+'&adapname='+adapname+'&action=delete_npiv&parentWWPN='+parentWWPN+'&parentWWNN='+parentWWNN;
		getdata += '&vportWWPN='+vportWWPN+'&vportWWNN='+vportWWNN;
		$.ajax({
			url:  '/python/npiv_management.py',
			type: 'GET',
			cache: false,
			data: getdata,
			success: function(html){
				counter++;
				if (html == '-2') {
					show_redirect_alert();
				}
				else if(html == '-1') {
					success = false;
				}
				else{
					atleast_one_success = true;
				}
				
				//When the loop ends
				if( counter == total_len ){
					
					//If all success
					if (success) {
						fcoe_get_virtualport_list(unique_inc, ip_id, ip, unique_parent_id);
						$(unique_parent_id + ' .delete_wr button').attr('disabled', 'disabled').removeClass('blue').addClass('disabled');
					}
					else{
						$(unique_parent_id+' .npiv_error').show();
					}
					
					//Refresing Menu if atleast one vport is deleted
					if(atleast_one_success){
						var xml_name = GetCookie("chelsio_webgui_user")+'_menu.xml';
						var getdata = 'ip='+ ip +'&filename='+xml_name;
						$('#global_loader .init_loader span').html('Refreshing Menu..');
						$.ajax({
							url: '/python/remove_system_node.py',
							type: 'GET',
							cache: false,
							data: getdata,
							success: function(data){
								if (data == '-2') {
									$('#global_loader').hide();
									show_redirect_alert();
								}
								else if( data == '0' ){
									var username = GetCookie("chelsio_webgui_user");
									var getdata = 'sid='+sid+'&ip='+ip+'&username='+username;
									$.ajax({
										url:  '/python/py_menu.py',
										type: 'GET',
										cache: false,
										data: getdata,
										success: function(data){
											if (data == '-2') {
												$('#global_loader').hide();
												show_redirect_alert();
											}
											else if (data != '-1') {
												var current_port_id = $('#ip_' + ip_id + ' .selected').attr('id');
												var current_card_id = $('#ip_' + ip_id + ' .selected').parent().parent().siblings('.tree_action').attr('id');
												menu_callback_fn = 'npiv_mangement_success("'+unique_parent_id+'", "'+current_card_id+'", "'+ip_id+'", "#'+current_port_id+'")';
												generate_menu();
											}
											else {
												$('#global_loader').hide();
												$(unique_parent_id+' .npiv_error').show();			
											}
										}
									});
								}
								else{
									$('#global_loader').hide();
									$(unique_parent_id+' .npiv_error').show();
								}
							}
						});
					}
					else{
						$('#global_loader').hide();
					}
				}
			}
		});	
	});
}

function npiv_make_default(unique_parent_id){
	$(unique_parent_id+' input[value=create]').trigger('click');
	$(unique_parent_id+' input.enabled').val('');
	$(unique_parent_id+' .main_tab').hide();
	$(unique_parent_id+' .second_wr').fadeIn(300);
	$(unique_parent_id+ ' .delete_wr button').attr('disabled','disabled').removeClass('blue').addClass('disabled');
	$(unique_parent_id+' .vport_list li').removeClass('selected');	
}