function fill_egress_packet_scheduler(ip_id){
	$(unique_parent_id+' .initializer').show();
	var unique_parent_id = '#egress_content__incend__' + ip_id+' .fill_egress_packet_scheduler_tab';
	var sid = GetCookie("chelsio_webgui_sid");
	var ip = replace_with(ip_id, '_', '.');
	var getdata = 'sid='+sid+'&ip='+ip+'&req_type=desktop';
	
	enable_disable_btn(unique_parent_id+' .save_wr button', 'blue', 'disable');
	
	$(unique_parent_id + ' .refresh a').attr('onclick', 'fill_egress_packet_scheduler("' + ip_id + '")');
	$(unique_parent_id + ' .epc_add_wr button').attr('onclick', 'epc_add("' + unique_parent_id + '")');
	$(unique_parent_id + ' .discard_wr button').attr('onclick', 'fill_egress_packet_scheduler("' + ip_id + '")');
	$(unique_parent_id + ' .save_wr button').attr('onclick', 'epc_save("' + unique_parent_id + '", "'+getdata+'", "'+ip_id+'")');
	wdudp_get_tx_schedulers(unique_parent_id, getdata);
}

function wdudp_get_tx_schedulers(unique_parent_id, getdata){
	$(unique_parent_id+' .initializer').show();
	getdata += '&action=get_initial_data';
	$.ajax({
		url: '/python/egress_packet_scheduler.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id+' .initializer').hide();
			enable_disable_btn(unique_parent_id+' .epc_add_wr button', 'yellow', 'enable');
			
			if (data.status == '-2' || data.ifname_status1 == '-2') {
				show_redirect_alert();
			}
			else if (data.status == '0') {
				if (data.html == '-6') {
					$(unique_parent_id + ' .grid').html('');
					$(unique_parent_id + ' .rules_set_wr').hide();
					show_error_msg(unique_parent_id, '0 schedulers are set');
					$(unique_parent_id).animate({
						height : '125px'
					},300);
					$(unique_parent_id+' .cached_data .height').val('125');
					enable_disable_btn(unique_parent_id+' .save_wr button', 'blue', 'disable');
				}
				else {
					$(unique_parent_id).animate({
						height : data.height+'px'
					},300);
					$(unique_parent_id+' .cached_data .height').val(data.height);
					$(unique_parent_id + ' .grid').html(data.html);
					$(unique_parent_id + ' .rules_set_wr').show();
				}
			}
			
			if (data.ifname_status1 == '0') {
				$(unique_parent_id+' .ifnames').val(data.ifnames);
			}
			
			if (data.status == '-1' || data.ifname_status1 == '-1') {
				display_failed(unique_parent_id);
			}
		}
	});
}

function epc_add(unique_parent_id){

	var ifnames_str = $(unique_parent_id+' .cached_data .ifnames').val();
	var ifnames = ifnames_str.split(',');
	var ifname_html = '<select class="ifname">';
	for( i=0; i<ifnames.length; i++  ){
		ifname_html += '<option value="'+ifnames[i]+'">'+ifnames[i]+'</option>';
	}
	ifname_html += '</select>';
	
	var maxrate_html = '<select class="maxrate" name="maxrate" onchange="$(this).removeClass(\'error\');">';
	maxrate_html += '<option value="0">Select One..</option>';
	for( i=1; i<=100; i++  ){
		maxrate_html += '<option value="'+i+'">'+i+'</option>';
	}
	 maxrate_html += '</select>';
	
	var clone_html = '<div class="new_rule as_hide"><ul class="horizontal content_tbl clear_left rules_ul">\
					<li class="classid_li">\
						<select class="classid" onchange="eps_validate(\''+unique_parent_id+'\', $(this))">\
							<option selected="selected" value="null">Select One..</option>\
							<option value="0">0</option>\
							<option value="1">1</option>\
							<option value="2">2</option>\
							<option value="3">3</option>\
							<option value="4">4</option>\
							<option value="5">5</option>\
							<option value="6">6</option>\
							<option value="7">7</option>\
							<option value="8">8</option>\
							<option value="9">9</option>\
							<option value="10">10</option>\
							<option value="11">11</option>\
							<option value="12">12</option>\
							<option value="13">13</option>\
							<option value="14">14</option>\
							<option value="15">15</option>\
						</select>\
					</li>\
					<li class="channelid_li">\
						<select class="channelid">\
							<option value="0">0</option>\
							<option value="1">1</option>\
							<option value="2">2</option>\
							<option value="3">3</option>\
						</select>\
					</li>\
					<li class="ifname_li">'+ifname_html+'</li>\
					<li class="mode_li" style="width:6%!important">\
						<select class="mode_sel" onchange="eps_validate(\''+unique_parent_id+'\', $(this))">\
							<option value="0">Class</option>\
							<option value="1">Flow</option>\
						</select>\
					</li>\
					<li class="ratemode_li">\
						<select class="ratemode" onchange="eps_validate(\''+unique_parent_id+'\', $(this))">\
							<option value="0">Relative</option>\
							<option value="1">Absolute</option>\
						</select>\
					</li>\
					<li class="rateunit_li">\
						<select class="rateunit" onchange="eps_validate(\''+unique_parent_id+'\', $(this))">\
							<option value="0">Bits (in kbps)</option>\
							<option value="1">Pkts/sec</option>\
						</select>\
					</li>\
					<li class="minrate_li">\
						<input type="text" value="" name="minrate" class="text minrate disabled" disabled="disabled" onkeyup="digit_validate($(this))">\
					</li>\
					<li class="maxrate_li">'+maxrate_html+'</li>\
					<li class="pktsize_li" style="width:10%!important">\
						<input type="text" value="" name="pktsize" class="text disabled" onkeyup="digit_validate($(this))" disabled="disabled">\
					</li>\
					<li class="weight_li">\
						<select class="weight disabled" disabled="disabled"><option value="0">Select One..</option><option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option><option value="5">5</option><option value="6">6</option><option value="7">7</option><option value="8">8</option><option value="9">9</option><option value="10">10</option><option value="11">11</option><option value="12">12</option><option value="13">13</option><option value="14">14</option><option value="15">15</option><option value="16">16</option><option value="17">17</option><option value="18">18</option><option value="19">19</option><option value="20">20</option><option value="21">21</option><option value="22">22</option><option value="23">23</option><option value="24">24</option><option value="25">25</option><option value="26">26</option><option value="27">27</option><option value="28">28</option><option value="29">29</option><option value="30">30</option><option value="31">31</option><option value="32">32</option><option value="33">33</option><option value="34">34</option><option value="35">35</option><option value="36">36</option><option value="37">37</option><option value="38">38</option><option value="39">39</option><option value="40">40</option><option value="41">41</option><option value="42">42</option><option value="43">43</option><option value="44">44</option><option value="45">45</option><option value="46">46</option><option value="47">47</option><option value="48">48</option><option value="49">49</option><option value="50">50</option><option value="51">51</option><option value="52">52</option><option value="53">53</option><option value="54">54</option><option value="55">55</option><option value="56">56</option><option value="57">57</option><option value="58">58</option><option value="59">59</option><option value="60">60</option><option value="61">61</option><option value="62">62</option><option value="63">63</option><option value="64">64</option><option value="65">65</option><option value="66">66</option><option value="67">67</option><option value="68">68</option><option value="69">69</option><option value="70">70</option><option value="71">71</option><option value="72">72</option><option value="73">73</option><option value="74">74</option><option value="75">75</option><option value="76">76</option><option value="77">77</option><option value="78">78</option><option value="79">79</option><option value="80">80</option><option value="81">81</option><option value="82">82</option><option value="83">83</option><option value="84">84</option><option value="85">85</option><option value="86">86</option><option value="87">87</option><option value="88">88</option><option value="89">89</option><option value="90">90</option><option value="91">91</option><option value="92">92</option><option value="93">93</option><option value="94">94</option><option value="95">95</option><option value="96">96</option><option value="97">97</option><option value="98">98</option><option value="99">99</option></select>\
					</li>\
				</ul></div>'
				
	if( $(unique_parent_id+' .saved_rule_wr').length ){
		$(unique_parent_id+' .saved_rule_wr').append(clone_html);
		$(unique_parent_id+' .new_rule').slideDown(300);
		var curr_height = parseInt($(unique_parent_id+' .cached_data .height').val())+42;
		$(unique_parent_id+' .cached_data .height').val(curr_height);
		$(unique_parent_id).animate({
			height : curr_height+'px'
		},300);
	}
	else{
		clone_html = '<div class="saved_rule_wr"><ul class="horizontal head_ul">\
                        <li><h2>Scheduler</h2></li>\
                        <li><h2>Channel ID</h2></li>\
                        <li><h2>Interface</h2></li>\
                        <li class="mode"><h2>Mode</h2></li>\
                        <li><h2>Rate Mode</h2></li>\
                        <li><h2>Rate Unit</h2></li>\
                        <li><h2>Min rate</h2></li>\
                        <li><h2>Max rate</h2></li>\
                        <li class="avg_pkt_s"><h2>Packet size</h2></li>\
                        <li><h2 class="bg_none">Weight</h2></li>\
                    </ul>'+clone_html+'</div>';
		$(unique_parent_id+' .grid').html(clone_html);
		$(unique_parent_id+' .new_rule').slideDown(300);
		$(unique_parent_id).animate({
			height : '213px'
		},300);
		$(unique_parent_id+' .cached_data .height').val(213);
	}
	$(unique_parent_id + ' .rules_set_wr').show();
	enable_disable_btn(unique_parent_id+' .save_wr button', 'blue', 'enable');
	enable_disable_btn(unique_parent_id+' .epc_add_wr button', 'yellow', 'disable');
}

function epc_save(unique_parent_id, getdata, ip_id){
	
	var success = true;
	if( $(unique_parent_id+' .new_rule .classid').val() == 'null' ){
		//If only channel is being selected, then MAXRATE is a mandatory field and value should be > 0
		//Relative
		if( $(unique_parent_id+' .new_rule .ratemode').val() == '0' && $(unique_parent_id+' .new_rule .maxrate').val() == '0' ){
			$(unique_parent_id+' .new_rule .maxrate').addClass('error');
			success = false;
		}
		
		//Absolute
		if( $(unique_parent_id + ' .new_rule .ratemode').val() == '1' ){
			if( $.trim($(unique_parent_id + ' .new_rule .maxrate').val()) == '' ){
				$(unique_parent_id+' .new_rule .maxrate').addClass('error');
				success = false;
			}
			else if($(unique_parent_id + ' .new_rule .maxrate').val().charAt(0) == '0'){
				success = false;
				show_error_msg(unique_parent_id, 'Max rate must be greater than 0');
			}
		}
	}
	else{
		//Class is being set, if both maxrate and weight are not selected then prompt
		
		if ( ( $(unique_parent_id + ' .new_rule .maxrate').val() == '0' || $.trim($(unique_parent_id + ' .new_rule .maxrate').val()) == '' ) && $(unique_parent_id + ' .new_rule .weight').val() == '0') {
			show_error_msg(unique_parent_id, 'You didn\'t set any values for the scheduler. Please set maxrate or weight or both.');
			success = false;
		}
		
		if( $.trim($(unique_parent_id + ' .new_rule input.maxrate').val()) != '' ) {
			if( $.trim($(unique_parent_id + ' .new_rule input.maxrate').val()).charAt(0) == '0' ){
				$(unique_parent_id+' .new_rule .maxrate').addClass('error');
				show_error_msg(unique_parent_id, 'Max rate must be greater than 0');
				success = false;
			}
		} 
	}
	
	if(!success){
		return;
	}
	
	$(unique_parent_id+' .initializer').show();

	var iff_name = $(unique_parent_id+' .new_rule .ifname').val();
	var classId = $(unique_parent_id+' .new_rule .classid').val();
	var channelId = $(unique_parent_id+' .new_rule .channelid').val();
	var mode = $(unique_parent_id+' .new_rule .mode_sel').val();
	var rateunit = $(unique_parent_id+' .new_rule .rateunit').val();
	var ratemode = $(unique_parent_id+' .new_rule .ratemode').val();
	var minrate = $.trim($(unique_parent_id+' .new_rule .minrate').val());
	if( minrate == '' ){
		minrate = 0;
	}
	var maxrate = $.trim($(unique_parent_id+' .new_rule .maxrate').val());
	/*if( maxrate == '' ){
		maxrate = 0;
	}*/
	var pktsize = $.trim($(unique_parent_id+' .new_rule .pktsize_li input').val());
	if( pktsize == '' ){
		pktsize = 0;
	}
	var weight = $(unique_parent_id+' .new_rule .weight').val();
	
	getdata += '&action=save&iff_name='+iff_name+'&schedType=0&classId='+classId+'&channelId='+channelId+'&mode='+mode+'&rateunit='+rateunit+'&ratemode='+ratemode;
	getdata += '&minrate='+minrate+'&maxrate='+maxrate+'&pktsize='+pktsize+'&weight='+weight;
	$.ajax({
		url: '/python/egress_packet_scheduler.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id+' .initializer').hide();
			if (status == '-2') {
				show_redirect_alert();
			}
			else if (status == '0' || status == '6' ) {
				fill_egress_packet_scheduler(ip_id);
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});	
}

function eps_validate(unique_parent_id, element){
	/*if( $(unique_parent_id+' .new_rule .mode_sel').val() == '1' &&  $(unique_parent_id+' .new_rule .rateunit').val() == '1' ){
		$(unique_parent_id+' .new_rule .pktsize_li input').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' .new_rule .pktsize_li input').val('');
	}	
	else{
		$(unique_parent_id+' .new_rule .pktsize_li input').val('').attr('disabled','disabled').addClass('disabled');
	}*/
	
	//<input type="text" value="" name="maxrate" class="text maxrate" onkeyup="digit_validate($(this));$(this).removeClass(\'error\')">\
	
	if( $(unique_parent_id+' .new_rule .classid').val() == 'null' ){
		//Then only channel can be set. Hence disable class specific details
		$(unique_parent_id+' .new_rule .minrate_li input').val('').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id+' .new_rule .pktsize_li input').val('').attr('disabled','disabled').addClass('disabled');
		$(unique_parent_id+' .new_rule .weight_li select').val('0').attr('disabled','disabled').addClass('disabled');
	}
	else{
		$(unique_parent_id+' .new_rule .minrate_li input').val('').removeAttr('disabled').removeClass('disabled');
		$(unique_parent_id+' .new_rule .weight_li select').val('0').removeAttr('disabled','disabled').removeClass('disabled');
		if ($(unique_parent_id + ' .new_rule .mode_sel').val() == '1' || $(unique_parent_id + ' .new_rule .rateunit').val() == '1') {
			$(unique_parent_id + ' .new_rule .pktsize_li input').val('').removeAttr('disabled').removeClass('disabled');
		}
		else if ( $(unique_parent_id + ' .new_rule .mode_sel').val() == '0' &&  $(unique_parent_id + ' .new_rule .rateunit').val() == '0') {
			$(unique_parent_id+' .new_rule .pktsize_li input').val('').attr('disabled','disabled').addClass('disabled');	
		}
	}
	
	if( element.attr('class') == 'ratemode' &&  element.val() == '1' ){
		$(unique_parent_id + ' .new_rule .maxrate_li').html('<input type="text" onkeyup="digit_validate($(this))" class="text maxrate" name="maxrate" value="">');
	}
	else{
		var maxrate_html = '<select class="maxrate" name="maxrate" onchange="$(this).removeClass(\'error\');">';
		maxrate_html += '<option value="0">Select One..</option>';
		for( i=1; i<=100; i++  ){
			maxrate_html += '<option value="'+i+'">'+i+'</option>';
		}
		 maxrate_html += '</select>';
		 $(unique_parent_id + ' .new_rule .maxrate_li').html(maxrate_html);
	}
	
	if( element.attr('class') == 'classid' ){
		$(unique_parent_id+' .new_rule .ratemode').trigger('change');
	}
	
}