(function ($) {
    var methods = {
        init: function () {},
        alert: function (options) {
            lboptions = jQuery.extend({
                alertTitle: 'Chelsio UM 1.0',
                alertMsg: '',
                alertOk: 'OK',
                successfn: '$("#modalogContainer").remove()',
                fadeTime: 300,
                lbWidth: 420,
                top_extra: 100
            }, options);
            chAlert()
        },
        confirm: function (options) {
            lboptions = jQuery.extend({
                cnfmTitle: 'Chelsio UM 1.0',
                cnfmMsg: '',
                cnfmCancel: 'Cancel',
                cnfmOk: 'OK',
                successfn: '',
                fadeTime: 300,
                lbWidth: 420,
                top_extra: 100
            }, options);
            chConfirm()
        },
        ajax: function (options) {
            lboptions = jQuery.extend({
                lbTitle: 'Chelsio UM 1.0',
                lbCancel: 'Cancel',
                lbOk: 'OK',
                ajaxHtml: 'Ajax Error',
                successfn: lbDestroy(),
                fadeTime: 300,
                lbWidth: '',
                top_extra: 0
            }, options);
            chLbAjax()
        },
        popup: function (options) {
            lboptions = jQuery.extend({
                PopTitle: 'Chelsio UM 1.0',
                PopCancel: 'Cancel',
                PopOk: 'OK',
                PopDivId: '',
                successfn: lbDestroy(),
                fadeTime: 300,
                lbWidth: '',
                top_extra: 0
            }, options);
            chLbPopup()
        },
        destroy: function () {
            /*$('#modalogContainer').fadeOut(300, function () {
                $('#modalogContainer').remove()
            })*/
			$('#modalogContainer').remove()
        }
    };
    $.fn.chLightbox = function (method) {
        if (methods[method]) {
            return methods[method].apply(this, Array.prototype.slice.call(arguments, 1))
        } else if (typeof method === 'object' || !method) {
            return methods.init.apply(this, arguments)
        } else {
            $.error('Method ') + method + ' does not exist on jQuery.chLightbox';
        }
    };

    function chLbAjax() {
        var html = build_top_html(lboptions.lbTitle);
        html += '<div id="modalogClose"><a href="javascript:void(0);" class="close_ch_lb" id="modalogCloseButton">' + 'Close' + '</a></div>';
        html += lboptions.ajaxHtml;
        html += build_bottom_html(lboptions.lbOk, lboptions.lbCancel);
        lbShow(html)
    }
    function chConfirm() {
        var html = build_top_html(lboptions.cnfmTitle);
        html += '<div id="shareModal"><div id="modalogContent">';
        html += '<p class="fnt14">' + lboptions.cnfmMsg + '</p></div></div>';
        html += build_bottom_html(lboptions.cnfmOk, lboptions.cnfmCancel);
        lbShow(html)
    }
    function chAlert() {
        var html = build_top_html(lboptions.alertTitle);
        html += '<div id="shareModal"><div id="modalogContent">';
        html += '<p class="fnt14">' + lboptions.alertMsg + '</p></div></div>';
        html += build_alert_bottom_html(lboptions.alertOk);
        lbShow(html)
    }
    function chLbPopup() {
        var html = build_top_html(lboptions.PopTitle);
        html += '<div id="modalogClose"><a href="javascript:void(0);" class="close_ch_lb" id="modalogCloseButton">' + 'Close' + '</a></div>';
        html += $('#' + lboptions.PopDivId).html().replace('<!--', '').replace('-->', '');
        html += build_bottom_html(lboptions.PopOk, lboptions.PopCancel);
        lbShow(html)
    }
    function build_top_html(title) {
        var top_html = '<div style="height: ' + $(document).height() + 'px;" id="modalogContainer" class="as_hide">';
        top_html += '<div id = "modalogOverlay" ></div>';
        top_html += '<div class="closed done open" id="modalogBox" ';
        var mgnLeft = '-' + parseInt(lboptions.lbWidth) / 2 + 'px';
        var top = getPageScroll()[1] + (getPageHeight() / 10) + lboptions.top_extra;
        top_html += 'style="width:' + lboptions.lbWidth + 'px;margin-left:' + mgnLeft + ';top:' + top + 'px"';
        top_html += ' >';
        top_html += '<form method="post" id="as_ch_lb_form" class="edit_user group" onsubmit="return false" >';
        top_html += '<div id="dialogBoxHdr"><h3>' + title + '</h3></div>';
        return top_html
    }
    function build_bottom_html(ok, cancel) {
        var btm_html = '<div id="dialogBoxFtr">';
        if (ok != 'none') {
            btm_html += '<div class="form-actions as_gp_lb_button_wrapper">';
            btm_html += '<img src="/site_media/ui/img/gray-spinner.gif" id="save_spinner" class="as_hide" alt="' + 'Please Wait...' + '" style="float:left"><div class="btn_wraper as_form_action mgn_t0 mgn_r5"><button class="btn yellow" type="submit">';
            btm_html += ok + '</button></div>'
        }
        if (cancel != 'none') {
            btm_html += '<div class="btn_wraper mgn_t0">';
            btm_html += '<button class="btn close_ch_lb" type="button" >' + cancel + '</button></div><div class="clear"></div></div></div>'
        }
        btm_html += '</div></form></div>';
        return btm_html
    }
    function build_alert_bottom_html(ok) {
        var btm_html = '<div id="dialogBoxFtr">';
        if (ok != 'none') {
            btm_html += '<div class="form-actions as_gp_lb_button_wrapper">';
            btm_html += '<img src="/site_media/ui/img/gray-spinner.gif" id="save_spinner" class="as_hide" alt="' + 'Please Wait...' + '" style="float:left"><div class="btn_wraper as_form_action mgn_t0 mgn_r5"><button class="btn yellow" type="submit">';
            btm_html += ok + '</button></div><div class="clear"></div></div>'
        }
        btm_html += '</div></form></div>';
        return btm_html
    }
    $('#as_ch_lb_form').live('submit', function () {
        eval(lboptions.successfn)
    });
    
	$('.close_ch_lb').live('click', function () {
        lbDestroy()
    });

    function lbDestroy() {
        $('#modalogContainer').remove()
    }
    function lbShow(html) {
        $('body').prepend(html);
        $('#modalogContainer').show()
    }
    function getPageScroll() {
        var xScroll, yScroll;
        if (self.pageYOffset) {
            yScroll = self.pageYOffset;
            xScroll = self.pageXOffset
        } else if (document.documentElement && document.documentElement.scrollTop) {
            yScroll = document.documentElement.scrollTop;
            xScroll = document.documentElement.scrollLeft
        } else if (document.body) {
            yScroll = document.body.scrollTop;
            xScroll = document.body.scrollLeft
        }
        return new Array(xScroll, yScroll)
    }
    function getPageHeight() {
        var windowHeight;
        if (self.innerHeight) {
            windowHeight = self.innerHeight
        } else if (document.documentElement && document.documentElement.clientHeight) {
            windowHeight = document.documentElement.clientHeight
        } else if (document.body) {
            windowHeight = document.body.clientHeight
        }
        return windowHeight
    }
})(jQuery);