function fill_card_stats(ip_id){
	var unique_inc = $('#m_tree_wrap .tree .tree_ul a.selected').attr('name')+'end';
	var unique_parent_id = '#card_content__'+ unique_inc + '__' + ip_id + ' .card_stats_tab ';
	
	if( $(unique_parent_id +' .global_error').css('display') == 'block' ){
		return;
	}
	var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	var loader_selector = unique_parent_id +' .initializer';
	$(loader_selector).show();
	var ip = replace_with(ip_id,'_','.');
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid='+sid+'&ip='+ip+'&ostype='+ostype;
	
	var pciloc = $.trim($('#m_tree_wrap .tree .tree_ul a.selected').children('.pciloc').val());
	if (ostype == '4') {
		$(loader_selector).hide();
		show_error_msg(unique_parent_id, 'Card statistics are not available for freebsd agents.');
	}
	else {
		card_statistics(unique_parent_id, ip_id, getdata, loader_selector, pciloc);
	}
	$(unique_parent_id+' .overlay_disp_wr').html('');
}

function card_statistics(unique_parent_id, ip_id, getdata,loader_selector,pciloc){
	//var ostype = $.trim($('#ip_' + ip_id + ' .system_link').children('.ostype').val());
	getdata += "&pciloc="+pciloc;
	var chiptype = $.trim($('#ip_' + ip_id + ' a.selected').children('.chiptype').val());
	getdata += "&chiptype="+chiptype
	var card_name = $.trim($('#ip_' + ip_id + ' a.selected').children('.tree_cardname').val());
	getdata += "&card_name="+card_name
	
	$.ajax({
		url: '/python/get_card_statistics.py',
		type: 'GET',
		cache: false,
		data: getdata,
		dataType: 'json',
		success: function(data){
			$(loader_selector).hide();
			
			if (data == '-2') {
				show_redirect_alert();
			}
			else if (data == '-1') {
				$(unique_parent_id+ '  .card_stats_main ul').removeClass('from_server');
				$(unique_parent_id +'  .card_stats_error').fadeIn(300);
			}
			else if (data == '-6') {
				$(unique_parent_id+ '  .card_stats_main ul').removeClass('from_server');
				/*var msg = ''
				if(chiptype == 'T4' && ostype != '1' ){
					msg = 't4_tom driver is not loaded.';					
				} 
				else{
					msg = 't3_tom driver is not loaded.';
				}*/
				show_error_msg(unique_parent_id, 'No stats found for this card.');
			}
			else if (data == '-9') {
				$(unique_parent_id+ '  .card_stats_main ul').removeClass('from_server');
				show_error_msg(unique_parent_id, 'No stats found for this card.');
			}
			else {
				$(unique_parent_id).animate({
					'height': data.height+'px'
				},300);
				$(unique_parent_id+ '  .card_stats_main').html(data.html);
				$(unique_parent_id+ '  .card_stats_main').fadeIn(300);
			}
			
		}
	});
}