function fill_bulk_manage_machine_groups(){
	var unique_parent_id = '#bulk_content .bulk_manage_machine_groups_tab';
	var loader_selector = unique_parent_id + ' .initializer';
	$(loader_selector).hide();
	

	if( $(loader_selector).css('display') == 'block' || $(unique_parent_id +' .group_sel').length ){
		return
	}
	
	var sid = GetCookie("chelsio_webgui_sid");
	var getdata = 'sid=' + sid + '&req_type=desktop';
	
	//Initializing
	$(unique_parent_id +' .refresh').attr('onclick','$("'+ unique_parent_id +' .group_wr").html("");fill_bulk_manage_machine_groups()');
	$(unique_parent_id +' .blk_mmg_discard button').attr('onclick','blk_mmg_discard("'+ unique_parent_id +'")');
	$(unique_parent_id +' .blk_add_gp').attr('onclick','blk_mg_create_gp( "'+ unique_parent_id +'", "'+ getdata +'")');
	$(unique_parent_id +' .blk_mmg_del_gp button').attr('onclick','blk_mg_delete_gp( "'+ unique_parent_id +'", "'+ getdata +'")');
	$(unique_parent_id +' .blk_mmg_delete_sys button').attr('onclick','blk_mg_delete_sys( "'+ unique_parent_id +'", "'+ getdata +'")');
	$(unique_parent_id +' .blk_mmg_add_row button').attr('onclick','blk_mmg_add_row( "'+ unique_parent_id +'")');
	$(unique_parent_id +' .blk_mmg_save_sys button').attr('onclick','blk_mmg_save_sys( "'+ unique_parent_id +'", "'+ getdata +'")');
	$(unique_parent_id +' .blk_mmg_fetch_data button').attr('onclick','blk_mmg_fetch_data( "'+ unique_parent_id +'", "'+ getdata +'")');
	
	blk_mg_get_intial_data(unique_parent_id, getdata);
}

function blk_mg_get_intial_data(unique_parent_id, getdata){
	$(unique_parent_id + ' .initializer').show();
	getdata += '&action=get_initial_data';
	$.ajax({
		url: '/python/bulk_manage_machine_groups.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id + ' .initializer').hide();
			if( data.status == '-2' ){
				show_redirect_alert();
			}
			else if (data.status == '-1') {
				display_failed(unique_parent_id);
			}
			else if (data.status == '6') {
				show_error_msg(unique_parent_id, data.msg);
				if( data.error_code == '-3' ){
					$(unique_parent_id + ' .second_wr').slideUp(300);
					$(unique_parent_id + ' .third_wr').slideUp(300);
					$(unique_parent_id).animate({
						'height' : '275px'
					},300);
				}
			}
			else if (data.status == '0') {
				$(unique_parent_id + ' .group_wr').html(data.html);
				$(unique_parent_id + ' .second_wr').slideDown(300);
				$(unique_parent_id + ' .third_wr').slideUp(300);
				$(unique_parent_id).animate({
					'height' : '485px'
				},300);
				$(unique_parent_id+' .group_sel').trigger('change');
			}
		}
	});
}

function blk_mg_create_gp(unique_parent_id, getdata){
	
	var group_name = $.trim($(unique_parent_id+' .grpname').val());
	if( group_name == '' ){
		$(unique_parent_id+' .grpname').addClass('error');
		return
	}
	
	$(unique_parent_id + ' .initializer').show();
	var gpostype = $(unique_parent_id+' .ostype').val();
	var grouptype = $(unique_parent_id+' .grouptype').val();
	getdata += '&action=create_gp&group_name='+group_name+'&grouptype='+grouptype+'&gpostype='+gpostype;
	$.ajax({
		url: '/python/bulk_manage_machine_groups.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id + ' .initializer').hide();
			if( status == '0' ){
				display_success(unique_parent_id);
				$(unique_parent_id +' .group_wr').html('');
				fill_bulk_manage_machine_groups();
			}
			else if( status == '-2' ){
				show_redirect_alert();
			}
			else if( status == '-1' ){
				display_failed(unique_parent_id);
			}
			else{
				show_error_msg(unique_parent_id, status);
			}
		}
	});
}

function blk_mg_delete_gp(unique_parent_id, getdata){
	
	var group_name = $.trim($(unique_parent_id+' .group_sel').val());
	if( group_name == '' ){
		$(unique_parent_id+' .group_sel').addClass('error');
		return
	}
	
	$(unique_parent_id + ' .initializer').show();
	getdata += '&action=delete_gp&group_name='+group_name;
	$.ajax({
		url: '/python/bulk_manage_machine_groups.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id + ' .initializer').hide();
			if( status == '0' ){
				$(unique_parent_id +' .group_wr').html('');
				fill_bulk_manage_machine_groups();
			}
			else if( status == '-2' ){
				show_redirect_alert();
			}
			else if( status == '-1' ){
				display_failed(unique_parent_id);
			}
			else{
				show_error_msg(unique_parent_id, status);
			}
		}
	});
}

function blk_mg_delete_sys(unique_parent_id, getdata){
	var group_name = $.trim($(unique_parent_id+' .group_sel').val());
	if( group_name == '' ){
		$(unique_parent_id+' .group_sel').addClass('error');
		return
	}
	$(unique_parent_id + ' .initializer').show();
	getdata += '&action=delete_sys&group_name='+group_name;
	
	var index = $.trim($(unique_parent_id+' .sno_chk:checked').val());
	getdata += '&index='+index;
	$.ajax({
		url: '/python/bulk_manage_machine_groups.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id + ' .initializer').hide();
			if( status == '0' ){
				$(unique_parent_id+' .group_sel').trigger('change');
				enable_disable_btn(unique_parent_id + ' .blk_mmg_delete_sys button', 'yellow', 'disable');
			}
			else if( status == '-2' ){
				show_redirect_alert();
			}
			else{
				display_failed(unique_parent_id);
			}
		}
	});
}

function blk_mmg_save_sys(unique_parent_id, getdata){
	var success = true;
	var group_name = $.trim($(unique_parent_id+' .group_sel').val());
	if( group_name == '' ){
		$(unique_parent_id+' .group_sel').addClass('error');
		success = false;
	}
	
	$(unique_parent_id + ' .grid .required').each(function(){
		if( $.trim($(this).val()) == ''){
			$(this).addClass('error');
			success = false;
		}
	});
	
	if(!success){
		return
	}
	
	var sys_ip = $.trim($(unique_parent_id+' .host_ip_txt').val());
	var username = $.trim($(unique_parent_id+' .username_txt').val());
	var pwd = $.trim($(unique_parent_id+' .pwd_txt').val());
	
	var pciid = '';
	var port_instance = '';
	var ifname = '';
	var adpater = '';
	var group_type = $(unique_parent_id+' .group_sel option:selected').attr('grouptype');
	if( group_type == 't5port' || group_type == 't4port' || group_type == 't3port' ){
		pciid = $.trim($(unique_parent_id + ' .new_sys_ul select.details').val().split('#')[0]);
		//var details = $(unique_parent_id + ' .new_sys_ul select.details').val();
		//var pciid = details.match(/(\d+\:\d+\:\d+)/)[0];
		port_instance = $.trim($(unique_parent_id + ' .new_sys_ul select.details').val().split('#')[1]);
	}
	else if( group_type == 'network' ){
		ifname = $.trim($(unique_parent_id+' .network_mem select.details').val());
	}
	else if( group_type == 't5adapter' || group_type == 't4adapter' || group_type == 't3adapter'){
		adpater = $.trim($(unique_parent_id+' .new_sys_ul select.details').val());
		var details =  $.trim($(unique_parent_id+' .new_sys_ul select.details').html());
		var pci_id_regex = /([0-9A-Za-f]+:[0-9A-Za-f]+.[0-9A-Za-f]+)/;
		var pci_id_match = pci_id_regex.exec(details);
		pciid = pci_id_match[0];
	}
	
	if( $(unique_parent_id+' .fetch_ul').length ){
		var adpater_str = $.trim($(unique_parent_id+' .adpater_txt option:selected').html());
		adpater += '_'+replace_with( adpater_str , ' ', 'space' )
		getdata += '&fetch_data=yes';
	}
	else{
		getdata += '&fetch_data=no';
	}
	
	var desc = '';
	if( $(unique_parent_id+' .new_sys_ul select.details').length ){
		desc =  $(unique_parent_id+' .new_sys_ul select.details option:selected').html();
	}
	getdata += '&action=save_sys&group_name='+group_name+'&sys_ip='+sys_ip+'&username='+username+'&pwd='+pwd+'&adpater='+adpater+'&pciid='+pciid;
	getdata += '&ifname='+ifname+'&port_instance='+port_instance+'&desc='+encodeURIComponent(desc);
	$(unique_parent_id + ' .initializer').show();
	$.ajax({
		url: '/python/bulk_manage_machine_groups.py',
		type: 'GET',
		cache: false,
		data: getdata,
		success: function(status){
			$(unique_parent_id + ' .initializer').hide();
			if( status == '0' ){
				$(unique_parent_id+' .group_sel').trigger('change');
				enable_disable_btn(unique_parent_id + ' .blk_mmg_save_sys button', 'blue', 'disable');
				enable_disable_btn(unique_parent_id + ' .blk_mmg_fetch_data button', 'yellow', 'disable');
			}
			else if( status == '-2' ){
				show_redirect_alert();
			}
			else if( status == '-1' ){
				display_failed(unique_parent_id);
			}
			else{
				show_error_msg(unique_parent_id, status);	
			}
		}
	});
}

function blk_mmg_gp_change(element){
	var unique_parent_id = '#bulk_content .bulk_manage_machine_groups_tab ';
	enable_disable_btn(unique_parent_id + ' .blk_mmg_delete_sys button', 'yellow', 'disable');
	enable_disable_btn(unique_parent_id + ' .blk_mmg_fetch_data button', 'yellow', 'disable');
	if( $.trim(element.val()) == ''  ){
		$(unique_parent_id+' .ostype_li').html('&nbsp;');
		$(unique_parent_id+' .grouptype_li').html('&nbsp;');
		$(unique_parent_id+' .row_div_wr .grid').html('');
		$(unique_parent_id+' .row_div_wr').slideUp(300); 
		$(unique_parent_id+' .third_wr').slideUp(300);
		$(unique_parent_id).animate({
			'height' : '485px'
		},300);
		return
	}
	else{
		$(unique_parent_id+' .ostype_li').html($(unique_parent_id+' .group_sel option:selected').attr('ostype'));
		$(unique_parent_id+' .grouptype_li').html($(unique_parent_id+' .group_sel option:selected').attr('grouptype'));
	}
	
	$(unique_parent_id + ' .initializer').show();
	var group_name = $.trim($(unique_parent_id+' .group_sel option:selected').html());
	var getdata = '&action=get_sys&req_type=desktop&group_name='+group_name+'&sid='+GetCookie("chelsio_webgui_sid");;
	$.ajax({
		url: '/python/bulk_manage_machine_groups.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id + ' .initializer').hide();
			if( data.status == '-2' ){
				show_redirect_alert()
			}
			else if (data.status == '-1') {
				display_failed(unique_parent_id);
			}
			else if (data.status == '-3') {
				$(unique_parent_id+' .row_div_wr .grid').html('');
				$(unique_parent_id+' .row_div_wr').slideDown(300);
				$(unique_parent_id+' .third_wr').slideDown(300);
				$(unique_parent_id).animate({
					'height' : '485px'
				},300);
			}
			else if (data.status == '0') {
				if( data.html == '-4' ){
					$(unique_parent_id+' .row_div_wr .grid').html('');
					$(unique_parent_id+' .row_div_wr').slideUp(300);
					$(unique_parent_id+' .third_wr').slideUp(300);
					$(unique_parent_id).animate({
						'height' : '485px'
					},300);
				}
				else{
					$(unique_parent_id+' .row_div_wr .grid').html(data.html);
					$(unique_parent_id+' .row_div_wr').slideDown(300); 
					$(unique_parent_id+' .third_wr').slideDown(300);
					$(unique_parent_id).animate({
						'height' : data.height+'px'
					},300);
				}
			}
		}
	});
}

function blk_mmg_add_row(unique_parent_id){
	
	var head_html = '<ul class="horizontal head_ul">\
				<li class="sno"><h2>SNO</h2></li>\
				<li class="host_ip"><h2>Hostname / IP</h2></li>\
				<li class="user_name"><h2>Username</h2></li>\
				<li><h2>Password</h2></li>\
				<li class="details"><h2>Details</h2></li>\
				</ul>'
		
	var grouptype = $(unique_parent_id+' .group_sel option:selected').attr('grouptype');
	var row_html = '<ul class="horizontal clear_left content_tbl rules_ul new_sys_ul '+grouptype+'_mem">\
				<li class="sno">&nbsp;</li>\
				<li class="host_ip">\
					<input type="text" class="host_ip_txt text required" onkeyup="$(this).removeClass(\'error\')" />\
				</li>\
				<li class="user_name">\
					<input type="text" class="username_txt text required" onkeyup="$(this).removeClass(\'error\')" />\
				</li>\
				<li>\
					<input type="password" class="pwd_txt text required" onkeyup="$(this).removeClass(\'error\')" />\
				</li>\
					<li class="details">-</li>\
				</ul>\
				<div class="clear_left"></div>';
	
	if( $(unique_parent_id+' .rules_ul').length ){
		if( $(unique_parent_id+' .new_sys_ul').length || $(unique_parent_id+' .fetch_ul').length ){
			$(unique_parent_id+' .new_sys_ul').remove();			
			$(unique_parent_id+' .fetch_ul').remove();
		}
		else{
			$(unique_parent_id).animate({
				'height' : $(unique_parent_id).height()+30
			},300);
		}
		$(unique_parent_id+' .grid').append(row_html);
		$(unique_parent_id+' .host_ip_txt').focus();
	}
	else{
		$(unique_parent_id+' .grid').html(head_html+row_html);
		$(unique_parent_id).animate({
			'height' : '605px'
		},300);
		
	}			
	
	$(unique_parent_id+' .row_div_wr').slideDown(300);
	$(unique_parent_id+' .third_wr').slideDown(300);
	if( grouptype == 'system' ){
		enable_disable_btn(unique_parent_id + ' .blk_mmg_save_sys button', 'blue', 'enable');
		enable_disable_btn(unique_parent_id + ' .blk_mmg_fetch_data button', 'yellow', 'disable');
	}
	else{
		enable_disable_btn(unique_parent_id + ' .blk_mmg_save_sys button', 'blue', 'disable');
		enable_disable_btn(unique_parent_id + ' .blk_mmg_fetch_data button', 'yellow', 'enable');
	}
}

function blk_mmg_toggle_btn(element){
	var unique_parent_id = '#bulk_content .bulk_manage_machine_groups_tab ';
	if (element.hasClass('group_sel')) {
		if ($.trim(element.val()) == '') {
			enable_disable_btn(unique_parent_id + ' .blk_mmg_del_gp button', 'blue', 'disable');
			enable_disable_btn(unique_parent_id + ' .blk_mmg_add_row button', 'yellow', 'disable');
		}
		else {
			enable_disable_btn(unique_parent_id + ' .blk_mmg_del_gp button', 'blue', 'enable');
			enable_disable_btn(unique_parent_id + ' .blk_mmg_add_row button', 'yellow', 'enable');
		}
		enable_disable_btn(unique_parent_id + ' .blk_mmg_fetch_data button', 'yellow', 'disable');
		enable_disable_btn(unique_parent_id + ' .blk_mmg_save_sys button', 'blue', 'disable');
	}
	else if (element.hasClass('sno_chk')) {
		if( $(unique_parent_id+' .sno_chk').is(':checked') ){
			enable_disable_btn(unique_parent_id + ' .blk_mmg_delete_sys button', 'yellow', 'enable');
		}
		else{
			enable_disable_btn(unique_parent_id + ' .blk_mmg_delete_sys button', 'yellow', 'disable');
		}
	}	 
}

function blk_mmg_fetch_data(unique_parent_id, getdata){
	var success = true;
	
	$(unique_parent_id + ' .grid .required').each(function(){
		if( $.trim($(this).val()) == ''){
			$(this).addClass('error');
			success = false;
		}
	});
	
	if(!success){
		return
	}
	
	$(unique_parent_id + ' .initializer').show();
	
	var sys_ip = $.trim($(unique_parent_id+' .host_ip_txt').val());
	var username = $.trim($(unique_parent_id+' .username_txt').val());
	var pwd = $.trim($(unique_parent_id+' .new_sys_ul .pwd_txt').val());
	var group_type = $(unique_parent_id+' .group_sel option:selected').attr('grouptype');
	getdata += '&action=fetch_data&sys_ip='+sys_ip+'&username='+username+'&pwd='+pwd+'&group_type='+group_type;
	$.ajax({
		url: '/python/bulk_manage_machine_groups.py',
		type: 'GET',
		dataType: 'json',
		cache: false,
		data: getdata,
		success: function(data){
			$(unique_parent_id + ' .initializer').hide();
			if (data.status == '-2') {
				show_redirect_alert();
			}
			else if (data.status == '-1') {
				display_failed(unique_parent_id);
			}
			else if (data.status == '-6') {
				show_error_msg(unique_parent_id, data.error_msg);
			}
			else if (data.status == '0') {
				$(unique_parent_id+' .new_sys_ul input').addClass('disabled').attr('disabled','disabled');
				$(unique_parent_id+' .new_sys_ul .details').html(data.html);
				enable_disable_btn(unique_parent_id + ' .blk_mmg_save_sys button', 'blue', 'enable');
				enable_disable_btn(unique_parent_id + ' .blk_mmg_fetch_data button', 'yellow', 'enable');
			}	
			else{
				display_failed(unique_parent_id);
			}	
		}
	});	
		
}

function blk_mmg_show_data(element){
	var unique_parent_id = '#bulk_content .bulk_manage_machine_groups_tab';
	var adap_idx = $(element).val();
	
	$(unique_parent_id+' .pciid_txt').hide();
	$(unique_parent_id+' .pciid_adapt_'+adap_idx).show();
	
	$(unique_parent_id+' .port_instance_txt').hide();
	$(unique_parent_id+' .portinstance_adapt_'+adap_idx).show();
	
	$(unique_parent_id+' .ifname_txt').hide();
	$(unique_parent_id+' .ifname_adapt_'+adap_idx).show();
}

function blk_mmg_discard(unique_parent_id){
	if(  $.trim($(unique_parent_id+' .group_sel').val()) == '' ){
		$(unique_parent_id +' .group_wr').html("");
		fill_bulk_manage_machine_groups();
	}
	else{
		$(unique_parent_id+' .group_sel').trigger('change');
		enable_disable_btn(unique_parent_id + ' .blk_mmg_save_sys button', 'blue', 'disable');
		enable_disable_btn(unique_parent_id + ' .blk_mmg_fetch_data button', 'yellow', 'disable');
		enable_disable_btn(unique_parent_id + ' .blk_mmg_delete_sys button', 'yellow', 'disable');
	}
}
