from XenVfPropsFile import XenVfProps 

def index(req, **kwargs):
    
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return '-1'
    
    if data['action'] == 'get':
        return invoke_get_xen_props_data(data)
    elif data['action'] == 'assign':
        try:
            data['uuid'] = kwargs['uuid']
            data['vfpci'] = kwargs['vfpci']
        except:
            return '-1'
        
        return invoke_set_operations(data)
    
    elif data['action'] == 'set_iommu':
        try:
            data['iommu_val'] = kwargs['iommu_val']
        except:
            return '-1'
        
        return invoke_setIommu(data)
    else:
        return -1
    
def invoke_get_xen_props_data(data):
    obj =  XenVfProps(data['sid'], data['ip'])
    return obj.get_xen_props_data()

def invoke_set_operations(data):
    obj =  XenVfProps(data['sid'], data['ip'])
    return obj.set_operations(data)

def invoke_setIommu(data):
    obj =  XenVfProps(data['sid'], data['ip'])
    return obj.setIommu(data['iommu_val'])