from XenAddVirtualNwConfFile import XenAddVirtualNwConf

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip']  = kwargs['ip']
        data['action'] = kwargs['action']
        data['type'] = kwargs['type']
    except:
        return '-1'
    
    if data['action'] == 'get':
        return invoke_get_initial_data(data)
    elif data['action'] == 'create_bridge':
        try:
            data['bname'] = kwargs['bname']
            data['bmtu'] = kwargs['bmtu']
            data['bname_desc'] = kwargs['bname_desc']
        except:
            return '-1'
        return invoke_create_bridge(data)
    elif data['action'] == 'create_vif':
        try:
            data['device_id'] = kwargs['device_id']
            data['bridge_uuid'] = kwargs['bridge_uuid']
            data['vm_uuid'] = kwargs['vm_uuid']
            data['mac'] = kwargs['mac']
        except:
            return '-1'
        return invoke_create_vif(data)

def invoke_get_initial_data(data):
    vnt_obj =  XenAddVirtualNwConf(data['sid'], data['ip'], data['type'])
    return vnt_obj.get_initial_data()

def invoke_create_bridge(data):
    vnt_obj =  XenAddVirtualNwConf(data['sid'], data['ip'], data['type'])
    return vnt_obj.create_bridge(data)

def invoke_create_vif(data):
    vnt_obj =  XenAddVirtualNwConf(data['sid'], data['ip'], data['type'])
    return vnt_obj.create_vif(data)