from HypervisorFile import Hypervisor
from NetworkInfoFile import WebNetworkInfo

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip']  = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return '-1'
    
    if data['action'] == 'get_switch_tree':
        return invoke_get_switch_tree(data)
    elif data['action'] == 'get_interface_list':
        return invoke_get_interface_list(data)
    elif data['action'] == 'specific_call':
        try:
            data['vmnic'] = kwargs['vmnic']
            data['reqType'] = kwargs['reqType']
            data['VSwitchName'] = kwargs['VSwitchName']
            data['PGName'] = kwargs['PGName']
        except:
            return '-1'
        return invoke_specific_call(data)
    elif data['action'] == 'set_mtu':
        try:
            data['ifName'] = kwargs['ifname']
            data['mtu'] = kwargs['mtu']
        except:
            return '-1'
        return invoke_set_mtu(data)
    elif data['action'] == 'set_vlanid':
        try:
            data['vswitchname'] = kwargs['vswitchname']
            data['PGName'] = kwargs['PGName']
            data['vlanid'] = kwargs['vlanid']
        except:
            return '-1'
        return invoke_set_vlanid(data)
    else:
        return -1

def invoke_get_switch_tree(data):
    vnt_obj =  Hypervisor(data['sid'], data['ip'])
    return vnt_obj.get_switch_tree(data)

def invoke_get_interface_list(data):
    vnt_obj =  Hypervisor(data['sid'], data['ip'])
    return vnt_obj.get_interface_list()

def invoke_specific_call(data):
    vnt_obj =  Hypervisor(data['sid'], data['ip'])
    return vnt_obj.create_virtual_network(data)

def invoke_set_mtu(data):
    nw_obj = WebNetworkInfo(data['sid'],data['ip'])
    return nw_obj.set_mtu(data)

def invoke_set_vlanid(data):
    nw_obj = Hypervisor(data['sid'],data['ip'])
    return nw_obj.set_vlanid(data)
