#From Python
from xml.dom import minidom
import os

#From Project
from UmBoostLib import ConnectToUmServer, Utilities
import settings
logging = settings.get_logger()

def index(req, **kwargs):
    
    try:
        action = kwargs['action']
    except:
        return -1
    
    if action == 'ostype':
        
        try:
            sid = kwargs['sid']
            ip = kwargs['ip']
        except:
            return -1
        
        return get_ostype(sid, ip)
    
    else:
        return -1
    

def remove_system_node(xml_filename,ip):
    xml_filename = '%s%s'%(settings.document_root_path,xml_filename)
    
    doc = minidom.parse(xml_filename)
    
    system_nodes = doc.getElementsByTagName('system')
    for system_node in system_nodes:
        if ip == system_node.getAttribute("ip"):
            parentNode = system_node.parentNode
            parentNode.removeChild(system_node)
    
    file = open(xml_filename,'w')
    file.write(doc.toprettyxml())
    file.close()
    return 0

def get_ostype(sid, ip):
     obj = ConnectToUmServer()
     return obj.GetUmServerOSType(sid, ip)
 
def refresh_system(sid, ip):
     obj = Utilities()
     logging.info('Fcoe Refresh for windows sid: %s, ip: %s'%(sid, ip))
     status = obj.RefreshSystem(sid, ip)
     logging.info('Fcoe Refresh for windows Status: %s'%(status))
     if status == -2 or status == 0:
         return status
     else:
         return -1
 
#define VALIDATE_IP 1
#define VALIDATE_MASK 2
#define VALIDATE_GW 3
def validate_ip(ip, validate):
    IpValidateBoostObj = Utilities()
    
    status = IpValidateBoostObj.ValidateAddress(ip, validate)
    if status == 0:
        return status
    else:
        return -1
    
def validate_mac(mac):
    MacValidateBoostObj = Utilities()
    
    status = MacValidateBoostObj.isValidMacAddress(mac)
    if status == 1:
        return 0
    else:
        return -1
    
def get_boolean_editor(propdesc, propname, value):
    html_list = []
    html_list.append('<ul class="horizontal content_tbl clear from_server">\
                      <li class="desc">%s</li>'%propdesc)
    html_list.append('<li class="bg_none value" >')
    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'%(value, propname))
    if value.strip().lower() == 'yes':
        html_list.append('<option value="yes" selected="selected">Yes</option>\
                          <option value="no">No</option></select>')
    else:
        html_list.append('<option value="yes">Yes</option>\
                          <option value="no" selected="selected">No</option></select>')
    html_list.append('</li></ul>')
    return ''.join(html_list)

def get_text_editor(propdesc, propname, value):
    html_list = []
    html_list.append('<ul class="horizontal content_tbl clear from_server">\
                      <li class="desc">%s</li>'%propdesc)
    html_list.append('<li class="bg_none value" >')
    html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name="value_%s" title="%s" value="%s" >'%(value, propname, value))
    html_list.append('</li></ul>')
    return ''.join(html_list)

def get_choice_editor(propdesc, propname, value, choices):
    html_list = []
    html_list.append('<ul class="horizontal content_tbl clear from_server">\
                      <li class="desc">%s</li>'%propdesc)
    html_list.append('<li class="bg_none value" >')
    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'%(value,propname))
    choices_list = choices.split('#')
    m = 0
    for j in choices_list:
        if str(value) == str(m):
            html_list.append('<option value="%s" selected="selected">%s</option>'%(m, j))
        else:
            html_list.append('<option value="%s" >%s</option>'%(m, j))
        m += 1
    html_list.append('</select>')
    html_list.append('</li></ul>')
    return ''.join(html_list)

def get_custom_choice_editor(**kwargs):
    html_list = []
    html_list.append('<ul class="horizontal content_tbl clear from_server">\
                      <li class="desc">%s</li>'%kwargs['propdesc'])
    html_list.append('<li class="bg_none value" >')
    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'%(kwargs['value'],kwargs['propname']))
    choices_list = kwargs['choices'].split('#')
    for j in choices_list:
        if str(kwargs['value'].lower()) == str(j.lower()):
            html_list.append('<option value="%s" selected="selected">%s</option>'%(j, j))
        else:
            html_list.append('<option value="%s" >%s</option>'%(j, j))
    html_list.append('</select>')
    html_list.append('</li></ul>')
    return ''.join(html_list)

def get_readonly_editor(propdesc, value):
    html_list = []
    html_list.append('<ul class="horizontal content_tbl clear from_server">\
                      <li class="desc">%s</li>'%propdesc)
    html_list.append('<li class="bg_none value" >%s</li></ul>'%value)
    return ''.join(html_list)

def get_number_editor(propdesc, propname, range, stepby, value):
    html_list = []
    html_list.append('<ul class="horizontal content_tbl clear from_server">\
                      <li class="desc">%s</li>'%propdesc)
    html_list.append('<li class="bg_none value" >')                    
    html_list.append('<div class="number_editor">\
                        <div class="fl_left input_wr">')
    min = range.split('#')[0]
    max = range.split('#')[1]
    inc = stepby
    html_list.append('<input type = "text" name="value_%s" title="%s" value="%s" class="text xsml" onblur="number_editor($(this),%s,%s,%s,\'blur\')" onkeyup="number_editor($(this),%s,%s,%s,\'validate\')"  />\
                    </div>'%(value, propname, value, max, min, inc, max, min, inc))
    
    html_list.append('<div class="controls"><div class="up_arrow_wr">\
                    <img src="/images/black/up_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'inc\')"  />\
                    </div><div class= "down_arrow_wr">\
                    <img src="/images/black/down_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'dec\')" />\
                    </div></div></div>'%(max,min,inc,max,min,inc))
    html_list.append('</li></ul>')
    return ''.join(html_list)

def get_error_string(errNo):
    Obj = Utilities()
    return Obj.RetErrStr(errNo)

def create_user_folder(dir):
    try:
        os.makedirs(dir)
        #The syntax of 0o777 is for Python 2.6 and 3+. otherwise for the 2 series it is 0777. 2.6 accepts either syntax 
        os.chmod(dir,0777) 
        return True
    except OSError, e:
        return False
    
def get_boolean_editor(propdesc, propname, value):
    html_list = []
    html_list.append('<ul class="horizontal content_tbl clear from_server">\
                      <li class="desc">%s</li>'%propdesc)
    html_list.append('<li class="bg_none value" >')
    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'%(value, propname))
    if value.strip().lower() == 'yes':
        html_list.append('<option value="yes" selected="selected">Yes</option>\
                          <option value="no">No</option></select>')
    else:
        html_list.append('<option value="yes">Yes</option>\
                          <option value="no" selected="selected">No</option></select>')
    html_list.append('</li></ul>')
    return ''.join(html_list)

def getTextEditor(**kwargs):
    html_list = []
    #Desc
    html_list.append('<ul class="horizontal content_tbl clear from_server">\
                      <li class="desc">%s</li>'%kwargs['propdesc'])
    #range
    if kwargs.has_key('range'):
        html_list.append('<li class="range" >%s</li>'%kwargs['range'])
    
    #value
    html_list.append('<li class="bg_none value" >')
    html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name="value_%s" title="%s" value="%s" >'%(kwargs['value'], kwargs['propname'], kwargs['value']))
    html_list.append('</li>')
    
    html_list.append('</ul>')
    return ''.join(html_list)