from TrafficManagementFile import TrafficManagement
from CardSummary import CardSummary
from PortSummary import PortsSummary
from DriverInfoFile import DriverDetails

import settings
logging = settings.get_logger()

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['req_type'] = kwargs['req_type']
    except:
        data['req_type'] = 'desktop'
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
        data['ostype'] = kwargs['ostype']
        data['pciloc'] = kwargs['pciloc']
    except:
        return -1
    
        
    if data['pciloc'] == -1:
        return -1
    elif data['pciloc'] == -2:
        return -2
    
    if data['action'] == 'get_rules_list':
        try:
            data['card_index'] = kwargs['card_index']
            data['dr_name'] = kwargs['dr_name']
            data['chiptype'] = kwargs['chiptype']
        except:
            return -1
        
        try:
            data['ifName'] = kwargs['ifname']
        except:
            data['ifName'] = get_ifname(data)
            if data['ifName'] == -1 or data['ifName'] == -2:
                return data['ifName']
            
        driver_data = is_driver_loaded(data)
        if driver_data['status'] == -2 or driver_data['status'] == -1:
            return driver_data['status']
        elif driver_data['loaded'] == -6:
            return -6
        
        return invoke_get_rules_list(data)
    
    elif data['action'] == 'get_rule_details':
        
        try:
            data['index'] = kwargs['index']
            data['card_index'] = kwargs['card_index']
            data['chiptype'] = kwargs['chiptype']
        except:
            return -1
        
        try:
            data['ifName'] = kwargs['ifname']
        except:
            data['ifName'] = get_ifname(data)
            if data['ifName'] == -1 or data['ifName'] == -2:
                return data['ifName']
            
        return invoke_get_rule_details(data)
    
    elif data['action'] == 'update_rule':
        
        try:
            data['idx'] = kwargs['idx']
            data['reqType'] = kwargs['reqType']
            data['card_index'] = kwargs['card_index']
            data['policy'] = kwargs['policy']
        except:
            return -1
        
        try:
            data['ifName'] = kwargs['ifname']
        except:
            data['ifName'] = get_ifname(data)
            if data['ifName'] == -1:
                return -1
        
        return invoke_update_rule(data)
    
    else:
        return -1
    
def invoke_get_rules_list(data):
    obj =  TrafficManagement(data['sid'], data['ip'], data['req_type'])
    return obj.get_rules_list( data['ifName'], data['chiptype'] )

def invoke_get_rule_details(data):
    obj =  TrafficManagement(data['sid'], data['ip'], data['req_type'])
    return obj.get_rule_details(data['index'], data['ifName'], data['chiptype'] )

def get_pciloc(data, ostype):
    card_obj =  CardSummary(data['sid'], data['ip'], ostype)
    return card_obj.get_pciloc(data['card_index'])

def get_ifname(data):
    port_obj =  PortsSummary(data['sid'], data['ip'], data['pciloc'], 1, data['req_type'], data['ostype'])
    return port_obj.get_port_ifname()

def is_driver_loaded(data):
    obj = DriverDetails(data['sid'], data['ip'],  data['req_type'])
    return obj.is_driver_loaded( dr_name = data['dr_name'] )
    
def invoke_update_rule(data):
    obj =  TrafficManagement(data['sid'], data['ip'], data['req_type'])
    return obj.update_rule(data)
