from T4FilteringFile import T4Filtering

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip']  = kwargs['ip']
        data['action'] = kwargs['action']
        data['req_type'] = kwargs['req_type']
    except:
        return '-1'
    
    if data['action'] == 'get_initial_data':
        data['pci_str'] = kwargs['pci_str']
        return invoke_get_initial_data(data)
    elif data['action'] == 'set_comb':
        try:
            data['comb_str'] = kwargs['comb_str']
            data['pci_str'] = kwargs['pci_str']
        except:
            return '-1'
        return invoke_set_comb(data)
    elif data['action'] == 'get_comb_filters':
        try:
            data['comb_str'] = kwargs['comb_str']
            data['t4_card'] = kwargs['t4_card']
            data['is_active'] = kwargs['is_active']
            data['pci_str'] = kwargs['pci_str']	
        except:
            return '-1'
        return invoke_get_comb_filters(data)
    elif data['action'] == 'save':
        try:
            data['propname'] = kwargs['propname']
            data['value'] = kwargs['value']
            data['fid'] = kwargs['fid']
            data['filter_count'] = kwargs['filter_count']
            data['comb_str'] = kwargs['comb_str']
            data['action_type'] = kwargs['action_type']
            data['ostype'] = kwargs['ostype']
        except:
            return '-1'
        return invoke_save_filters(kwargs)
    elif data['action'] == 'filter_row':
        try:
            data['comb_str'] = kwargs['comb_str']
            data['t4_card'] = kwargs['t4_card']
        except:
            return '-1'
        return invoke_get_filter_row(data)
    elif data['action'] == 'delete_filter':
        try:
            data['comb_str'] = kwargs['comb_str']
            data['fid'] = kwargs['fid']
        except:
            return '-1'
        return invoke_delete_filter(data)

def invoke_get_initial_data(data):
    obj =  T4Filtering(data['sid'], data['ip'], data['req_type'])
    return obj.get_initial_data(data['pci_str'])

def invoke_set_comb(data):
    obj =  T4Filtering(data['sid'], data['ip'], data['req_type'])
    return obj.set_comb(data['comb_str'], data['pci_str'])

def invoke_get_comb_filters(data):
    obj =  T4Filtering(data['sid'], data['ip'], data['req_type'])
    return obj.get_comb_filters(data)

def invoke_save_filters(data):
    obj =  T4Filtering(data['sid'], data['ip'], data['req_type'])
    return obj.save_filters(data)

def invoke_get_filter_row(data):
    obj =  T4Filtering(data['sid'], data['ip'], data['req_type'])
    return obj.get_filter_row(data)

def invoke_delete_filter(data):
    obj =  T4Filtering(data['sid'], data['ip'], data['req_type'])
    return obj.delete_filter(data['comb_str'], data['fid'])
