from Discovery import DiscoverNode

import settings
logging = settings.get_logger()

def index(req, **param):
    data = {}
    try:
        data['sid'] = param['sid']
        data['discover_through_agent'] = param['discover_through_agent']
        data['dta_search_ip'] = param['dta_search_ip']
        data['dta_search_hostname'] = param['dta_search_hostname']
    except:
        return '-1'
    
    if data['discover_through_agent'] == 'yes':
        try:
            data['agent_ip'] = param['agent_ip']
        except:
            return -1
    
    
    try:
        data['ostype'] = param['ostype']
    except:
        data['ostype'] = ''
        
    try:
        data['hostip'] = param['hostip']
        data['ipvalidate'] = True
    except:
        data['hostip'] = ''
        data['ipvalidate'] = False
    
    discoverList = getServiceDiscovery(data)
    
    if discoverList == -1 or discoverList == -2 or discoverList == 'Invalid IP':
        return discoverList
    
    req.content_type = "application/xml"
    return discoverList

def getServiceDiscovery(data):
    obj = DiscoverNode(data['sid'], data['ostype'], data['hostip'])
    return obj.getNodes(data)
