#from mod_python import Cookie
from xml.dom.minidom import parseString, parse, Document
import os, shutil

#From Project
from py_logout import doLogout
from utils import create_user_folder
import settings
logging = settings.get_logger()

## Checks the login credentials provided by the user.
def index(req, **param):
    
    auth = status = False
    
    try:
        user = param['user']
        password = param['password']
        action = param['action']
    except:
        return -1
    
    if action == 'f_logout':
        xml_filename = '%s%s_menu.xml'%(settings.document_root_path, user)
        doc = parse(xml_filename)
        home_node = doc.getElementsByTagName('home')[0]
        sid =  home_node.getAttribute('sid').strip()
        status = doLogout(str(sid))
        if status != 0:
            return -1
        
    #Login
    sessionId = genSessionId(req)
    
    try:
        auth = authenticate(user,password,sessionId)
        if auth == -1 or auth == -7 or auth == -11 or auth == -12:
            return auth 
    except:
        return '-3'
    
    if auth:
        dom = parseString(auth)
        for node in dom.getElementsByTagName('status'):
            status = node.firstChild.data
        
    if status == '0':
        
        #Create an empty menu.xml for this user
        doc = Document()
        # Create the <menu> base element
        menu = doc.createElement("menu")
        doc.appendChild(menu)
        
        # Create the <home> element
        home = doc.createElement("home")
        home.setAttribute('sid', sessionId)
        menu.appendChild(home)
        
        # run chmod 777 /var/www/html ; If IO error 13 encounters or os chmod
        logging.debug('')
        menu_xml = open('%s%s_menu.xml'%(settings.document_root_path,user),'w')
        menu_xml.write(doc.toprettyxml())
        menu_xml.close()
        
        #Preventing accident removal of the whole document root directory
        if user.strip() == '':
            return -1
        
        #Create an temp empty directory for this user to store all of his current session files eg: chinfofile , chkey files etc
        dir = '%s%s'%(settings.document_root_path,user)
        dir_status = False
        
        if not os.path.exists(dir):
            dir_status = create_user_folder(dir)        
        else:
            shutil.rmtree(dir)
            dir_status = create_user_folder(dir)

        return "%s___%s"%(sessionId,user)
    else:
        return '-1'
    
def genSessionId(req):
    import Session as Identifier
    sess = Identifier.Session(req)
    return sess.getSessionId()

def authenticate(user,password,sessionId):
    import StationLogin as login
    obj = login.StationLogin(user,password,sessionId)
    status = obj.authenticate()
    return status