from NetworkStatisticsFile import NetworkStatistics
from xml.dom.minidom import Document

def index(req, **kwargs):
    
    try:
        sid = kwargs['sid']
        ip = kwargs['ip']
        action = kwargs['action']
    except:
        return '-1'
    
    if action == 'interfaceList':
        try:
            ostype = kwargs['ostype']
        except:
            return '-1'
            
        return invoke_interface_list(sid, ip, ostype)

    elif action == 'ans_poll':
        
        try:
            ethcount = kwargs['ethcount']
            propertiescount = kwargs['propertiescount']
        except:
            return '-1'
        req.content_type = "application/xml"
        return invoke_table_poll_stats(sid, ip, kwargs)

    elif action == 'poll':
        try:
            ethcount = kwargs['ethcount']
            type = kwargs['type']
            poll_time = kwargs['poll_time']
        except:
            return '-1'
        
        if type == 'tm':
            try:
                ethcount = kwargs['tm_rm_prev_val']
                type = kwargs['tm_tm_prev_val']
                poll_time = kwargs['tm_bdm_prev_val']
            except:
                return '-1'
        
        req.content_type = "application/xml"
        return invoke_graph_poll_stats(sid, ip, kwargs)
    
    elif action == 'graph':
        try:
            ethcount = kwargs['ethcount']
            type = kwargs['type']
            poll_time = kwargs['poll_time']
        except:
            return '-1'
        
        if type == 'tps':
            try:
                ethcount = kwargs['tps_rps_prev_val']
                type = kwargs['tps_tps_prev_val']
                poll_time = kwargs['tps_bdps_prev_val']
            except:
                return '-1'
        elif type == 'tm':
            try:
                ethcount = kwargs['tm_rm_prev_val']
                type = kwargs['tm_tm_prev_val']
                poll_time = kwargs['tm_bdm_prev_val']
            except:
                return '-1'
            
        req.content_type = "application/xml"
        return invoke_graph_poll_stats(sid, ip, kwargs)
        
def invoke_interface_list(sid, ip, ostype ):
    nw_obj =  NetworkStatistics(sid,ip)
    interface_list = nw_obj.get_interface_list(ostype)
    return interface_list

def invoke_table_poll_stats(sid, ip, kwargs ):
    nw_obj =  NetworkStatistics(sid,ip)
    poll_values_xml = nw_obj.get_table_poll_values(kwargs)
    if poll_values_xml == -2:
        doc = Document()
        nw_stats = doc.createElement("NetworkStatistics")
        doc.appendChild(nw_stats)
        
        status_node = doc.createElement("status")
        nw_stats.appendChild(status_node)
        
        status_value = doc.createTextNode('-2')
        status_node.appendChild(status_value)
        
        return doc.toprettyxml()
    else:
        return poll_values_xml

def invoke_graph_poll_stats(sid, ip, kwargs):
    nw_obj =  NetworkStatistics(sid,ip)
    poll_values_xml = nw_obj.get_graph_poll_values(kwargs)
    if poll_values_xml == -2:
        doc = Document()
        nw_stats = doc.createElement("NetworkStatistics")
        doc.appendChild(nw_stats)
        
        status_node = doc.createElement("status")
        nw_stats.appendChild(status_node)
        
        status_value = doc.createTextNode('-2')
        status_node.appendChild(status_value)
        
        return doc.toprettyxml()
    else:
        return poll_values_xml
    return poll_values_xml
