from LinuxVFConfFile import LinuxVFConf

import settings
logging = settings.get_logger()

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
        data['type'] = kwargs['type']
    except:
        return '-1'
    
    if data['action'] == 'get':
        return invoke_get_initial_data(data)
    
    elif data['action'] == 'assign':
        try:
            data['vfpci'] = kwargs['vfpci']
            data['vmid'] = kwargs['vmid']
        except:
            return '-1'
        return invoke_add_vf_to_vm(data) 
    
    elif data['action'] == 'remove':
        try:
            data['vfpci'] = kwargs['vfpci']
            data['vmid'] = kwargs['vmid']
        except:
            return '-1'
        return invoke_remove_vf_to_vm(data) 

def invoke_get_initial_data(data):
    obj = LinuxVFConf(data['sid'], data['ip'], data['type'])
    return obj.get_initial_data()

def invoke_add_vf_to_vm(data):
    obj = LinuxVFConf(data['sid'], data['ip'], data['type'])
    return obj.add_vf_to_vm(data)

def invoke_remove_vf_to_vm(data):
    obj = LinuxVFConf(data['sid'], data['ip'], data['type'])
    return obj.remove_vf_to_vm(data)