from LinAddVirtualNwConfFile import LinAddVirtualNwConf

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip']  = kwargs['ip']
        data['action'] = kwargs['action']
        data['type'] = kwargs['type']
    except:
        return '-1'
    
    if data['action'] == 'get':
        return invoke_get_initial_data(data)
    
    elif data['action'] == 'create_bridge':
        try:
            data['bname'] = kwargs['bname']
        except:
            return '-1'
        
        data['agingtime'] = kwargs['agingtime']
        data['forward_delay'] = kwargs['forward_delay']
        data['hello_time'] = kwargs['hello_time']
        data['max_age'] = kwargs['max_age']
        data['priority'] = kwargs['priority']
        data['stp'] = kwargs['stp']
        return invoke_create_bridge(data)
    
    elif data['action'] == 'add_bridge_to_vm':
        try:
            data['brname'] = kwargs['brname']
            data['vmid'] = kwargs['vmid']
        except:
            return '-1'
        return invoke_add_bridge_to_vm(data)
    
    elif data['action'] == 'add_interface_to_bridge':
        try:
            data['interface'] = kwargs['interface']
            data['brname'] = kwargs['brname']
            data['cost'] = kwargs['cost']
            data['priority'] = kwargs['priority']
        except:
            return '-1'
        return invoke_add_interface_to_bridge(data)

def invoke_get_initial_data(data):
    vnt_obj =  LinAddVirtualNwConf(data['sid'], data['ip'], data['type'])
    return vnt_obj.get_initial_data()

def invoke_create_bridge(data):
    vnt_obj =  LinAddVirtualNwConf(data['sid'], data['ip'], data['type'])
    return vnt_obj.create_bridge(data)

def invoke_add_bridge_to_vm(data):
    vnt_obj =  LinAddVirtualNwConf(data['sid'], data['ip'], data['type'])
    return vnt_obj.add_bridge_to_vm(data)

def invoke_add_interface_to_bridge(data):
    vnt_obj =  LinAddVirtualNwConf(data['sid'], data['ip'], data['type'])
    return vnt_obj.add_interface_to_bridge(data)