from IscsiIniTargetsSessionsFile import IscsiIniTargetsSessions

import logging, settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
        data['ostype'] = kwargs['ostype']
    except:
        return -1
    
    try:
        data['req_type'] = kwargs['req_type']
    except:
        data['req_type'] =  'desktop'
    
    if data['action'] == 'get_data':
        return invoke_get_data(data)
    elif data['action'] == 'get_connections':
        try:
           data['init_name'] = kwargs['init_name']
           data['sessid'] = kwargs['sessid']
           data['stack'] = kwargs['stack']
           data['tarname'] = kwargs['tarname']
        except:
           return -1
        return invoke_get_connections(data)
    else:
        return -1

def invoke_get_data(data):
    obj =  IscsiIniTargetsSessions(data['sid'], data['ip'], data['ostype'], data['req_type'] )
    return obj.get_data()

def invoke_get_connections(data):
    obj =  IscsiIniTargetsSessions(data['sid'], data['ip'], data['ostype'], data['req_type'] )
    return obj.get_connections(data)